/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.command;

import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.Log;
import com.android.tradefed.command.CommandScheduler;
import com.android.tradefed.command.ConfigFileParser;
import com.android.tradefed.command.ICommandScheduler;
import com.android.tradefed.config.ArgsOptionParser;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceManager;
import com.android.tradefed.device.IDeviceManager;
import com.android.tradefed.invoker.ITestInvocation;
import com.android.tradefed.log.LogRegistry;
import com.android.tradefed.util.QuotationAwareTokenizer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;

public class Console {
    private static final String LOG_TAG = "Console";
    private static final String CONSOLE_PROMPT = "tf >";
    @Option(name="file", description="the path to file of configs to run")
    private File mFile = null;
    @Option(name="help", description="get command line usage info")
    private boolean mHelpMode = false;
    private ICommandScheduler mScheduler;
    private java.io.Console mTerminal;

    Console() {
        this(new CommandScheduler());
    }

    Console(ICommandScheduler scheduler) {
        this.mScheduler = scheduler;
        this.mTerminal = System.console();
    }

    void setConfigFile(File file) {
        this.mFile = file;
    }

    private String getConsoleInput() throws IOException {
        String line = this.mTerminal.readLine(CONSOLE_PROMPT, new Object[0]);
        return line;
    }

    private String index(String[] array, int i) {
        if (i > array.length) {
            return null;
        }
        return array[i];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String[] args) {
        this.initLogging();
        try {
            ArgsOptionParser myParser = new ArgsOptionParser(this);
            myParser.parse(args);
            if (this.mHelpMode) {
                this.printHelp();
                return;
            }
            if (this.mFile != null) {
                this.createConfigFileParser().parseFile(this.mFile, this.mScheduler);
            }
            this.mScheduler.start();
            if (this.mTerminal == null) {
                Log.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)LOG_TAG, (String)"Running indefinitely in non-interactive mode.");
                this.mScheduler.join();
                return;
            }
            String input = "";
            boolean shouldExit = false;
            Thread.sleep(500L);
            while (!shouldExit) {
                input = this.getConsoleInput();
                String[] tokens = QuotationAwareTokenizer.tokenizeLine(input);
                if (tokens.length == 0) continue;
                String cmd = tokens[0];
                if ("exit".equals(cmd) || "q".equals(cmd)) {
                    shouldExit = true;
                } else if ("?".equals(cmd) || "help".equals(cmd) || "h".equals(cmd)) {
                    this.mTerminal.printf("Not-so-helpful help:\n'q' == 'exit'\n'l i' == 'list invocations'\n'l d' == 'list devices'\n'l c' == 'list configs'\n", new Object[0]);
                } else if ("list".equals(cmd) || "l".equals(cmd)) {
                    int counter;
                    if ("i".equals(this.index(tokens, 1)) || "invocations".equals(this.index(tokens, 1))) {
                        Collection<ITestInvocation> invs = this.mScheduler.listInvocations();
                        counter = 1;
                        for (ITestInvocation inv : invs) {
                            this.mTerminal.printf("Got invocation %d: %s\n", counter++, inv);
                        }
                    } else if ("d".equals(this.index(tokens, 1)) || "devices".equals(this.index(tokens, 1))) {
                        IDeviceManager manager = DeviceManager.getInstance();
                        Collection<String> devices = null;
                        devices = manager.getAvailableDevices();
                        this.mTerminal.printf("Available devices:   %s\n", devices);
                        devices = manager.getUnavailableDevices();
                        this.mTerminal.printf("Unavailable devices: %s\n", devices);
                        devices = manager.getAllocatedDevices();
                        this.mTerminal.printf("Allocated devices:   %s\n", devices);
                    } else if ("c".equals(this.index(tokens, 1)) || "configs".equals(this.index(tokens, 1))) {
                        Collection<String> configs = this.mScheduler.listConfigs();
                        counter = 1;
                        for (String config : configs) {
                            this.mTerminal.printf("Got config %d: %s\n", counter++, config);
                        }
                    }
                } else {
                    this.mTerminal.printf("Unknown command '%s'.  Enter 'help' for help.\n", cmd);
                }
                Thread.sleep(100L);
            }
            this.mScheduler.shutdown();
            this.mScheduler.join();
        }
        catch (ConfigurationException e) {
            System.err.println(String.format("Failed to parse options: %s", e.getMessage()));
            this.printHelp();
        }
        catch (FileNotFoundException e) {
            System.err.println(String.format("Provided file %s does not exist", this.mFile.getAbsolutePath()));
        }
        catch (IOException e) {
            System.err.println(String.format("Provided file %s cannot be read", this.mFile.getAbsolutePath()));
            e.printStackTrace();
        }
        catch (InterruptedException e) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.exit();
        }
    }

    void initLogging() {
        DdmPreferences.setLogLevel((String)Log.LogLevel.VERBOSE.getStringValue());
        Log.setLogOutput((Log.ILogOutput)LogRegistry.getLogRegistry());
    }

    void exit() {
        LogRegistry.getLogRegistry().closeAndRemoveAllLogs();
        System.exit(0);
    }

    ConfigFileParser createConfigFileParser() {
        return new ConfigFileParser();
    }

    private void printHelp() {
        System.out.println("Run TradeFederation console.");
        System.out.println("Options:");
        System.out.print(ArgsOptionParser.getOptionHelp(this.getClass()));
    }

    public static void main(String[] mainArgs) {
        Console console = new Console();
        console.run(mainArgs);
    }
}

