/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.command;

import com.android.ddmlib.Log;
import com.android.tradefed.command.ICommandScheduler;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.util.QuotationAwareTokenizer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConfigFileParser {
    private static final String LOG_TAG = "ConfigFileParser";
    private static final Pattern mMacroPattern = Pattern.compile("([a-z_]+)\\(\\)");
    private Map<String, ConfigLine> mMacros = new HashMap<String, ConfigLine>();
    private Map<String, List<ConfigLine>> mLongMacros = new HashMap<String, List<ConfigLine>>();
    private List<ConfigLine> mLines = new LinkedList<ConfigLine>();

    ConfigFileParser() {
    }

    private boolean isLineMacro(ConfigLine line) {
        return line.size() >= 4 && "MACRO".equals(line.get(0)) && "=".equals(line.get(2));
    }

    private boolean isLineLongMacro(ConfigLine line) {
        return line.size() == 3 && "LONG".equals(line.get(0)) && "MACRO".equals(line.get(1));
    }

    private boolean shouldParseLine(String line) {
        return !(line = line.trim()).isEmpty() && !line.startsWith("#");
    }

    private void scanFile(File file) throws IOException, ConfigurationException {
        BufferedReader fileReader = this.createConfigFileReader(file);
        String inputLine = null;
        while ((inputLine = fileReader.readLine()) != null) {
            ConfigLine expansion;
            String name;
            if (!this.shouldParseLine(inputLine = inputLine.trim())) continue;
            ConfigLine lArgs = null;
            try {
                String[] args = QuotationAwareTokenizer.tokenizeLine(inputLine);
                lArgs = new ConfigLine(Arrays.asList(args));
            }
            catch (IllegalArgumentException e) {
                throw new ConfigurationException(e.getMessage());
            }
            if (this.isLineMacro(lArgs)) {
                name = (String)lArgs.get(1);
                expansion = new ConfigLine(lArgs.subList(3, lArgs.size()));
                this.mMacros.put(name, expansion);
                continue;
            }
            if (this.isLineLongMacro(lArgs)) {
                name = (String)lArgs.get(2);
                expansion = new LinkedList();
                inputLine = fileReader.readLine();
                while (!"END MACRO".equals(inputLine)) {
                    if (inputLine == null) {
                        throw new ConfigurationException(String.format("Syntax error: Unexpected EOF while reading definition for LONG MACRO %s.", name));
                    }
                    if (this.shouldParseLine(inputLine)) {
                        ConfigLine line = new ConfigLine(Arrays.asList(QuotationAwareTokenizer.tokenizeLine(inputLine)));
                        expansion.add(line);
                    }
                    inputLine = fileReader.readLine();
                }
                Log.d((String)LOG_TAG, (String)String.format("Parsed %d-line definition for long macro %s", expansion.size(), name));
                this.mLongMacros.put(name, expansion);
                continue;
            }
            this.mLines.add(lArgs);
        }
    }

    public void parseFile(File file, ICommandScheduler scheduler) throws IOException, ConfigurationException {
        this.scanFile(file);
        LinkedList<Boolean> inputBitmask = new LinkedList<Boolean>();
        for (int i = 0; i < this.mLines.size(); ++i) {
            inputBitmask.add(true);
        }
        int inputBitmaskCount = this.mLines.size();
        for (int iCount = 0; iCount < 10 && inputBitmaskCount > 0; ++iCount) {
            Log.d((String)LOG_TAG, (String)("### Expansion iteration " + iCount));
            int inputIdx = 0;
            while (inputIdx < this.mLines.size()) {
                ConfigLine line;
                if (!((Boolean)inputBitmask.get(inputIdx)).booleanValue()) {
                    ++inputIdx;
                    continue;
                }
                boolean sawMacro = this.expandMacro(line = this.mLines.get(inputIdx));
                List<ConfigLine> longMacroExpansion = this.expandLongMacro(line, !sawMacro);
                if (longMacroExpansion == null) {
                    if (!sawMacro) {
                        inputBitmask.set(inputIdx, false);
                        --inputBitmaskCount;
                    }
                    ++inputIdx;
                    continue;
                }
                this.mLines.remove(inputIdx);
                this.mLines.addAll(inputIdx, longMacroExpansion);
                for (int i = 0; i < longMacroExpansion.size(); ++i) {
                    inputBitmask.add(inputIdx, true);
                }
                inputIdx += longMacroExpansion.size();
            }
        }
        for (ConfigLine configLine : this.mLines) {
            Log.d((String)LOG_TAG, (String)String.format("Adding line: %s", configLine.toString()));
            String[] aryCmdLine = new String[configLine.size()];
            scheduler.addConfig(configLine.toArray(aryCmdLine));
        }
    }

    private List<ConfigLine> expandLongMacro(ConfigLine line, boolean checkMissingMacro) throws ConfigurationException {
        for (int idx = 0; idx < line.size(); ++idx) {
            String token = (String)line.get(idx);
            Matcher matchMacro = mMacroPattern.matcher(token);
            if (!matchMacro.matches()) continue;
            LinkedList<ConfigLine> expansion = new LinkedList<ConfigLine>();
            String name = matchMacro.group(1);
            List<ConfigLine> longMacro = this.mLongMacros.get(name);
            if (longMacro == null) {
                if (checkMissingMacro) {
                    throw new ConfigurationException(String.format("Macro call '%s' does not match any macro definitions.", name));
                }
                return null;
            }
            ConfigLine prefix = new ConfigLine(line.subList(0, idx));
            ConfigLine suffix = new ConfigLine(line.subList(idx, line.size()));
            suffix.remove(0);
            for (ConfigLine macroLine : longMacro) {
                ConfigLine expanded = new ConfigLine();
                expanded.addAll(prefix);
                expanded.addAll(macroLine);
                expanded.addAll(suffix);
                expansion.add(expanded);
            }
            return expansion;
        }
        return null;
    }

    private boolean expandMacro(ConfigLine line) {
        boolean sawMacro = false;
        int idx = 0;
        while (idx < line.size()) {
            String token = (String)line.get(idx);
            Matcher matchMacro = mMacroPattern.matcher(token);
            if (matchMacro.matches() && this.mMacros.containsKey(matchMacro.group(1))) {
                String name = matchMacro.group(1);
                ConfigLine macro = this.mMacros.get(name);
                Log.d((String)LOG_TAG, (String)String.format("Gotcha!  Expanding macro '%s' to '%s'", name, macro));
                line.remove(idx);
                line.addAll(idx, macro);
                idx += macro.size();
                sawMacro = true;
                continue;
            }
            ++idx;
        }
        return sawMacro;
    }

    BufferedReader createConfigFileReader(File file) throws IOException {
        return new BufferedReader(new FileReader(file));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConfigLine
    extends LinkedList<String> {
        ConfigLine() {
        }

        ConfigLine(Collection<? extends String> c) {
            super(c);
        }
    }
}

