/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.command;

import com.android.ddmlib.Log;
import com.android.tradefed.command.ICommandScheduler;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.ConfigurationFactory;
import com.android.tradefed.config.IConfigurationFactory;
import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceManager;
import com.android.tradefed.device.DeviceSelectionMatcher;
import com.android.tradefed.device.DeviceSelectionOptions;
import com.android.tradefed.device.IDeviceManager;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.ITestInvocation;
import com.android.tradefed.invoker.TestInvocation;
import com.android.tradefed.util.ConditionPriorityBlockingQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandScheduler
extends Thread
implements ICommandScheduler {
    private static final String LOG_TAG = "ConfigScheduler";
    private ConditionPriorityBlockingQueue<ConfigCommand> mConfigQueue = new ConditionPriorityBlockingQueue<ConfigCommand>(new ConfigComparator());
    private Set<InvocationThread> mInvocationThreads = new HashSet<InvocationThread>();
    private Timer mConfigTimer;
    private boolean mShutdown = false;

    CommandScheduler() {
    }

    ITestInvocation createRunInstance() {
        return new TestInvocation();
    }

    IDeviceManager getDeviceManager() {
        return DeviceManager.getInstance();
    }

    IConfigurationFactory getConfigFactory() {
        return ConfigurationFactory.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ArrayList<InvocationThread> threadListCopy;
        Thread invThread;
        this.mConfigTimer = new Timer("config timer");
        IDeviceManager manager = this.getDeviceManager();
        while (!this.isShutdown()) {
            Log.d((String)LOG_TAG, (String)"Waiting for device to test");
            ITestDevice device = manager.allocateDevice();
            if (device == null) continue;
            invThread = this.startInvocation(manager, device);
            this.addInvocationThread((InvocationThread)invThread);
        }
        Log.i((String)LOG_TAG, (String)"Waiting for invocation threads to complete");
        invThread = this;
        synchronized (invThread) {
            threadListCopy = new ArrayList<InvocationThread>(this.mInvocationThreads.size());
            threadListCopy.addAll(this.mInvocationThreads);
        }
        for (InvocationThread thread : threadListCopy) {
            this.waitForThread(thread);
        }
        Log.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)LOG_TAG, (String)"All done");
        this.exit(manager);
    }

    private void waitForThread(Thread thread) {
        try {
            thread.join();
        }
        catch (InterruptedException e) {
            this.waitForThread(thread);
        }
    }

    private void exit(IDeviceManager manager) {
        if (manager != null) {
            manager.terminate();
        }
    }

    @Override
    public void addConfig(String[] args) {
        CommandOptions cmdOptions = this.createCommandOptions();
        DeviceSelectionOptions deviceOptions = this.createDeviceOptions();
        try {
            this.getConfigFactory().createConfigurationFromArgs(args, cmdOptions, deviceOptions);
            if (cmdOptions.isHelpMode()) {
                this.getConfigFactory().printHelp(args, System.out, CommandOptions.class, DeviceSelectionOptions.class);
            } else {
                ConfigCommand cmd = new ConfigCommand(args, cmdOptions, deviceOptions);
                this.mConfigQueue.add(cmd);
            }
        }
        catch (ConfigurationException e) {
            System.out.println(String.format("Unrecognized arguments: %s", e.getMessage()));
            this.getConfigFactory().printHelp(args, System.out, CommandOptions.class, DeviceSelectionOptions.class);
        }
    }

    CommandOptions createCommandOptions() {
        return new CommandOptions();
    }

    DeviceSelectionOptions createDeviceOptions() {
        return new DeviceSelectionOptions();
    }

    private ConfigCommand dequeueConfigCommand(ITestDevice device) {
        if (this.isShutdown()) {
            return null;
        }
        ConfigCommand cmd = null;
        try {
            cmd = this.mConfigQueue.take(new DeviceCmdMatcher(device));
            if (cmd.getCommandOptions().isLoopMode()) {
                this.returnConfigToQueue(cmd);
            }
        }
        catch (InterruptedException e) {
            Log.i((String)LOG_TAG, (String)"Waiting for config command interrupted");
        }
        return cmd;
    }

    private void returnConfigToQueue(final ConfigCommand cmd) {
        long minLoopTime = cmd.getCommandOptions().getMinLoopTime();
        if (minLoopTime > 0L) {
            TimerTask delayConfig = new TimerTask(){

                public void run() {
                    Log.d((String)CommandScheduler.LOG_TAG, (String)String.format("Adding config '%s' back to queue", CommandScheduler.this.getArgString(cmd.getArgs())));
                    CommandScheduler.this.mConfigQueue.add(cmd);
                }
            };
            Log.d((String)LOG_TAG, (String)String.format("Delay adding config '%s' back to queue for %d ms", this.getArgString(cmd.getArgs()), minLoopTime));
            this.mConfigTimer.schedule(delayConfig, minLoopTime);
        } else {
            this.mConfigQueue.add(cmd);
        }
    }

    private String getArgString(String[] args) {
        StringBuilder builder = new StringBuilder();
        for (String arg : args) {
            builder.append(arg);
            builder.append(" ");
        }
        return builder.toString();
    }

    private InvocationThread startInvocation(IDeviceManager manager, ITestDevice device) {
        String invocationName = String.format("Invocation-%s", device.getSerialNumber());
        InvocationThread invocationThread = new InvocationThread(invocationName, manager, device);
        invocationThread.start();
        return invocationThread;
    }

    private synchronized void removeInvocationThread(InvocationThread invThread) {
        this.mInvocationThreads.remove(invThread);
    }

    private synchronized void addInvocationThread(InvocationThread invThread) {
        this.mInvocationThreads.add(invThread);
    }

    private synchronized boolean isShutdown() {
        return this.mShutdown;
    }

    @Override
    public synchronized void shutdown() {
        if (!this.mShutdown) {
            this.mShutdown = true;
            this.mConfigQueue.clear();
            if (this.mConfigTimer != null) {
                this.mConfigTimer.cancel();
            }
            this.interrupt();
            for (InvocationThread invThread : this.mInvocationThreads) {
                invThread.shutdownInvocation();
            }
        }
    }

    @Override
    public Collection<ITestInvocation> listInvocations() throws UnsupportedOperationException {
        ArrayList<ITestInvocation> invs = new ArrayList<ITestInvocation>(this.mInvocationThreads.size());
        if (this.mInvocationThreads == null) {
            return null;
        }
        for (InvocationThread invThread : this.mInvocationThreads) {
            invs.add(invThread.getInvocation());
        }
        return invs;
    }

    @Override
    public boolean stopInvocation(ITestInvocation invocation) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<String> listConfigs() throws UnsupportedOperationException {
        Iterator<ConfigCommand> configIter = this.mConfigQueue.iterator();
        ArrayList<String> stringConfigs = new ArrayList<String>();
        while (configIter.hasNext()) {
            ConfigCommand config = configIter.next();
            stringConfigs.add(this.getArgString(config.getArgs()));
        }
        return stringConfigs;
    }

    static /* synthetic */ ConfigCommand access$100(CommandScheduler x0, ITestDevice x1) {
        return x0.dequeueConfigCommand(x1);
    }

    static /* synthetic */ void access$200(CommandScheduler x0, InvocationThread x1) {
        x0.removeInvocationThread(x1);
    }

    private class InvocationThread
    extends Thread {
        private IDeviceManager mManager;
        private ITestDevice mDevice;
        private ITestInvocation mInvocation;
        private boolean mIsStarted;

        public InvocationThread(String name, IDeviceManager manager, ITestDevice device) {
            super(new ThreadGroup(name), name);
            this.mInvocation = null;
            this.mIsStarted = false;
            this.mManager = manager;
            this.mDevice = device;
        }

        private synchronized ITestInvocation createInvocation() {
            this.mInvocation = CommandScheduler.this.createRunInstance();
            return this.mInvocation;
        }

        /*
         * Exception decompiling
         */
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private synchronized ITestInvocation getInvocation() {
            return this.mInvocation;
        }

        public void shutdownInvocation() {
            if (this.getInvocation() == null && this.mIsStarted) {
                this.interrupt();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DeviceCmdMatcher
    implements ConditionPriorityBlockingQueue.IMatcher<ConfigCommand> {
        private final ITestDevice mDevice;

        DeviceCmdMatcher(ITestDevice device) {
            this.mDevice = device;
        }

        @Override
        public boolean matches(ConfigCommand cmd) {
            DeviceSelectionOptions deviceOptions = cmd.getDeviceOptions();
            return DeviceSelectionMatcher.matches(this.mDevice.getIDevice(), deviceOptions);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConfigComparator
    implements Comparator<ConfigCommand> {
        private ConfigComparator() {
        }

        @Override
        public int compare(ConfigCommand c1, ConfigCommand c2) {
            if (c1.mTotalExecTime == c2.mTotalExecTime) {
                return 0;
            }
            if (c1.mTotalExecTime < c2.mTotalExecTime) {
                return -1;
            }
            return 1;
        }
    }

    private static class ConfigCommand {
        private final String[] mArgs;
        private final CommandOptions mCmdOptions;
        private final DeviceSelectionOptions mDeviceOptions;
        private long mTotalExecTime = 0L;

        ConfigCommand(String[] args, CommandOptions cmdOptions, DeviceSelectionOptions deviceOptions) {
            this.mArgs = args;
            this.mCmdOptions = cmdOptions;
            this.mDeviceOptions = deviceOptions;
        }

        synchronized void incrementExecTime(long execTime) {
            this.mTotalExecTime += execTime;
        }

        CommandOptions getCommandOptions() {
            return this.mCmdOptions;
        }

        DeviceSelectionOptions getDeviceOptions() {
            return this.mDeviceOptions;
        }

        String[] getArgs() {
            return this.mArgs;
        }
    }

    static class CommandOptions {
        @Option(name="help", description="display the help text")
        private boolean mHelpMode = false;
        @Option(name="min-loop-time", description="the minimum invocation time in ms when in loop mode. Default is 1 minute.")
        private long mMinLoopTime = 60000L;
        @Option(name="loop", description="keep running continuously")
        private boolean mLoopMode = true;

        CommandOptions() {
        }

        void setHelpMode(boolean helpMode) {
            this.mHelpMode = helpMode;
        }

        public boolean isHelpMode() {
            return this.mHelpMode;
        }

        void setLoopMode(boolean loopMode) {
            this.mLoopMode = loopMode;
        }

        boolean isLoopMode() {
            return this.mLoopMode;
        }

        void setMinLoopTime(long loopTime) {
            this.mMinLoopTime = loopTime;
        }

        public long getMinLoopTime() {
            return this.mMinLoopTime;
        }
    }
}

