/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.command;

import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.Log;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.ConfigurationFactory;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IConfigurationFactory;
import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceManager;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.DeviceSelectionOptions;
import com.android.tradefed.device.DeviceUnresponsiveException;
import com.android.tradefed.device.IDeviceManager;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.ITestInvocation;
import com.android.tradefed.invoker.TestInvocation;
import com.android.tradefed.log.LogRegistry;

public class Command {
    private static final String LOG_TAG = "Command";
    static final long WAIT_DEVICE_TIME = 10000L;
    @Option(name="help", description="get command line usage info")
    private boolean mHelpMode = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void run(String[] args) {
        this.initLogging();
        IDeviceManager manager = null;
        try {
            DeviceSelectionOptions deviceOptions = new DeviceSelectionOptions();
            IConfiguration config = this.getConfigFactory().createConfigurationFromArgs(args, this, deviceOptions);
            if (this.mHelpMode) {
                this.printHelp(args);
                this.exit(manager);
                return;
            }
            manager = this.getDeviceManager();
            this.runInvocation(manager, deviceOptions, config);
            this.exit(manager);
        }
        catch (ConfigurationException e) {
            System.out.println(String.format("Failed to load configuration: %s", e.getMessage()));
            this.printHelp(args);
        }
        finally {
            this.exit(manager);
        }
    }

    private void printHelp(String[] args) {
        this.getConfigFactory().printHelp(args, System.out, this.getClass(), DeviceSelectionOptions.class);
    }

    void initLogging() {
        DdmPreferences.setLogLevel((String)Log.LogLevel.VERBOSE.getStringValue());
        Log.setLogOutput((Log.ILogOutput)this.getLogRegistry());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runInvocation(IDeviceManager manager, DeviceSelectionOptions deviceOptions, IConfiguration config) throws ConfigurationException {
        ITestDevice device = null;
        IDeviceManager.FreeDeviceState deviceState = IDeviceManager.FreeDeviceState.AVAILABLE;
        try {
            ITestInvocation instance = this.createRunInstance();
            device = manager.allocateDevice(10000L, deviceOptions);
            if (device == null) {
                System.out.println("Could not find device to test");
                throw new DeviceNotAvailableException();
            }
            instance.invoke(device, config);
        }
        catch (DeviceUnresponsiveException e) {
            deviceState = IDeviceManager.FreeDeviceState.UNRESPONSIVE;
        }
        catch (DeviceNotAvailableException e) {
            deviceState = IDeviceManager.FreeDeviceState.UNAVAILABLE;
        }
        finally {
            if (manager != null && device != null) {
                manager.freeDevice(device, deviceState);
            }
        }
    }

    private void exit(IDeviceManager manager) {
        if (manager != null) {
            manager.terminate();
        }
        this.getLogRegistry().closeAndRemoveAllLogs();
    }

    ITestInvocation createRunInstance() {
        return new TestInvocation();
    }

    IDeviceManager getDeviceManager() {
        return DeviceManager.getInstance();
    }

    LogRegistry getLogRegistry() {
        return LogRegistry.getLogRegistry();
    }

    IConfigurationFactory getConfigFactory() {
        return ConfigurationFactory.getInstance();
    }

    public static void main(String[] args) {
        Command cmd = new Command();
        cmd.run(args);
    }
}

