/*
 * Decompiled with CFR 0.152.
 */
package com.android.resources;

import com.android.resources.ResourceEnum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Navigation implements ResourceEnum
{
    NONAV("nonav", "None", "No navigation"),
    DPAD("dpad", "D-pad", "D-pad navigation"),
    TRACKBALL("trackball", "Trackball", "Trackball navigation"),
    WHEEL("wheel", "Wheel", "Wheel navigation");

    private final String mValue;
    private final String mShortDisplayValue;
    private final String mLongDisplayValue;

    private Navigation(String value, String shortDisplayValue, String longDisplayValue) {
        this.mValue = value;
        this.mShortDisplayValue = shortDisplayValue;
        this.mLongDisplayValue = longDisplayValue;
    }

    public static Navigation getEnum(String value) {
        for (Navigation nav : Navigation.values()) {
            if (!nav.mValue.equals(value)) continue;
            return nav;
        }
        return null;
    }

    @Override
    public String getResourceValue() {
        return this.mValue;
    }

    @Override
    public String getShortDisplayValue() {
        return this.mShortDisplayValue;
    }

    @Override
    public String getLongDisplayValue() {
        return this.mLongDisplayValue;
    }

    public static int getIndex(Navigation value) {
        int i = 0;
        for (Navigation nav : Navigation.values()) {
            if (nav == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static Navigation getByIndex(int index) {
        int i = 0;
        for (Navigation value : Navigation.values()) {
            if (i == index) {
                return value;
            }
            ++i;
        }
        return null;
    }

    @Override
    public boolean isFakeValue() {
        return false;
    }

    @Override
    public boolean isValidValueForDevice() {
        return true;
    }
}

