/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.xnet.provider.jsse;

import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import org.apache.harmony.xnet.provider.jsse.HandshakeIODataStream;
import org.apache.harmony.xnet.provider.jsse.Message;

public class CertificateRequest
extends Message {
    public static final byte RSA_SIGN = 1;
    public static final byte DSS_SIGN = 2;
    public static final byte RSA_FIXED_DH = 3;
    public static final byte DSS_FIXED_DH = 4;
    public final byte[] certificate_types;
    public final X500Principal[] certificate_authorities;
    public String[] types;
    public byte[][] encoded_principals;

    public CertificateRequest(byte[] certificate_types, X509Certificate[] accepted) {
        if (accepted == null) {
            this.fatalAlert((byte)80, "CertificateRequest: array of certificate authority certificates is null");
        }
        this.certificate_types = certificate_types;
        int totalPrincipalsLength = 0;
        this.certificate_authorities = new X500Principal[accepted.length];
        this.encoded_principals = new byte[accepted.length][];
        for (int i = 0; i < accepted.length; ++i) {
            this.certificate_authorities[i] = accepted[i].getIssuerX500Principal();
            this.encoded_principals[i] = this.certificate_authorities[i].getEncoded();
            totalPrincipalsLength += this.encoded_principals[i].length + 2;
        }
        this.length = 3 + certificate_types.length + totalPrincipalsLength;
    }

    public CertificateRequest(HandshakeIODataStream in, int length) throws IOException {
        int totalPrincipalsLength;
        int size = in.readUint8();
        this.certificate_types = new byte[size];
        in.read(this.certificate_types, 0, size);
        size = in.readUint16();
        int principalLength = 0;
        Vector<X500Principal> principals = new Vector<X500Principal>();
        for (totalPrincipalsLength = 0; totalPrincipalsLength < size; totalPrincipalsLength += principalLength) {
            principalLength = in.readUint16();
            principals.add(new X500Principal(in));
            totalPrincipalsLength += 2;
        }
        this.certificate_authorities = new X500Principal[principals.size()];
        for (int i = 0; i < this.certificate_authorities.length; ++i) {
            this.certificate_authorities[i] = (X500Principal)principals.elementAt(i);
        }
        this.length = 3 + this.certificate_types.length + totalPrincipalsLength;
        if (this.length != length) {
            this.fatalAlert((byte)50, "DECODE ERROR: incorrect CertificateRequest");
        }
    }

    public void send(HandshakeIODataStream out) {
        int i;
        out.writeUint8(this.certificate_types.length);
        for (int i2 = 0; i2 < this.certificate_types.length; ++i2) {
            out.write(this.certificate_types[i2]);
        }
        int authoritiesLength = 0;
        for (i = 0; i < this.certificate_authorities.length; ++i) {
            authoritiesLength += this.encoded_principals[i].length + 2;
        }
        out.writeUint16(authoritiesLength);
        for (i = 0; i < this.certificate_authorities.length; ++i) {
            out.writeUint16(this.encoded_principals[i].length);
            out.write(this.encoded_principals[i]);
        }
    }

    public int getType() {
        return 13;
    }

    public String[] getTypesAsString() {
        if (this.types == null) {
            this.types = new String[this.certificate_types.length];
            block6: for (int i = 0; i < this.types.length; ++i) {
                switch (this.certificate_types[i]) {
                    case 1: {
                        this.types[i] = "RSA";
                        continue block6;
                    }
                    case 2: {
                        this.types[i] = "DSA";
                        continue block6;
                    }
                    case 3: {
                        this.types[i] = "DH_RSA";
                        continue block6;
                    }
                    case 4: {
                        this.types[i] = "DH_DSA";
                        continue block6;
                    }
                    default: {
                        this.fatalAlert((byte)50, "DECODE ERROR: incorrect CertificateRequest");
                    }
                }
            }
        }
        return this.types;
    }
}

