/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.x509;

import java.util.Date;
import org.apache.harmony.security.asn1.ASN1Sequence;
import org.apache.harmony.security.asn1.ASN1Type;
import org.apache.harmony.security.asn1.BerInputStream;
import org.apache.harmony.security.x509.Time;

public class Validity {
    public final Date notBefore;
    public final Date notAfter;
    public byte[] encoding;
    public static final ASN1Sequence ASN1 = new ASN1Sequence(new ASN1Type[]{Time.ASN1, Time.ASN1}){

        public Object getDecodedObject(BerInputStream in) {
            Object[] values = (Object[])in.content;
            return new Validity((Date)values[0], (Date)values[1]);
        }

        public void getValues(Object object, Object[] values) {
            Validity validity = (Validity)object;
            values[0] = validity.notBefore;
            values[1] = validity.notAfter;
        }
    };

    public Validity(Date notBefore, Date notAfter) {
        this.notBefore = notBefore;
        this.notAfter = notAfter;
    }

    public Date getNotBefore() {
        return this.notBefore;
    }

    public Date getNotAfter() {
        return this.notAfter;
    }

    public byte[] getEncoded() {
        if (this.encoding == null) {
            this.encoding = ASN1.encode(this);
        }
        return this.encoding;
    }
}

