/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.x509;

import java.io.IOException;
import java.util.Date;
import org.apache.harmony.security.asn1.ASN1GeneralizedTime;
import org.apache.harmony.security.asn1.ASN1Type;
import org.apache.harmony.security.x509.ExtensionValue;

public class InvalidityDate
extends ExtensionValue {
    public final Date date;
    public static final ASN1Type ASN1 = ASN1GeneralizedTime.getInstance();

    public InvalidityDate(Date date) {
        this.date = date;
    }

    public InvalidityDate(byte[] encoding) throws IOException {
        super(encoding);
        this.date = (Date)ASN1.decode(encoding);
    }

    public Date getDate() {
        return this.date;
    }

    public byte[] getEncoded() {
        if (this.encoding == null) {
            this.encoding = ASN1.encode(this.date);
        }
        return this.encoding;
    }

    public void dumpValue(StringBuffer buffer, String prefix) {
        buffer.append(prefix).append("Invalidity Date: [ ").append(this.date).append(" ]\n");
    }
}

