/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.x509;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.apache.harmony.security.asn1.ASN1SequenceOf;
import org.apache.harmony.security.asn1.ASN1Type;
import org.apache.harmony.security.asn1.BerInputStream;
import org.apache.harmony.security.x509.BasicConstraints;
import org.apache.harmony.security.x509.CertificateIssuer;
import org.apache.harmony.security.x509.ExtendedKeyUsage;
import org.apache.harmony.security.x509.Extension;
import org.apache.harmony.security.x509.GeneralNames;
import org.apache.harmony.security.x509.KeyUsage;

public class Extensions {
    public static List SUPPORTED_CRITICAL = Arrays.asList("2.5.29.15", "2.5.29.19", "2.5.29.32", "2.5.29.17", "2.5.29.30", "2.5.29.36", "2.5.29.37", "2.5.29.54");
    public List<Extension> extensions;
    public Set critical;
    public Set noncritical;
    public boolean hasUnsupported;
    public HashMap oidMap;
    public byte[] encoding;
    public static final ASN1Type ASN1 = new ASN1SequenceOf(Extension.ASN1){

        public Object getDecodedObject(BerInputStream in) {
            return new Extensions((List)in.content);
        }

        public Collection getValues(Object object) {
            Extensions exts = (Extensions)object;
            return exts.extensions == null ? new ArrayList() : exts.extensions;
        }
    };

    public Extensions() {
    }

    public Extensions(List extensions) {
        this.extensions = extensions;
    }

    public List getExtensions() {
        return this.extensions;
    }

    public int size() {
        return this.extensions == null ? 0 : this.extensions.size();
    }

    public Set getCriticalExtensions() {
        if (this.critical == null) {
            this.makeOidsLists();
        }
        return this.critical;
    }

    public Set getNonCriticalExtensions() {
        if (this.noncritical == null) {
            this.makeOidsLists();
        }
        return this.noncritical;
    }

    public boolean hasUnsupportedCritical() {
        if (this.critical == null) {
            this.makeOidsLists();
        }
        return this.hasUnsupported;
    }

    public void makeOidsLists() {
        if (this.extensions == null) {
            return;
        }
        int size = this.extensions.size();
        this.critical = new HashSet(size);
        this.noncritical = new HashSet(size);
        for (int i = 0; i < size; ++i) {
            Extension extn = this.extensions.get(i);
            String oid = extn.getExtnID();
            if (extn.getCritical()) {
                if (!SUPPORTED_CRITICAL.contains(oid)) {
                    this.hasUnsupported = true;
                }
                this.critical.add(oid);
                continue;
            }
            this.noncritical.add(oid);
        }
    }

    public Extension getExtensionByOID(String oid) {
        if (this.extensions == null) {
            return null;
        }
        if (this.oidMap == null) {
            this.oidMap = new HashMap();
            for (Extension extn : this.extensions) {
                this.oidMap.put(extn.getExtnID(), extn);
            }
        }
        return (Extension)this.oidMap.get(oid);
    }

    public boolean[] valueOfKeyUsage() {
        Extension extn = this.getExtensionByOID("2.5.29.15");
        KeyUsage kUsage = null;
        if (extn == null || (kUsage = extn.getKeyUsageValue()) == null) {
            return null;
        }
        return kUsage.getKeyUsage();
    }

    public List valueOfExtendedKeyUsage() throws IOException {
        Extension extn = this.getExtensionByOID("2.5.29.37");
        if (extn == null) {
            return null;
        }
        return ((ExtendedKeyUsage)extn.getDecodedExtensionValue()).getExtendedKeyUsage();
    }

    public int valueOfBasicConstrains() {
        Extension extn = this.getExtensionByOID("2.5.29.19");
        BasicConstraints bc = null;
        if (extn == null || (bc = extn.getBasicConstraintsValue()) == null) {
            return Integer.MAX_VALUE;
        }
        return bc.getPathLenConstraint();
    }

    public List valueOfSubjectAlternativeName() throws IOException {
        Extension extn = this.getExtensionByOID("2.5.29.17");
        if (extn == null) {
            return null;
        }
        return ((GeneralNames)GeneralNames.ASN1.decode(extn.getExtnValue())).getPairsList();
    }

    public List valueOfIssuerAlternativeName() throws IOException {
        Extension extn = this.getExtensionByOID("2.5.29.18");
        if (extn == null) {
            return null;
        }
        return ((GeneralNames)GeneralNames.ASN1.decode(extn.getExtnValue())).getPairsList();
    }

    public X500Principal valueOfCertificateIssuerExtension() throws IOException {
        Extension extn = this.getExtensionByOID("2.5.29.29");
        if (extn == null) {
            return null;
        }
        return ((CertificateIssuer)extn.getDecodedExtensionValue()).getIssuer();
    }

    public void addExtension(Extension extn) {
        this.encoding = null;
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        this.extensions.add(extn);
        if (this.oidMap != null) {
            this.oidMap.put(extn.getExtnID(), extn);
        }
        if (this.critical != null) {
            String oid = extn.getExtnID();
            if (extn.getCritical()) {
                if (!SUPPORTED_CRITICAL.contains(oid)) {
                    this.hasUnsupported = true;
                }
                this.critical.add(oid);
            } else {
                this.noncritical.add(oid);
            }
        }
    }

    public byte[] getEncoded() {
        if (this.encoding == null) {
            this.encoding = ASN1.encode(this);
        }
        return this.encoding;
    }

    public boolean equals(Object exts) {
        if (!(exts instanceof Extensions)) {
            return false;
        }
        Extensions extns = (Extensions)exts;
        return this.extensions == null || this.extensions.size() == 0 ? extns.extensions == null || extns.extensions.size() == 0 : (extns.extensions == null || extns.extensions.size() == 0 ? false : this.extensions.containsAll(extns.extensions) && this.extensions.size() == extns.extensions.size());
    }

    public int hashCode() {
        int hashcode = 0;
        if (this.extensions != null) {
            hashcode = ((Object)this.extensions).hashCode();
        }
        return hashcode;
    }

    public void dumpValue(StringBuffer buffer, String prefix) {
        if (this.extensions == null) {
            return;
        }
        int num = 1;
        for (Extension extension : this.extensions) {
            buffer.append('\n').append(prefix).append('[').append(num++).append("]: ");
            extension.dumpValue(buffer, prefix);
        }
    }
}

