/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.telephony.SmsCbConstants;

public class SmsCbHeader
implements SmsCbConstants {
    public static final int PDU_HEADER_LENGTH = 6;
    public static final int FORMAT_GSM = 1;
    public static final int FORMAT_UMTS = 2;
    public static final int FORMAT_ETWS_PRIMARY = 3;
    public static final int MESSAGE_TYPE_CBS_MESSAGE = 1;
    public static final int PDU_LENGTH_GSM = 88;
    public static final int PDU_LENGTH_ETWS = 56;
    public final int geographicalScope;
    public final int messageCode;
    public final int updateNumber;
    public final int messageIdentifier;
    public final int dataCodingScheme;
    public final int pageIndex;
    public final int nrOfPages;
    public final int format;
    public final boolean etwsEmergencyUserAlert;
    public final boolean etwsPopup;
    public final int etwsWarningType;

    public SmsCbHeader(byte[] pdu) throws IllegalArgumentException {
        if (pdu == null || pdu.length < 6) {
            throw new IllegalArgumentException("Illegal PDU");
        }
        if (pdu.length <= 56) {
            this.format = 3;
            this.geographicalScope = -1;
            this.messageCode = -1;
            this.updateNumber = -1;
            this.messageIdentifier = (pdu[2] & 0xFF) << 8 | pdu[3] & 0xFF;
            this.dataCodingScheme = -1;
            this.pageIndex = -1;
            this.nrOfPages = -1;
            this.etwsEmergencyUserAlert = (pdu[4] & 1) != 0;
            this.etwsPopup = (pdu[5] & 0x80) != 0;
            this.etwsWarningType = (pdu[4] & 0xFE) >> 1;
        } else if (pdu.length <= 88) {
            this.format = 1;
            this.geographicalScope = (pdu[0] & 0xC0) >> 6;
            this.messageCode = (pdu[0] & 0x3F) << 4 | (pdu[1] & 0xF0) >> 4;
            this.updateNumber = pdu[1] & 0xF;
            this.messageIdentifier = (pdu[2] & 0xFF) << 8 | pdu[3] & 0xFF;
            this.dataCodingScheme = pdu[4] & 0xFF;
            int pageIndex = (pdu[5] & 0xF0) >> 4;
            int nrOfPages = pdu[5] & 0xF;
            if (pageIndex == 0 || nrOfPages == 0 || pageIndex > nrOfPages) {
                pageIndex = 1;
                nrOfPages = 1;
            }
            this.pageIndex = pageIndex;
            this.nrOfPages = nrOfPages;
            this.etwsEmergencyUserAlert = false;
            this.etwsPopup = false;
            this.etwsWarningType = -1;
        } else {
            this.format = 2;
            byte messageType = pdu[0];
            if (messageType != 1) {
                throw new IllegalArgumentException("Unsupported message type " + messageType);
            }
            this.messageIdentifier = (pdu[1] & 0xFF) << 8 | pdu[2] & 0xFF;
            this.geographicalScope = (pdu[3] & 0xC0) >> 6;
            this.messageCode = (pdu[3] & 0x3F) << 4 | (pdu[4] & 0xF0) >> 4;
            this.updateNumber = pdu[4] & 0xF;
            this.dataCodingScheme = pdu[5] & 0xFF;
            this.pageIndex = 1;
            this.nrOfPages = 1;
            this.etwsEmergencyUserAlert = false;
            this.etwsPopup = false;
            this.etwsWarningType = -1;
        }
    }

    public static boolean isEmergencyMessage(int id2) {
        return id2 >= 4352 && id2 <= 6399;
    }

    public static boolean isEtwsMessage(int id2) {
        return (id2 & 0xFFF8) == 4352;
    }

    public static boolean isCmasMessage(int id2) {
        return id2 >= 4370 && id2 <= 4399;
    }

    public static boolean isEtwsPopupAlert(int messageCode) {
        return (messageCode & 0x100) != 0;
    }

    public static boolean isEtwsEmergencyUserAlert(int messageCode) {
        return (messageCode & 0x200) != 0;
    }

    public String toString() {
        return "SmsCbHeader{GS=" + this.geographicalScope + ", messageCode=0x" + Integer.toHexString(this.messageCode) + ", updateNumber=" + this.updateNumber + ", messageIdentifier=0x" + Integer.toHexString(this.messageIdentifier) + ", DCS=0x" + Integer.toHexString(this.dataCodingScheme) + ", page " + this.pageIndex + " of " + this.nrOfPages + '}';
    }
}

