/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.content.res.Resources;
import android.media.AudioManager;
import android.media.AudioService;
import android.media.AudioSystem;
import android.media.RingtoneManager;
import android.media.ToneGenerator;
import android.net.Uri;
import android.os.Handler;
import android.os.Message;
import android.os.Vibrator;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;

public class VolumePanel
extends Handler {
    public static final String TAG = "VolumePanel";
    public static boolean LOGD = false;
    public static final int PLAY_SOUND_DELAY = 300;
    public static final int VIBRATE_DELAY = 300;
    public static final int VIBRATE_DURATION = 300;
    public static final int BEEP_DURATION = 150;
    public static final int MAX_VOLUME = 100;
    public static final int FREE_DELAY = 10000;
    public static final int MSG_VOLUME_CHANGED = 0;
    public static final int MSG_FREE_RESOURCES = 1;
    public static final int MSG_PLAY_SOUND = 2;
    public static final int MSG_STOP_SOUNDS = 3;
    public static final int MSG_VIBRATE = 4;
    public static final int RINGTONE_VOLUME_TEXT = 17040147;
    public static final int MUSIC_VOLUME_TEXT = 17040148;
    public static final int INCALL_VOLUME_TEXT = 17040151;
    public static final int ALARM_VOLUME_TEXT = 17040153;
    public static final int UNKNOWN_VOLUME_TEXT = 17040155;
    public static final int NOTIFICATION_VOLUME_TEXT = 17040154;
    public static final int BLUETOOTH_INCALL_VOLUME_TEXT = 17040152;
    public Context mContext;
    public AudioManager mAudioManager;
    public AudioService mAudioService;
    public boolean mRingIsSilent;
    public final Toast mToast;
    public final View mView;
    public final TextView mMessage;
    public final TextView mAdditionalMessage;
    public final ImageView mSmallStreamIcon;
    public final ImageView mLargeStreamIcon;
    public final ProgressBar mLevel;
    public ToneGenerator[] mToneGenerators;
    public Vibrator mVibrator;

    public VolumePanel(Context context, AudioService volumeService) {
        this.mContext = context;
        this.mAudioManager = (AudioManager)context.getSystemService("audio");
        this.mAudioService = volumeService;
        this.mToast = new Toast(context);
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        View view = this.mView = inflater.inflate(17367147, null);
        this.mMessage = (TextView)view.findViewById(16908299);
        this.mAdditionalMessage = (TextView)view.findViewById(16908842);
        this.mSmallStreamIcon = (ImageView)view.findViewById(16908841);
        this.mLargeStreamIcon = (ImageView)view.findViewById(16908843);
        this.mLevel = (ProgressBar)view.findViewById(16908844);
        this.mToneGenerators = new ToneGenerator[AudioSystem.getNumStreamTypes()];
        this.mVibrator = new Vibrator();
    }

    public void postVolumeChanged(int streamType, int flags) {
        if (this.hasMessages(0)) {
            return;
        }
        this.removeMessages(1);
        this.obtainMessage(0, streamType, flags).sendToTarget();
    }

    public void onVolumeChanged(int streamType, int flags) {
        if (LOGD) {
            Log.d(TAG, "onVolumeChanged(streamType: " + streamType + ", flags: " + flags + ")");
        }
        if ((flags & 1) != 0) {
            this.onShowVolumeChanged(streamType, flags);
        }
        if ((flags & 4) != 0 && !this.mRingIsSilent) {
            this.removeMessages(2);
            this.sendMessageDelayed(this.obtainMessage(2, streamType, flags), 300L);
        }
        if ((flags & 8) != 0) {
            this.removeMessages(2);
            this.removeMessages(4);
            this.onStopSounds();
        }
        this.removeMessages(1);
        this.sendMessageDelayed(this.obtainMessage(1), 10000L);
    }

    public void onShowVolumeChanged(int streamType, int flags) {
        int index = this.mAudioService.getStreamVolume(streamType);
        int message = 17040155;
        int additionalMessage = 0;
        this.mRingIsSilent = false;
        if (LOGD) {
            Log.d(TAG, "onShowVolumeChanged(streamType: " + streamType + ", flags: " + flags + "), index: " + index);
        }
        int max = this.mAudioService.getStreamMaxVolume(streamType);
        switch (streamType) {
            case 2: {
                this.setRingerIcon();
                message = 17040147;
                Uri ringuri = RingtoneManager.getActualDefaultRingtoneUri(this.mContext, 1);
                if (ringuri != null) break;
                additionalMessage = 17040150;
                this.mRingIsSilent = true;
                break;
            }
            case 3: {
                message = 17040148;
                if (this.mAudioManager.isBluetoothA2dpOn()) {
                    additionalMessage = 17040149;
                    this.setLargeIcon(17301966);
                    break;
                }
                this.setSmallIcon(index);
                break;
            }
            case 0: {
                ++max;
                message = 17040151;
                this.setSmallIcon(++index);
                break;
            }
            case 4: {
                message = 17040153;
                this.setSmallIcon(index);
                break;
            }
            case 5: {
                message = 17040154;
                this.setSmallIcon(index);
                Uri ringuri = RingtoneManager.getActualDefaultRingtoneUri(this.mContext, 2);
                if (ringuri != null) break;
                additionalMessage = 17040150;
                this.mRingIsSilent = true;
                break;
            }
            case 6: {
                ++index;
                ++max;
                message = 17040152;
                this.setLargeIcon(17301967);
            }
        }
        String messageString = Resources.getSystem().getString(message);
        if (!this.mMessage.getText().equals(messageString)) {
            this.mMessage.setText(messageString);
        }
        if (additionalMessage == 0) {
            this.mAdditionalMessage.setVisibility(8);
        } else {
            this.mAdditionalMessage.setVisibility(0);
            this.mAdditionalMessage.setText(Resources.getSystem().getString(additionalMessage));
        }
        if (max != this.mLevel.getMax()) {
            this.mLevel.setMax(max);
        }
        this.mLevel.setProgress(index);
        this.mToast.setView(this.mView);
        this.mToast.setDuration(0);
        this.mToast.setGravity(48, 0, 0);
        this.mToast.show();
        if ((flags & 0x10) != 0 && this.mAudioService.isStreamAffectedByRingerMode(streamType) && this.mAudioService.getRingerMode() == 1 && this.mAudioService.shouldVibrate(0)) {
            this.sendMessageDelayed(this.obtainMessage(4), 300L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPlaySound(int streamType, int flags) {
        if (this.hasMessages(3)) {
            this.removeMessages(3);
            this.onStopSounds();
        }
        VolumePanel volumePanel = this;
        synchronized (volumePanel) {
            ToneGenerator toneGen = this.getOrCreateToneGenerator(streamType);
            toneGen.startTone(24);
        }
        this.sendMessageDelayed(this.obtainMessage(3), 150L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStopSounds() {
        VolumePanel volumePanel = this;
        synchronized (volumePanel) {
            int numStreamTypes = AudioSystem.getNumStreamTypes();
            for (int i = numStreamTypes - 1; i >= 0; --i) {
                ToneGenerator toneGen = this.mToneGenerators[i];
                if (toneGen == null) continue;
                toneGen.stopTone();
            }
        }
    }

    public void onVibrate() {
        if (this.mAudioService.getRingerMode() != 1) {
            return;
        }
        this.mVibrator.vibrate(300L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ToneGenerator getOrCreateToneGenerator(int streamType) {
        VolumePanel volumePanel = this;
        synchronized (volumePanel) {
            if (this.mToneGenerators[streamType] == null) {
                this.mToneGenerators[streamType] = new ToneGenerator(streamType, 100);
                return this.mToneGenerators[streamType];
            }
            return this.mToneGenerators[streamType];
        }
    }

    public void setSmallIcon(int index) {
        this.mLargeStreamIcon.setVisibility(8);
        this.mSmallStreamIcon.setVisibility(0);
        this.mSmallStreamIcon.setImageResource(index == 0 ? 17301969 : 17301970);
    }

    public void setLargeIcon(int resId) {
        this.mSmallStreamIcon.setVisibility(8);
        this.mLargeStreamIcon.setVisibility(0);
        this.mLargeStreamIcon.setImageResource(resId);
    }

    public void setRingerIcon() {
        this.mSmallStreamIcon.setVisibility(8);
        this.mLargeStreamIcon.setVisibility(0);
        int ringerMode = this.mAudioService.getRingerMode();
        if (LOGD) {
            Log.d(TAG, "setRingerIcon(), ringerMode: " + ringerMode);
        }
        int icon = ringerMode == 0 ? 17301968 : (ringerMode == 1 ? 17301963 : 17301965);
        this.mLargeStreamIcon.setImageResource(icon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFreeResources() {
        this.mSmallStreamIcon.setImageDrawable(null);
        this.mLargeStreamIcon.setImageDrawable(null);
        VolumePanel volumePanel = this;
        synchronized (volumePanel) {
            for (int i = this.mToneGenerators.length - 1; i >= 0; --i) {
                if (this.mToneGenerators[i] != null) {
                    this.mToneGenerators[i].release();
                }
                this.mToneGenerators[i] = null;
            }
        }
    }

    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 0: {
                this.onVolumeChanged(msg.arg1, msg.arg2);
                break;
            }
            case 1: {
                this.onFreeResources();
                break;
            }
            case 3: {
                this.onStopSounds();
                break;
            }
            case 2: {
                this.onPlaySound(msg.arg1, msg.arg2);
                break;
            }
            case 4: {
                this.onVibrate();
            }
        }
    }
}

