/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.os.Parcel;
import android.os.Parcelable;
import com.android.tools.layoutlib.create.OverrideMethod;

public class InputChannel
implements Parcelable {
    public static final String TAG = "InputChannel";
    public static final boolean DEBUG = false;
    public static final Parcelable.Creator<InputChannel> CREATOR = new Parcelable.Creator<InputChannel>(){

        @Override
        public InputChannel createFromParcel(Parcel source) {
            InputChannel result = new InputChannel();
            result.readFromParcel(source);
            return result;
        }

        public InputChannel[] newArray(int size) {
            return new InputChannel[size];
        }
    };
    public int mPtr;
    public boolean mDisposeAfterWriteToParcel;

    public static InputChannel[] nativeOpenInputChannelPair(String string2) {
        return (InputChannel[])OverrideMethod.invokeA("android.view.InputChannel#nativeOpenInputChannelPair(Ljava/lang/String;)[Landroid/view/InputChannel;", true, null);
    }

    public void nativeDispose(boolean bl) {
        OverrideMethod.invokeV("android.view.InputChannel#nativeDispose(Z)V", true, this);
    }

    public void nativeTransferTo(InputChannel inputChannel) {
        OverrideMethod.invokeV("android.view.InputChannel#nativeTransferTo(Landroid/view/InputChannel;)V", true, this);
    }

    public void nativeReadFromParcel(Parcel parcel) {
        OverrideMethod.invokeV("android.view.InputChannel#nativeReadFromParcel(Landroid/os/Parcel;)V", true, this);
    }

    public void nativeWriteToParcel(Parcel parcel) {
        OverrideMethod.invokeV("android.view.InputChannel#nativeWriteToParcel(Landroid/os/Parcel;)V", true, this);
    }

    public String nativeGetName() {
        return (String)OverrideMethod.invokeA("android.view.InputChannel#nativeGetName()Ljava/lang/String;", true, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        try {
            this.nativeDispose(true);
        }
        finally {
            super.finalize();
        }
    }

    public static InputChannel[] openInputChannelPair(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        return InputChannel.nativeOpenInputChannelPair(name);
    }

    public String getName() {
        String name = this.nativeGetName();
        return name != null ? name : "uninitialized";
    }

    public void dispose() {
        this.nativeDispose(false);
    }

    public void transferToBinderOutParameter(InputChannel outParameter) {
        if (outParameter == null) {
            throw new IllegalArgumentException("outParameter must not be null");
        }
        this.nativeTransferTo(outParameter);
        outParameter.mDisposeAfterWriteToParcel = true;
    }

    public int describeContents() {
        return 1;
    }

    public void readFromParcel(Parcel in) {
        if (in == null) {
            throw new IllegalArgumentException("in must not be null");
        }
        this.nativeReadFromParcel(in);
    }

    public void writeToParcel(Parcel out, int flags) {
        if (out == null) {
            throw new IllegalArgumentException("out must not be null");
        }
        this.nativeWriteToParcel(out);
        if (this.mDisposeAfterWriteToParcel) {
            this.dispose();
        }
    }

    public String toString() {
        return this.getName();
    }
}

