/*
 * Decompiled with CFR 0.152.
 */
package android.text.style;

import android.graphics.Paint;
import android.graphics.Typeface;
import android.os.Parcel;
import android.text.ParcelableSpan;
import android.text.TextPaint;
import android.text.style.MetricAffectingSpan;

public class StyleSpan
extends MetricAffectingSpan
implements ParcelableSpan {
    public final int mStyle;

    public StyleSpan(int style2) {
        this.mStyle = style2;
    }

    public StyleSpan(Parcel src) {
        this.mStyle = src.readInt();
    }

    public int getSpanTypeId() {
        return 7;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mStyle);
    }

    public int getStyle() {
        return this.mStyle;
    }

    public void updateDrawState(TextPaint ds) {
        StyleSpan.apply(ds, this.mStyle);
    }

    public void updateMeasureState(TextPaint paint) {
        StyleSpan.apply(paint, this.mStyle);
    }

    public static void apply(Paint paint, int style2) {
        Typeface tf;
        Typeface old = paint.getTypeface();
        int oldStyle = old == null ? 0 : old.getStyle();
        int want = oldStyle | style2;
        int fake = want & ~(tf = old == null ? Typeface.defaultFromStyle(want) : Typeface.create(old, want)).getStyle();
        if ((fake & 1) != 0) {
            paint.setFakeBoldText(true);
        }
        if ((fake & 2) != 0) {
            paint.setTextSkewX(-0.25f);
        }
        paint.setTypeface(tf);
    }
}

