/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.os.Bundle;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.telephony.TelephonyManager;
import android.telephony.cdma.CdmaCellLocation;
import android.telephony.gsm.GsmCellLocation;
import com.android.internal.telephony.ITelephony;

public abstract class CellLocation {
    public static void requestLocationUpdate() {
        try {
            ITelephony phone = ITelephony.Stub.asInterface(ServiceManager.getService((String)"phone"));
            if (phone != null) {
                phone.updateServiceLocation();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public static CellLocation newFromBundle(Bundle bundle) {
        switch (TelephonyManager.getDefault().getPhoneType()) {
            case 2: {
                return new CdmaCellLocation(bundle);
            }
            case 1: {
                return new GsmCellLocation(bundle);
            }
        }
        return null;
    }

    public abstract void fillInNotifierBundle(Bundle var1);

    public abstract boolean isEmpty();

    public static CellLocation getEmpty() {
        switch (TelephonyManager.getDefault().getPhoneType()) {
            case 2: {
                return new CdmaCellLocation();
            }
            case 1: {
                return new GsmCellLocation();
            }
        }
        return null;
    }
}

