/*
 * Decompiled with CFR 0.152.
 */
package android.net.rtp;

import java.util.Arrays;

public class AudioCodec {
    public final int type;
    public final String rtpmap;
    public final String fmtp;
    public static final AudioCodec PCMU = new AudioCodec(0, "PCMU/8000", null);
    public static final AudioCodec PCMA = new AudioCodec(8, "PCMA/8000", null);
    public static final AudioCodec GSM = new AudioCodec(3, "GSM/8000", null);
    public static final AudioCodec GSM_EFR = new AudioCodec(96, "GSM-EFR/8000", null);
    public static final AudioCodec AMR = new AudioCodec(97, "AMR/8000", null);
    public static final AudioCodec[] sCodecs = new AudioCodec[]{GSM_EFR, AMR, GSM, PCMU, PCMA};

    public AudioCodec(int type, String rtpmap, String fmtp) {
        this.type = type;
        this.rtpmap = rtpmap;
        this.fmtp = fmtp;
    }

    public static AudioCodec[] getCodecs() {
        return Arrays.copyOf(sCodecs, sCodecs.length);
    }

    public static AudioCodec getCodec(int type, String rtpmap, String fmtp) {
        String clue;
        if (type < 0 || type > 127) {
            return null;
        }
        AudioCodec hint = null;
        if (rtpmap != null) {
            clue = rtpmap.trim().toUpperCase();
            for (AudioCodec codec : sCodecs) {
                if (!clue.startsWith(codec.rtpmap)) continue;
                String channels = clue.substring(codec.rtpmap.length());
                if (channels.length() != 0 && !channels.equals("/1")) break;
                hint = codec;
                break;
            }
        } else if (type < 96) {
            for (AudioCodec codec : sCodecs) {
                if (type != codec.type) continue;
                hint = codec;
                rtpmap = codec.rtpmap;
                break;
            }
        }
        if (hint == null) {
            return null;
        }
        if (hint == AMR && fmtp != null && ((clue = fmtp.toLowerCase()).contains("crc=1") || clue.contains("robust-sorting=1") || clue.contains("interleaving="))) {
            return null;
        }
        return new AudioCodec(type, rtpmap, fmtp);
    }
}

