/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.content.res.AssetManager;
import android.graphics.Typeface_Delegate;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.io.File;

public class Typeface {
    public static final Typeface DEFAULT = Typeface.create((String)null, 0);
    public static final Typeface DEFAULT_BOLD = Typeface.create((String)null, 1);
    public static final Typeface SANS_SERIF = Typeface.create("sans-serif", 0);
    public static final Typeface SERIF = Typeface.create("serif", 0);
    public static final Typeface MONOSPACE = Typeface.create("monospace", 0);
    public static Typeface[] sDefaults = new Typeface[]{DEFAULT, DEFAULT_BOLD, Typeface.create((String)null, 2), Typeface.create((String)null, 3)};
    public int native_instance;
    public static final int NORMAL = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public static final int BOLD_ITALIC = 3;

    public int getStyle() {
        return Typeface.nativeGetStyle(this.native_instance);
    }

    public boolean isBold() {
        return (this.getStyle() & 1) != 0;
    }

    public boolean isItalic() {
        return (this.getStyle() & 2) != 0;
    }

    public static Typeface create(String familyName, int style2) {
        return new Typeface(Typeface.nativeCreate(familyName, style2));
    }

    public static Typeface create(Typeface family, int style2) {
        int ni = 0;
        if (family != null) {
            ni = family.native_instance;
        }
        return new Typeface(Typeface.nativeCreateFromTypeface(ni, style2));
    }

    public static Typeface defaultFromStyle(int style2) {
        return sDefaults[style2];
    }

    public static Typeface createFromAsset(AssetManager mgr, String path) {
        return new Typeface(Typeface.nativeCreateFromAsset(mgr, path));
    }

    public static Typeface createFromFile(File path) {
        return new Typeface(Typeface.nativeCreateFromFile(path.getAbsolutePath()));
    }

    public static Typeface createFromFile(String path) {
        return new Typeface(Typeface.nativeCreateFromFile(path));
    }

    public Typeface(int ni) {
        if (0 == ni) {
            throw new RuntimeException("native typeface cannot be made");
        }
        this.native_instance = ni;
    }

    public void finalize() throws Throwable {
        super.finalize();
        Typeface.nativeUnref(this.native_instance);
    }

    @LayoutlibDelegate
    public static int nativeCreate(String string2, int n) {
        return Typeface_Delegate.nativeCreate((String)string2, (int)n);
    }

    @LayoutlibDelegate
    public static int nativeCreateFromTypeface(int n, int n2) {
        return Typeface_Delegate.nativeCreateFromTypeface((int)n, (int)n2);
    }

    @LayoutlibDelegate
    public static void nativeUnref(int n) {
        Typeface_Delegate.nativeUnref((int)n);
    }

    @LayoutlibDelegate
    public static int nativeGetStyle(int n) {
        return Typeface_Delegate.nativeGetStyle((int)n);
    }

    @LayoutlibDelegate
    public static int nativeCreateFromAsset(AssetManager assetManager, String string2) {
        return Typeface_Delegate.nativeCreateFromAsset((AssetManager)assetManager, (String)string2);
    }

    @LayoutlibDelegate
    public static int nativeCreateFromFile(String string2) {
        return Typeface_Delegate.nativeCreateFromFile((String)string2);
    }

    @LayoutlibDelegate
    public static void setGammaForText(float f, float f2) {
        Typeface_Delegate.setGammaForText((float)f, (float)f2);
    }
}

