/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.ColorFilter;
import android.graphics.MaskFilter;
import android.graphics.Paint_Delegate;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.Rasterizer;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.TemporaryBuffer;
import android.graphics.Typeface;
import android.graphics.Xfermode;
import android.text.GraphicsOperations;
import android.text.SpannableString;
import android.text.SpannedString;
import android.text.TextUtils;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;

public class Paint {
    public int mNativePaint;
    public ColorFilter mColorFilter;
    public MaskFilter mMaskFilter;
    public PathEffect mPathEffect;
    public Rasterizer mRasterizer;
    public Shader mShader;
    public Typeface mTypeface;
    public Xfermode mXfermode;
    public boolean mHasCompatScaling;
    public float mCompatScaling;
    public float mInvCompatScaling;
    public static final Style[] sStyleArray = new Style[]{Style.FILL, Style.STROKE, Style.FILL_AND_STROKE};
    public static final Cap[] sCapArray = new Cap[]{Cap.BUTT, Cap.ROUND, Cap.SQUARE};
    public static final Join[] sJoinArray = new Join[]{Join.MITER, Join.ROUND, Join.BEVEL};
    public static final Align[] sAlignArray = new Align[]{Align.LEFT, Align.CENTER, Align.RIGHT};
    public static final int ANTI_ALIAS_FLAG = 1;
    public static final int FILTER_BITMAP_FLAG = 2;
    public static final int DITHER_FLAG = 4;
    public static final int UNDERLINE_TEXT_FLAG = 8;
    public static final int STRIKE_THRU_TEXT_FLAG = 16;
    public static final int FAKE_BOLD_TEXT_FLAG = 32;
    public static final int LINEAR_TEXT_FLAG = 64;
    public static final int SUBPIXEL_TEXT_FLAG = 128;
    public static final int DEV_KERN_TEXT_FLAG = 256;
    public static final int DEFAULT_PAINT_FLAGS = 256;

    public Paint() {
        this(0);
    }

    public Paint(int flags) {
        this.mNativePaint = Paint.native_init();
        this.setFlags(flags | 0x100);
        this.mInvCompatScaling = 1.0f;
        this.mCompatScaling = 1.0f;
    }

    public Paint(Paint paint) {
        this.mNativePaint = Paint.native_initWithPaint(paint.mNativePaint);
        this.mHasCompatScaling = paint.mHasCompatScaling;
        this.mCompatScaling = paint.mCompatScaling;
        this.mInvCompatScaling = paint.mInvCompatScaling;
    }

    public void reset() {
        Paint.native_reset(this.mNativePaint);
        this.setFlags(256);
        this.mHasCompatScaling = false;
        this.mInvCompatScaling = 1.0f;
        this.mCompatScaling = 1.0f;
    }

    public void set(Paint src) {
        if (this != src) {
            Paint.native_set(this.mNativePaint, src.mNativePaint);
            this.mColorFilter = src.mColorFilter;
            this.mMaskFilter = src.mMaskFilter;
            this.mPathEffect = src.mPathEffect;
            this.mRasterizer = src.mRasterizer;
            this.mShader = src.mShader;
            this.mTypeface = src.mTypeface;
            this.mXfermode = src.mXfermode;
            this.mHasCompatScaling = src.mHasCompatScaling;
            this.mCompatScaling = src.mCompatScaling;
            this.mInvCompatScaling = src.mInvCompatScaling;
        }
    }

    public void setCompatibilityScaling(float factor) {
        if ((double)factor == 1.0) {
            this.mHasCompatScaling = false;
            this.mInvCompatScaling = 1.0f;
            this.mCompatScaling = 1.0f;
        } else {
            this.mHasCompatScaling = true;
            this.mCompatScaling = factor;
            this.mInvCompatScaling = 1.0f / factor;
        }
    }

    @LayoutlibDelegate
    public int getFlags() {
        return Paint_Delegate.getFlags((Paint)this);
    }

    @LayoutlibDelegate
    public void setFlags(int n) {
        Paint_Delegate.setFlags((Paint)this, (int)n);
    }

    public boolean isAntiAlias() {
        return (this.getFlags() & 1) != 0;
    }

    @LayoutlibDelegate
    public void setAntiAlias(boolean bl) {
        Paint_Delegate.setAntiAlias((Paint)this, (boolean)bl);
    }

    public boolean isDither() {
        return (this.getFlags() & 4) != 0;
    }

    @LayoutlibDelegate
    public void setDither(boolean bl) {
        Paint_Delegate.setDither((Paint)this, (boolean)bl);
    }

    public boolean isLinearText() {
        return (this.getFlags() & 0x40) != 0;
    }

    @LayoutlibDelegate
    public void setLinearText(boolean bl) {
        Paint_Delegate.setLinearText((Paint)this, (boolean)bl);
    }

    public boolean isSubpixelText() {
        return (this.getFlags() & 0x80) != 0;
    }

    @LayoutlibDelegate
    public void setSubpixelText(boolean bl) {
        Paint_Delegate.setSubpixelText((Paint)this, (boolean)bl);
    }

    public boolean isUnderlineText() {
        return (this.getFlags() & 8) != 0;
    }

    @LayoutlibDelegate
    public void setUnderlineText(boolean bl) {
        Paint_Delegate.setUnderlineText((Paint)this, (boolean)bl);
    }

    public boolean isStrikeThruText() {
        return (this.getFlags() & 0x10) != 0;
    }

    @LayoutlibDelegate
    public void setStrikeThruText(boolean bl) {
        Paint_Delegate.setStrikeThruText((Paint)this, (boolean)bl);
    }

    public boolean isFakeBoldText() {
        return (this.getFlags() & 0x20) != 0;
    }

    @LayoutlibDelegate
    public void setFakeBoldText(boolean bl) {
        Paint_Delegate.setFakeBoldText((Paint)this, (boolean)bl);
    }

    public boolean isFilterBitmap() {
        return (this.getFlags() & 2) != 0;
    }

    @LayoutlibDelegate
    public void setFilterBitmap(boolean bl) {
        Paint_Delegate.setFilterBitmap((Paint)this, (boolean)bl);
    }

    public Style getStyle() {
        return sStyleArray[Paint.native_getStyle(this.mNativePaint)];
    }

    public void setStyle(Style style2) {
        Paint.native_setStyle(this.mNativePaint, style2.nativeInt);
    }

    @LayoutlibDelegate
    public int getColor() {
        return Paint_Delegate.getColor((Paint)this);
    }

    @LayoutlibDelegate
    public void setColor(int n) {
        Paint_Delegate.setColor((Paint)this, (int)n);
    }

    @LayoutlibDelegate
    public int getAlpha() {
        return Paint_Delegate.getAlpha((Paint)this);
    }

    @LayoutlibDelegate
    public void setAlpha(int n) {
        Paint_Delegate.setAlpha((Paint)this, (int)n);
    }

    public void setARGB(int a, int r, int g, int b) {
        this.setColor(a << 24 | r << 16 | g << 8 | b);
    }

    @LayoutlibDelegate
    public float getStrokeWidth() {
        return Paint_Delegate.getStrokeWidth((Paint)this);
    }

    @LayoutlibDelegate
    public void setStrokeWidth(float f) {
        Paint_Delegate.setStrokeWidth((Paint)this, (float)f);
    }

    @LayoutlibDelegate
    public float getStrokeMiter() {
        return Paint_Delegate.getStrokeMiter((Paint)this);
    }

    @LayoutlibDelegate
    public void setStrokeMiter(float f) {
        Paint_Delegate.setStrokeMiter((Paint)this, (float)f);
    }

    public Cap getStrokeCap() {
        return sCapArray[Paint.native_getStrokeCap(this.mNativePaint)];
    }

    public void setStrokeCap(Cap cap) {
        Paint.native_setStrokeCap(this.mNativePaint, cap.nativeInt);
    }

    public Join getStrokeJoin() {
        return sJoinArray[Paint.native_getStrokeJoin(this.mNativePaint)];
    }

    public void setStrokeJoin(Join join) {
        Paint.native_setStrokeJoin(this.mNativePaint, join.nativeInt);
    }

    public boolean getFillPath(Path src, Path dst) {
        return Paint.native_getFillPath(this.mNativePaint, src.ni(), dst.ni());
    }

    public Shader getShader() {
        return this.mShader;
    }

    public Shader setShader(Shader shader) {
        int shaderNative = 0;
        if (shader != null) {
            shaderNative = shader.native_instance;
        }
        Paint.native_setShader(this.mNativePaint, shaderNative);
        this.mShader = shader;
        return shader;
    }

    public ColorFilter getColorFilter() {
        return this.mColorFilter;
    }

    public ColorFilter setColorFilter(ColorFilter filter) {
        int filterNative = 0;
        if (filter != null) {
            filterNative = filter.native_instance;
        }
        Paint.native_setColorFilter(this.mNativePaint, filterNative);
        this.mColorFilter = filter;
        return filter;
    }

    public Xfermode getXfermode() {
        return this.mXfermode;
    }

    public Xfermode setXfermode(Xfermode xfermode) {
        int xfermodeNative = 0;
        if (xfermode != null) {
            xfermodeNative = xfermode.native_instance;
        }
        Paint.native_setXfermode(this.mNativePaint, xfermodeNative);
        this.mXfermode = xfermode;
        return xfermode;
    }

    public PathEffect getPathEffect() {
        return this.mPathEffect;
    }

    public PathEffect setPathEffect(PathEffect effect) {
        int effectNative = 0;
        if (effect != null) {
            effectNative = effect.native_instance;
        }
        Paint.native_setPathEffect(this.mNativePaint, effectNative);
        this.mPathEffect = effect;
        return effect;
    }

    public MaskFilter getMaskFilter() {
        return this.mMaskFilter;
    }

    public MaskFilter setMaskFilter(MaskFilter maskfilter) {
        int maskfilterNative = 0;
        if (maskfilter != null) {
            maskfilterNative = maskfilter.native_instance;
        }
        Paint.native_setMaskFilter(this.mNativePaint, maskfilterNative);
        this.mMaskFilter = maskfilter;
        return maskfilter;
    }

    public Typeface getTypeface() {
        return this.mTypeface;
    }

    public Typeface setTypeface(Typeface typeface) {
        int typefaceNative = 0;
        if (typeface != null) {
            typefaceNative = typeface.native_instance;
        }
        Paint.native_setTypeface(this.mNativePaint, typefaceNative);
        this.mTypeface = typeface;
        return typeface;
    }

    public Rasterizer getRasterizer() {
        return this.mRasterizer;
    }

    public Rasterizer setRasterizer(Rasterizer rasterizer) {
        int rasterizerNative = 0;
        if (rasterizer != null) {
            rasterizerNative = rasterizer.native_instance;
        }
        Paint.native_setRasterizer(this.mNativePaint, rasterizerNative);
        this.mRasterizer = rasterizer;
        return rasterizer;
    }

    @LayoutlibDelegate
    public void setShadowLayer(float f, float f2, float f3, int n) {
        Paint_Delegate.setShadowLayer((Paint)this, (float)f, (float)f2, (float)f3, (int)n);
    }

    public void clearShadowLayer() {
        this.setShadowLayer(0.0f, 0.0f, 0.0f, 0);
    }

    public Align getTextAlign() {
        return sAlignArray[Paint.native_getTextAlign(this.mNativePaint)];
    }

    public void setTextAlign(Align align) {
        Paint.native_setTextAlign(this.mNativePaint, align.nativeInt);
    }

    @LayoutlibDelegate
    public float getTextSize() {
        return Paint_Delegate.getTextSize((Paint)this);
    }

    @LayoutlibDelegate
    public void setTextSize(float f) {
        Paint_Delegate.setTextSize((Paint)this, (float)f);
    }

    @LayoutlibDelegate
    public float getTextScaleX() {
        return Paint_Delegate.getTextScaleX((Paint)this);
    }

    @LayoutlibDelegate
    public void setTextScaleX(float f) {
        Paint_Delegate.setTextScaleX((Paint)this, (float)f);
    }

    @LayoutlibDelegate
    public float getTextSkewX() {
        return Paint_Delegate.getTextSkewX((Paint)this);
    }

    @LayoutlibDelegate
    public void setTextSkewX(float f) {
        Paint_Delegate.setTextSkewX((Paint)this, (float)f);
    }

    @LayoutlibDelegate
    public float ascent() {
        return Paint_Delegate.ascent((Paint)this);
    }

    @LayoutlibDelegate
    public float descent() {
        return Paint_Delegate.descent((Paint)this);
    }

    @LayoutlibDelegate
    public float getFontMetrics(FontMetrics fontMetrics) {
        return Paint_Delegate.getFontMetrics((Paint)this, (FontMetrics)fontMetrics);
    }

    public FontMetrics getFontMetrics() {
        FontMetrics fm = new FontMetrics();
        this.getFontMetrics(fm);
        return fm;
    }

    @LayoutlibDelegate
    public int getFontMetricsInt(FontMetricsInt fontMetricsInt) {
        return Paint_Delegate.getFontMetricsInt((Paint)this, (FontMetricsInt)fontMetricsInt);
    }

    public FontMetricsInt getFontMetricsInt() {
        FontMetricsInt fm = new FontMetricsInt();
        this.getFontMetricsInt(fm);
        return fm;
    }

    public float getFontSpacing() {
        return this.getFontMetrics(null);
    }

    public float measureText(char[] text, int index, int count) {
        if (!this.mHasCompatScaling) {
            return this.native_measureText(text, index, count);
        }
        float oldSize = this.getTextSize();
        this.setTextSize(oldSize * this.mCompatScaling);
        float w = this.native_measureText(text, index, count);
        this.setTextSize(oldSize);
        return w * this.mInvCompatScaling;
    }

    @LayoutlibDelegate
    public float native_measureText(char[] cArray, int n, int n2) {
        return Paint_Delegate.native_measureText((Paint)this, (char[])cArray, (int)n, (int)n2);
    }

    public float measureText(String text, int start, int end) {
        if (!this.mHasCompatScaling) {
            return this.native_measureText(text, start, end);
        }
        float oldSize = this.getTextSize();
        this.setTextSize(oldSize * this.mCompatScaling);
        float w = this.native_measureText(text, start, end);
        this.setTextSize(oldSize);
        return w * this.mInvCompatScaling;
    }

    @LayoutlibDelegate
    public float native_measureText(String string2, int n, int n2) {
        return Paint_Delegate.native_measureText((Paint)this, (String)string2, (int)n, (int)n2);
    }

    public float measureText(String text) {
        if (!this.mHasCompatScaling) {
            return this.native_measureText(text);
        }
        float oldSize = this.getTextSize();
        this.setTextSize(oldSize * this.mCompatScaling);
        float w = this.native_measureText(text);
        this.setTextSize(oldSize);
        return w * this.mInvCompatScaling;
    }

    @LayoutlibDelegate
    public float native_measureText(String string2) {
        return Paint_Delegate.native_measureText((Paint)this, (String)string2);
    }

    public float measureText(CharSequence text, int start, int end) {
        if (text instanceof String) {
            return this.measureText((String)text, start, end);
        }
        if (text instanceof SpannedString || text instanceof SpannableString) {
            return this.measureText(((Object)text).toString(), start, end);
        }
        if (text instanceof GraphicsOperations) {
            return ((GraphicsOperations)text).measureText(start, end, this);
        }
        char[] buf = TemporaryBuffer.obtain(end - start);
        TextUtils.getChars(text, start, end, buf, 0);
        float result = this.measureText(buf, 0, end - start);
        TemporaryBuffer.recycle(buf);
        return result;
    }

    public int breakText(char[] text, int index, int count, float maxWidth, float[] measuredWidth) {
        if (!this.mHasCompatScaling) {
            return this.native_breakText(text, index, count, maxWidth, measuredWidth);
        }
        float oldSize = this.getTextSize();
        this.setTextSize(oldSize * this.mCompatScaling);
        int res = this.native_breakText(text, index, count, maxWidth * this.mCompatScaling, measuredWidth);
        this.setTextSize(oldSize);
        if (measuredWidth != null) {
            measuredWidth[0] = measuredWidth[0] * this.mInvCompatScaling;
        }
        return res;
    }

    @LayoutlibDelegate
    public int native_breakText(char[] cArray, int n, int n2, float f, float[] fArray) {
        return Paint_Delegate.native_breakText((Paint)this, (char[])cArray, (int)n, (int)n2, (float)f, (float[])fArray);
    }

    public int breakText(CharSequence text, int start, int end, boolean measureForwards, float maxWidth, float[] measuredWidth) {
        if (start == 0 && text instanceof String && end == text.length()) {
            return this.breakText((String)text, measureForwards, maxWidth, measuredWidth);
        }
        char[] buf = TemporaryBuffer.obtain(end - start);
        TextUtils.getChars(text, start, end, buf, 0);
        int result = measureForwards ? this.breakText(buf, 0, end - start, maxWidth, measuredWidth) : this.breakText(buf, 0, -(end - start), maxWidth, measuredWidth);
        TemporaryBuffer.recycle(buf);
        return result;
    }

    public int breakText(String text, boolean measureForwards, float maxWidth, float[] measuredWidth) {
        if (!this.mHasCompatScaling) {
            return this.native_breakText(text, measureForwards, maxWidth, measuredWidth);
        }
        float oldSize = this.getTextSize();
        this.setTextSize(oldSize * this.mCompatScaling);
        int res = this.native_breakText(text, measureForwards, maxWidth * this.mCompatScaling, measuredWidth);
        this.setTextSize(oldSize);
        if (measuredWidth != null) {
            measuredWidth[0] = measuredWidth[0] * this.mInvCompatScaling;
        }
        return res;
    }

    @LayoutlibDelegate
    public int native_breakText(String string2, boolean bl, float f, float[] fArray) {
        return Paint_Delegate.native_breakText((Paint)this, (String)string2, (boolean)bl, (float)f, (float[])fArray);
    }

    public int getTextWidths(char[] text, int index, int count, float[] widths) {
        if ((index | count) < 0 || index + count > text.length || count > widths.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (!this.mHasCompatScaling) {
            return Paint.native_getTextWidths(this.mNativePaint, text, index, count, widths);
        }
        float oldSize = this.getTextSize();
        this.setTextSize(oldSize * this.mCompatScaling);
        int res = Paint.native_getTextWidths(this.mNativePaint, text, index, count, widths);
        this.setTextSize(oldSize);
        int i = 0;
        while (i < res) {
            int n = i++;
            widths[n] = widths[n] * this.mInvCompatScaling;
        }
        return res;
    }

    public int getTextWidths(CharSequence text, int start, int end, float[] widths) {
        if (text instanceof String) {
            return this.getTextWidths((String)text, start, end, widths);
        }
        if (text instanceof SpannedString || text instanceof SpannableString) {
            return this.getTextWidths(((Object)text).toString(), start, end, widths);
        }
        if (text instanceof GraphicsOperations) {
            return ((GraphicsOperations)text).getTextWidths(start, end, widths, this);
        }
        char[] buf = TemporaryBuffer.obtain(end - start);
        TextUtils.getChars(text, start, end, buf, 0);
        int result = this.getTextWidths(buf, 0, end - start, widths);
        TemporaryBuffer.recycle(buf);
        return result;
    }

    public int getTextWidths(String text, int start, int end, float[] widths) {
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (end - start > widths.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (!this.mHasCompatScaling) {
            return Paint.native_getTextWidths(this.mNativePaint, text, start, end, widths);
        }
        float oldSize = this.getTextSize();
        this.setTextSize(oldSize * this.mCompatScaling);
        int res = Paint.native_getTextWidths(this.mNativePaint, text, start, end, widths);
        this.setTextSize(oldSize);
        int i = 0;
        while (i < res) {
            int n = i++;
            widths[n] = widths[n] * this.mInvCompatScaling;
        }
        return res;
    }

    public int getTextWidths(String text, float[] widths) {
        return this.getTextWidths(text, 0, text.length(), widths);
    }

    public void getTextPath(char[] text, int index, int count, float x, float y, Path path) {
        if ((index | count) < 0 || index + count > text.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Paint.native_getTextPath(this.mNativePaint, text, index, count, x, y, path.ni());
    }

    public void getTextPath(String text, int start, int end, float x, float y, Path path) {
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        Paint.native_getTextPath(this.mNativePaint, text, start, end, x, y, path.ni());
    }

    public void getTextBounds(String text, int start, int end, Rect bounds) {
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (bounds == null) {
            throw new NullPointerException("need bounds Rect");
        }
        Paint.nativeGetStringBounds(this.mNativePaint, text, start, end, bounds);
    }

    public void getTextBounds(char[] text, int index, int count, Rect bounds) {
        if ((index | count) < 0 || index + count > text.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (bounds == null) {
            throw new NullPointerException("need bounds Rect");
        }
        Paint.nativeGetCharArrayBounds(this.mNativePaint, text, index, count, bounds);
    }

    public void finalize() throws Throwable {
        Paint.finalizer(this.mNativePaint);
    }

    @LayoutlibDelegate
    public static int native_init() {
        return Paint_Delegate.native_init();
    }

    @LayoutlibDelegate
    public static int native_initWithPaint(int n) {
        return Paint_Delegate.native_initWithPaint((int)n);
    }

    @LayoutlibDelegate
    public static void native_reset(int n) {
        Paint_Delegate.native_reset((int)n);
    }

    @LayoutlibDelegate
    public static void native_set(int n, int n2) {
        Paint_Delegate.native_set((int)n, (int)n2);
    }

    @LayoutlibDelegate
    public static int native_getStyle(int n) {
        return Paint_Delegate.native_getStyle((int)n);
    }

    @LayoutlibDelegate
    public static void native_setStyle(int n, int n2) {
        Paint_Delegate.native_setStyle((int)n, (int)n2);
    }

    @LayoutlibDelegate
    public static int native_getStrokeCap(int n) {
        return Paint_Delegate.native_getStrokeCap((int)n);
    }

    @LayoutlibDelegate
    public static void native_setStrokeCap(int n, int n2) {
        Paint_Delegate.native_setStrokeCap((int)n, (int)n2);
    }

    @LayoutlibDelegate
    public static int native_getStrokeJoin(int n) {
        return Paint_Delegate.native_getStrokeJoin((int)n);
    }

    @LayoutlibDelegate
    public static void native_setStrokeJoin(int n, int n2) {
        Paint_Delegate.native_setStrokeJoin((int)n, (int)n2);
    }

    @LayoutlibDelegate
    public static boolean native_getFillPath(int n, int n2, int n3) {
        return Paint_Delegate.native_getFillPath((int)n, (int)n2, (int)n3);
    }

    @LayoutlibDelegate
    public static int native_setShader(int n, int n2) {
        return Paint_Delegate.native_setShader((int)n, (int)n2);
    }

    @LayoutlibDelegate
    public static int native_setColorFilter(int n, int n2) {
        return Paint_Delegate.native_setColorFilter((int)n, (int)n2);
    }

    @LayoutlibDelegate
    public static int native_setXfermode(int n, int n2) {
        return Paint_Delegate.native_setXfermode((int)n, (int)n2);
    }

    @LayoutlibDelegate
    public static int native_setPathEffect(int n, int n2) {
        return Paint_Delegate.native_setPathEffect((int)n, (int)n2);
    }

    @LayoutlibDelegate
    public static int native_setMaskFilter(int n, int n2) {
        return Paint_Delegate.native_setMaskFilter((int)n, (int)n2);
    }

    @LayoutlibDelegate
    public static int native_setTypeface(int n, int n2) {
        return Paint_Delegate.native_setTypeface((int)n, (int)n2);
    }

    @LayoutlibDelegate
    public static int native_setRasterizer(int n, int n2) {
        return Paint_Delegate.native_setRasterizer((int)n, (int)n2);
    }

    @LayoutlibDelegate
    public static int native_getTextAlign(int n) {
        return Paint_Delegate.native_getTextAlign((int)n);
    }

    @LayoutlibDelegate
    public static void native_setTextAlign(int n, int n2) {
        Paint_Delegate.native_setTextAlign((int)n, (int)n2);
    }

    @LayoutlibDelegate
    public static float native_getFontMetrics(int n, FontMetrics fontMetrics) {
        return Paint_Delegate.native_getFontMetrics((int)n, (FontMetrics)fontMetrics);
    }

    @LayoutlibDelegate
    public static int native_getTextWidths(int n, char[] cArray, int n2, int n3, float[] fArray) {
        return Paint_Delegate.native_getTextWidths((int)n, (char[])cArray, (int)n2, (int)n3, (float[])fArray);
    }

    @LayoutlibDelegate
    public static int native_getTextWidths(int n, String string2, int n2, int n3, float[] fArray) {
        return Paint_Delegate.native_getTextWidths((int)n, (String)string2, (int)n2, (int)n3, (float[])fArray);
    }

    @LayoutlibDelegate
    public static void native_getTextPath(int n, char[] cArray, int n2, int n3, float f, float f2, int n4) {
        Paint_Delegate.native_getTextPath((int)n, (char[])cArray, (int)n2, (int)n3, (float)f, (float)f2, (int)n4);
    }

    @LayoutlibDelegate
    public static void native_getTextPath(int n, String string2, int n2, int n3, float f, float f2, int n4) {
        Paint_Delegate.native_getTextPath((int)n, (String)string2, (int)n2, (int)n3, (float)f, (float)f2, (int)n4);
    }

    @LayoutlibDelegate
    public static void nativeGetStringBounds(int n, String string2, int n2, int n3, Rect rect) {
        Paint_Delegate.nativeGetStringBounds((int)n, (String)string2, (int)n2, (int)n3, (Rect)rect);
    }

    @LayoutlibDelegate
    public static void nativeGetCharArrayBounds(int n, char[] cArray, int n2, int n3, Rect rect) {
        Paint_Delegate.nativeGetCharArrayBounds((int)n, (char[])cArray, (int)n2, (int)n3, (Rect)rect);
    }

    @LayoutlibDelegate
    public static void finalizer(int n) {
        Paint_Delegate.finalizer((int)n);
    }

    public static class FontMetricsInt {
        public int top;
        public int ascent;
        public int descent;
        public int bottom;
        public int leading;

        public String toString() {
            return "FontMetricsInt: top=" + this.top + " ascent=" + this.ascent + " descent=" + this.descent + " bottom=" + this.bottom + " leading=" + this.leading;
        }
    }

    public static class FontMetrics {
        public float top;
        public float ascent;
        public float descent;
        public float bottom;
        public float leading;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Align {
        LEFT(0),
        CENTER(1),
        RIGHT(2);

        public final int nativeInt;

        public Align(int nativeInt) {
            this.nativeInt = nativeInt;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Join {
        MITER(0),
        ROUND(1),
        BEVEL(2);

        public final int nativeInt;

        public Join(int nativeInt) {
            this.nativeInt = nativeInt;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Cap {
        BUTT(0),
        ROUND(1),
        SQUARE(2);

        public final int nativeInt;

        public Cap(int nativeInt) {
            this.nativeInt = nativeInt;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Style {
        FILL(0),
        STROKE(1),
        FILL_AND_STROKE(2);

        public final int nativeInt;

        public Style(int nativeInt) {
            this.nativeInt = nativeInt;
        }
    }
}

