/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import com.android.tools.layoutlib.create.OverrideMethod;

public class LargeBitmap {
    public int mNativeLargeBitmap;
    public boolean mRecycled;

    public LargeBitmap(int lbm) {
        this.mNativeLargeBitmap = lbm;
        this.mRecycled = false;
    }

    public Bitmap decodeRegion(Rect rect, BitmapFactory.Options options) {
        this.checkRecycled("decodeRegion called on recycled large bitmap");
        if (rect.left < 0 || rect.top < 0 || rect.right > this.getWidth() || rect.bottom > this.getHeight()) {
            throw new IllegalArgumentException("rectangle is not inside the image");
        }
        return LargeBitmap.nativeDecodeRegion(this.mNativeLargeBitmap, rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top, options);
    }

    public int getWidth() {
        this.checkRecycled("getWidth called on recycled large bitmap");
        return LargeBitmap.nativeGetWidth(this.mNativeLargeBitmap);
    }

    public int getHeight() {
        this.checkRecycled("getHeight called on recycled large bitmap");
        return LargeBitmap.nativeGetHeight(this.mNativeLargeBitmap);
    }

    public void recycle() {
        if (!this.mRecycled) {
            LargeBitmap.nativeClean(this.mNativeLargeBitmap);
            this.mRecycled = true;
        }
    }

    public boolean isRecycled() {
        return this.mRecycled;
    }

    public void checkRecycled(String errorMessage) {
        if (this.mRecycled) {
            throw new IllegalStateException(errorMessage);
        }
    }

    public void finalize() {
        this.recycle();
    }

    public static Bitmap nativeDecodeRegion(int n, int n2, int n3, int n4, int n5, BitmapFactory.Options options) {
        return (Bitmap)OverrideMethod.invokeA("android.graphics.LargeBitmap#nativeDecodeRegion(IIIIILandroid/graphics/BitmapFactory$Options;)Landroid/graphics/Bitmap;", true, null);
    }

    public static int nativeGetWidth(int n) {
        return OverrideMethod.invokeI("android.graphics.LargeBitmap#nativeGetWidth(I)I", true, null);
    }

    public static int nativeGetHeight(int n) {
        return OverrideMethod.invokeI("android.graphics.LargeBitmap#nativeGetHeight(I)I", true, null);
    }

    public static void nativeClean(int n) {
        OverrideMethod.invokeV("android.graphics.LargeBitmap#nativeClean(I)V", true, null);
    }
}

