/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Bitmap;
import android.graphics.Canvas_Delegate;
import android.graphics.DrawFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Picture;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.TemporaryBuffer;
import android.text.GraphicsOperations;
import android.text.SpannableString;
import android.text.SpannedString;
import android.text.TextUtils;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import javax.microedition.khronos.opengles.GL;

public class Canvas {
    public final int mNativeCanvas;
    public Bitmap mBitmap;
    public GL mGL;
    public DrawFilter mDrawFilter;
    public int mDensity = 0;
    public int mScreenDensity = 0;
    public int mSurfaceFormat;
    public static final int MATRIX_SAVE_FLAG = 1;
    public static final int CLIP_SAVE_FLAG = 2;
    public static final int HAS_ALPHA_LAYER_SAVE_FLAG = 4;
    public static final int FULL_COLOR_LAYER_SAVE_FLAG = 8;
    public static final int CLIP_TO_LAYER_SAVE_FLAG = 16;
    public static final int ALL_SAVE_FLAG = 31;

    public Canvas() {
        this.mNativeCanvas = Canvas.initRaster(0);
    }

    public Canvas(Bitmap bitmap) {
        if (!bitmap.isMutable()) {
            throw new IllegalStateException("Immutable bitmap passed to Canvas constructor");
        }
        Canvas.throwIfRecycled(bitmap);
        this.mNativeCanvas = Canvas.initRaster(bitmap.ni());
        this.mBitmap = bitmap;
        this.mDensity = bitmap.mDensity;
    }

    public Canvas(int nativeCanvas) {
        if (nativeCanvas == 0) {
            throw new IllegalStateException();
        }
        this.mNativeCanvas = nativeCanvas;
        this.mDensity = Bitmap.getDefaultDensity();
    }

    public Canvas(GL gl) {
        this.mNativeCanvas = Canvas.initGL();
        this.mGL = gl;
        this.mDensity = Bitmap.getDefaultDensity();
    }

    public GL getGL() {
        return this.mGL;
    }

    public static void freeGlCaches() {
        Canvas.freeCaches();
    }

    public void setBitmap(Bitmap bitmap) {
        if (!bitmap.isMutable()) {
            throw new IllegalStateException();
        }
        if (this.mGL != null) {
            throw new RuntimeException("Can't set a bitmap device on a GL canvas");
        }
        Canvas.throwIfRecycled(bitmap);
        Canvas.native_setBitmap(this.mNativeCanvas, bitmap.ni());
        this.mBitmap = bitmap;
        this.mDensity = bitmap.mDensity;
    }

    public void setViewport(int width, int height) {
        if (this.mGL != null) {
            Canvas.nativeSetViewport(this.mNativeCanvas, width, height);
        }
    }

    @LayoutlibDelegate
    public boolean isOpaque() {
        return Canvas_Delegate.isOpaque((Canvas)this);
    }

    @LayoutlibDelegate
    public int getWidth() {
        return Canvas_Delegate.getWidth((Canvas)this);
    }

    @LayoutlibDelegate
    public int getHeight() {
        return Canvas_Delegate.getHeight((Canvas)this);
    }

    public int getDensity() {
        return this.mDensity;
    }

    public void setDensity(int density) {
        if (this.mBitmap != null) {
            this.mBitmap.setDensity(density);
        }
        this.mDensity = density;
    }

    public void setScreenDensity(int density) {
        this.mScreenDensity = density;
    }

    @LayoutlibDelegate
    public int save() {
        return Canvas_Delegate.save((Canvas)this);
    }

    @LayoutlibDelegate
    public int save(int n) {
        return Canvas_Delegate.save((Canvas)this, (int)n);
    }

    public int saveLayer(RectF bounds, Paint paint, int saveFlags) {
        return Canvas.native_saveLayer(this.mNativeCanvas, bounds, paint != null ? paint.mNativePaint : 0, saveFlags);
    }

    public int saveLayer(float left, float top, float right, float bottom, Paint paint, int saveFlags) {
        return Canvas.native_saveLayer(this.mNativeCanvas, left, top, right, bottom, paint != null ? paint.mNativePaint : 0, saveFlags);
    }

    public int saveLayerAlpha(RectF bounds, int alpha, int saveFlags) {
        alpha = Math.min(255, Math.max(0, alpha));
        return Canvas.native_saveLayerAlpha(this.mNativeCanvas, bounds, alpha, saveFlags);
    }

    public int saveLayerAlpha(float left, float top, float right, float bottom, int alpha, int saveFlags) {
        return Canvas.native_saveLayerAlpha(this.mNativeCanvas, left, top, right, bottom, alpha, saveFlags);
    }

    @LayoutlibDelegate
    public void restore() {
        Canvas_Delegate.restore((Canvas)this);
    }

    @LayoutlibDelegate
    public int getSaveCount() {
        return Canvas_Delegate.getSaveCount((Canvas)this);
    }

    @LayoutlibDelegate
    public void restoreToCount(int n) {
        Canvas_Delegate.restoreToCount((Canvas)this, (int)n);
    }

    @LayoutlibDelegate
    public void translate(float f, float f2) {
        Canvas_Delegate.translate((Canvas)this, (float)f, (float)f2);
    }

    @LayoutlibDelegate
    public void scale(float f, float f2) {
        Canvas_Delegate.scale((Canvas)this, (float)f, (float)f2);
    }

    public void scale(float sx, float sy, float px, float py) {
        this.translate(px, py);
        this.scale(sx, sy);
        this.translate(-px, -py);
    }

    @LayoutlibDelegate
    public void rotate(float f) {
        Canvas_Delegate.rotate((Canvas)this, (float)f);
    }

    public void rotate(float degrees, float px, float py) {
        this.translate(px, py);
        this.rotate(degrees);
        this.translate(-px, -py);
    }

    @LayoutlibDelegate
    public void skew(float f, float f2) {
        Canvas_Delegate.skew((Canvas)this, (float)f, (float)f2);
    }

    public void concat(Matrix matrix) {
        Canvas.native_concat(this.mNativeCanvas, matrix.native_instance);
    }

    public void setMatrix(Matrix matrix) {
        Canvas.native_setMatrix(this.mNativeCanvas, matrix == null ? 0 : matrix.native_instance);
    }

    public void getMatrix(Matrix ctm) {
        Canvas.native_getCTM(this.mNativeCanvas, ctm.native_instance);
    }

    public Matrix getMatrix() {
        Matrix m = new Matrix();
        this.getMatrix(m);
        return m;
    }

    public boolean clipRect(RectF rect, Region.Op op) {
        return Canvas.native_clipRect(this.mNativeCanvas, rect.left, rect.top, rect.right, rect.bottom, op.nativeInt);
    }

    public boolean clipRect(Rect rect, Region.Op op) {
        return Canvas.native_clipRect(this.mNativeCanvas, rect.left, rect.top, rect.right, rect.bottom, op.nativeInt);
    }

    @LayoutlibDelegate
    public boolean clipRect(RectF rectF) {
        return Canvas_Delegate.clipRect((Canvas)this, (RectF)rectF);
    }

    @LayoutlibDelegate
    public boolean clipRect(Rect rect) {
        return Canvas_Delegate.clipRect((Canvas)this, (Rect)rect);
    }

    public boolean clipRect(float left, float top, float right, float bottom, Region.Op op) {
        return Canvas.native_clipRect(this.mNativeCanvas, left, top, right, bottom, op.nativeInt);
    }

    @LayoutlibDelegate
    public boolean clipRect(float f, float f2, float f3, float f4) {
        return Canvas_Delegate.clipRect((Canvas)this, (float)f, (float)f2, (float)f3, (float)f4);
    }

    @LayoutlibDelegate
    public boolean clipRect(int n, int n2, int n3, int n4) {
        return Canvas_Delegate.clipRect((Canvas)this, (int)n, (int)n2, (int)n3, (int)n4);
    }

    public boolean clipPath(Path path, Region.Op op) {
        return Canvas.native_clipPath(this.mNativeCanvas, path.ni(), op.nativeInt);
    }

    public boolean clipPath(Path path) {
        return this.clipPath(path, Region.Op.INTERSECT);
    }

    public boolean clipRegion(Region region, Region.Op op) {
        return Canvas.native_clipRegion(this.mNativeCanvas, region.ni(), op.nativeInt);
    }

    public boolean clipRegion(Region region) {
        return this.clipRegion(region, Region.Op.INTERSECT);
    }

    public DrawFilter getDrawFilter() {
        return this.mDrawFilter;
    }

    public void setDrawFilter(DrawFilter filter) {
        int nativeFilter = 0;
        if (filter != null) {
            nativeFilter = filter.mNativeInt;
        }
        this.mDrawFilter = filter;
        Canvas.nativeSetDrawFilter(this.mNativeCanvas, nativeFilter);
    }

    public boolean quickReject(RectF rect, EdgeType type) {
        return Canvas.native_quickReject(this.mNativeCanvas, rect, type.nativeInt);
    }

    public boolean quickReject(Path path, EdgeType type) {
        return Canvas.native_quickReject(this.mNativeCanvas, path.ni(), type.nativeInt);
    }

    public boolean quickReject(float left, float top, float right, float bottom, EdgeType type) {
        return Canvas.native_quickReject(this.mNativeCanvas, left, top, right, bottom, type.nativeInt);
    }

    public boolean getClipBounds(Rect bounds) {
        return Canvas.native_getClipBounds(this.mNativeCanvas, bounds);
    }

    public Rect getClipBounds() {
        Rect r = new Rect();
        this.getClipBounds(r);
        return r;
    }

    public void drawRGB(int r, int g, int b) {
        Canvas.native_drawRGB(this.mNativeCanvas, r, g, b);
    }

    public void drawARGB(int a, int r, int g, int b) {
        Canvas.native_drawARGB(this.mNativeCanvas, a, r, g, b);
    }

    public void drawColor(int color2) {
        Canvas.native_drawColor(this.mNativeCanvas, color2);
    }

    public void drawColor(int color2, PorterDuff.Mode mode) {
        Canvas.native_drawColor(this.mNativeCanvas, color2, mode.nativeInt);
    }

    public void drawPaint(Paint paint) {
        Canvas.native_drawPaint(this.mNativeCanvas, paint.mNativePaint);
    }

    @LayoutlibDelegate
    public void drawPoints(float[] fArray, int n, int n2, Paint paint) {
        Canvas_Delegate.drawPoints((Canvas)this, (float[])fArray, (int)n, (int)n2, (Paint)paint);
    }

    public void drawPoints(float[] pts, Paint paint) {
        this.drawPoints(pts, 0, pts.length, paint);
    }

    @LayoutlibDelegate
    public void drawPoint(float f, float f2, Paint paint) {
        Canvas_Delegate.drawPoint((Canvas)this, (float)f, (float)f2, (Paint)paint);
    }

    public void drawLine(float startX, float startY, float stopX, float stopY, Paint paint) {
        Canvas.native_drawLine(this.mNativeCanvas, startX, startY, stopX, stopY, paint.mNativePaint);
    }

    @LayoutlibDelegate
    public void drawLines(float[] fArray, int n, int n2, Paint paint) {
        Canvas_Delegate.drawLines((Canvas)this, (float[])fArray, (int)n, (int)n2, (Paint)paint);
    }

    public void drawLines(float[] pts, Paint paint) {
        this.drawLines(pts, 0, pts.length, paint);
    }

    public void drawRect(RectF rect, Paint paint) {
        Canvas.native_drawRect(this.mNativeCanvas, rect, paint.mNativePaint);
    }

    public void drawRect(Rect r, Paint paint) {
        this.drawRect(r.left, r.top, r.right, r.bottom, paint);
    }

    public void drawRect(float left, float top, float right, float bottom, Paint paint) {
        Canvas.native_drawRect(this.mNativeCanvas, left, top, right, bottom, paint.mNativePaint);
    }

    public void drawOval(RectF oval, Paint paint) {
        if (oval == null) {
            throw new NullPointerException();
        }
        Canvas.native_drawOval(this.mNativeCanvas, oval, paint.mNativePaint);
    }

    public void drawCircle(float cx, float cy, float radius, Paint paint) {
        Canvas.native_drawCircle(this.mNativeCanvas, cx, cy, radius, paint.mNativePaint);
    }

    public void drawArc(RectF oval, float startAngle, float sweepAngle, boolean useCenter, Paint paint) {
        if (oval == null) {
            throw new NullPointerException();
        }
        Canvas.native_drawArc(this.mNativeCanvas, oval, startAngle, sweepAngle, useCenter, paint.mNativePaint);
    }

    public void drawRoundRect(RectF rect, float rx, float ry, Paint paint) {
        if (rect == null) {
            throw new NullPointerException();
        }
        Canvas.native_drawRoundRect(this.mNativeCanvas, rect, rx, ry, paint.mNativePaint);
    }

    public void drawPath(Path path, Paint paint) {
        Canvas.native_drawPath(this.mNativeCanvas, path.ni(), paint.mNativePaint);
    }

    public static void throwIfRecycled(Bitmap bitmap) {
        if (bitmap.isRecycled()) {
            throw new RuntimeException("Canvas: trying to use a recycled bitmap " + bitmap);
        }
    }

    public void drawBitmap(Bitmap bitmap, float left, float top, Paint paint) {
        Canvas.throwIfRecycled(bitmap);
        this.native_drawBitmap(this.mNativeCanvas, bitmap.ni(), left, top, paint != null ? paint.mNativePaint : 0, this.mDensity, this.mScreenDensity, bitmap.mDensity);
    }

    public void drawBitmap(Bitmap bitmap, Rect src, RectF dst, Paint paint) {
        if (dst == null) {
            throw new NullPointerException();
        }
        Canvas.throwIfRecycled(bitmap);
        this.native_drawBitmap(this.mNativeCanvas, bitmap.ni(), src, dst, paint != null ? paint.mNativePaint : 0, this.mScreenDensity, bitmap.mDensity);
    }

    public void drawBitmap(Bitmap bitmap, Rect src, Rect dst, Paint paint) {
        if (dst == null) {
            throw new NullPointerException();
        }
        Canvas.throwIfRecycled(bitmap);
        Canvas.native_drawBitmap(this.mNativeCanvas, bitmap.ni(), src, dst, paint != null ? paint.mNativePaint : 0, this.mScreenDensity, bitmap.mDensity);
    }

    public void drawBitmap(int[] colors, int offset, int stride, float x, float y, int width, int height, boolean hasAlpha, Paint paint) {
        if (width < 0) {
            throw new IllegalArgumentException("width must be >= 0");
        }
        if (height < 0) {
            throw new IllegalArgumentException("height must be >= 0");
        }
        if (Math.abs(stride) < width) {
            throw new IllegalArgumentException("abs(stride) must be >= width");
        }
        int lastScanline = offset + (height - 1) * stride;
        int length = colors.length;
        if (offset < 0 || offset + width > length || lastScanline < 0 || lastScanline + width > length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (width == 0 || height == 0) {
            return;
        }
        Canvas.native_drawBitmap(this.mNativeCanvas, colors, offset, stride, x, y, width, height, hasAlpha, paint != null ? paint.mNativePaint : 0);
    }

    public void drawBitmap(int[] colors, int offset, int stride, int x, int y, int width, int height, boolean hasAlpha, Paint paint) {
        this.drawBitmap(colors, offset, stride, (float)x, (float)y, width, height, hasAlpha, paint);
    }

    public void drawBitmap(Bitmap bitmap, Matrix matrix, Paint paint) {
        Canvas.nativeDrawBitmapMatrix(this.mNativeCanvas, bitmap.ni(), matrix.ni(), paint != null ? paint.mNativePaint : 0);
    }

    public static void checkRange(int length, int offset, int count) {
        if ((offset | count) < 0 || offset + count > length) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public void drawBitmapMesh(Bitmap bitmap, int meshWidth, int meshHeight, float[] verts, int vertOffset, int[] colors, int colorOffset, Paint paint) {
        if ((meshWidth | meshHeight | vertOffset | colorOffset) < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (meshWidth == 0 || meshHeight == 0) {
            return;
        }
        int count = (meshWidth + 1) * (meshHeight + 1);
        Canvas.checkRange(verts.length, vertOffset, count * 2);
        if (colors != null) {
            Canvas.checkRange(colors.length, colorOffset, count);
        }
        Canvas.nativeDrawBitmapMesh(this.mNativeCanvas, bitmap.ni(), meshWidth, meshHeight, verts, vertOffset, colors, colorOffset, paint != null ? paint.mNativePaint : 0);
    }

    public void drawVertices(VertexMode mode, int vertexCount, float[] verts, int vertOffset, float[] texs, int texOffset, int[] colors, int colorOffset, short[] indices, int indexOffset, int indexCount, Paint paint) {
        Canvas.checkRange(verts.length, vertOffset, vertexCount);
        if (texs != null) {
            Canvas.checkRange(texs.length, texOffset, vertexCount);
        }
        if (colors != null) {
            Canvas.checkRange(colors.length, colorOffset, vertexCount);
        }
        if (indices != null) {
            Canvas.checkRange(indices.length, indexOffset, indexCount);
        }
        Canvas.nativeDrawVertices(this.mNativeCanvas, mode.nativeInt, vertexCount, verts, vertOffset, texs, texOffset, colors, colorOffset, indices, indexOffset, indexCount, paint.mNativePaint);
    }

    public void drawText(char[] text, int index, int count, float x, float y, Paint paint) {
        if ((index | count | index + count | text.length - index - count) < 0) {
            throw new IndexOutOfBoundsException();
        }
        Canvas.native_drawText(this.mNativeCanvas, text, index, count, x, y, paint.mNativePaint);
    }

    @LayoutlibDelegate
    public void drawText(String string2, float f, float f2, Paint paint) {
        Canvas_Delegate.drawText((Canvas)this, (String)string2, (float)f, (float)f2, (Paint)paint);
    }

    public void drawText(String text, int start, int end, float x, float y, Paint paint) {
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        Canvas.native_drawText(this.mNativeCanvas, text, start, end, x, y, paint.mNativePaint);
    }

    public void drawText(CharSequence text, int start, int end, float x, float y, Paint paint) {
        if (text instanceof String || text instanceof SpannedString || text instanceof SpannableString) {
            Canvas.native_drawText(this.mNativeCanvas, ((Object)text).toString(), start, end, x, y, paint.mNativePaint);
        } else if (text instanceof GraphicsOperations) {
            ((GraphicsOperations)text).drawText(this, start, end, x, y, paint);
        } else {
            char[] buf = TemporaryBuffer.obtain(end - start);
            TextUtils.getChars(text, start, end, buf, 0);
            this.drawText(buf, 0, end - start, x, y, paint);
            TemporaryBuffer.recycle(buf);
        }
    }

    public void drawPosText(char[] text, int index, int count, float[] pos, Paint paint) {
        if (index < 0 || index + count > text.length || count * 2 > pos.length) {
            throw new IndexOutOfBoundsException();
        }
        Canvas.native_drawPosText(this.mNativeCanvas, text, index, count, pos, paint.mNativePaint);
    }

    public void drawPosText(String text, float[] pos, Paint paint) {
        if (text.length() * 2 > pos.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Canvas.native_drawPosText(this.mNativeCanvas, text, pos, paint.mNativePaint);
    }

    public void drawTextOnPath(char[] text, int index, int count, Path path, float hOffset, float vOffset, Paint paint) {
        if (index < 0 || index + count > text.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Canvas.native_drawTextOnPath(this.mNativeCanvas, text, index, count, path.ni(), hOffset, vOffset, paint.mNativePaint);
    }

    public void drawTextOnPath(String text, Path path, float hOffset, float vOffset, Paint paint) {
        if (text.length() > 0) {
            Canvas.native_drawTextOnPath(this.mNativeCanvas, text, path.ni(), hOffset, vOffset, paint.mNativePaint);
        }
    }

    public void drawPicture(Picture picture) {
        picture.endRecording();
        Canvas.native_drawPicture(this.mNativeCanvas, picture.ni());
    }

    public void drawPicture(Picture picture, RectF dst) {
        this.save();
        this.translate(dst.left, dst.top);
        if (picture.getWidth() > 0 && picture.getHeight() > 0) {
            this.scale(dst.width() / (float)picture.getWidth(), dst.height() / (float)picture.getHeight());
        }
        this.drawPicture(picture);
        this.restore();
    }

    public void drawPicture(Picture picture, Rect dst) {
        this.save();
        this.translate(dst.left, dst.top);
        if (picture.getWidth() > 0 && picture.getHeight() > 0) {
            this.scale((float)dst.width() / (float)picture.getWidth(), (float)dst.height() / (float)picture.getHeight());
        }
        this.drawPicture(picture);
        this.restore();
    }

    public void finalize() throws Throwable {
        super.finalize();
        if (this.mNativeCanvas != 0) {
            Canvas.finalizer(this.mNativeCanvas);
        }
    }

    @LayoutlibDelegate
    public static void freeCaches() {
        Canvas_Delegate.freeCaches();
    }

    @LayoutlibDelegate
    public static int initRaster(int n) {
        return Canvas_Delegate.initRaster((int)n);
    }

    @LayoutlibDelegate
    public static int initGL() {
        return Canvas_Delegate.initGL();
    }

    @LayoutlibDelegate
    public static void native_setBitmap(int n, int n2) {
        Canvas_Delegate.native_setBitmap((int)n, (int)n2);
    }

    @LayoutlibDelegate
    public static void nativeSetViewport(int n, int n2, int n3) {
        Canvas_Delegate.nativeSetViewport((int)n, (int)n2, (int)n3);
    }

    @LayoutlibDelegate
    public static int native_saveLayer(int n, RectF rectF, int n2, int n3) {
        return Canvas_Delegate.native_saveLayer((int)n, (RectF)rectF, (int)n2, (int)n3);
    }

    @LayoutlibDelegate
    public static int native_saveLayer(int n, float f, float f2, float f3, float f4, int n2, int n3) {
        return Canvas_Delegate.native_saveLayer((int)n, (float)f, (float)f2, (float)f3, (float)f4, (int)n2, (int)n3);
    }

    @LayoutlibDelegate
    public static int native_saveLayerAlpha(int n, RectF rectF, int n2, int n3) {
        return Canvas_Delegate.native_saveLayerAlpha((int)n, (RectF)rectF, (int)n2, (int)n3);
    }

    @LayoutlibDelegate
    public static int native_saveLayerAlpha(int n, float f, float f2, float f3, float f4, int n2, int n3) {
        return Canvas_Delegate.native_saveLayerAlpha((int)n, (float)f, (float)f2, (float)f3, (float)f4, (int)n2, (int)n3);
    }

    @LayoutlibDelegate
    public static void native_concat(int n, int n2) {
        Canvas_Delegate.native_concat((int)n, (int)n2);
    }

    @LayoutlibDelegate
    public static void native_setMatrix(int n, int n2) {
        Canvas_Delegate.native_setMatrix((int)n, (int)n2);
    }

    @LayoutlibDelegate
    public static boolean native_clipRect(int n, float f, float f2, float f3, float f4, int n2) {
        return Canvas_Delegate.native_clipRect((int)n, (float)f, (float)f2, (float)f3, (float)f4, (int)n2);
    }

    @LayoutlibDelegate
    public static boolean native_clipPath(int n, int n2, int n3) {
        return Canvas_Delegate.native_clipPath((int)n, (int)n2, (int)n3);
    }

    @LayoutlibDelegate
    public static boolean native_clipRegion(int n, int n2, int n3) {
        return Canvas_Delegate.native_clipRegion((int)n, (int)n2, (int)n3);
    }

    @LayoutlibDelegate
    public static void nativeSetDrawFilter(int n, int n2) {
        Canvas_Delegate.nativeSetDrawFilter((int)n, (int)n2);
    }

    @LayoutlibDelegate
    public static boolean native_getClipBounds(int n, Rect rect) {
        return Canvas_Delegate.native_getClipBounds((int)n, (Rect)rect);
    }

    @LayoutlibDelegate
    public static void native_getCTM(int n, int n2) {
        Canvas_Delegate.native_getCTM((int)n, (int)n2);
    }

    @LayoutlibDelegate
    public static boolean native_quickReject(int n, RectF rectF, int n2) {
        return Canvas_Delegate.native_quickReject((int)n, (RectF)rectF, (int)n2);
    }

    @LayoutlibDelegate
    public static boolean native_quickReject(int n, int n2, int n3) {
        return Canvas_Delegate.native_quickReject((int)n, (int)n2, (int)n3);
    }

    @LayoutlibDelegate
    public static boolean native_quickReject(int n, float f, float f2, float f3, float f4, int n2) {
        return Canvas_Delegate.native_quickReject((int)n, (float)f, (float)f2, (float)f3, (float)f4, (int)n2);
    }

    @LayoutlibDelegate
    public static void native_drawRGB(int n, int n2, int n3, int n4) {
        Canvas_Delegate.native_drawRGB((int)n, (int)n2, (int)n3, (int)n4);
    }

    @LayoutlibDelegate
    public static void native_drawARGB(int n, int n2, int n3, int n4, int n5) {
        Canvas_Delegate.native_drawARGB((int)n, (int)n2, (int)n3, (int)n4, (int)n5);
    }

    @LayoutlibDelegate
    public static void native_drawColor(int n, int n2) {
        Canvas_Delegate.native_drawColor((int)n, (int)n2);
    }

    @LayoutlibDelegate
    public static void native_drawColor(int n, int n2, int n3) {
        Canvas_Delegate.native_drawColor((int)n, (int)n2, (int)n3);
    }

    @LayoutlibDelegate
    public static void native_drawPaint(int n, int n2) {
        Canvas_Delegate.native_drawPaint((int)n, (int)n2);
    }

    @LayoutlibDelegate
    public static void native_drawLine(int n, float f, float f2, float f3, float f4, int n2) {
        Canvas_Delegate.native_drawLine((int)n, (float)f, (float)f2, (float)f3, (float)f4, (int)n2);
    }

    @LayoutlibDelegate
    public static void native_drawRect(int n, RectF rectF, int n2) {
        Canvas_Delegate.native_drawRect((int)n, (RectF)rectF, (int)n2);
    }

    @LayoutlibDelegate
    public static void native_drawRect(int n, float f, float f2, float f3, float f4, int n2) {
        Canvas_Delegate.native_drawRect((int)n, (float)f, (float)f2, (float)f3, (float)f4, (int)n2);
    }

    @LayoutlibDelegate
    public static void native_drawOval(int n, RectF rectF, int n2) {
        Canvas_Delegate.native_drawOval((int)n, (RectF)rectF, (int)n2);
    }

    @LayoutlibDelegate
    public static void native_drawCircle(int n, float f, float f2, float f3, int n2) {
        Canvas_Delegate.native_drawCircle((int)n, (float)f, (float)f2, (float)f3, (int)n2);
    }

    @LayoutlibDelegate
    public static void native_drawArc(int n, RectF rectF, float f, float f2, boolean bl, int n2) {
        Canvas_Delegate.native_drawArc((int)n, (RectF)rectF, (float)f, (float)f2, (boolean)bl, (int)n2);
    }

    @LayoutlibDelegate
    public static void native_drawRoundRect(int n, RectF rectF, float f, float f2, int n2) {
        Canvas_Delegate.native_drawRoundRect((int)n, (RectF)rectF, (float)f, (float)f2, (int)n2);
    }

    @LayoutlibDelegate
    public static void native_drawPath(int n, int n2, int n3) {
        Canvas_Delegate.native_drawPath((int)n, (int)n2, (int)n3);
    }

    @LayoutlibDelegate
    public void native_drawBitmap(int n, int n2, float f, float f2, int n3, int n4, int n5, int n6) {
        Canvas_Delegate.native_drawBitmap((Canvas)this, (int)n, (int)n2, (float)f, (float)f2, (int)n3, (int)n4, (int)n5, (int)n6);
    }

    @LayoutlibDelegate
    public void native_drawBitmap(int n, int n2, Rect rect, RectF rectF, int n3, int n4, int n5) {
        Canvas_Delegate.native_drawBitmap((Canvas)this, (int)n, (int)n2, (Rect)rect, (RectF)rectF, (int)n3, (int)n4, (int)n5);
    }

    @LayoutlibDelegate
    public static void native_drawBitmap(int n, int n2, Rect rect, Rect rect2, int n3, int n4, int n5) {
        Canvas_Delegate.native_drawBitmap((int)n, (int)n2, (Rect)rect, (Rect)rect2, (int)n3, (int)n4, (int)n5);
    }

    @LayoutlibDelegate
    public static void native_drawBitmap(int n, int[] nArray, int n2, int n3, float f, float f2, int n4, int n5, boolean bl, int n6) {
        Canvas_Delegate.native_drawBitmap((int)n, (int[])nArray, (int)n2, (int)n3, (float)f, (float)f2, (int)n4, (int)n5, (boolean)bl, (int)n6);
    }

    @LayoutlibDelegate
    public static void nativeDrawBitmapMatrix(int n, int n2, int n3, int n4) {
        Canvas_Delegate.nativeDrawBitmapMatrix((int)n, (int)n2, (int)n3, (int)n4);
    }

    @LayoutlibDelegate
    public static void nativeDrawBitmapMesh(int n, int n2, int n3, int n4, float[] fArray, int n5, int[] nArray, int n6, int n7) {
        Canvas_Delegate.nativeDrawBitmapMesh((int)n, (int)n2, (int)n3, (int)n4, (float[])fArray, (int)n5, (int[])nArray, (int)n6, (int)n7);
    }

    @LayoutlibDelegate
    public static void nativeDrawVertices(int n, int n2, int n3, float[] fArray, int n4, float[] fArray2, int n5, int[] nArray, int n6, short[] sArray, int n7, int n8, int n9) {
        Canvas_Delegate.nativeDrawVertices((int)n, (int)n2, (int)n3, (float[])fArray, (int)n4, (float[])fArray2, (int)n5, (int[])nArray, (int)n6, (short[])sArray, (int)n7, (int)n8, (int)n9);
    }

    @LayoutlibDelegate
    public static void native_drawText(int n, char[] cArray, int n2, int n3, float f, float f2, int n4) {
        Canvas_Delegate.native_drawText((int)n, (char[])cArray, (int)n2, (int)n3, (float)f, (float)f2, (int)n4);
    }

    @LayoutlibDelegate
    public static void native_drawText(int n, String string2, int n2, int n3, float f, float f2, int n4) {
        Canvas_Delegate.native_drawText((int)n, (String)string2, (int)n2, (int)n3, (float)f, (float)f2, (int)n4);
    }

    @LayoutlibDelegate
    public static void native_drawPosText(int n, char[] cArray, int n2, int n3, float[] fArray, int n4) {
        Canvas_Delegate.native_drawPosText((int)n, (char[])cArray, (int)n2, (int)n3, (float[])fArray, (int)n4);
    }

    @LayoutlibDelegate
    public static void native_drawPosText(int n, String string2, float[] fArray, int n2) {
        Canvas_Delegate.native_drawPosText((int)n, (String)string2, (float[])fArray, (int)n2);
    }

    @LayoutlibDelegate
    public static void native_drawTextOnPath(int n, char[] cArray, int n2, int n3, int n4, float f, float f2, int n5) {
        Canvas_Delegate.native_drawTextOnPath((int)n, (char[])cArray, (int)n2, (int)n3, (int)n4, (float)f, (float)f2, (int)n5);
    }

    @LayoutlibDelegate
    public static void native_drawTextOnPath(int n, String string2, int n2, float f, float f2, int n3) {
        Canvas_Delegate.native_drawTextOnPath((int)n, (String)string2, (int)n2, (float)f, (float)f2, (int)n3);
    }

    @LayoutlibDelegate
    public static void native_drawPicture(int n, int n2) {
        Canvas_Delegate.native_drawPicture((int)n, (int)n2);
    }

    @LayoutlibDelegate
    public static void finalizer(int n) {
        Canvas_Delegate.finalizer((int)n);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum VertexMode {
        TRIANGLES(0),
        TRIANGLE_STRIP(1),
        TRIANGLE_FAN(2);

        public final int nativeInt;

        public VertexMode(int nativeInt) {
            this.nativeInt = nativeInt;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EdgeType {
        BW(0),
        AA(1);

        public final int nativeInt;

        public EdgeType(int nativeInt) {
            this.nativeInt = nativeInt;
        }
    }
}

