/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.accounts.Account;
import android.content.ContentResolver;
import android.content.Context;
import android.content.IContentService;
import android.content.ISyncStatusObserver;
import android.content.PeriodicSync;
import android.content.SyncAdapterType;
import android.content.SyncInfo;
import android.content.SyncManager;
import android.content.SyncStatusInfo;
import android.database.IContentObserver;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentService
extends IContentService.Stub {
    public static final String TAG = "ContentService";
    public Context mContext;
    public boolean mFactoryTest;
    public final ObserverNode mRootNode = new ObserverNode("");
    public SyncManager mSyncManager = null;
    public final Object mSyncManagerLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SyncManager getSyncManager() {
        Object object = this.mSyncManagerLock;
        synchronized (object) {
            try {
                if (this.mSyncManager == null) {
                    this.mSyncManager = new SyncManager(this.mContext, this.mFactoryTest);
                }
            }
            catch (SQLiteException e) {
                Log.e(TAG, "Can't create SyncManager", e);
            }
            return this.mSyncManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DUMP", "caller doesn't have the DUMP permission");
        long identityToken = ContentService.clearCallingIdentity();
        try {
            if (this.mSyncManager == null) {
                pw.println("No SyncManager created!  (Disk full?)");
            } else {
                this.mSyncManager.dump(fd, pw);
            }
        }
        finally {
            ContentService.restoreCallingIdentity(identityToken);
        }
    }

    @Override
    public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        try {
            return super.onTransact(code, data, reply, flags);
        }
        catch (RuntimeException e) {
            if (!(e instanceof SecurityException)) {
                Log.e(TAG, "Content Service Crash", e);
            }
            throw e;
        }
    }

    public ContentService(Context context, boolean factoryTest) {
        this.mContext = context;
        this.mFactoryTest = factoryTest;
        this.getSyncManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerContentObserver(Uri uri, boolean notifyForDescendents, IContentObserver observer) {
        if (observer == null || uri == null) {
            throw new IllegalArgumentException("You must pass a valid uri and observer");
        }
        ObserverNode observerNode = this.mRootNode;
        synchronized (observerNode) {
            this.mRootNode.addObserverLocked(uri, observer, notifyForDescendents, this.mRootNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterContentObserver(IContentObserver observer) {
        if (observer == null) {
            throw new IllegalArgumentException("You must pass a valid observer");
        }
        ObserverNode observerNode = this.mRootNode;
        synchronized (observerNode) {
            this.mRootNode.removeObserverLocked(observer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyChange(Uri uri, IContentObserver observer, boolean observerWantsSelfNotifications, boolean syncToNetwork) {
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "Notifying update of " + uri + " from observer " + observer + ", syncToNetwork " + syncToNetwork);
        }
        long identityToken = ContentService.clearCallingIdentity();
        try {
            SyncManager syncManager;
            ArrayList<ObserverCall> calls = new ArrayList<ObserverCall>();
            ObserverNode observerNode = this.mRootNode;
            synchronized (observerNode) {
                this.mRootNode.collectObserversLocked(uri, 0, observer, observerWantsSelfNotifications, calls);
            }
            int numCalls = calls.size();
            for (int i = 0; i < numCalls; ++i) {
                ObserverCall oc = calls.get(i);
                try {
                    oc.mObserver.onChange(oc.mSelfNotify);
                    if (!Log.isLoggable(TAG, 2)) continue;
                    Log.v(TAG, "Notified " + oc.mObserver + " of " + "update at " + uri);
                    continue;
                }
                catch (RemoteException ex) {
                    ObserverNode observerNode2 = this.mRootNode;
                    synchronized (observerNode2) {
                        Log.w(TAG, "Found dead observer, removing");
                        IBinder binder = oc.mObserver.asBinder();
                        ArrayList list = oc.mNode.mObservers;
                        int numList = list.size();
                        for (int j = 0; j < numList; ++j) {
                            ObserverNode.ObserverEntry oe = (ObserverNode.ObserverEntry)list.get(j);
                            if (oe.observer.asBinder() != binder) continue;
                            list.remove(j);
                            --j;
                            --numList;
                        }
                        continue;
                    }
                }
            }
            if (syncToNetwork && (syncManager = this.getSyncManager()) != null) {
                syncManager.scheduleLocalSync(null, uri.getAuthority());
            }
        }
        finally {
            ContentService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestSync(Account account, String authority, Bundle extras) {
        ContentResolver.validateSyncExtrasBundle(extras);
        long identityToken = ContentService.clearCallingIdentity();
        try {
            SyncManager syncManager = this.getSyncManager();
            if (syncManager != null) {
                syncManager.scheduleSync(account, authority, extras, 0L, false);
            }
        }
        finally {
            ContentService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelSync(Account account, String authority) {
        long identityToken = ContentService.clearCallingIdentity();
        try {
            SyncManager syncManager = this.getSyncManager();
            if (syncManager != null) {
                syncManager.clearScheduledSyncOperations(account, authority);
                syncManager.cancelActiveSync(account, authority);
            }
        }
        finally {
            ContentService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SyncAdapterType[] getSyncAdapterTypes() {
        long identityToken = ContentService.clearCallingIdentity();
        try {
            SyncManager syncManager = this.getSyncManager();
            SyncAdapterType[] syncAdapterTypeArray = syncManager.getSyncAdapterTypes();
            return syncAdapterTypeArray;
        }
        finally {
            ContentService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getSyncAutomatically(Account account, String providerName) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.READ_SYNC_SETTINGS", "no permission to read the sync settings");
        long identityToken = ContentService.clearCallingIdentity();
        try {
            SyncManager syncManager = this.getSyncManager();
            if (syncManager != null) {
                boolean bl = syncManager.getSyncStorageEngine().getSyncAutomatically(account, providerName);
                return bl;
            }
        }
        finally {
            ContentService.restoreCallingIdentity(identityToken);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSyncAutomatically(Account account, String providerName, boolean sync) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.WRITE_SYNC_SETTINGS", "no permission to write the sync settings");
        long identityToken = ContentService.clearCallingIdentity();
        try {
            SyncManager syncManager = this.getSyncManager();
            if (syncManager != null) {
                syncManager.getSyncStorageEngine().setSyncAutomatically(account, providerName, sync);
            }
        }
        finally {
            ContentService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPeriodicSync(Account account, String authority, Bundle extras, long pollFrequency) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.WRITE_SYNC_SETTINGS", "no permission to write the sync settings");
        long identityToken = ContentService.clearCallingIdentity();
        try {
            this.getSyncManager().getSyncStorageEngine().addPeriodicSync(account, authority, extras, pollFrequency);
        }
        finally {
            ContentService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePeriodicSync(Account account, String authority, Bundle extras) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.WRITE_SYNC_SETTINGS", "no permission to write the sync settings");
        long identityToken = ContentService.clearCallingIdentity();
        try {
            this.getSyncManager().getSyncStorageEngine().removePeriodicSync(account, authority, extras);
        }
        finally {
            ContentService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PeriodicSync> getPeriodicSyncs(Account account, String providerName) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.READ_SYNC_SETTINGS", "no permission to read the sync settings");
        long identityToken = ContentService.clearCallingIdentity();
        try {
            List<PeriodicSync> list = this.getSyncManager().getSyncStorageEngine().getPeriodicSyncs(account, providerName);
            return list;
        }
        finally {
            ContentService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getIsSyncable(Account account, String providerName) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.READ_SYNC_SETTINGS", "no permission to read the sync settings");
        long identityToken = ContentService.clearCallingIdentity();
        try {
            SyncManager syncManager = this.getSyncManager();
            if (syncManager != null) {
                int n = syncManager.getSyncStorageEngine().getIsSyncable(account, providerName);
                return n;
            }
        }
        finally {
            ContentService.restoreCallingIdentity(identityToken);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setIsSyncable(Account account, String providerName, int syncable) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.WRITE_SYNC_SETTINGS", "no permission to write the sync settings");
        long identityToken = ContentService.clearCallingIdentity();
        try {
            SyncManager syncManager = this.getSyncManager();
            if (syncManager != null) {
                syncManager.getSyncStorageEngine().setIsSyncable(account, providerName, syncable);
            }
        }
        finally {
            ContentService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getMasterSyncAutomatically() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.READ_SYNC_SETTINGS", "no permission to read the sync settings");
        long identityToken = ContentService.clearCallingIdentity();
        try {
            SyncManager syncManager = this.getSyncManager();
            if (syncManager != null) {
                boolean bl = syncManager.getSyncStorageEngine().getMasterSyncAutomatically();
                return bl;
            }
        }
        finally {
            ContentService.restoreCallingIdentity(identityToken);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMasterSyncAutomatically(boolean flag) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.WRITE_SYNC_SETTINGS", "no permission to write the sync settings");
        long identityToken = ContentService.clearCallingIdentity();
        try {
            SyncManager syncManager = this.getSyncManager();
            if (syncManager != null) {
                syncManager.getSyncStorageEngine().setMasterSyncAutomatically(flag);
            }
        }
        finally {
            ContentService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSyncActive(Account account, String authority) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.READ_SYNC_STATS", "no permission to read the sync stats");
        long identityToken = ContentService.clearCallingIdentity();
        try {
            SyncManager syncManager = this.getSyncManager();
            if (syncManager != null) {
                boolean bl = syncManager.getSyncStorageEngine().isSyncActive(account, authority);
                return bl;
            }
        }
        finally {
            ContentService.restoreCallingIdentity(identityToken);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SyncInfo getCurrentSync() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.READ_SYNC_STATS", "no permission to read the sync stats");
        long identityToken = ContentService.clearCallingIdentity();
        try {
            SyncManager syncManager = this.getSyncManager();
            if (syncManager != null) {
                SyncInfo syncInfo = syncManager.getSyncStorageEngine().getCurrentSync();
                return syncInfo;
            }
        }
        finally {
            ContentService.restoreCallingIdentity(identityToken);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SyncStatusInfo getSyncStatus(Account account, String authority) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.READ_SYNC_STATS", "no permission to read the sync stats");
        long identityToken = ContentService.clearCallingIdentity();
        try {
            SyncManager syncManager = this.getSyncManager();
            if (syncManager != null) {
                SyncStatusInfo syncStatusInfo = syncManager.getSyncStorageEngine().getStatusByAccountAndAuthority(account, authority);
                return syncStatusInfo;
            }
        }
        finally {
            ContentService.restoreCallingIdentity(identityToken);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSyncPending(Account account, String authority) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.READ_SYNC_STATS", "no permission to read the sync stats");
        long identityToken = ContentService.clearCallingIdentity();
        try {
            SyncManager syncManager = this.getSyncManager();
            if (syncManager != null) {
                boolean bl = syncManager.getSyncStorageEngine().isSyncPending(account, authority);
                return bl;
            }
        }
        finally {
            ContentService.restoreCallingIdentity(identityToken);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addStatusChangeListener(int mask, ISyncStatusObserver callback) {
        long identityToken = ContentService.clearCallingIdentity();
        try {
            SyncManager syncManager = this.getSyncManager();
            if (syncManager != null && callback != null) {
                syncManager.getSyncStorageEngine().addStatusChangeListener(mask, callback);
            }
        }
        finally {
            ContentService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeStatusChangeListener(ISyncStatusObserver callback) {
        long identityToken = ContentService.clearCallingIdentity();
        try {
            SyncManager syncManager = this.getSyncManager();
            if (syncManager != null && callback != null) {
                syncManager.getSyncStorageEngine().removeStatusChangeListener(callback);
            }
        }
        finally {
            ContentService.restoreCallingIdentity(identityToken);
        }
    }

    public static IContentService main(Context context, boolean factoryTest) {
        ContentService service = new ContentService(context, factoryTest);
        ServiceManager.addService((String)"content", (IBinder)service);
        return service;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ObserverNode {
        public static final int INSERT_TYPE = 0;
        public static final int UPDATE_TYPE = 1;
        public static final int DELETE_TYPE = 2;
        public String mName;
        public ArrayList<ObserverNode> mChildren = new ArrayList();
        public ArrayList<ObserverEntry> mObservers = new ArrayList();

        public ObserverNode(String name) {
            this.mName = name;
        }

        public String getUriSegment(Uri uri, int index) {
            if (uri != null) {
                if (index == 0) {
                    return uri.getAuthority();
                }
                return uri.getPathSegments().get(index - 1);
            }
            return null;
        }

        public int countUriSegments(Uri uri) {
            if (uri == null) {
                return 0;
            }
            return uri.getPathSegments().size() + 1;
        }

        public void addObserverLocked(Uri uri, IContentObserver observer, boolean notifyForDescendents, Object observersLock) {
            this.addObserverLocked(uri, 0, observer, notifyForDescendents, observersLock);
        }

        public void addObserverLocked(Uri uri, int index, IContentObserver observer, boolean notifyForDescendents, Object observersLock) {
            if (index == this.countUriSegments(uri)) {
                this.mObservers.add(new ObserverEntry(observer, notifyForDescendents, observersLock));
                return;
            }
            String segment = this.getUriSegment(uri, index);
            if (segment == null) {
                throw new IllegalArgumentException("Invalid Uri (" + uri + ") used for observer");
            }
            int N = this.mChildren.size();
            for (int i = 0; i < N; ++i) {
                ObserverNode node = this.mChildren.get(i);
                if (!node.mName.equals(segment)) continue;
                node.addObserverLocked(uri, index + 1, observer, notifyForDescendents, observersLock);
                return;
            }
            ObserverNode node = new ObserverNode(segment);
            this.mChildren.add(node);
            node.addObserverLocked(uri, index + 1, observer, notifyForDescendents, observersLock);
        }

        public boolean removeObserverLocked(IContentObserver observer) {
            int size = this.mChildren.size();
            for (int i = 0; i < size; ++i) {
                boolean empty = this.mChildren.get(i).removeObserverLocked(observer);
                if (!empty) continue;
                this.mChildren.remove(i);
                --i;
                --size;
            }
            IBinder observerBinder = observer.asBinder();
            size = this.mObservers.size();
            for (int i = 0; i < size; ++i) {
                ObserverEntry entry = this.mObservers.get(i);
                if (entry.observer.asBinder() != observerBinder) continue;
                this.mObservers.remove(i);
                observerBinder.unlinkToDeath(entry, 0);
                break;
            }
            return this.mChildren.size() == 0 && this.mObservers.size() == 0;
        }

        public void collectMyObserversLocked(boolean leaf, IContentObserver observer, boolean selfNotify, ArrayList<ObserverCall> calls) {
            int N = this.mObservers.size();
            IBinder observerBinder = observer == null ? null : observer.asBinder();
            for (int i = 0; i < N; ++i) {
                ObserverEntry entry = this.mObservers.get(i);
                if (entry.observer.asBinder() == observerBinder && !selfNotify || !leaf && (leaf || !entry.notifyForDescendents)) continue;
                calls.add(new ObserverCall(this, entry.observer, selfNotify));
            }
        }

        public void collectObserversLocked(Uri uri, int index, IContentObserver observer, boolean selfNotify, ArrayList<ObserverCall> calls) {
            String segment = null;
            int segmentCount = this.countUriSegments(uri);
            if (index >= segmentCount) {
                this.collectMyObserversLocked(true, observer, selfNotify, calls);
            } else if (index < segmentCount) {
                segment = this.getUriSegment(uri, index);
                this.collectMyObserversLocked(false, observer, selfNotify, calls);
            }
            int N = this.mChildren.size();
            for (int i = 0; i < N; ++i) {
                ObserverNode node = this.mChildren.get(i);
                if (segment != null && !node.mName.equals(segment)) continue;
                node.collectObserversLocked(uri, index + 1, observer, selfNotify, calls);
                if (segment != null) break;
            }
        }

        public class ObserverEntry
        implements IBinder.DeathRecipient {
            public final IContentObserver observer;
            public final boolean notifyForDescendents;
            public final Object observersLock;

            public ObserverEntry(IContentObserver o, boolean n, Object observersLock) {
                this.observersLock = observersLock;
                this.observer = o;
                this.notifyForDescendents = n;
                try {
                    this.observer.asBinder().linkToDeath(this, 0);
                }
                catch (RemoteException e) {
                    this.binderDied();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void binderDied() {
                Object object = this.observersLock;
                synchronized (object) {
                    ObserverNode.this.removeObserverLocked(this.observer);
                }
            }
        }
    }

    public static class ObserverCall {
        public final ObserverNode mNode;
        public final IContentObserver mObserver;
        public final boolean mSelfNotify;

        public ObserverCall(ObserverNode node, IContentObserver observer, boolean selfNotify) {
            this.mNode = node;
            this.mObserver = observer;
            this.mSelfNotify = selfNotify;
        }
    }
}

