/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.accounts.AccountManager;
import android.accounts.IAccountManager;
import android.app.ActivityManager;
import android.app.ActivityManagerNative;
import android.app.ActivityThread;
import android.app.AlarmManager;
import android.app.DownloadManager;
import android.app.IAlarmManager;
import android.app.IServiceConnection;
import android.app.Instrumentation;
import android.app.KeyguardManager;
import android.app.LoadedApk;
import android.app.NotificationManager;
import android.app.QueuedWork;
import android.app.ReceiverRestrictedContext;
import android.app.SearchManager;
import android.app.StatusBarManager;
import android.app.UiModeManager;
import android.app.WallpaperManager;
import android.app.admin.DevicePolicyManager;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.IContentProvider;
import android.content.IIntentReceiver;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.ServiceConnection;
import android.content.SharedPreferences;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.ComponentInfo;
import android.content.pm.FeatureInfo;
import android.content.pm.IPackageDataObserver;
import android.content.pm.IPackageDeleteObserver;
import android.content.pm.IPackageInstallObserver;
import android.content.pm.IPackageManager;
import android.content.pm.IPackageMoveObserver;
import android.content.pm.IPackageStatsObserver;
import android.content.pm.InstrumentationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ParceledListSlice;
import android.content.pm.PermissionGroupInfo;
import android.content.pm.PermissionInfo;
import android.content.pm.ProviderInfo;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.database.sqlite.SQLiteDatabase;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.hardware.SensorManager;
import android.hardware.usb.IUsbManager;
import android.hardware.usb.UsbManager;
import android.location.ILocationManager;
import android.location.LocationManager;
import android.media.AudioManager;
import android.net.ConnectivityManager;
import android.net.IConnectivityManager;
import android.net.IThrottleManager;
import android.net.ThrottleManager;
import android.net.Uri;
import android.net.wifi.IWifiManager;
import android.net.wifi.WifiManager;
import android.nfc.NfcManager;
import android.os.Binder;
import android.os.Bundle;
import android.os.DropBoxManager;
import android.os.Environment;
import android.os.FileUtils;
import android.os.Handler;
import android.os.IBinder;
import android.os.IPowerManager;
import android.os.Looper;
import android.os.PowerManager;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.Vibrator;
import android.os.storage.StorageManager;
import android.telephony.TelephonyManager;
import android.text.ClipboardManager;
import android.util.AndroidRuntimeException;
import android.util.Log;
import android.view.ContextThemeWrapper;
import android.view.LayoutInflater;
import android.view.WindowManagerImpl;
import android.view.accessibility.AccessibilityManager;
import android.view.inputmethod.InputMethodManager;
import com.android.internal.os.IDropBoxManagerService;
import com.android.internal.policy.PolicyManager;
import com.android.internal.util.XmlUtils;
import com.google.android.collect.Maps;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CountDownLatch;
import org.xmlpull.v1.XmlPullParserException;

public class ContextImpl
extends Context {
    public static final String TAG = "ApplicationContext";
    public static final boolean DEBUG = false;
    public static final boolean DEBUG_ICONS = false;
    public static final Object sSync = new Object();
    public static AlarmManager sAlarmManager;
    public static PowerManager sPowerManager;
    public static ConnectivityManager sConnectivityManager;
    public static ThrottleManager sThrottleManager;
    public static WifiManager sWifiManager;
    public static LocationManager sLocationManager;
    public static final HashMap<String, SharedPreferencesImpl> sSharedPrefs;
    public AudioManager mAudioManager;
    public LoadedApk mPackageInfo;
    public Resources mResources;
    public ActivityThread mMainThread;
    public Context mOuterContext;
    public IBinder mActivityToken = null;
    public ApplicationContentResolver mContentResolver;
    public int mThemeResource = 0;
    public Resources.Theme mTheme = null;
    public PackageManager mPackageManager;
    public NotificationManager mNotificationManager = null;
    public ActivityManager mActivityManager = null;
    public WallpaperManager mWallpaperManager = null;
    public Context mReceiverRestrictedContext = null;
    public SearchManager mSearchManager = null;
    public SensorManager mSensorManager = null;
    public StorageManager mStorageManager = null;
    public UsbManager mUsbManager = null;
    public Vibrator mVibrator = null;
    public LayoutInflater mLayoutInflater = null;
    public StatusBarManager mStatusBarManager = null;
    public TelephonyManager mTelephonyManager = null;
    public ClipboardManager mClipboardManager = null;
    public boolean mRestricted;
    public AccountManager mAccountManager;
    public DropBoxManager mDropBoxManager = null;
    public DevicePolicyManager mDevicePolicyManager = null;
    public UiModeManager mUiModeManager = null;
    public DownloadManager mDownloadManager = null;
    public NfcManager mNfcManager = null;
    public final Object mSync = new Object();
    public File mDatabasesDir;
    public File mPreferencesDir;
    public File mFilesDir;
    public File mCacheDir;
    public File mExternalFilesDir;
    public File mExternalCacheDir;
    public static long sInstanceCount;
    public static final String[] EMPTY_FILE_LIST;

    public static long getInstanceCount() {
        return sInstanceCount;
    }

    public AssetManager getAssets() {
        return this.mResources.getAssets();
    }

    public Resources getResources() {
        return this.mResources;
    }

    public PackageManager getPackageManager() {
        if (this.mPackageManager != null) {
            return this.mPackageManager;
        }
        IPackageManager pm = ActivityThread.getPackageManager();
        if (pm != null) {
            this.mPackageManager = new ApplicationPackageManager(this, pm);
            return this.mPackageManager;
        }
        return null;
    }

    public ContentResolver getContentResolver() {
        return this.mContentResolver;
    }

    public Looper getMainLooper() {
        return this.mMainThread.getLooper();
    }

    public Context getApplicationContext() {
        return this.mPackageInfo != null ? this.mPackageInfo.getApplication() : this.mMainThread.getApplication();
    }

    public void setTheme(int resid) {
        this.mThemeResource = resid;
    }

    public Resources.Theme getTheme() {
        if (this.mTheme == null) {
            if (this.mThemeResource == 0) {
                this.mThemeResource = 16973829;
            }
            this.mTheme = this.mResources.newTheme();
            this.mTheme.applyStyle(this.mThemeResource, true);
        }
        return this.mTheme;
    }

    public ClassLoader getClassLoader() {
        return this.mPackageInfo != null ? this.mPackageInfo.getClassLoader() : ClassLoader.getSystemClassLoader();
    }

    public String getPackageName() {
        if (this.mPackageInfo != null) {
            return this.mPackageInfo.getPackageName();
        }
        throw new RuntimeException("Not supported in system context");
    }

    public ApplicationInfo getApplicationInfo() {
        if (this.mPackageInfo != null) {
            return this.mPackageInfo.getApplicationInfo();
        }
        throw new RuntimeException("Not supported in system context");
    }

    public String getPackageResourcePath() {
        if (this.mPackageInfo != null) {
            return this.mPackageInfo.getResDir();
        }
        throw new RuntimeException("Not supported in system context");
    }

    public String getPackageCodePath() {
        if (this.mPackageInfo != null) {
            return this.mPackageInfo.getAppDir();
        }
        throw new RuntimeException("Not supported in system context");
    }

    public static File makeBackupFile(File prefsFile) {
        return new File(prefsFile.getPath() + ".bak");
    }

    public File getSharedPrefsFile(String name) {
        return this.makeFilename(this.getPreferencesDir(), name + ".xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SharedPreferences getSharedPreferences(String name, int mode) {
        File prefsFile;
        SharedPreferencesImpl sp;
        boolean needInitialLoad = false;
        Object object = sSharedPrefs;
        synchronized (object) {
            sp = sSharedPrefs.get(name);
            if (sp != null && !sp.hasFileChangedUnexpectedly()) {
                return sp;
            }
            prefsFile = this.getSharedPrefsFile(name);
            if (sp == null) {
                sp = new SharedPreferencesImpl(prefsFile, mode, null);
                sSharedPrefs.put(name, sp);
                needInitialLoad = true;
            }
        }
        object = sp;
        synchronized (object) {
            if (needInitialLoad && sp.isLoaded()) {
                return sp;
            }
            File backup = ContextImpl.makeBackupFile(prefsFile);
            if (backup.exists()) {
                prefsFile.delete();
                backup.renameTo(prefsFile);
            }
            if (prefsFile.exists() && !prefsFile.canRead()) {
                Log.w(TAG, "Attempt to read preferences file " + prefsFile + " without permission");
            }
            HashMap map = null;
            FileUtils.FileStatus stat = new FileUtils.FileStatus();
            if (FileUtils.getFileStatus(prefsFile.getPath(), stat) && prefsFile.canRead()) {
                try {
                    FileInputStream str = new FileInputStream(prefsFile);
                    map = XmlUtils.readMapXml(str);
                    str.close();
                }
                catch (XmlPullParserException e) {
                    Log.w(TAG, "getSharedPreferences", e);
                }
                catch (FileNotFoundException e) {
                    Log.w(TAG, "getSharedPreferences", e);
                }
                catch (IOException e) {
                    Log.w(TAG, "getSharedPreferences", e);
                }
            }
            sp.replace(map, stat);
        }
        return sp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getPreferencesDir() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mPreferencesDir == null) {
                this.mPreferencesDir = new File(this.getDataDirFile(), "shared_prefs");
            }
            return this.mPreferencesDir;
        }
    }

    public FileInputStream openFileInput(String name) throws FileNotFoundException {
        File f = this.makeFilename(this.getFilesDir(), name);
        return new FileInputStream(f);
    }

    public FileOutputStream openFileOutput(String name, int mode) throws FileNotFoundException {
        boolean append = (mode & 0x8000) != 0;
        File f = this.makeFilename(this.getFilesDir(), name);
        try {
            FileOutputStream fos = new FileOutputStream(f, append);
            ContextImpl.setFilePermissionsFromMode(f.getPath(), mode, 0);
            return fos;
        }
        catch (FileNotFoundException e) {
            File parent = f.getParentFile();
            parent.mkdir();
            FileUtils.setPermissions(parent.getPath(), 505, -1, -1);
            FileOutputStream fos = new FileOutputStream(f, append);
            ContextImpl.setFilePermissionsFromMode(f.getPath(), mode, 0);
            return fos;
        }
    }

    public boolean deleteFile(String name) {
        File f = this.makeFilename(this.getFilesDir(), name);
        return f.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getFilesDir() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mFilesDir == null) {
                this.mFilesDir = new File(this.getDataDirFile(), "files");
            }
            if (!this.mFilesDir.exists()) {
                if (!this.mFilesDir.mkdirs()) {
                    Log.w(TAG, "Unable to create files directory");
                    return null;
                }
                FileUtils.setPermissions(this.mFilesDir.getPath(), 505, -1, -1);
            }
            return this.mFilesDir;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getExternalFilesDir(String type) {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mExternalFilesDir == null) {
                this.mExternalFilesDir = Environment.getExternalStorageAppFilesDirectory(this.getPackageName());
            }
            if (!this.mExternalFilesDir.exists()) {
                try {
                    new File(Environment.getExternalStorageAndroidDataDir(), ".nomedia").createNewFile();
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (!this.mExternalFilesDir.mkdirs()) {
                    Log.w(TAG, "Unable to create external files directory");
                    return null;
                }
            }
            if (type == null) {
                return this.mExternalFilesDir;
            }
            File dir = new File(this.mExternalFilesDir, type);
            if (!dir.exists() && !dir.mkdirs()) {
                Log.w(TAG, "Unable to create external media directory " + dir);
                return null;
            }
            return dir;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getCacheDir() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mCacheDir == null) {
                this.mCacheDir = new File(this.getDataDirFile(), "cache");
            }
            if (!this.mCacheDir.exists()) {
                if (!this.mCacheDir.mkdirs()) {
                    Log.w(TAG, "Unable to create cache directory");
                    return null;
                }
                FileUtils.setPermissions(this.mCacheDir.getPath(), 505, -1, -1);
            }
        }
        return this.mCacheDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getExternalCacheDir() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mExternalCacheDir == null) {
                this.mExternalCacheDir = Environment.getExternalStorageAppCacheDirectory(this.getPackageName());
            }
            if (!this.mExternalCacheDir.exists()) {
                try {
                    new File(Environment.getExternalStorageAndroidDataDir(), ".nomedia").createNewFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (!this.mExternalCacheDir.mkdirs()) {
                    Log.w(TAG, "Unable to create external cache directory");
                    return null;
                }
            }
            return this.mExternalCacheDir;
        }
    }

    public File getFileStreamPath(String name) {
        return this.makeFilename(this.getFilesDir(), name);
    }

    public String[] fileList() {
        String[] list = this.getFilesDir().list();
        return list != null ? list : EMPTY_FILE_LIST;
    }

    public SQLiteDatabase openOrCreateDatabase(String name, int mode, SQLiteDatabase.CursorFactory factory) {
        File f = this.validateFilePath(name, true);
        SQLiteDatabase db = SQLiteDatabase.openOrCreateDatabase(f, factory);
        ContextImpl.setFilePermissionsFromMode(f.getPath(), mode, 0);
        return db;
    }

    public boolean deleteDatabase(String name) {
        try {
            File f = this.validateFilePath(name, false);
            return f.delete();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public File getDatabasePath(String name) {
        return this.validateFilePath(name, false);
    }

    public String[] databaseList() {
        String[] list = this.getDatabasesDir().list();
        return list != null ? list : EMPTY_FILE_LIST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getDatabasesDir() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mDatabasesDir == null) {
                this.mDatabasesDir = new File(this.getDataDirFile(), "databases");
            }
            if (this.mDatabasesDir.getPath().equals("databases")) {
                this.mDatabasesDir = new File("/data/system");
            }
            return this.mDatabasesDir;
        }
    }

    public Drawable getWallpaper() {
        return this.getWallpaperManager().getDrawable();
    }

    public Drawable peekWallpaper() {
        return this.getWallpaperManager().peekDrawable();
    }

    public int getWallpaperDesiredMinimumWidth() {
        return this.getWallpaperManager().getDesiredMinimumWidth();
    }

    public int getWallpaperDesiredMinimumHeight() {
        return this.getWallpaperManager().getDesiredMinimumHeight();
    }

    public void setWallpaper(Bitmap bitmap) throws IOException {
        this.getWallpaperManager().setBitmap(bitmap);
    }

    public void setWallpaper(InputStream data) throws IOException {
        this.getWallpaperManager().setStream(data);
    }

    public void clearWallpaper() throws IOException {
        this.getWallpaperManager().clear();
    }

    public void startActivity(Intent intent) {
        if ((intent.getFlags() & 0x10000000) == 0) {
            throw new AndroidRuntimeException("Calling startActivity() from outside of an Activity  context requires the FLAG_ACTIVITY_NEW_TASK flag. Is this really what you want?");
        }
        this.mMainThread.getInstrumentation().execStartActivity(this.getOuterContext(), this.mMainThread.getApplicationThread(), null, null, intent, -1);
    }

    public void startIntentSender(IntentSender intent, Intent fillInIntent, int flagsMask, int flagsValues, int extraFlags) throws IntentSender.SendIntentException {
        try {
            int result;
            String resolvedType = null;
            if (fillInIntent != null) {
                resolvedType = fillInIntent.resolveTypeIfNeeded(this.getContentResolver());
            }
            if ((result = ActivityManagerNative.getDefault().startActivityIntentSender(this.mMainThread.getApplicationThread(), intent, fillInIntent, resolvedType, null, null, 0, flagsMask, flagsValues)) == -6) {
                throw new IntentSender.SendIntentException();
            }
            Instrumentation.checkStartActivityResult(result, null);
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    public void sendBroadcast(Intent intent) {
        String resolvedType = intent.resolveTypeIfNeeded(this.getContentResolver());
        try {
            ActivityManagerNative.getDefault().broadcastIntent(this.mMainThread.getApplicationThread(), intent, resolvedType, null, -1, null, null, null, false, false);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void sendBroadcast(Intent intent, String receiverPermission) {
        String resolvedType = intent.resolveTypeIfNeeded(this.getContentResolver());
        try {
            ActivityManagerNative.getDefault().broadcastIntent(this.mMainThread.getApplicationThread(), intent, resolvedType, null, -1, null, null, receiverPermission, false, false);
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    public void sendOrderedBroadcast(Intent intent, String receiverPermission) {
        String resolvedType = intent.resolveTypeIfNeeded(this.getContentResolver());
        try {
            ActivityManagerNative.getDefault().broadcastIntent(this.mMainThread.getApplicationThread(), intent, resolvedType, null, -1, null, null, receiverPermission, true, false);
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    public void sendOrderedBroadcast(Intent intent, String receiverPermission, BroadcastReceiver resultReceiver, Handler scheduler, int initialCode, String initialData, Bundle initialExtras) {
        IIntentReceiver rd = null;
        if (resultReceiver != null) {
            if (this.mPackageInfo != null) {
                if (scheduler == null) {
                    scheduler = this.mMainThread.getHandler();
                }
                rd = this.mPackageInfo.getReceiverDispatcher(resultReceiver, this.getOuterContext(), scheduler, this.mMainThread.getInstrumentation(), false);
            } else {
                if (scheduler == null) {
                    scheduler = this.mMainThread.getHandler();
                }
                rd = new LoadedApk.ReceiverDispatcher(resultReceiver, this.getOuterContext(), scheduler, null, false).getIIntentReceiver();
            }
        }
        String resolvedType = intent.resolveTypeIfNeeded(this.getContentResolver());
        try {
            ActivityManagerNative.getDefault().broadcastIntent(this.mMainThread.getApplicationThread(), intent, resolvedType, rd, initialCode, initialData, initialExtras, receiverPermission, true, false);
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    public void sendStickyBroadcast(Intent intent) {
        String resolvedType = intent.resolveTypeIfNeeded(this.getContentResolver());
        try {
            ActivityManagerNative.getDefault().broadcastIntent(this.mMainThread.getApplicationThread(), intent, resolvedType, null, -1, null, null, null, false, true);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void sendStickyOrderedBroadcast(Intent intent, BroadcastReceiver resultReceiver, Handler scheduler, int initialCode, String initialData, Bundle initialExtras) {
        IIntentReceiver rd = null;
        if (resultReceiver != null) {
            if (this.mPackageInfo != null) {
                if (scheduler == null) {
                    scheduler = this.mMainThread.getHandler();
                }
                rd = this.mPackageInfo.getReceiverDispatcher(resultReceiver, this.getOuterContext(), scheduler, this.mMainThread.getInstrumentation(), false);
            } else {
                if (scheduler == null) {
                    scheduler = this.mMainThread.getHandler();
                }
                rd = new LoadedApk.ReceiverDispatcher(resultReceiver, this.getOuterContext(), scheduler, null, false).getIIntentReceiver();
            }
        }
        String resolvedType = intent.resolveTypeIfNeeded(this.getContentResolver());
        try {
            ActivityManagerNative.getDefault().broadcastIntent(this.mMainThread.getApplicationThread(), intent, resolvedType, rd, initialCode, initialData, initialExtras, null, true, true);
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    public void removeStickyBroadcast(Intent intent) {
        String resolvedType = intent.resolveTypeIfNeeded(this.getContentResolver());
        if (resolvedType != null) {
            intent = new Intent(intent);
            intent.setDataAndType(intent.getData(), resolvedType);
        }
        try {
            ActivityManagerNative.getDefault().unbroadcastIntent(this.mMainThread.getApplicationThread(), intent);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public Intent registerReceiver(BroadcastReceiver receiver, IntentFilter filter) {
        return this.registerReceiver(receiver, filter, null, null);
    }

    public Intent registerReceiver(BroadcastReceiver receiver, IntentFilter filter, String broadcastPermission, Handler scheduler) {
        return this.registerReceiverInternal(receiver, filter, broadcastPermission, scheduler, this.getOuterContext());
    }

    public Intent registerReceiverInternal(BroadcastReceiver receiver, IntentFilter filter, String broadcastPermission, Handler scheduler, Context context) {
        IIntentReceiver rd = null;
        if (receiver != null) {
            if (this.mPackageInfo != null && context != null) {
                if (scheduler == null) {
                    scheduler = this.mMainThread.getHandler();
                }
                rd = this.mPackageInfo.getReceiverDispatcher(receiver, context, scheduler, this.mMainThread.getInstrumentation(), true);
            } else {
                if (scheduler == null) {
                    scheduler = this.mMainThread.getHandler();
                }
                rd = new LoadedApk.ReceiverDispatcher(receiver, context, scheduler, null, true).getIIntentReceiver();
            }
        }
        try {
            return ActivityManagerNative.getDefault().registerReceiver(this.mMainThread.getApplicationThread(), rd, filter, broadcastPermission);
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public void unregisterReceiver(BroadcastReceiver receiver) {
        if (this.mPackageInfo != null) {
            IIntentReceiver rd = this.mPackageInfo.forgetReceiverDispatcher(this.getOuterContext(), receiver);
            try {
                ActivityManagerNative.getDefault().unregisterReceiver(rd);
            }
            catch (RemoteException remoteException) {}
        } else {
            throw new RuntimeException("Not supported in system context");
        }
    }

    public ComponentName startService(Intent service) {
        try {
            ComponentName cn = ActivityManagerNative.getDefault().startService(this.mMainThread.getApplicationThread(), service, service.resolveTypeIfNeeded(this.getContentResolver()));
            if (cn != null && cn.getPackageName().equals("!")) {
                throw new SecurityException("Not allowed to start service " + service + " without permission " + cn.getClassName());
            }
            return cn;
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public boolean stopService(Intent service) {
        try {
            int res = ActivityManagerNative.getDefault().stopService(this.mMainThread.getApplicationThread(), service, service.resolveTypeIfNeeded(this.getContentResolver()));
            if (res < 0) {
                throw new SecurityException("Not allowed to stop service " + service);
            }
            return res != 0;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean bindService(Intent service, ServiceConnection conn, int flags) {
        if (this.mPackageInfo == null) {
            throw new RuntimeException("Not supported in system context");
        }
        IServiceConnection sd = this.mPackageInfo.getServiceDispatcher(conn, this.getOuterContext(), this.mMainThread.getHandler(), flags);
        try {
            int res = ActivityManagerNative.getDefault().bindService(this.mMainThread.getApplicationThread(), this.getActivityToken(), service, service.resolveTypeIfNeeded(this.getContentResolver()), sd, flags);
            if (res < 0) {
                throw new SecurityException("Not allowed to bind to service " + service);
            }
            return res != 0;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public void unbindService(ServiceConnection conn) {
        if (this.mPackageInfo != null) {
            IServiceConnection sd = this.mPackageInfo.forgetServiceDispatcher(this.getOuterContext(), conn);
            try {
                ActivityManagerNative.getDefault().unbindService(sd);
            }
            catch (RemoteException remoteException) {}
        } else {
            throw new RuntimeException("Not supported in system context");
        }
    }

    public boolean startInstrumentation(ComponentName className, String profileFile, Bundle arguments) {
        try {
            return ActivityManagerNative.getDefault().startInstrumentation(className, profileFile, 0, arguments, null);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getSystemService(String name) {
        if ("window".equals(name)) {
            return WindowManagerImpl.getDefault();
        }
        if ("layout_inflater".equals(name)) {
            Object object = this.mSync;
            synchronized (object) {
                LayoutInflater inflater = this.mLayoutInflater;
                if (inflater != null) {
                    return inflater;
                }
                this.mLayoutInflater = inflater = PolicyManager.makeNewLayoutInflater(this.getOuterContext());
                return inflater;
            }
        }
        if ("activity".equals(name)) {
            return this.getActivityManager();
        }
        if ("input_method".equals(name)) {
            return InputMethodManager.getInstance(this);
        }
        if ("alarm".equals(name)) {
            return this.getAlarmManager();
        }
        if ("account".equals(name)) {
            return this.getAccountManager();
        }
        if ("power".equals(name)) {
            return this.getPowerManager();
        }
        if ("connectivity".equals(name)) {
            return this.getConnectivityManager();
        }
        if ("throttle".equals(name)) {
            return this.getThrottleManager();
        }
        if ("wifi".equals(name)) {
            return this.getWifiManager();
        }
        if ("notification".equals(name)) {
            return this.getNotificationManager();
        }
        if ("keyguard".equals(name)) {
            return new KeyguardManager();
        }
        if ("accessibility".equals(name)) {
            return AccessibilityManager.getInstance((Context)this);
        }
        if ("location".equals(name)) {
            return this.getLocationManager();
        }
        if ("search".equals(name)) {
            return this.getSearchManager();
        }
        if ("sensor".equals(name)) {
            return this.getSensorManager();
        }
        if ("storage".equals(name)) {
            return this.getStorageManager();
        }
        if ("usb".equals(name)) {
            return this.getUsbManager();
        }
        if ("vibrator".equals(name)) {
            return this.getVibrator();
        }
        if ("statusbar".equals(name)) {
            Object object = this.mSync;
            synchronized (object) {
                if (this.mStatusBarManager == null) {
                    this.mStatusBarManager = new StatusBarManager(this.getOuterContext());
                }
                return this.mStatusBarManager;
            }
        }
        if ("audio".equals(name)) {
            return this.getAudioManager();
        }
        if ("phone".equals(name)) {
            return this.getTelephonyManager();
        }
        if ("clipboard".equals(name)) {
            return this.getClipboardManager();
        }
        if ("wallpaper".equals(name)) {
            return this.getWallpaperManager();
        }
        if ("dropbox".equals(name)) {
            return this.getDropBoxManager();
        }
        if ("device_policy".equals(name)) {
            return this.getDevicePolicyManager();
        }
        if ("uimode".equals(name)) {
            return this.getUiModeManager();
        }
        if ("download".equals(name)) {
            return this.getDownloadManager();
        }
        if ("nfc".equals(name)) {
            return this.getNfcManager();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccountManager getAccountManager() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mAccountManager == null) {
                IBinder b = ServiceManager.getService((String)"account");
                IAccountManager service = IAccountManager.Stub.asInterface(b);
                this.mAccountManager = new AccountManager(this, service);
            }
            return this.mAccountManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActivityManager getActivityManager() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mActivityManager == null) {
                this.mActivityManager = new ActivityManager(this.getOuterContext(), this.mMainThread.getHandler());
            }
        }
        return this.mActivityManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AlarmManager getAlarmManager() {
        Object object = sSync;
        synchronized (object) {
            if (sAlarmManager == null) {
                IBinder b = ServiceManager.getService((String)"alarm");
                IAlarmManager service = IAlarmManager.Stub.asInterface(b);
                sAlarmManager = new AlarmManager(service);
            }
        }
        return sAlarmManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PowerManager getPowerManager() {
        Object object = sSync;
        synchronized (object) {
            if (sPowerManager == null) {
                IBinder b = ServiceManager.getService((String)"power");
                IPowerManager service = IPowerManager.Stub.asInterface(b);
                sPowerManager = new PowerManager(service, this.mMainThread.getHandler());
            }
        }
        return sPowerManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectivityManager getConnectivityManager() {
        Object object = sSync;
        synchronized (object) {
            if (sConnectivityManager == null) {
                IBinder b = ServiceManager.getService((String)"connectivity");
                IConnectivityManager service = IConnectivityManager.Stub.asInterface(b);
                sConnectivityManager = new ConnectivityManager(service);
            }
        }
        return sConnectivityManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThrottleManager getThrottleManager() {
        Object object = sSync;
        synchronized (object) {
            if (sThrottleManager == null) {
                IBinder b = ServiceManager.getService((String)"throttle");
                IThrottleManager service = IThrottleManager.Stub.asInterface(b);
                sThrottleManager = new ThrottleManager(service);
            }
        }
        return sThrottleManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WifiManager getWifiManager() {
        Object object = sSync;
        synchronized (object) {
            if (sWifiManager == null) {
                IBinder b = ServiceManager.getService((String)"wifi");
                IWifiManager service = IWifiManager.Stub.asInterface(b);
                sWifiManager = new WifiManager(service, this.mMainThread.getHandler());
            }
        }
        return sWifiManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NotificationManager getNotificationManager() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mNotificationManager == null) {
                this.mNotificationManager = new NotificationManager(new ContextThemeWrapper(this.getOuterContext(), 16973835), this.mMainThread.getHandler());
            }
        }
        return this.mNotificationManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WallpaperManager getWallpaperManager() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mWallpaperManager == null) {
                this.mWallpaperManager = new WallpaperManager(this.getOuterContext(), this.mMainThread.getHandler());
            }
        }
        return this.mWallpaperManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TelephonyManager getTelephonyManager() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mTelephonyManager == null) {
                this.mTelephonyManager = new TelephonyManager(this.getOuterContext());
            }
        }
        return this.mTelephonyManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClipboardManager getClipboardManager() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mClipboardManager == null) {
                this.mClipboardManager = new ClipboardManager(this.getOuterContext(), this.mMainThread.getHandler());
            }
        }
        return this.mClipboardManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocationManager getLocationManager() {
        Object object = sSync;
        synchronized (object) {
            if (sLocationManager == null) {
                IBinder b = ServiceManager.getService((String)"location");
                ILocationManager service = ILocationManager.Stub.asInterface(b);
                sLocationManager = new LocationManager(service);
            }
        }
        return sLocationManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchManager getSearchManager() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mSearchManager == null) {
                this.mSearchManager = new SearchManager(this.getOuterContext(), this.mMainThread.getHandler());
            }
        }
        return this.mSearchManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SensorManager getSensorManager() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mSensorManager == null) {
                this.mSensorManager = new SensorManager(this.mMainThread.getHandler().getLooper());
            }
        }
        return this.mSensorManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StorageManager getStorageManager() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mStorageManager == null) {
                try {
                    this.mStorageManager = new StorageManager(this.mMainThread.getHandler().getLooper());
                }
                catch (RemoteException rex) {
                    Log.e(TAG, "Failed to create StorageManager", rex);
                    this.mStorageManager = null;
                }
            }
        }
        return this.mStorageManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UsbManager getUsbManager() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mUsbManager == null) {
                IBinder b = ServiceManager.getService((String)"usb");
                IUsbManager service = IUsbManager.Stub.asInterface(b);
                this.mUsbManager = new UsbManager(this, service);
            }
        }
        return this.mUsbManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vibrator getVibrator() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mVibrator == null) {
                this.mVibrator = new Vibrator();
            }
        }
        return this.mVibrator;
    }

    public AudioManager getAudioManager() {
        if (this.mAudioManager == null) {
            this.mAudioManager = new AudioManager(this);
        }
        return this.mAudioManager;
    }

    public static DropBoxManager createDropBoxManager() {
        IBinder b = ServiceManager.getService((String)"dropbox");
        IDropBoxManagerService service = IDropBoxManagerService.Stub.asInterface(b);
        return new DropBoxManager(service);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DropBoxManager getDropBoxManager() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mDropBoxManager == null) {
                this.mDropBoxManager = ContextImpl.createDropBoxManager();
            }
        }
        return this.mDropBoxManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DevicePolicyManager getDevicePolicyManager() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mDevicePolicyManager == null) {
                this.mDevicePolicyManager = DevicePolicyManager.create(this, this.mMainThread.getHandler());
            }
        }
        return this.mDevicePolicyManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UiModeManager getUiModeManager() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mUiModeManager == null) {
                this.mUiModeManager = new UiModeManager();
            }
        }
        return this.mUiModeManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadManager getDownloadManager() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mDownloadManager == null) {
                this.mDownloadManager = new DownloadManager(this.getContentResolver(), this.getPackageName());
            }
        }
        return this.mDownloadManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NfcManager getNfcManager() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mNfcManager == null) {
                this.mNfcManager = new NfcManager(this);
            }
        }
        return this.mNfcManager;
    }

    public int checkPermission(String permission2, int pid, int uid) {
        if (permission2 == null) {
            throw new IllegalArgumentException("permission is null");
        }
        if (!Process.supportsProcesses()) {
            return 0;
        }
        try {
            return ActivityManagerNative.getDefault().checkPermission(permission2, pid, uid);
        }
        catch (RemoteException e) {
            return -1;
        }
    }

    public int checkCallingPermission(String permission2) {
        if (permission2 == null) {
            throw new IllegalArgumentException("permission is null");
        }
        if (!Process.supportsProcesses()) {
            return 0;
        }
        int pid = Binder.getCallingPid();
        if (pid != Process.myPid()) {
            return this.checkPermission(permission2, pid, Binder.getCallingUid());
        }
        return -1;
    }

    public int checkCallingOrSelfPermission(String permission2) {
        if (permission2 == null) {
            throw new IllegalArgumentException("permission is null");
        }
        return this.checkPermission(permission2, Binder.getCallingPid(), Binder.getCallingUid());
    }

    public void enforce(String permission2, int resultOfCheck, boolean selfToo, int uid, String message) {
        if (resultOfCheck != 0) {
            throw new SecurityException((message != null ? message + ": " : "") + (selfToo ? "Neither user " + uid + " nor current process has " : "User " + uid + " does not have ") + permission2 + ".");
        }
    }

    public void enforcePermission(String permission2, int pid, int uid, String message) {
        this.enforce(permission2, this.checkPermission(permission2, pid, uid), false, uid, message);
    }

    public void enforceCallingPermission(String permission2, String message) {
        this.enforce(permission2, this.checkCallingPermission(permission2), false, Binder.getCallingUid(), message);
    }

    public void enforceCallingOrSelfPermission(String permission2, String message) {
        this.enforce(permission2, this.checkCallingOrSelfPermission(permission2), true, Binder.getCallingUid(), message);
    }

    public void grantUriPermission(String toPackage, Uri uri, int modeFlags) {
        try {
            ActivityManagerNative.getDefault().grantUriPermission(this.mMainThread.getApplicationThread(), toPackage, uri, modeFlags);
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    public void revokeUriPermission(Uri uri, int modeFlags) {
        try {
            ActivityManagerNative.getDefault().revokeUriPermission(this.mMainThread.getApplicationThread(), uri, modeFlags);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public int checkUriPermission(Uri uri, int pid, int uid, int modeFlags) {
        if (!Process.supportsProcesses()) {
            return 0;
        }
        try {
            return ActivityManagerNative.getDefault().checkUriPermission(uri, pid, uid, modeFlags);
        }
        catch (RemoteException e) {
            return -1;
        }
    }

    public int checkCallingUriPermission(Uri uri, int modeFlags) {
        if (!Process.supportsProcesses()) {
            return 0;
        }
        int pid = Binder.getCallingPid();
        if (pid != Process.myPid()) {
            return this.checkUriPermission(uri, pid, Binder.getCallingUid(), modeFlags);
        }
        return -1;
    }

    public int checkCallingOrSelfUriPermission(Uri uri, int modeFlags) {
        return this.checkUriPermission(uri, Binder.getCallingPid(), Binder.getCallingUid(), modeFlags);
    }

    public int checkUriPermission(Uri uri, String readPermission, String writePermission, int pid, int uid, int modeFlags) {
        if ((modeFlags & 1) != 0 && (readPermission == null || this.checkPermission(readPermission, pid, uid) == 0)) {
            return 0;
        }
        if ((modeFlags & 2) != 0 && (writePermission == null || this.checkPermission(writePermission, pid, uid) == 0)) {
            return 0;
        }
        return uri != null ? this.checkUriPermission(uri, pid, uid, modeFlags) : -1;
    }

    public String uriModeFlagToString(int uriModeFlags) {
        switch (uriModeFlags) {
            case 3: {
                return "read and write";
            }
            case 1: {
                return "read";
            }
            case 2: {
                return "write";
            }
        }
        throw new IllegalArgumentException("Unknown permission mode flags: " + uriModeFlags);
    }

    public void enforceForUri(int modeFlags, int resultOfCheck, boolean selfToo, int uid, Uri uri, String message) {
        if (resultOfCheck != 0) {
            throw new SecurityException((message != null ? message + ": " : "") + (selfToo ? "Neither user " + uid + " nor current process has " : "User " + uid + " does not have ") + this.uriModeFlagToString(modeFlags) + " permission on " + uri + ".");
        }
    }

    public void enforceUriPermission(Uri uri, int pid, int uid, int modeFlags, String message) {
        this.enforceForUri(modeFlags, this.checkUriPermission(uri, pid, uid, modeFlags), false, uid, uri, message);
    }

    public void enforceCallingUriPermission(Uri uri, int modeFlags, String message) {
        this.enforceForUri(modeFlags, this.checkCallingUriPermission(uri, modeFlags), false, Binder.getCallingUid(), uri, message);
    }

    public void enforceCallingOrSelfUriPermission(Uri uri, int modeFlags, String message) {
        this.enforceForUri(modeFlags, this.checkCallingOrSelfUriPermission(uri, modeFlags), true, Binder.getCallingUid(), uri, message);
    }

    public void enforceUriPermission(Uri uri, String readPermission, String writePermission, int pid, int uid, int modeFlags, String message) {
        this.enforceForUri(modeFlags, this.checkUriPermission(uri, readPermission, writePermission, pid, uid, modeFlags), false, uid, uri, message);
    }

    public Context createPackageContext(String packageName, int flags) throws PackageManager.NameNotFoundException {
        if (packageName.equals("system") || packageName.equals("android")) {
            return new ContextImpl(this.mMainThread.getSystemContext());
        }
        LoadedApk pi = this.mMainThread.getPackageInfo(packageName, flags);
        if (pi != null) {
            ContextImpl c = new ContextImpl();
            c.mRestricted = (flags & 4) == 4;
            c.init(pi, null, this.mMainThread, this.mResources);
            if (c.mResources != null) {
                return c;
            }
        }
        throw new PackageManager.NameNotFoundException("Application package " + packageName + " not found");
    }

    public boolean isRestricted() {
        return this.mRestricted;
    }

    public File getDataDirFile() {
        if (this.mPackageInfo != null) {
            return this.mPackageInfo.getDataDirFile();
        }
        throw new RuntimeException("Not supported in system context");
    }

    public File getDir(String name, int mode) {
        name = "app_" + name;
        File file = this.makeFilename(this.getDataDirFile(), name);
        if (!file.exists()) {
            file.mkdir();
            ContextImpl.setFilePermissionsFromMode(file.getPath(), mode, 505);
        }
        return file;
    }

    public static ContextImpl createSystemContext(ActivityThread mainThread) {
        ContextImpl context = new ContextImpl();
        context.init(Resources.getSystem(), mainThread);
        return context;
    }

    public ContextImpl() {
        this.mOuterContext = this;
    }

    public ContextImpl(ContextImpl context) {
        ++sInstanceCount;
        this.mPackageInfo = context.mPackageInfo;
        this.mResources = context.mResources;
        this.mMainThread = context.mMainThread;
        this.mContentResolver = context.mContentResolver;
        this.mOuterContext = this;
    }

    public void init(LoadedApk packageInfo, IBinder activityToken, ActivityThread mainThread) {
        this.init(packageInfo, activityToken, mainThread, null);
    }

    public void init(LoadedApk packageInfo, IBinder activityToken, ActivityThread mainThread, Resources container) {
        this.mPackageInfo = packageInfo;
        this.mResources = this.mPackageInfo.getResources(mainThread);
        if (this.mResources != null && container != null && container.getCompatibilityInfo().applicationScale != this.mResources.getCompatibilityInfo().applicationScale) {
            this.mResources = mainThread.getTopLevelResources(this.mPackageInfo.getResDir(), container.getCompatibilityInfo().copy());
        }
        this.mMainThread = mainThread;
        this.mContentResolver = new ApplicationContentResolver(this, mainThread);
        this.setActivityToken(activityToken);
    }

    public void init(Resources resources, ActivityThread mainThread) {
        this.mPackageInfo = null;
        this.mResources = resources;
        this.mMainThread = mainThread;
        this.mContentResolver = new ApplicationContentResolver(this, mainThread);
    }

    public void scheduleFinalCleanup(String who, String what) {
        this.mMainThread.scheduleContextCleanup(this, who, what);
    }

    public void performFinalCleanup(String who, String what) {
        this.mPackageInfo.removeContextRegistrations(this.getOuterContext(), who, what);
    }

    public Context getReceiverRestrictedContext() {
        if (this.mReceiverRestrictedContext != null) {
            return this.mReceiverRestrictedContext;
        }
        this.mReceiverRestrictedContext = new ReceiverRestrictedContext(this.getOuterContext());
        return this.mReceiverRestrictedContext;
    }

    public void setActivityToken(IBinder token) {
        this.mActivityToken = token;
    }

    public void setOuterContext(Context context) {
        this.mOuterContext = context;
    }

    public Context getOuterContext() {
        return this.mOuterContext;
    }

    public IBinder getActivityToken() {
        return this.mActivityToken;
    }

    public static void setFilePermissionsFromMode(String name, int mode, int extraPermissions) {
        int perms = 0x1B0 | extraPermissions;
        if ((mode & 1) != 0) {
            perms |= 4;
        }
        if ((mode & 2) != 0) {
            perms |= 2;
        }
        FileUtils.setPermissions(name, perms, -1, -1);
    }

    public File validateFilePath(String name, boolean createDirectory) {
        File f;
        File dir;
        if (name.charAt(0) == File.separatorChar) {
            String dirPath = name.substring(0, name.lastIndexOf(File.separatorChar));
            dir = new File(dirPath);
            name = name.substring(name.lastIndexOf(File.separatorChar));
            f = new File(dir, name);
        } else {
            dir = this.getDatabasesDir();
            f = this.makeFilename(dir, name);
        }
        if (createDirectory && !dir.isDirectory() && dir.mkdir()) {
            FileUtils.setPermissions(dir.getPath(), 505, -1, -1);
        }
        return f;
    }

    public File makeFilename(File base, String name) {
        if (name.indexOf(File.separatorChar) < 0) {
            return new File(base, name);
        }
        throw new IllegalArgumentException("File " + name + " contains a path separator");
    }

    static {
        sSharedPrefs = new HashMap();
        sInstanceCount = 0L;
        EMPTY_FILE_LIST = new String[0];
    }

    public static class 1 {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SharedPreferencesImpl
    implements SharedPreferences {
        public final File mFile;
        public final File mBackupFile;
        public final int mMode;
        public Map<String, Object> mMap;
        public int mDiskWritesInFlight = 0;
        public boolean mLoaded = false;
        public long mStatTimestamp;
        public long mStatSize;
        public final Object mWritingToDiskLock = new Object();
        public static final Object mContent = new Object();
        public final WeakHashMap<SharedPreferences.OnSharedPreferenceChangeListener, Object> mListeners;

        public SharedPreferencesImpl(File file, int mode, Map initialContents) {
            this.mFile = file;
            this.mBackupFile = ContextImpl.makeBackupFile(file);
            this.mMode = mode;
            this.mLoaded = initialContents != null;
            this.mMap = initialContents != null ? initialContents : new HashMap();
            FileUtils.FileStatus stat = new FileUtils.FileStatus();
            if (FileUtils.getFileStatus(file.getPath(), stat)) {
                this.mStatTimestamp = stat.mtime;
            }
            this.mListeners = new WeakHashMap();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isLoaded() {
            SharedPreferencesImpl sharedPreferencesImpl = this;
            synchronized (sharedPreferencesImpl) {
                return this.mLoaded;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasFileChangedUnexpectedly() {
            SharedPreferencesImpl sharedPreferencesImpl = this;
            synchronized (sharedPreferencesImpl) {
                if (this.mDiskWritesInFlight > 0) {
                    return false;
                }
            }
            FileUtils.FileStatus stat = new FileUtils.FileStatus();
            if (!FileUtils.getFileStatus(this.mFile.getPath(), stat)) {
                return true;
            }
            SharedPreferencesImpl sharedPreferencesImpl2 = this;
            synchronized (sharedPreferencesImpl2) {
                return this.mStatTimestamp != stat.mtime || this.mStatSize != stat.size;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void replace(Map newContents, FileUtils.FileStatus stat) {
            SharedPreferencesImpl sharedPreferencesImpl = this;
            synchronized (sharedPreferencesImpl) {
                this.mLoaded = true;
                if (newContents != null) {
                    this.mMap = newContents;
                }
                if (stat != null) {
                    this.mStatTimestamp = stat.mtime;
                    this.mStatSize = stat.size;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void registerOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
            SharedPreferencesImpl sharedPreferencesImpl = this;
            synchronized (sharedPreferencesImpl) {
                this.mListeners.put(listener, mContent);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unregisterOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
            SharedPreferencesImpl sharedPreferencesImpl = this;
            synchronized (sharedPreferencesImpl) {
                this.mListeners.remove(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<String, ?> getAll() {
            SharedPreferencesImpl sharedPreferencesImpl = this;
            synchronized (sharedPreferencesImpl) {
                return new HashMap<String, Object>(this.mMap);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getString(String key, String defValue) {
            SharedPreferencesImpl sharedPreferencesImpl = this;
            synchronized (sharedPreferencesImpl) {
                String v = (String)this.mMap.get(key);
                return v != null ? v : defValue;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getInt(String key, int defValue) {
            SharedPreferencesImpl sharedPreferencesImpl = this;
            synchronized (sharedPreferencesImpl) {
                Integer v = (Integer)this.mMap.get(key);
                return v != null ? v : defValue;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long getLong(String key, long defValue) {
            SharedPreferencesImpl sharedPreferencesImpl = this;
            synchronized (sharedPreferencesImpl) {
                Long v = (Long)this.mMap.get(key);
                return v != null ? v : defValue;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public float getFloat(String key, float defValue) {
            SharedPreferencesImpl sharedPreferencesImpl = this;
            synchronized (sharedPreferencesImpl) {
                Float v = (Float)this.mMap.get(key);
                return v != null ? v.floatValue() : defValue;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean getBoolean(String key, boolean defValue) {
            SharedPreferencesImpl sharedPreferencesImpl = this;
            synchronized (sharedPreferencesImpl) {
                Boolean v = (Boolean)this.mMap.get(key);
                return v != null ? v : defValue;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(String key) {
            SharedPreferencesImpl sharedPreferencesImpl = this;
            synchronized (sharedPreferencesImpl) {
                return this.mMap.containsKey(key);
            }
        }

        @Override
        public SharedPreferences.Editor edit() {
            return new EditorImpl();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void enqueueDiskWrite(final MemoryCommitResult mcr, final Runnable postWriteRunnable) {
            boolean isFromSyncCommit;
            Runnable writeToDiskRunnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Object object = SharedPreferencesImpl.this.mWritingToDiskLock;
                    synchronized (object) {
                        SharedPreferencesImpl.this.writeToFile(mcr);
                    }
                    object = SharedPreferencesImpl.this;
                    synchronized (object) {
                        SharedPreferencesImpl.this.mDiskWritesInFlight--;
                    }
                    if (postWriteRunnable != null) {
                        postWriteRunnable.run();
                    }
                }
            };
            boolean bl = isFromSyncCommit = postWriteRunnable == null;
            if (isFromSyncCommit) {
                boolean wasEmpty = false;
                SharedPreferencesImpl sharedPreferencesImpl = this;
                synchronized (sharedPreferencesImpl) {
                    wasEmpty = this.mDiskWritesInFlight == 1;
                }
                if (wasEmpty) {
                    writeToDiskRunnable.run();
                    return;
                }
            }
            QueuedWork.singleThreadExecutor().execute(writeToDiskRunnable);
        }

        public static FileOutputStream createFileOutputStream(File file) {
            FileOutputStream str = null;
            try {
                str = new FileOutputStream(file);
            }
            catch (FileNotFoundException e) {
                File parent = file.getParentFile();
                if (!parent.mkdir()) {
                    Log.e(ContextImpl.TAG, "Couldn't create directory for SharedPreferences file " + file);
                    return null;
                }
                FileUtils.setPermissions(parent.getPath(), 505, -1, -1);
                try {
                    str = new FileOutputStream(file);
                }
                catch (FileNotFoundException e2) {
                    Log.e(ContextImpl.TAG, "Couldn't create SharedPreferences file " + file, e2);
                }
            }
            return str;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeToFile(MemoryCommitResult mcr) {
            if (this.mFile.exists()) {
                if (!mcr.changesMade) {
                    mcr.setDiskWriteResult(true);
                    return;
                }
                if (!this.mBackupFile.exists()) {
                    if (!this.mFile.renameTo(this.mBackupFile)) {
                        Log.e(ContextImpl.TAG, "Couldn't rename file " + this.mFile + " to backup file " + this.mBackupFile);
                        mcr.setDiskWriteResult(false);
                        return;
                    }
                } else {
                    this.mFile.delete();
                }
            }
            try {
                FileOutputStream str = SharedPreferencesImpl.createFileOutputStream(this.mFile);
                if (str == null) {
                    mcr.setDiskWriteResult(false);
                    return;
                }
                XmlUtils.writeMapXml(mcr.mapToWriteToDisk, str);
                FileUtils.sync(str);
                str.close();
                ContextImpl.setFilePermissionsFromMode(this.mFile.getPath(), this.mMode, 0);
                FileUtils.FileStatus stat = new FileUtils.FileStatus();
                if (FileUtils.getFileStatus(this.mFile.getPath(), stat)) {
                    SharedPreferencesImpl sharedPreferencesImpl = this;
                    synchronized (sharedPreferencesImpl) {
                        this.mStatTimestamp = stat.mtime;
                        this.mStatSize = stat.size;
                    }
                }
                this.mBackupFile.delete();
                mcr.setDiskWriteResult(true);
                return;
            }
            catch (XmlPullParserException e) {
                Log.w(ContextImpl.TAG, "writeToFile: Got exception:", e);
            }
            catch (IOException e) {
                Log.w(ContextImpl.TAG, "writeToFile: Got exception:", e);
            }
            if (this.mFile.exists() && !this.mFile.delete()) {
                Log.e(ContextImpl.TAG, "Couldn't clean up partially-written file " + this.mFile);
            }
            mcr.setDiskWriteResult(false);
        }

        public class EditorImpl
        implements SharedPreferences.Editor {
            public final Map<String, Object> mModified = Maps.newHashMap();
            public boolean mClear = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public SharedPreferences.Editor putString(String key, String value) {
                EditorImpl editorImpl = this;
                synchronized (editorImpl) {
                    this.mModified.put(key, value);
                    return this;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public SharedPreferences.Editor putInt(String key, int value) {
                EditorImpl editorImpl = this;
                synchronized (editorImpl) {
                    this.mModified.put(key, value);
                    return this;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public SharedPreferences.Editor putLong(String key, long value) {
                EditorImpl editorImpl = this;
                synchronized (editorImpl) {
                    this.mModified.put(key, value);
                    return this;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public SharedPreferences.Editor putFloat(String key, float value) {
                EditorImpl editorImpl = this;
                synchronized (editorImpl) {
                    this.mModified.put(key, Float.valueOf(value));
                    return this;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public SharedPreferences.Editor putBoolean(String key, boolean value) {
                EditorImpl editorImpl = this;
                synchronized (editorImpl) {
                    this.mModified.put(key, value);
                    return this;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public SharedPreferences.Editor remove(String key) {
                EditorImpl editorImpl = this;
                synchronized (editorImpl) {
                    this.mModified.put(key, this);
                    return this;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public SharedPreferences.Editor clear() {
                EditorImpl editorImpl = this;
                synchronized (editorImpl) {
                    this.mClear = true;
                    return this;
                }
            }

            public void apply() {
                final MemoryCommitResult mcr = this.commitToMemory();
                final Runnable awaitCommit = new Runnable(){

                    public void run() {
                        try {
                            mcr.writtenToDiskLatch.await();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                };
                QueuedWork.add(awaitCommit);
                Runnable postWriteRunnable = new Runnable(){

                    public void run() {
                        awaitCommit.run();
                        QueuedWork.remove(awaitCommit);
                    }
                };
                SharedPreferencesImpl.this.enqueueDiskWrite(mcr, postWriteRunnable);
                this.notifyListeners(mcr);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public MemoryCommitResult commitToMemory() {
                MemoryCommitResult mcr = new MemoryCommitResult(null);
                SharedPreferencesImpl sharedPreferencesImpl = SharedPreferencesImpl.this;
                synchronized (sharedPreferencesImpl) {
                    boolean hasListeners;
                    if (SharedPreferencesImpl.this.mDiskWritesInFlight > 0) {
                        SharedPreferencesImpl.this.mMap = new HashMap(SharedPreferencesImpl.this.mMap);
                    }
                    mcr.mapToWriteToDisk = SharedPreferencesImpl.this.mMap;
                    SharedPreferencesImpl.this.mDiskWritesInFlight++;
                    boolean bl = hasListeners = SharedPreferencesImpl.this.mListeners.size() > 0;
                    if (hasListeners) {
                        mcr.keysModified = new ArrayList<String>();
                        mcr.listeners = new HashSet(SharedPreferencesImpl.this.mListeners.keySet());
                    }
                    EditorImpl editorImpl = this;
                    synchronized (editorImpl) {
                        if (this.mClear) {
                            if (!SharedPreferencesImpl.this.mMap.isEmpty()) {
                                mcr.changesMade = true;
                                SharedPreferencesImpl.this.mMap.clear();
                            }
                            this.mClear = false;
                        }
                        for (Map.Entry<String, Object> e : this.mModified.entrySet()) {
                            String k = e.getKey();
                            Object v = e.getValue();
                            if (v == this) {
                                if (!SharedPreferencesImpl.this.mMap.containsKey(k)) continue;
                                SharedPreferencesImpl.this.mMap.remove(k);
                            } else {
                                Object existingValue;
                                boolean isSame = false;
                                if (SharedPreferencesImpl.this.mMap.containsKey(k) && (existingValue = SharedPreferencesImpl.this.mMap.get(k)) != null && existingValue.equals(v)) continue;
                                SharedPreferencesImpl.this.mMap.put(k, v);
                            }
                            mcr.changesMade = true;
                            if (!hasListeners) continue;
                            mcr.keysModified.add(k);
                        }
                        this.mModified.clear();
                    }
                }
                return mcr;
            }

            public boolean commit() {
                MemoryCommitResult mcr = this.commitToMemory();
                SharedPreferencesImpl.this.enqueueDiskWrite(mcr, null);
                try {
                    mcr.writtenToDiskLatch.await();
                }
                catch (InterruptedException e) {
                    return false;
                }
                this.notifyListeners(mcr);
                return mcr.writeToDiskResult;
            }

            public void notifyListeners(final MemoryCommitResult mcr) {
                if (mcr.listeners == null || mcr.keysModified == null || mcr.keysModified.size() == 0) {
                    return;
                }
                if (Looper.myLooper() == Looper.getMainLooper()) {
                    for (int i = mcr.keysModified.size() - 1; i >= 0; --i) {
                        String key = mcr.keysModified.get(i);
                        for (SharedPreferences.OnSharedPreferenceChangeListener listener : mcr.listeners) {
                            if (listener == null) continue;
                            listener.onSharedPreferenceChanged(SharedPreferencesImpl.this, key);
                        }
                    }
                } else {
                    ActivityThread.sMainThreadHandler.post(new Runnable(){

                        public void run() {
                            EditorImpl.this.notifyListeners(mcr);
                        }
                    });
                }
            }
        }

        public static class MemoryCommitResult {
            public boolean changesMade;
            public List<String> keysModified;
            public Set<SharedPreferences.OnSharedPreferenceChangeListener> listeners;
            public Map<?, ?> mapToWriteToDisk;
            public final CountDownLatch writtenToDiskLatch = new CountDownLatch(1);
            public volatile boolean writeToDiskResult = false;

            public MemoryCommitResult() {
            }

            public void setDiskWriteResult(boolean result) {
                this.writeToDiskResult = result;
                this.writtenToDiskLatch.countDown();
            }

            public /* synthetic */ MemoryCommitResult(1 x0) {
                this();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ApplicationPackageManager
    extends PackageManager {
        public int mCachedSafeMode = -1;
        public final ContextImpl mContext;
        public final IPackageManager mPM;
        public static final Object sSync = new Object();
        public static HashMap<ResourceName, WeakReference<Drawable>> sIconCache = new HashMap();
        public static HashMap<ResourceName, WeakReference<CharSequence>> sStringCache = new HashMap();

        @Override
        public PackageInfo getPackageInfo(String packageName, int flags) throws PackageManager.NameNotFoundException {
            try {
                PackageInfo pi = this.mPM.getPackageInfo(packageName, flags);
                if (pi != null) {
                    return pi;
                }
            }
            catch (RemoteException e) {
                throw new RuntimeException("Package manager has died", e);
            }
            throw new PackageManager.NameNotFoundException(packageName);
        }

        @Override
        public String[] currentToCanonicalPackageNames(String[] names) {
            try {
                return this.mPM.currentToCanonicalPackageNames(names);
            }
            catch (RemoteException e) {
                throw new RuntimeException("Package manager has died", e);
            }
        }

        @Override
        public String[] canonicalToCurrentPackageNames(String[] names) {
            try {
                return this.mPM.canonicalToCurrentPackageNames(names);
            }
            catch (RemoteException e) {
                throw new RuntimeException("Package manager has died", e);
            }
        }

        @Override
        public Intent getLaunchIntentForPackage(String packageName) {
            Intent intentToResolve = new Intent("android.intent.action.MAIN");
            intentToResolve.addCategory("android.intent.category.INFO");
            intentToResolve.setPackage(packageName);
            ResolveInfo resolveInfo = this.resolveActivity(intentToResolve, 0);
            if (resolveInfo == null) {
                intentToResolve.removeCategory("android.intent.category.INFO");
                intentToResolve.addCategory("android.intent.category.LAUNCHER");
                intentToResolve.setPackage(packageName);
                resolveInfo = this.resolveActivity(intentToResolve, 0);
            }
            if (resolveInfo == null) {
                return null;
            }
            Intent intent = new Intent("android.intent.action.MAIN");
            intent.setClassName(packageName, resolveInfo.activityInfo.name);
            intent.setFlags(0x10000000);
            return intent;
        }

        @Override
        public int[] getPackageGids(String packageName) throws PackageManager.NameNotFoundException {
            try {
                int[] gids = this.mPM.getPackageGids(packageName);
                if (gids == null || gids.length > 0) {
                    return gids;
                }
            }
            catch (RemoteException e) {
                throw new RuntimeException("Package manager has died", e);
            }
            throw new PackageManager.NameNotFoundException(packageName);
        }

        @Override
        public PermissionInfo getPermissionInfo(String name, int flags) throws PackageManager.NameNotFoundException {
            try {
                PermissionInfo pi = this.mPM.getPermissionInfo(name, flags);
                if (pi != null) {
                    return pi;
                }
            }
            catch (RemoteException e) {
                throw new RuntimeException("Package manager has died", e);
            }
            throw new PackageManager.NameNotFoundException(name);
        }

        @Override
        public List<PermissionInfo> queryPermissionsByGroup(String group, int flags) throws PackageManager.NameNotFoundException {
            try {
                List<PermissionInfo> pi = this.mPM.queryPermissionsByGroup(group, flags);
                if (pi != null) {
                    return pi;
                }
            }
            catch (RemoteException e) {
                throw new RuntimeException("Package manager has died", e);
            }
            throw new PackageManager.NameNotFoundException(group);
        }

        @Override
        public PermissionGroupInfo getPermissionGroupInfo(String name, int flags) throws PackageManager.NameNotFoundException {
            try {
                PermissionGroupInfo pgi = this.mPM.getPermissionGroupInfo(name, flags);
                if (pgi != null) {
                    return pgi;
                }
            }
            catch (RemoteException e) {
                throw new RuntimeException("Package manager has died", e);
            }
            throw new PackageManager.NameNotFoundException(name);
        }

        @Override
        public List<PermissionGroupInfo> getAllPermissionGroups(int flags) {
            try {
                return this.mPM.getAllPermissionGroups(flags);
            }
            catch (RemoteException e) {
                throw new RuntimeException("Package manager has died", e);
            }
        }

        @Override
        public ApplicationInfo getApplicationInfo(String packageName, int flags) throws PackageManager.NameNotFoundException {
            try {
                ApplicationInfo ai = this.mPM.getApplicationInfo(packageName, flags);
                if (ai != null) {
                    return ai;
                }
            }
            catch (RemoteException e) {
                throw new RuntimeException("Package manager has died", e);
            }
            throw new PackageManager.NameNotFoundException(packageName);
        }

        @Override
        public ActivityInfo getActivityInfo(ComponentName className, int flags) throws PackageManager.NameNotFoundException {
            try {
                ActivityInfo ai = this.mPM.getActivityInfo(className, flags);
                if (ai != null) {
                    return ai;
                }
            }
            catch (RemoteException e) {
                throw new RuntimeException("Package manager has died", e);
            }
            throw new PackageManager.NameNotFoundException(className.toString());
        }

        @Override
        public ActivityInfo getReceiverInfo(ComponentName className, int flags) throws PackageManager.NameNotFoundException {
            try {
                ActivityInfo ai = this.mPM.getReceiverInfo(className, flags);
                if (ai != null) {
                    return ai;
                }
            }
            catch (RemoteException e) {
                throw new RuntimeException("Package manager has died", e);
            }
            throw new PackageManager.NameNotFoundException(className.toString());
        }

        @Override
        public ServiceInfo getServiceInfo(ComponentName className, int flags) throws PackageManager.NameNotFoundException {
            try {
                ServiceInfo si = this.mPM.getServiceInfo(className, flags);
                if (si != null) {
                    return si;
                }
            }
            catch (RemoteException e) {
                throw new RuntimeException("Package manager has died", e);
            }
            throw new PackageManager.NameNotFoundException(className.toString());
        }

        @Override
        public ProviderInfo getProviderInfo(ComponentName className, int flags) throws PackageManager.NameNotFoundException {
            try {
                ProviderInfo pi = this.mPM.getProviderInfo(className, flags);
                if (pi != null) {
                    return pi;
                }
            }
            catch (RemoteException e) {
                throw new RuntimeException("Package manager has died", e);
            }
            throw new PackageManager.NameNotFoundException(className.toString());
        }

        @Override
        public String[] getSystemSharedLibraryNames() {
            try {
                return this.mPM.getSystemSharedLibraryNames();
            }
            catch (RemoteException e) {
                throw new RuntimeException("Package manager has died", e);
            }
        }

        @Override
        public FeatureInfo[] getSystemAvailableFeatures() {
            try {
                return this.mPM.getSystemAvailableFeatures();
            }
            catch (RemoteException e) {
                throw new RuntimeException("Package manager has died", e);
            }
        }

        @Override
        public boolean hasSystemFeature(String name) {
            try {
                return this.mPM.hasSystemFeature(name);
            }
            catch (RemoteException e) {
                throw new RuntimeException("Package manager has died", e);
            }
        }

        @Override
        public int checkPermission(String permName, String pkgName) {
            try {
                return this.mPM.checkPermission(permName, pkgName);
            }
            catch (RemoteException e) {
                throw new RuntimeException("Package manager has died", e);
            }
        }

        @Override
        public boolean addPermission(PermissionInfo info) {
            try {
                return this.mPM.addPermission(info);
            }
            catch (RemoteException e) {
                throw new RuntimeException("Package manager has died", e);
            }
        }

        @Override
        public boolean addPermissionAsync(PermissionInfo info) {
            try {
                return this.mPM.addPermissionAsync(info);
            }
            catch (RemoteException e) {
                throw new RuntimeException("Package manager has died", e);
            }
        }

        @Override
        public void removePermission(String name) {
            try {
                this.mPM.removePermission(name);
            }
            catch (RemoteException e) {
                throw new RuntimeException("Package manager has died", e);
            }
        }

        @Override
        public int checkSignatures(String pkg1, String pkg2) {
            try {
                return this.mPM.checkSignatures(pkg1, pkg2);
            }
            catch (RemoteException e) {
                throw new RuntimeException("Package manager has died", e);
            }
        }

        @Override
        public int checkSignatures(int uid1, int uid2) {
            try {
                return this.mPM.checkUidSignatures(uid1, uid2);
            }
            catch (RemoteException e) {
                throw new RuntimeException("Package manager has died", e);
            }
        }

        @Override
        public String[] getPackagesForUid(int uid) {
            try {
                return this.mPM.getPackagesForUid(uid);
            }
            catch (RemoteException e) {
                throw new RuntimeException("Package manager has died", e);
            }
        }

        @Override
        public String getNameForUid(int uid) {
            try {
                return this.mPM.getNameForUid(uid);
            }
            catch (RemoteException e) {
                throw new RuntimeException("Package manager has died", e);
            }
        }

        @Override
        public int getUidForSharedUser(String sharedUserName) throws PackageManager.NameNotFoundException {
            try {
                int uid = this.mPM.getUidForSharedUser(sharedUserName);
                if (uid != -1) {
                    return uid;
                }
            }
            catch (RemoteException e) {
                throw new RuntimeException("Package manager has died", e);
            }
            throw new PackageManager.NameNotFoundException("No shared userid for user:" + sharedUserName);
        }

        @Override
        public List<PackageInfo> getInstalledPackages(int flags) {
            try {
                ParceledListSlice slice;
                ArrayList<PackageInfo> packageInfos = new ArrayList<PackageInfo>();
                PackageInfo lastItem = null;
                do {
                    String lastKey = lastItem != null ? lastItem.packageName : null;
                    slice = this.mPM.getInstalledPackages(flags, lastKey);
                    lastItem = slice.populateList(packageInfos, PackageInfo.CREATOR);
                } while (!slice.isLastSlice());
                return packageInfos;
            }
            catch (RemoteException e) {
                throw new RuntimeException("Package manager has died", e);
            }
        }

        @Override
        public List<ApplicationInfo> getInstalledApplications(int flags) {
            try {
                ParceledListSlice slice;
                ArrayList<ApplicationInfo> applicationInfos = new ArrayList<ApplicationInfo>();
                ApplicationInfo lastItem = null;
                do {
                    String lastKey = lastItem != null ? lastItem.packageName : null;
                    slice = this.mPM.getInstalledApplications(flags, lastKey);
                    lastItem = slice.populateList(applicationInfos, ApplicationInfo.CREATOR);
                } while (!slice.isLastSlice());
                return applicationInfos;
            }
            catch (RemoteException e) {
                throw new RuntimeException("Package manager has died", e);
            }
        }

        @Override
        public ResolveInfo resolveActivity(Intent intent, int flags) {
            try {
                return this.mPM.resolveIntent(intent, intent.resolveTypeIfNeeded(this.mContext.getContentResolver()), flags);
            }
            catch (RemoteException e) {
                throw new RuntimeException("Package manager has died", e);
            }
        }

        @Override
        public List<ResolveInfo> queryIntentActivities(Intent intent, int flags) {
            try {
                return this.mPM.queryIntentActivities(intent, intent.resolveTypeIfNeeded(this.mContext.getContentResolver()), flags);
            }
            catch (RemoteException e) {
                throw new RuntimeException("Package manager has died", e);
            }
        }

        @Override
        public List<ResolveInfo> queryIntentActivityOptions(ComponentName caller, Intent[] specifics, Intent intent, int flags) {
            ContentResolver resolver = this.mContext.getContentResolver();
            String[] specificTypes = null;
            if (specifics != null) {
                int N = specifics.length;
                for (int i = 0; i < N; ++i) {
                    String t;
                    Intent sp = specifics[i];
                    if (sp == null || (t = sp.resolveTypeIfNeeded(resolver)) == null) continue;
                    if (specificTypes == null) {
                        specificTypes = new String[N];
                    }
                    specificTypes[i] = t;
                }
            }
            try {
                return this.mPM.queryIntentActivityOptions(caller, specifics, specificTypes, intent, intent.resolveTypeIfNeeded(resolver), flags);
            }
            catch (RemoteException e) {
                throw new RuntimeException("Package manager has died", e);
            }
        }

        @Override
        public List<ResolveInfo> queryBroadcastReceivers(Intent intent, int flags) {
            try {
                return this.mPM.queryIntentReceivers(intent, intent.resolveTypeIfNeeded(this.mContext.getContentResolver()), flags);
            }
            catch (RemoteException e) {
                throw new RuntimeException("Package manager has died", e);
            }
        }

        @Override
        public ResolveInfo resolveService(Intent intent, int flags) {
            try {
                return this.mPM.resolveService(intent, intent.resolveTypeIfNeeded(this.mContext.getContentResolver()), flags);
            }
            catch (RemoteException e) {
                throw new RuntimeException("Package manager has died", e);
            }
        }

        @Override
        public List<ResolveInfo> queryIntentServices(Intent intent, int flags) {
            try {
                return this.mPM.queryIntentServices(intent, intent.resolveTypeIfNeeded(this.mContext.getContentResolver()), flags);
            }
            catch (RemoteException e) {
                throw new RuntimeException("Package manager has died", e);
            }
        }

        @Override
        public ProviderInfo resolveContentProvider(String name, int flags) {
            try {
                return this.mPM.resolveContentProvider(name, flags);
            }
            catch (RemoteException e) {
                throw new RuntimeException("Package manager has died", e);
            }
        }

        @Override
        public List<ProviderInfo> queryContentProviders(String processName, int uid, int flags) {
            try {
                return this.mPM.queryContentProviders(processName, uid, flags);
            }
            catch (RemoteException e) {
                throw new RuntimeException("Package manager has died", e);
            }
        }

        @Override
        public InstrumentationInfo getInstrumentationInfo(ComponentName className, int flags) throws PackageManager.NameNotFoundException {
            try {
                InstrumentationInfo ii = this.mPM.getInstrumentationInfo(className, flags);
                if (ii != null) {
                    return ii;
                }
            }
            catch (RemoteException e) {
                throw new RuntimeException("Package manager has died", e);
            }
            throw new PackageManager.NameNotFoundException(className.toString());
        }

        @Override
        public List<InstrumentationInfo> queryInstrumentation(String targetPackage, int flags) {
            try {
                return this.mPM.queryInstrumentation(targetPackage, flags);
            }
            catch (RemoteException e) {
                throw new RuntimeException("Package manager has died", e);
            }
        }

        @Override
        public Drawable getDrawable(String packageName, int resid, ApplicationInfo appInfo) {
            ResourceName name = new ResourceName(packageName, resid);
            Drawable dr = this.getCachedIcon(name);
            if (dr != null) {
                return dr;
            }
            if (appInfo == null) {
                try {
                    appInfo = this.getApplicationInfo(packageName, 0);
                }
                catch (PackageManager.NameNotFoundException e) {
                    return null;
                }
            }
            try {
                Resources r = this.getResourcesForApplication(appInfo);
                dr = r.getDrawable(resid);
                this.putCachedIcon(name, dr);
                return dr;
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.w("PackageManager", "Failure retrieving resources for" + appInfo.packageName);
            }
            catch (RuntimeException e) {
                Log.w("PackageManager", "Failure retrieving icon 0x" + Integer.toHexString(resid) + " in package " + packageName, e);
            }
            return null;
        }

        @Override
        public Drawable getActivityIcon(ComponentName activityName) throws PackageManager.NameNotFoundException {
            return this.getActivityInfo(activityName, 0).loadIcon(this);
        }

        @Override
        public Drawable getActivityIcon(Intent intent) throws PackageManager.NameNotFoundException {
            if (intent.getComponent() != null) {
                return this.getActivityIcon(intent.getComponent());
            }
            ResolveInfo info = this.resolveActivity(intent, 65536);
            if (info != null) {
                return info.activityInfo.loadIcon(this);
            }
            throw new PackageManager.NameNotFoundException(intent.toURI());
        }

        @Override
        public Drawable getDefaultActivityIcon() {
            return Resources.getSystem().getDrawable(17301651);
        }

        @Override
        public Drawable getApplicationIcon(ApplicationInfo info) {
            return info.loadIcon(this);
        }

        @Override
        public Drawable getApplicationIcon(String packageName) throws PackageManager.NameNotFoundException {
            return this.getApplicationIcon(this.getApplicationInfo(packageName, 0));
        }

        @Override
        public Drawable getActivityLogo(ComponentName activityName) throws PackageManager.NameNotFoundException {
            return this.getActivityInfo(activityName, 0).loadLogo(this);
        }

        @Override
        public Drawable getActivityLogo(Intent intent) throws PackageManager.NameNotFoundException {
            if (intent.getComponent() != null) {
                return this.getActivityLogo(intent.getComponent());
            }
            ResolveInfo info = this.resolveActivity(intent, 65536);
            if (info != null) {
                return info.activityInfo.loadLogo(this);
            }
            throw new PackageManager.NameNotFoundException(intent.toUri(0));
        }

        @Override
        public Drawable getApplicationLogo(ApplicationInfo info) {
            return info.loadLogo(this);
        }

        @Override
        public Drawable getApplicationLogo(String packageName) throws PackageManager.NameNotFoundException {
            return this.getApplicationLogo(this.getApplicationInfo(packageName, 0));
        }

        @Override
        public Resources getResourcesForActivity(ComponentName activityName) throws PackageManager.NameNotFoundException {
            return this.getResourcesForApplication(this.getActivityInfo((ComponentName)activityName, (int)0).applicationInfo);
        }

        @Override
        public Resources getResourcesForApplication(ApplicationInfo app) throws PackageManager.NameNotFoundException {
            if (app.packageName.equals("system")) {
                return this.mContext.mMainThread.getSystemContext().getResources();
            }
            Resources r = this.mContext.mMainThread.getTopLevelResources(app.uid == Process.myUid() ? app.sourceDir : app.publicSourceDir, this.mContext.mPackageInfo);
            if (r != null) {
                return r;
            }
            throw new PackageManager.NameNotFoundException("Unable to open " + app.publicSourceDir);
        }

        @Override
        public Resources getResourcesForApplication(String appPackageName) throws PackageManager.NameNotFoundException {
            return this.getResourcesForApplication(this.getApplicationInfo(appPackageName, 0));
        }

        @Override
        public boolean isSafeMode() {
            try {
                if (this.mCachedSafeMode < 0) {
                    this.mCachedSafeMode = this.mPM.isSafeMode() ? 1 : 0;
                }
                return this.mCachedSafeMode != 0;
            }
            catch (RemoteException e) {
                throw new RuntimeException("Package manager has died", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void configurationChanged() {
            Object object = sSync;
            synchronized (object) {
                sIconCache.clear();
                sStringCache.clear();
            }
        }

        public ApplicationPackageManager(ContextImpl context, IPackageManager pm) {
            this.mContext = context;
            this.mPM = pm;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Drawable getCachedIcon(ResourceName name) {
            Object object = sSync;
            synchronized (object) {
                WeakReference<Drawable> wr = sIconCache.get(name);
                if (wr != null) {
                    Drawable dr = (Drawable)wr.get();
                    if (dr != null) {
                        return dr;
                    }
                    sIconCache.remove(name);
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void putCachedIcon(ResourceName name, Drawable dr) {
            Object object = sSync;
            synchronized (object) {
                sIconCache.put(name, new WeakReference<Drawable>(dr));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void handlePackageBroadcast(int cmd, String[] pkgList, boolean hasPkgInfo) {
            boolean immediateGc = false;
            if (cmd == 1) {
                immediateGc = true;
            }
            if (pkgList != null && pkgList.length > 0) {
                boolean needCleanup = false;
                for (String ssp : pkgList) {
                    Object object = sSync;
                    synchronized (object) {
                        ResourceName nm;
                        Iterator<ResourceName> it;
                        if (sIconCache.size() > 0) {
                            it = sIconCache.keySet().iterator();
                            while (it.hasNext()) {
                                nm = it.next();
                                if (!nm.packageName.equals(ssp)) continue;
                                it.remove();
                                needCleanup = true;
                            }
                        }
                        if (sStringCache.size() > 0) {
                            it = sStringCache.keySet().iterator();
                            while (it.hasNext()) {
                                nm = it.next();
                                if (!nm.packageName.equals(ssp)) continue;
                                it.remove();
                                needCleanup = true;
                            }
                        }
                    }
                }
                if (needCleanup || hasPkgInfo) {
                    if (immediateGc) {
                        Runtime.getRuntime().gc();
                    } else {
                        ActivityThread.currentActivityThread().scheduleGcIdler();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CharSequence getCachedString(ResourceName name) {
            Object object = sSync;
            synchronized (object) {
                WeakReference<CharSequence> wr = sStringCache.get(name);
                if (wr != null) {
                    CharSequence cs2 = (CharSequence)wr.get();
                    if (cs2 != null) {
                        return cs2;
                    }
                    sStringCache.remove(name);
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void putCachedString(ResourceName name, CharSequence cs2) {
            Object object = sSync;
            synchronized (object) {
                sStringCache.put(name, new WeakReference<CharSequence>(cs2));
            }
        }

        @Override
        public CharSequence getText(String packageName, int resid, ApplicationInfo appInfo) {
            ResourceName name = new ResourceName(packageName, resid);
            CharSequence text = this.getCachedString(name);
            if (text != null) {
                return text;
            }
            if (appInfo == null) {
                try {
                    appInfo = this.getApplicationInfo(packageName, 0);
                }
                catch (PackageManager.NameNotFoundException e) {
                    return null;
                }
            }
            try {
                Resources r = this.getResourcesForApplication(appInfo);
                text = r.getText(resid);
                this.putCachedString(name, text);
                return text;
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.w("PackageManager", "Failure retrieving resources for" + appInfo.packageName);
            }
            catch (RuntimeException e) {
                Log.w("PackageManager", "Failure retrieving text 0x" + Integer.toHexString(resid) + " in package " + packageName, e);
            }
            return null;
        }

        @Override
        public XmlResourceParser getXml(String packageName, int resid, ApplicationInfo appInfo) {
            if (appInfo == null) {
                try {
                    appInfo = this.getApplicationInfo(packageName, 0);
                }
                catch (PackageManager.NameNotFoundException e) {
                    return null;
                }
            }
            try {
                Resources r = this.getResourcesForApplication(appInfo);
                return r.getXml(resid);
            }
            catch (RuntimeException e) {
                Log.w("PackageManager", "Failure retrieving xml 0x" + Integer.toHexString(resid) + " in package " + packageName, e);
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.w("PackageManager", "Failure retrieving resources for" + appInfo.packageName);
            }
            return null;
        }

        @Override
        public CharSequence getApplicationLabel(ApplicationInfo info) {
            return info.loadLabel(this);
        }

        @Override
        public void installPackage(Uri packageURI, IPackageInstallObserver observer, int flags, String installerPackageName) {
            try {
                this.mPM.installPackage(packageURI, observer, flags, installerPackageName);
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }

        @Override
        public void movePackage(String packageName, IPackageMoveObserver observer, int flags) {
            try {
                this.mPM.movePackage(packageName, observer, flags);
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }

        @Override
        public String getInstallerPackageName(String packageName) {
            try {
                return this.mPM.getInstallerPackageName(packageName);
            }
            catch (RemoteException remoteException) {
                return null;
            }
        }

        @Override
        public void deletePackage(String packageName, IPackageDeleteObserver observer, int flags) {
            try {
                this.mPM.deletePackage(packageName, observer, flags);
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }

        @Override
        public void clearApplicationUserData(String packageName, IPackageDataObserver observer) {
            try {
                this.mPM.clearApplicationUserData(packageName, observer);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        @Override
        public void deleteApplicationCacheFiles(String packageName, IPackageDataObserver observer) {
            try {
                this.mPM.deleteApplicationCacheFiles(packageName, observer);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        @Override
        public void freeStorageAndNotify(long idealStorageSize, IPackageDataObserver observer) {
            try {
                this.mPM.freeStorageAndNotify(idealStorageSize, observer);
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }

        @Override
        public void freeStorage(long freeStorageSize, IntentSender pi) {
            try {
                this.mPM.freeStorage(freeStorageSize, pi);
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }

        @Override
        public void getPackageSizeInfo(String packageName, IPackageStatsObserver observer) {
            try {
                this.mPM.getPackageSizeInfo(packageName, observer);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        @Override
        public void addPackageToPreferred(String packageName) {
            try {
                this.mPM.addPackageToPreferred(packageName);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        @Override
        public void removePackageFromPreferred(String packageName) {
            try {
                this.mPM.removePackageFromPreferred(packageName);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        @Override
        public List<PackageInfo> getPreferredPackages(int flags) {
            try {
                return this.mPM.getPreferredPackages(flags);
            }
            catch (RemoteException remoteException) {
                return new ArrayList<PackageInfo>();
            }
        }

        @Override
        public void addPreferredActivity(IntentFilter filter, int match, ComponentName[] set, ComponentName activity) {
            try {
                this.mPM.addPreferredActivity(filter, match, set, activity);
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }

        @Override
        public void replacePreferredActivity(IntentFilter filter, int match, ComponentName[] set, ComponentName activity) {
            try {
                this.mPM.replacePreferredActivity(filter, match, set, activity);
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }

        @Override
        public void clearPackagePreferredActivities(String packageName) {
            try {
                this.mPM.clearPackagePreferredActivities(packageName);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        @Override
        public int getPreferredActivities(List<IntentFilter> outFilters, List<ComponentName> outActivities, String packageName) {
            try {
                return this.mPM.getPreferredActivities(outFilters, outActivities, packageName);
            }
            catch (RemoteException e) {
                return 0;
            }
        }

        @Override
        public void setComponentEnabledSetting(ComponentName componentName, int newState, int flags) {
            try {
                this.mPM.setComponentEnabledSetting(componentName, newState, flags);
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }

        @Override
        public int getComponentEnabledSetting(ComponentName componentName) {
            try {
                return this.mPM.getComponentEnabledSetting(componentName);
            }
            catch (RemoteException remoteException) {
                return 0;
            }
        }

        @Override
        public void setApplicationEnabledSetting(String packageName, int newState, int flags) {
            try {
                this.mPM.setApplicationEnabledSetting(packageName, newState, flags);
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }

        @Override
        public int getApplicationEnabledSetting(String packageName) {
            try {
                return this.mPM.getApplicationEnabledSetting(packageName);
            }
            catch (RemoteException remoteException) {
                return 0;
            }
        }

        public static class ResourceName {
            public final String packageName;
            public final int iconId;

            public ResourceName(String _packageName, int _iconId) {
                this.packageName = _packageName;
                this.iconId = _iconId;
            }

            public ResourceName(ApplicationInfo aInfo, int _iconId) {
                this(aInfo.packageName, _iconId);
            }

            public ResourceName(ComponentInfo cInfo, int _iconId) {
                this(cInfo.applicationInfo.packageName, _iconId);
            }

            public ResourceName(ResolveInfo rInfo, int _iconId) {
                this(rInfo.activityInfo.applicationInfo.packageName, _iconId);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                ResourceName that = (ResourceName)o;
                if (this.iconId != that.iconId) {
                    return false;
                }
                return !(this.packageName == null ? that.packageName != null : !this.packageName.equals(that.packageName));
            }

            public int hashCode() {
                int result = this.packageName.hashCode();
                result = 31 * result + this.iconId;
                return result;
            }

            public String toString() {
                return "{ResourceName " + this.packageName + " / " + this.iconId + "}";
            }
        }
    }

    public static class ApplicationContentResolver
    extends ContentResolver {
        public final ActivityThread mMainThread;

        public ApplicationContentResolver(Context context, ActivityThread mainThread) {
            super(context);
            this.mMainThread = mainThread;
        }

        public IContentProvider acquireProvider(Context context, String name) {
            return this.mMainThread.acquireProvider(context, name);
        }

        public IContentProvider acquireExistingProvider(Context context, String name) {
            return this.mMainThread.acquireExistingProvider(context, name);
        }

        public boolean releaseProvider(IContentProvider provider) {
            return this.mMainThread.releaseProvider(provider);
        }
    }
}

