/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class ScrollBar
extends Widget {
    int handle;
    int visibleRgn;
    int oldActionProc;
    Scrollable parent;
    boolean dragging;
    int increment = 1;
    int pageIncrement = 10;

    ScrollBar() {
    }

    ScrollBar(Scrollable scrollable, int n) {
        super(scrollable, ScrollBar.checkStyle(n));
        this.parent = scrollable;
        this.createWidget();
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n) {
        return ScrollBar.checkBits(n, 256, 512, 0, 0, 0, 0);
    }

    int actionProc(int n, int n2) {
        int n3 = super.actionProc(n, n2);
        if (n3 == 0) {
            return n3;
        }
        Event event = new Event();
        int n4 = 0;
        switch (n2) {
            case 20: {
                n4 -= this.increment;
                event.detail = 0x1000001;
                break;
            }
            case 22: {
                n4 -= this.pageIncrement;
                event.detail = 0x1000005;
                break;
            }
            case 23: {
                n4 += this.pageIncrement;
                event.detail = 0x1000006;
                break;
            }
            case 21: {
                n4 += this.increment;
                event.detail = 0x1000002;
                break;
            }
            case 129: {
                this.dragging = true;
                event.detail = 1;
                break;
            }
            default: {
                return n3;
            }
        }
        if (this.oldActionProc != 0) {
            OS.Call(this.oldActionProc, n, n2);
            this.parent.redrawBackgroundImage();
        } else {
            int n5 = OS.GetControl32BitValue(this.handle) + n4;
            OS.SetControl32BitValue(this.handle, n5);
        }
        this.sendEvent(13, event);
        return n3;
    }

    void destroyHandle() {
        int n = this.handle;
        this.releaseHandle();
        if (n != 0) {
            OS.DisposeControl(n);
        }
    }

    void destroyWidget() {
        this.parent.destroyScrollBar(this);
        this.releaseHandle();
    }

    void enableWidget(boolean bl) {
        if (bl) {
            OS.EnableControl(this.handle);
        } else {
            OS.DisableControl(this.handle);
        }
    }

    void createHandle() {
        int n = this.display.actionProc;
        int[] nArray = new int[1];
        int n2 = OS.GetControlOwner(this.parent.scrolledHandle);
        OS.CreateScrollBarControl(n2, null, 0, 0, 90, 10, true, n, nArray);
        if (nArray[0] == 0) {
            this.error(2);
        }
        this.handle = nArray[0];
    }

    void createWidget() {
        super.createWidget();
        this.setZOrder();
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(this.handle);
    }

    boolean getDrawing() {
        return this.parent.getDrawing();
    }

    public boolean getEnabled() {
        this.checkWidget();
        return (this.state & 8) == 0;
    }

    public int getIncrement() {
        this.checkWidget();
        return this.increment;
    }

    public int getMaximum() {
        this.checkWidget();
        int n = OS.GetControl32BitMaximum(this.handle) & Integer.MAX_VALUE;
        int n2 = OS.GetControlViewSize(this.handle);
        return n + n2;
    }

    public int getMinimum() {
        this.checkWidget();
        return OS.GetControl32BitMinimum(this.handle) & Integer.MAX_VALUE;
    }

    public int getPageIncrement() {
        this.checkWidget();
        return this.pageIncrement;
    }

    public Scrollable getParent() {
        this.checkWidget();
        return this.parent;
    }

    public int getSelection() {
        this.checkWidget();
        return OS.GetControl32BitValue(this.handle) & Integer.MAX_VALUE;
    }

    public Point getSize() {
        this.checkWidget();
        return this.getControlSize(this.handle);
    }

    public int getThumb() {
        this.checkWidget();
        return OS.GetControlViewSize(this.handle);
    }

    public boolean getVisible() {
        this.checkWidget();
        return (this.state & 0x10) == 0;
    }

    int getVisibleRegion(int n, boolean bl) {
        if (this.visibleRgn == 0) {
            this.visibleRgn = OS.NewRgn();
            this.calculateVisibleRegion(n, this.visibleRgn, bl);
        }
        int n2 = OS.NewRgn();
        OS.CopyRgn(this.visibleRgn, n2);
        return n2;
    }

    void hookEvents() {
        super.hookEvents();
        int n = this.display.controlProc;
        int[] nArray = new int[]{1668183148, 51};
        int n2 = OS.GetControlEventTarget(this.handle);
        OS.InstallEventHandler(n2, n, nArray.length / 2, nArray, this.handle, null);
        if ((this.parent.state & 2) == 0) {
            this.oldActionProc = OS.GetControlAction(this.handle);
            OS.SetControlAction(this.handle, this.display.actionProc);
        }
    }

    void invalidateVisibleRegion(int n) {
        this.resetVisibleRegion(n);
        this.parent.resetVisibleRegion(n);
    }

    void invalWindowRgn(int n, int n2) {
        this.parent.invalWindowRgn(n, n2);
    }

    boolean isDrawing() {
        return this.getDrawing() && this.parent.isDrawing();
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    boolean isTrimHandle(int n) {
        return this.handle == n;
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible() && this.parent.isVisible();
    }

    int kEventMouseDown(int n, int n2, int n3) {
        int n4 = super.kEventMouseDown(n, n2, n3);
        if (n4 == 0) {
            return n4;
        }
        this.dragging = false;
        n4 = OS.CallNextEventHandler(n, n2);
        if (this.dragging) {
            Event event = new Event();
            this.sendEvent(13, event);
        }
        this.dragging = false;
        return n4;
    }

    int kEventMouseWheelMoved(int n, int n2, int n3) {
        return this.parent.kEventMouseWheelMoved(n, n2, n3);
    }

    void redraw() {
        this.redrawWidget(this.handle, false);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void register() {
        super.register();
        this.display.addWidget(this.handle, this);
    }

    void releaseHandle() {
        super.releaseHandle();
        this.handle = 0;
    }

    void releaseParent() {
        super.releaseParent();
        if (this.parent.horizontalBar == this) {
            this.parent.horizontalBar = null;
        }
        if (this.parent.verticalBar == this) {
            this.parent.verticalBar = null;
        }
        this.parent.resizeClientArea();
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.visibleRgn != 0) {
            OS.DisposeRgn(this.visibleRgn);
        }
        this.visibleRgn = 0;
    }

    void resetVisibleRegion(int n) {
        if (this.visibleRgn != 0) {
            OS.DisposeRgn(this.visibleRgn);
            this.visibleRgn = 0;
        }
    }

    public void setIncrement(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        this.increment = n;
    }

    public void setEnabled(boolean bl) {
        this.checkWidget();
        if (bl) {
            if ((this.state & 8) == 0) {
                return;
            }
            this.state &= 0xFFFFFFF7;
            OS.EnableControl(this.handle);
        } else {
            if ((this.state & 8) != 0) {
                return;
            }
            this.state |= 8;
            OS.DisableControl(this.handle);
        }
    }

    public void setMaximum(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        int n2 = OS.GetControl32BitMinimum(this.handle);
        if (n <= n2) {
            return;
        }
        int n3 = OS.GetControlViewSize(this.handle);
        if (n - n2 < n3) {
            n3 = n - n2;
            OS.SetControlViewSize(this.handle, n3);
        }
        OS.SetControl32BitMaximum(this.handle, n - n3);
    }

    public void setMinimum(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        int n2 = OS.GetControlViewSize(this.handle);
        int n3 = OS.GetControl32BitMaximum(this.handle) + n2;
        if (n >= n3) {
            return;
        }
        if (n3 - n < n2) {
            n2 = n3 - n;
            OS.SetControl32BitMaximum(this.handle, n3 - n2);
            OS.SetControlViewSize(this.handle, n2);
        }
        OS.SetControl32BitMinimum(this.handle, n);
    }

    public void setPageIncrement(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        this.pageIncrement = n;
    }

    public void setSelection(int n) {
        this.checkWidget();
        OS.SetControl32BitValue(this.handle, n);
    }

    public void setThumb(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        int n2 = OS.GetControl32BitMinimum(this.handle);
        int n3 = OS.GetControlViewSize(this.handle);
        int n4 = OS.GetControl32BitMaximum(this.handle) + n3;
        n = Math.min(n, n4 - n2);
        OS.SetControl32BitMaximum(this.handle, n4 - n);
        OS.SetControlViewSize(this.handle, n);
    }

    public void setValues(int n, int n2, int n3, int n4, int n5, int n6) {
        this.checkWidget();
        if (n2 < 0) {
            return;
        }
        if (n3 < 0) {
            return;
        }
        if (n4 < 1) {
            return;
        }
        if (n5 < 1) {
            return;
        }
        if (n6 < 1) {
            return;
        }
        n4 = Math.min(n4, n3 - n2);
        OS.SetControl32BitMinimum(this.handle, n2);
        OS.SetControl32BitMaximum(this.handle, n3 - n4);
        OS.SetControlViewSize(this.handle, n4);
        OS.SetControl32BitValue(this.handle, n);
        this.increment = n5;
        this.pageIncrement = n6;
    }

    public void setVisible(boolean bl) {
        this.checkWidget();
        if (bl) {
            if ((this.state & 0x10) == 0) {
                return;
            }
            this.state &= 0xFFFFFFEF;
        } else {
            if ((this.state & 0x10) != 0) {
                return;
            }
            this.state |= 0x10;
        }
        if (this.parent.setScrollBarVisible(this, bl)) {
            this.sendEvent(bl ? 22 : 23);
            this.parent.sendEvent(11);
        }
    }

    void setZOrder() {
        OS.HIViewAddSubview(this.parent.scrolledHandle, this.handle);
    }
}

