/*
 * Decompiled with CFR 0.152.
 */
package signature.model.impl;

import java.io.Serializable;
import signature.model.IMethod;
import signature.model.ITypeReference;
import signature.model.Modifier;
import signature.model.impl.SigExecutableMember;
import signature.model.impl.Uninitialized;
import signature.model.util.ModelUtil;

public class SigMethod
extends SigExecutableMember
implements IMethod,
Serializable {
    private ITypeReference returnType = (ITypeReference)Uninitialized.unset();

    public SigMethod(String name) {
        super(name);
    }

    public ITypeReference getReturnType() {
        return this.returnType;
    }

    public void setReturnType(ITypeReference returnType) {
        this.returnType = returnType;
    }

    public String toString() {
        return SigMethod.toString(this);
    }

    public static String toString(IMethod method) {
        StringBuilder builder = new StringBuilder();
        builder.append(Modifier.toString(method.getModifiers()));
        builder.append(method.getReturnType());
        builder.append(" ");
        if (method.getTypeParameters() != null && !method.getTypeParameters().isEmpty()) {
            builder.append("<");
            builder.append(ModelUtil.separate(method.getTypeParameters(), ", "));
            builder.append("> ");
        }
        builder.append(method.getName());
        builder.append("(");
        builder.append(method.getParameters().isEmpty() ? "" : ModelUtil.separate(method.getParameters(), ", "));
        builder.append(")");
        if (method.getExceptions() != null && !method.getExceptions().isEmpty()) {
            builder.append(" throws ");
            builder.append(ModelUtil.separate(method.getExceptions(), " "));
        }
        return builder.toString();
    }
}

