/*
 * Decompiled with CFR 0.152.
 */
package signature.model.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import signature.model.IAnnotationField;
import signature.model.IClassDefinition;
import signature.model.IConstructor;
import signature.model.IEnumConstant;
import signature.model.IField;
import signature.model.IMethod;
import signature.model.ITypeReference;
import signature.model.ITypeVariableDefinition;
import signature.model.Kind;
import signature.model.Modifier;
import signature.model.impl.SigAnnotatableElement;
import signature.model.impl.Uninitialized;
import signature.model.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SigClassDefinition
extends SigAnnotatableElement
implements IClassDefinition,
Serializable {
    private String name;
    private Kind kind = Kind.UNINITIALIZED;
    private ITypeReference superClass = (ITypeReference)Uninitialized.unset();
    private Set<ITypeReference> interfaces = (Set)Uninitialized.unset();
    private Set<Modifier> modifiers = (Set)Uninitialized.unset();
    private Set<IMethod> methods = (Set)Uninitialized.unset();
    private Set<IConstructor> constructors = (Set)Uninitialized.unset();
    private Set<IClassDefinition> innerClasses = (Set)Uninitialized.unset();
    private Set<IAnnotationField> annotationFields = (Set)Uninitialized.unset();
    private Set<IField> fields = (Set)Uninitialized.unset();
    private Set<IEnumConstant> enumConstants = (Set)Uninitialized.unset();
    private IClassDefinition declaringClass = (IClassDefinition)Uninitialized.unset();
    private List<ITypeVariableDefinition> typeParameters = (List)Uninitialized.unset();
    private String packageName;

    public SigClassDefinition(String packageName, String name) {
        this.packageName = packageName;
        this.name = name;
    }

    @Override
    public Kind getKind() {
        return this.kind;
    }

    public void setKind(Kind kind) {
        this.kind = kind;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public List<String> getPackageFragments() {
        return Arrays.asList(this.packageName.split("\\."));
    }

    @Override
    public String getQualifiedName() {
        return this.packageName + "." + this.name;
    }

    @Override
    public Set<Modifier> getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(Set<Modifier> modifiers) {
        this.modifiers = modifiers;
    }

    @Override
    public Set<IClassDefinition> getInnerClasses() {
        return this.innerClasses;
    }

    public void setInnerClasses(Set<IClassDefinition> innerClasses) {
        this.innerClasses = innerClasses;
    }

    @Override
    public Set<ITypeReference> getInterfaces() {
        return this.interfaces;
    }

    public void setInterfaces(Set<ITypeReference> interfaces) {
        this.interfaces = interfaces;
    }

    @Override
    public Set<IMethod> getMethods() {
        return this.methods;
    }

    public void setMethods(Set<IMethod> methods) {
        this.methods = methods;
    }

    @Override
    public Set<IConstructor> getConstructors() {
        return this.constructors;
    }

    public void setConstructors(Set<IConstructor> constructors) {
        this.constructors = constructors;
    }

    @Override
    public ITypeReference getSuperClass() {
        return this.superClass;
    }

    public void setSuperClass(ITypeReference superClass) {
        this.superClass = superClass;
    }

    @Override
    public IClassDefinition getDeclaringClass() {
        return this.declaringClass;
    }

    public void setDeclaringClass(IClassDefinition declaringClass) {
        this.declaringClass = declaringClass;
    }

    @Override
    public Set<IAnnotationField> getAnnotationFields() {
        return this.annotationFields;
    }

    public void setAnnotationFields(Set<IAnnotationField> annotationFields) {
        this.annotationFields = annotationFields;
    }

    @Override
    public Set<IField> getFields() {
        return this.fields;
    }

    public void setFields(Set<IField> fields) {
        this.fields = fields;
    }

    @Override
    public Set<IEnumConstant> getEnumConstants() {
        return this.enumConstants;
    }

    public void setEnumConstants(Set<IEnumConstant> enumConstants) {
        this.enumConstants = enumConstants;
    }

    @Override
    public List<ITypeVariableDefinition> getTypeParameters() {
        return this.typeParameters;
    }

    public void setTypeParameters(List<ITypeVariableDefinition> typeParameters) {
        this.typeParameters = typeParameters;
    }

    public int hashCode() {
        return SigClassDefinition.hashCode(this);
    }

    public static int hashCode(IClassDefinition definition) {
        int prime = 31;
        int result = 1;
        result = 31 + (definition.getName() == null ? 0 : definition.getName().hashCode());
        result = 31 * result + (definition.getPackageName() == null ? 0 : definition.getPackageName().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        return SigClassDefinition.equals(this, obj);
    }

    public static boolean equals(IClassDefinition thiz, Object obj) {
        if (thiz == obj) {
            return true;
        }
        if (obj instanceof IClassDefinition) {
            IClassDefinition that = (IClassDefinition)obj;
            return thiz.getName().equals(that.getName()) && thiz.getPackageName().equals(that.getPackageName());
        }
        return false;
    }

    @Override
    public String toString() {
        return SigClassDefinition.toString(this);
    }

    public static String toString(IClassDefinition type) {
        StringBuilder builder = new StringBuilder();
        if (type.getAnnotations() != null && !type.getAnnotations().isEmpty()) {
            builder.append("\n");
        }
        builder.append(type.getQualifiedName());
        if (type.getTypeParameters() != null && !type.getTypeParameters().isEmpty()) {
            builder.append("<");
            ModelUtil.separate(type.getTypeParameters(), ", ");
            builder.append(">");
        }
        return builder.toString();
    }
}

