/*
 * Decompiled with CFR 0.152.
 */
package signature.io.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Set;
import signature.converter.Visibility;
import signature.io.IApiExternalizer;
import signature.io.IApiLoader;
import signature.model.IApi;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryApi
implements IApiExternalizer,
IApiLoader {
    @Override
    public void externalizeApi(String fileName, IApi api) throws IOException {
        File directory = new File(fileName);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        File file = new File(directory, this.getFileName(api));
        file.createNewFile();
        ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(file));
        oos.writeObject(api);
        oos.flush();
        oos.close();
    }

    private String getFileName(IApi api) {
        return api.getName().replaceAll(" ", "_").concat(".sig");
    }

    @Override
    public IApi loadApi(String name, Visibility visibility, Set<String> fileNames, Set<String> packageNames) throws IOException {
        System.err.println("Binary signature loader ignores visibility and package names.");
        if (fileNames.size() != 1) {
            throw new IllegalArgumentException("Only one file can be processed by the binary signature loader.");
        }
        String fileName = fileNames.iterator().next();
        File file = new File(fileName);
        ObjectInputStream ois = new ObjectInputStream(new FileInputStream(file));
        IApi sig = null;
        try {
            sig = (IApi)ois.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
        if (name != null) {
            sig.setName(name);
        }
        ois.close();
        return sig;
    }
}

