/*
 * Decompiled with CFR 0.152.
 */
package signature.io.html;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.antlr.stringtemplate.StringTemplate;
import signature.compare.model.IAnnotationFieldDelta;
import signature.compare.model.IClassDefinitionDelta;
import signature.compare.model.IConstructorDelta;
import signature.compare.model.IEnumConstantDelta;
import signature.compare.model.IFieldDelta;
import signature.compare.model.IMethodDelta;
import signature.compare.model.impl.SigDelta;
import signature.io.html.ExecutableMemberComparator;
import signature.io.html.FieldByNameComparator;
import signature.io.html.IEmitter;
import signature.io.html.TemplateStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassOverviewPage
implements IEmitter {
    private static final String PAGE = "ClassOverviewPage";
    private final IClassDefinitionDelta classDelta;
    private FieldByNameComparator<IFieldDelta> fieldComparator = new FieldByNameComparator();
    private ArrayList<IFieldDelta> removedFields;
    private ArrayList<IFieldDelta> addedFields;
    private ArrayList<IFieldDelta> changedFields;
    private FieldByNameComparator<IAnnotationFieldDelta> annotationfieldComparator = new FieldByNameComparator();
    private ArrayList<IAnnotationFieldDelta> removedAnnotationFields;
    private ArrayList<IAnnotationFieldDelta> addedAnnotationFields;
    private ArrayList<IAnnotationFieldDelta> changedAnnotationFields;
    private FieldByNameComparator<IEnumConstantDelta> enumConstantComparator = new FieldByNameComparator();
    private ArrayList<IEnumConstantDelta> removedEnumConstants;
    private ArrayList<IEnumConstantDelta> addedEnumConstants;
    private ArrayList<IEnumConstantDelta> changedEnumConstants;
    private ExecutableMemberComparator constructorComparator = new ExecutableMemberComparator();
    private ArrayList<IConstructorDelta> removedConstructors;
    private ArrayList<IConstructorDelta> addedConstructors;
    private ArrayList<IConstructorDelta> changedConstructors;
    private ExecutableMemberComparator methodComparator = new ExecutableMemberComparator();
    private ArrayList<IMethodDelta> removedMethods;
    private ArrayList<IMethodDelta> addedMethods;
    private ArrayList<IMethodDelta> changedMethods;
    private final Map<String, String> commonInfos;

    public ClassOverviewPage(IClassDefinitionDelta classDelta, Map<String, String> commonInfos) {
        this.classDelta = classDelta;
        this.commonInfos = commonInfos;
        this.prepareData();
    }

    private void prepareData() {
        if (this.classDelta.getFieldDeltas() != null) {
            this.prepareFieldDeltas();
        }
        if (this.classDelta.getAnnotationFieldDeltas() != null) {
            this.prepareAnnotationFieldDeltas();
        }
        if (this.classDelta.getEnumConstantDeltas() != null) {
            this.prepareEnumConstantDeltas();
        }
        if (this.classDelta.getConstructorDeltas() != null) {
            this.prepareConstructorDeltas();
        }
        if (this.classDelta.getMethodDeltas() != null) {
            this.prepareMethodDeltas();
        }
    }

    private void prepareFieldDeltas() {
        this.removedFields = new ArrayList<IFieldDelta>(SigDelta.getRemoved(this.classDelta.getFieldDeltas()));
        Collections.sort(this.removedFields, this.fieldComparator);
        this.addedFields = new ArrayList<IFieldDelta>(SigDelta.getAdded(this.classDelta.getFieldDeltas()));
        Collections.sort(this.addedFields, this.fieldComparator);
        this.changedFields = new ArrayList<IFieldDelta>(SigDelta.getChanged(this.classDelta.getFieldDeltas()));
        Collections.sort(this.changedFields, this.fieldComparator);
    }

    private void prepareAnnotationFieldDeltas() {
        this.removedAnnotationFields = new ArrayList<IAnnotationFieldDelta>(SigDelta.getRemoved(this.classDelta.getAnnotationFieldDeltas()));
        Collections.sort(this.removedAnnotationFields, this.annotationfieldComparator);
        this.addedAnnotationFields = new ArrayList<IAnnotationFieldDelta>(SigDelta.getAdded(this.classDelta.getAnnotationFieldDeltas()));
        Collections.sort(this.addedAnnotationFields, this.annotationfieldComparator);
        this.changedAnnotationFields = new ArrayList<IAnnotationFieldDelta>(SigDelta.getChanged(this.classDelta.getAnnotationFieldDeltas()));
        Collections.sort(this.changedAnnotationFields, this.annotationfieldComparator);
    }

    private void prepareEnumConstantDeltas() {
        this.removedEnumConstants = new ArrayList<IEnumConstantDelta>(SigDelta.getRemoved(this.classDelta.getEnumConstantDeltas()));
        Collections.sort(this.removedEnumConstants, this.enumConstantComparator);
        this.addedEnumConstants = new ArrayList<IEnumConstantDelta>(SigDelta.getAdded(this.classDelta.getEnumConstantDeltas()));
        Collections.sort(this.addedEnumConstants, this.enumConstantComparator);
        this.changedEnumConstants = new ArrayList<IEnumConstantDelta>(SigDelta.getChanged(this.classDelta.getEnumConstantDeltas()));
        Collections.sort(this.changedEnumConstants, this.enumConstantComparator);
    }

    private void prepareConstructorDeltas() {
        this.removedConstructors = new ArrayList<IConstructorDelta>(SigDelta.getRemoved(this.classDelta.getConstructorDeltas()));
        Collections.sort(this.removedConstructors, this.constructorComparator);
        this.addedConstructors = new ArrayList<IConstructorDelta>(SigDelta.getAdded(this.classDelta.getConstructorDeltas()));
        Collections.sort(this.addedConstructors, this.constructorComparator);
        this.changedConstructors = new ArrayList<IConstructorDelta>(SigDelta.getChanged(this.classDelta.getConstructorDeltas()));
        Collections.sort(this.changedConstructors, this.constructorComparator);
    }

    private void prepareMethodDeltas() {
        this.removedMethods = new ArrayList<IMethodDelta>(SigDelta.getRemoved(this.classDelta.getMethodDeltas()));
        Collections.sort(this.removedMethods, this.methodComparator);
        this.addedMethods = new ArrayList<IMethodDelta>(SigDelta.getAdded(this.classDelta.getMethodDeltas()));
        Collections.sort(this.addedMethods, this.methodComparator);
        this.changedMethods = new ArrayList<IMethodDelta>(SigDelta.getChanged(this.classDelta.getMethodDeltas()));
        Collections.sort(this.changedMethods, this.methodComparator);
    }

    @Override
    public void writeTo(StringBuilder b) {
        StringTemplate template = TemplateStore.getStringTemplate(PAGE);
        template.setAttribute("class_delta", this.classDelta);
        boolean annotationDelta = this.classDelta.getAnnotationDeltas() != null;
        boolean modifierDelta = this.classDelta.getModifierDeltas() != null;
        boolean typeVariableDelta = this.classDelta.getTypeVariableDeltas() != null;
        boolean superClassDelta = this.classDelta.getSuperClassDelta() != null;
        boolean interfaceDelta = this.classDelta.getInterfaceDeltas() != null;
        boolean hasSignatureDelta = annotationDelta || modifierDelta || typeVariableDelta || superClassDelta || interfaceDelta;
        template.setAttribute("has_class_signature_delta", hasSignatureDelta);
        template.setAttribute("removed_fields", this.removedFields);
        template.setAttribute("added_fields", this.addedFields);
        template.setAttribute("changed_fields", this.changedFields);
        template.setAttribute("removed_annotation_fields", this.removedAnnotationFields);
        template.setAttribute("added_annotation_fields", this.addedAnnotationFields);
        template.setAttribute("changed_annotation_fields", this.changedAnnotationFields);
        template.setAttribute("removed_enum_constants", this.removedEnumConstants);
        template.setAttribute("added_enum_constants", this.addedEnumConstants);
        template.setAttribute("changed_enum_constants", this.changedEnumConstants);
        template.setAttribute("removed_constructors", this.removedConstructors);
        template.setAttribute("added_constructors", this.addedConstructors);
        template.setAttribute("changed_constructors", this.changedConstructors);
        template.setAttribute("removed_methods", this.removedMethods);
        template.setAttribute("added_methods", this.addedMethods);
        template.setAttribute("changed_methods", this.changedMethods);
        template.setArgumentContext(this.commonInfos);
        b.append(template.toString());
    }
}

