/*
 * Decompiled with CFR 0.152.
 */
package signature.converter.doclet;

import com.sun.javadoc.RootDoc;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javadoc.JavadocTool;
import com.sun.tools.javadoc.Messager;
import com.sun.tools.javadoc.ModifierFilter;
import com.sun.tools.javadoc.RootDocImpl;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.util.Set;
import signature.converter.Visibility;
import signature.converter.doclet.DocletToSigConverter;
import signature.io.IApiLoader;
import signature.model.IApi;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocletFactory
implements IApiLoader {
    @Override
    public IApi loadApi(String name, Visibility visibility, Set<String> fileNames, Set<String> packageNames) throws IOException {
        for (String packageName : packageNames) {
            if (packageName.length() != 0) continue;
            throw new IllegalArgumentException("default package not supported by DocletFactory");
        }
        StringBuffer buf = new StringBuffer();
        for (String filename : fileNames) {
            buf.append(filename);
            buf.append(":");
        }
        String sourcepath = buf.substring(0, buf.length() - 1);
        RootDoc root = DocletFactory.getRootDoc(visibility, sourcepath, packageNames);
        DocletToSigConverter converter = new DocletToSigConverter();
        IApi api = converter.convertDocletRoot(name, root, visibility, packageNames);
        return api;
    }

    private static RootDoc getRootDoc(Visibility visibility, String sourcepath, Set<String> packages) throws IOException {
        long accessModifier = 0L;
        switch (visibility) {
            case PRIVATE: {
                accessModifier |= 2L;
            }
            case PACKAGE: {
                accessModifier |= Long.MIN_VALUE;
            }
            case PROTECTED: {
                accessModifier |= 4L;
            }
            case PUBLIC: {
                accessModifier |= 1L;
            }
        }
        ModifierFilter showAccess = new ModifierFilter(accessModifier);
        boolean breakiterator = false;
        boolean quiet = false;
        boolean legacy = false;
        boolean docClasses = false;
        String docLocale = "";
        String encoding = null;
        ListBuffer<String> javaNames = new ListBuffer<String>();
        for (String p : packages) {
            javaNames.append(p);
        }
        ListBuffer<String[]> options = new ListBuffer<String[]>();
        options.append(new String[]{"-sourcepath", sourcepath});
        ListBuffer subPackages = new ListBuffer();
        ListBuffer excludedPackages = new ListBuffer();
        Context context = new Context();
        Options compOpts = Options.instance(context);
        compOpts.put("-sourcepath", sourcepath);
        try {
            Constructor c = Messager.class.getDeclaredConstructor(Context.class, String.class, PrintWriter.class, PrintWriter.class, PrintWriter.class);
            c.setAccessible(true);
            PrintWriter err = new PrintWriter(new StringWriter());
            PrintWriter warn = new PrintWriter(new StringWriter());
            PrintWriter notice = new PrintWriter(new StringWriter());
            c.newInstance(context, "SigTest", err, warn, notice);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        JavadocTool comp = JavadocTool.make0((Context)context);
        RootDocImpl root = comp.getRootDocImpl(docLocale, encoding, showAccess, javaNames.toList(), options.toList(), breakiterator, subPackages.toList(), excludedPackages.toList(), docClasses, legacy, quiet);
        return root;
    }
}

