/*
 * Decompiled with CFR 0.152.
 */
package signature.converter.dex;

import java.lang.reflect.GenericSignatureFormatError;
import java.util.ArrayList;
import java.util.List;
import signature.converter.dex.DexUtil;
import signature.converter.dex.IClassInitializer;
import signature.model.IClassDefinition;
import signature.model.IClassReference;
import signature.model.IConstructor;
import signature.model.IGenericDeclaration;
import signature.model.IMethod;
import signature.model.ITypeReference;
import signature.model.ITypeVariableDefinition;
import signature.model.ITypeVariableReference;
import signature.model.impl.SigArrayType;
import signature.model.impl.SigParameterizedType;
import signature.model.impl.SigPrimitiveType;
import signature.model.impl.SigTypeVariableDefinition;
import signature.model.impl.SigWildcardType;
import signature.model.impl.Uninitialized;
import signature.model.util.ITypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericSignatureParser {
    public List<ITypeReference> exceptionTypes;
    public List<ITypeReference> parameterTypes;
    public List<ITypeVariableDefinition> formalTypeParameters;
    public ITypeReference returnType;
    public ITypeReference fieldType;
    public List<ITypeReference> interfaceTypes;
    public ITypeReference superclassType;
    private IGenericDeclaration genericDecl;
    private char symbol;
    private String identifier;
    private boolean eof;
    private char[] buffer;
    private int pos;
    private final ITypeFactory factory;
    private final IClassInitializer classFinder;
    private boolean parseForField;

    public GenericSignatureParser(ITypeFactory factory, IClassInitializer classFinder) {
        this.factory = factory;
        this.classFinder = classFinder;
    }

    private void setInput(IGenericDeclaration genericDecl, String input) {
        if (input != null) {
            this.genericDecl = genericDecl;
            this.buffer = input.toCharArray();
            this.eof = false;
            this.scanSymbol();
        } else {
            this.eof = true;
        }
    }

    public ITypeReference parseNonGenericType(String typeSignature) {
        this.setInput(null, typeSignature);
        ITypeReference type = this.parsePrimitiveType();
        if (type == null) {
            type = this.parseFieldTypeSignature();
        }
        return type;
    }

    public ITypeReference parseNonGenericReturnType(String typeSignature) {
        this.setInput(null, typeSignature);
        ITypeReference returnType = this.parsePrimitiveType();
        if (returnType == null) {
            returnType = this.parseReturnType();
        }
        return returnType;
    }

    private ITypeReference parsePrimitiveType() {
        switch (this.symbol) {
            case 'B': {
                this.scanSymbol();
                return SigPrimitiveType.BYTE_TYPE;
            }
            case 'C': {
                this.scanSymbol();
                return SigPrimitiveType.CHAR_TYPE;
            }
            case 'D': {
                this.scanSymbol();
                return SigPrimitiveType.DOUBLE_TYPE;
            }
            case 'F': {
                this.scanSymbol();
                return SigPrimitiveType.FLOAT_TYPE;
            }
            case 'I': {
                this.scanSymbol();
                return SigPrimitiveType.INT_TYPE;
            }
            case 'J': {
                this.scanSymbol();
                return SigPrimitiveType.LONG_TYPE;
            }
            case 'S': {
                this.scanSymbol();
                return SigPrimitiveType.SHORT_TYPE;
            }
            case 'Z': {
                this.scanSymbol();
                return SigPrimitiveType.BOOLEAN_TYPE;
            }
        }
        return null;
    }

    public void parseForClass(IClassDefinition classToProcess, String signature) {
        this.setInput(classToProcess, signature);
        if (this.eof) {
            throw new IllegalStateException("Generic signature is invalid!");
        }
        this.parseClassSignature();
    }

    public void parseForMethod(IMethod genericDecl, String signature) {
        this.setInput(genericDecl, signature);
        if (this.eof) {
            throw new IllegalStateException("Generic signature is invalid!");
        }
        this.parseMethodTypeSignature();
    }

    public void parseForConstructor(IConstructor genericDecl, String signature) {
        this.setInput(genericDecl, signature);
        if (this.eof) {
            throw new IllegalStateException("Generic signature is invalid!");
        }
        this.parseMethodTypeSignature();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseForField(IClassDefinition genericDecl, String signature) {
        block4: {
            this.parseForField = true;
            this.setInput(genericDecl, signature);
            try {
                if (!this.eof) {
                    this.fieldType = this.parseFieldTypeSignature();
                    break block4;
                }
                throw new IllegalStateException("Generic signature is invalid!");
            }
            finally {
                this.parseForField = false;
            }
        }
    }

    private void parseClassSignature() {
        this.parseOptFormalTypeParameters();
        this.superclassType = this.parseClassTypeSignature();
        this.interfaceTypes = new ArrayList<ITypeReference>(16);
        while (this.symbol > '\u0000') {
            this.interfaceTypes.add(this.parseClassTypeSignature());
        }
    }

    private void parseOptFormalTypeParameters() {
        ArrayList<ITypeVariableDefinition> typeParameters = new ArrayList<ITypeVariableDefinition>();
        if (this.symbol == '<') {
            this.scanSymbol();
            typeParameters.add(this.parseFormalTypeParameter());
            while (this.symbol != '>' && this.symbol > '\u0000') {
                typeParameters.add(this.parseFormalTypeParameter());
            }
            this.expect('>');
        }
        this.formalTypeParameters = typeParameters;
    }

    private SigTypeVariableDefinition parseFormalTypeParameter() {
        this.scanIdentifier();
        String name = this.identifier.intern();
        SigTypeVariableDefinition typeVariable = this.factory.getTypeVariable(name, this.genericDecl);
        ArrayList<ITypeReference> bounds = new ArrayList<ITypeReference>();
        this.expect(':');
        if (this.symbol == 'L' || this.symbol == '[' || this.symbol == 'T') {
            bounds.add(this.parseFieldTypeSignature());
        }
        while (this.symbol == ':') {
            this.scanSymbol();
            bounds.add(this.parseFieldTypeSignature());
        }
        typeVariable.setUpperBounds(bounds);
        return typeVariable;
    }

    private IGenericDeclaration getDeclarationOfTypeVariable(String variableName, IClassDefinition declaration) {
        assert (variableName != null);
        assert (declaration != null);
        if (!Uninitialized.isInitialized(declaration.getTypeParameters())) {
            declaration = this.classFinder.initializeClass(declaration.getPackageName(), declaration.getName());
        }
        for (ITypeVariableDefinition typeVariable : declaration.getTypeParameters()) {
            if (!variableName.equals(typeVariable.getName())) continue;
            return declaration;
        }
        return this.getDeclarationOfTypeVariable(variableName, declaration.getDeclaringClass());
    }

    private ITypeReference parseFieldTypeSignature() {
        switch (this.symbol) {
            case 'L': {
                return this.parseClassTypeSignature();
            }
            case '[': {
                this.scanSymbol();
                SigArrayType arrayType = this.factory.getArrayType(this.parseTypeSignature());
                return arrayType;
            }
            case 'T': {
                return this.parseTypeVariableSignature();
            }
        }
        throw new GenericSignatureFormatError();
    }

    private ITypeReference parseClassTypeSignature() {
        this.expect('L');
        StringBuilder qualIdent = new StringBuilder("L");
        this.scanIdentifier();
        while (this.symbol == '/') {
            this.scanSymbol();
            qualIdent.append(this.identifier).append("/");
            this.scanIdentifier();
        }
        qualIdent.append(this.identifier);
        List<ITypeReference> typeArgs = this.parseOptTypeArguments();
        ITypeReference parentType = null;
        String packageName = DexUtil.getPackageName(qualIdent.toString() + ";");
        String className = DexUtil.getClassName(qualIdent.toString() + ";");
        if (typeArgs.isEmpty()) {
            parentType = this.factory.getClassReference(packageName, className);
        } else {
            IClassReference rawType = this.factory.getClassReference(packageName, className);
            SigParameterizedType parameterizedType = this.factory.getParameterizedType(null, rawType, typeArgs);
            parentType = parameterizedType;
        }
        IClassReference typeToReturn = parentType;
        while (this.symbol == '.') {
            this.scanSymbol();
            this.scanIdentifier();
            qualIdent.append("$").append(this.identifier);
            typeArgs = this.parseOptTypeArguments();
            ITypeReference memberType = null;
            packageName = DexUtil.getPackageName(qualIdent.toString() + ";");
            className = DexUtil.getClassName(qualIdent.toString() + ";");
            if (typeArgs.isEmpty()) {
                memberType = this.factory.getClassReference(packageName, className);
            } else {
                IClassReference rawType = this.factory.getClassReference(packageName, className);
                SigParameterizedType parameterizedType = this.factory.getParameterizedType(parentType, rawType, typeArgs);
                memberType = parameterizedType;
            }
            typeToReturn = memberType;
        }
        this.expect(';');
        return typeToReturn;
    }

    private List<ITypeReference> parseOptTypeArguments() {
        ArrayList<ITypeReference> typeArgs = new ArrayList<ITypeReference>(8);
        if (this.symbol == '<') {
            this.scanSymbol();
            typeArgs.add(this.parseTypeArgument());
            while (this.symbol != '>' && this.symbol > '\u0000') {
                typeArgs.add(this.parseTypeArgument());
            }
            this.expect('>');
        }
        return typeArgs;
    }

    private ITypeReference parseTypeArgument() {
        ArrayList<ITypeReference> extendsBound = new ArrayList<ITypeReference>(1);
        ITypeReference superBound = null;
        if (this.symbol == '*') {
            this.scanSymbol();
            extendsBound.add(this.factory.getClassReference("java.lang", "Object"));
            SigWildcardType wildcardType = this.factory.getWildcardType(superBound, extendsBound);
            return wildcardType;
        }
        if (this.symbol == '+') {
            this.scanSymbol();
            extendsBound.add(this.parseFieldTypeSignature());
            SigWildcardType wildcardType = this.factory.getWildcardType(superBound, extendsBound);
            return wildcardType;
        }
        if (this.symbol == '-') {
            this.scanSymbol();
            superBound = this.parseFieldTypeSignature();
            extendsBound.add(this.factory.getClassReference("java.lang", "Object"));
            SigWildcardType wildcardType = this.factory.getWildcardType(superBound, extendsBound);
            return wildcardType;
        }
        return this.parseFieldTypeSignature();
    }

    private ITypeVariableReference parseTypeVariableSignature() {
        this.expect('T');
        this.scanIdentifier();
        this.expect(';');
        IGenericDeclaration declaration = this.genericDecl;
        if (!this.factory.containsTypeVariableDefinition(this.identifier, declaration)) {
            declaration = this.parseForField ? this.getDeclarationOfTypeVariable(this.identifier, (IClassDefinition)this.genericDecl) : this.getDeclarationOfTypeVariable(this.identifier, this.genericDecl.getDeclaringClass());
            this.factory.getTypeVariable(this.identifier, declaration);
        }
        return this.factory.getTypeVariableReference(this.identifier, declaration);
    }

    private ITypeReference parseTypeSignature() {
        switch (this.symbol) {
            case 'B': {
                this.scanSymbol();
                return SigPrimitiveType.BYTE_TYPE;
            }
            case 'C': {
                this.scanSymbol();
                return SigPrimitiveType.CHAR_TYPE;
            }
            case 'D': {
                this.scanSymbol();
                return SigPrimitiveType.DOUBLE_TYPE;
            }
            case 'F': {
                this.scanSymbol();
                return SigPrimitiveType.FLOAT_TYPE;
            }
            case 'I': {
                this.scanSymbol();
                return SigPrimitiveType.INT_TYPE;
            }
            case 'J': {
                this.scanSymbol();
                return SigPrimitiveType.LONG_TYPE;
            }
            case 'S': {
                this.scanSymbol();
                return SigPrimitiveType.SHORT_TYPE;
            }
            case 'Z': {
                this.scanSymbol();
                return SigPrimitiveType.BOOLEAN_TYPE;
            }
        }
        return this.parseFieldTypeSignature();
    }

    private void parseMethodTypeSignature() {
        this.parseOptFormalTypeParameters();
        this.parameterTypes = new ArrayList<ITypeReference>(16);
        this.expect('(');
        while (this.symbol != ')' && this.symbol > '\u0000') {
            this.parameterTypes.add(this.parseTypeSignature());
        }
        this.expect(')');
        this.returnType = this.parseReturnType();
        this.exceptionTypes = new ArrayList<ITypeReference>(8);
        while (this.symbol == '^') {
            this.scanSymbol();
            if (this.symbol == 'T') {
                this.exceptionTypes.add(this.parseTypeVariableSignature());
                continue;
            }
            this.exceptionTypes.add(this.parseClassTypeSignature());
        }
    }

    private ITypeReference parseReturnType() {
        if (this.symbol != 'V') {
            return this.parseTypeSignature();
        }
        this.scanSymbol();
        return SigPrimitiveType.VOID_TYPE;
    }

    private void scanSymbol() {
        if (!this.eof) {
            if (this.pos < this.buffer.length) {
                this.symbol = this.buffer[this.pos];
                ++this.pos;
            } else {
                this.symbol = '\u0000';
                this.eof = true;
            }
        } else {
            throw new GenericSignatureFormatError();
        }
    }

    private void expect(char c) {
        if (this.symbol != c) {
            throw new GenericSignatureFormatError();
        }
        this.scanSymbol();
    }

    private boolean isStopSymbol(char ch) {
        switch (ch) {
            case '.': 
            case '/': 
            case ':': 
            case ';': 
            case '<': {
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void scanIdentifier() {
        if (this.eof) throw new GenericSignatureFormatError();
        StringBuilder identBuf = new StringBuilder(32);
        if (!this.isStopSymbol(this.symbol)) {
            identBuf.append(this.symbol);
            do {
                char ch;
                if ((ch = this.buffer[this.pos]) >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || !this.isStopSymbol(ch)) {
                    identBuf.append(this.buffer[this.pos]);
                    ++this.pos;
                    continue;
                }
                this.identifier = identBuf.toString();
                this.scanSymbol();
                return;
            } while (this.pos != this.buffer.length);
        } else {
            this.symbol = '\u0000';
            this.eof = true;
            throw new GenericSignatureFormatError();
        }
        this.identifier = identBuf.toString();
        this.symbol = '\u0000';
        this.eof = true;
    }
}

