/*
 * Decompiled with CFR 0.152.
 */
package signature.converter.dex;

import java.util.HashMap;
import java.util.Map;
import signature.model.impl.SigEnumConstant;
import signature.model.impl.SigField;

public class FieldPool {
    private Map<FieldKey, SigField> fieldStore = new HashMap<FieldKey, SigField>();
    private Map<FieldKey, SigEnumConstant> constantStore = new HashMap<FieldKey, SigEnumConstant>();

    public SigField getField(String qualifiedClassName, String fieldName) {
        FieldKey key = new FieldKey(qualifiedClassName, fieldName);
        SigField sigField = this.fieldStore.get(key);
        if (sigField == null) {
            sigField = new SigField(fieldName);
            this.fieldStore.put(key, sigField);
        }
        return sigField;
    }

    public SigEnumConstant getEnumConstant(String qualifiedName, String fieldName) {
        FieldKey key = new FieldKey(qualifiedName, fieldName);
        SigEnumConstant sigField = this.constantStore.get(key);
        if (sigField == null) {
            sigField = new SigEnumConstant(fieldName);
            this.constantStore.put(key, sigField);
        }
        return sigField;
    }

    private static class FieldKey {
        private final String qualifiedClassName;
        private final String fieldName;

        public FieldKey(String qualifiedClassName, String fieldName) {
            this.qualifiedClassName = qualifiedClassName;
            this.fieldName = fieldName;
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 * this.fieldName.hashCode();
            result = 31 * result + this.qualifiedClassName.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            FieldKey other = (FieldKey)obj;
            if (!this.fieldName.equals(other.fieldName)) {
                return false;
            }
            return this.qualifiedClassName.equals(other.qualifiedClassName);
        }
    }
}

