/*
 * Decompiled with CFR 0.152.
 */
package signature.compare.model.subst;

import java.util.List;
import java.util.Map;
import signature.compare.model.subst.ViewpointAdapter;
import signature.model.IClassReference;
import signature.model.IParameterizedType;
import signature.model.ITypeReference;
import signature.model.ITypeVariableDefinition;
import signature.model.impl.SigParameterizedType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterizedTypeProjection
implements IParameterizedType {
    private final IParameterizedType original;
    private final Map<ITypeVariableDefinition, ITypeReference> mappings;
    private IClassReference rawType = null;
    private List<ITypeReference> arguments = null;

    public ParameterizedTypeProjection(IParameterizedType original, Map<ITypeVariableDefinition, ITypeReference> mappings) {
        this.original = original;
        this.mappings = mappings;
    }

    @Override
    public ITypeReference getOwnerType() {
        ITypeReference ownerType = this.original.getOwnerType();
        if (ownerType == null) {
            return null;
        }
        return ViewpointAdapter.substitutedTypeReference(ownerType, this.mappings);
    }

    @Override
    public IClassReference getRawType() {
        if (this.rawType == null) {
            this.rawType = (IClassReference)ViewpointAdapter.substitutedTypeReference(this.original.getRawType(), ViewpointAdapter.createTypeMapping(this, this.original.getRawType().getClassDefinition()));
        }
        return this.rawType;
    }

    @Override
    public List<ITypeReference> getTypeArguments() {
        if (this.arguments == null) {
            this.arguments = ViewpointAdapter.substitutedTypeReferences(this.original.getTypeArguments(), this.mappings);
        }
        return this.arguments;
    }

    public int hashCode() {
        return SigParameterizedType.hashCode(this);
    }

    public boolean equals(Object obj) {
        return SigParameterizedType.equals(this, obj);
    }

    public String toString() {
        return SigParameterizedType.toString(this);
    }
}

