/*
 * Decompiled with CFR 0.152.
 */
package signature.compare.model.subst;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import signature.compare.model.subst.MethodProjection;
import signature.compare.model.subst.ViewpointAdapter;
import signature.model.IAnnotation;
import signature.model.IAnnotationField;
import signature.model.IClassDefinition;
import signature.model.IConstructor;
import signature.model.IEnumConstant;
import signature.model.IField;
import signature.model.IMethod;
import signature.model.ITypeReference;
import signature.model.ITypeVariableDefinition;
import signature.model.Kind;
import signature.model.Modifier;
import signature.model.impl.SigClassDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassProjection
implements IClassDefinition {
    private final IClassDefinition original;
    private final Map<ITypeVariableDefinition, ITypeReference> substitutions;
    Set<ITypeReference> interfaces = null;
    Set<IMethod> methods = null;
    private boolean superClassInit = false;
    private ITypeReference superClass = null;

    public ClassProjection(IClassDefinition original, Map<ITypeVariableDefinition, ITypeReference> mapping) {
        this.original = original;
        this.substitutions = mapping;
    }

    @Override
    public Set<IAnnotationField> getAnnotationFields() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<IAnnotation> getAnnotations() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<IConstructor> getConstructors() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IClassDefinition getDeclaringClass() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<IEnumConstant> getEnumConstants() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<IField> getFields() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<IClassDefinition> getInnerClasses() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<ITypeReference> getInterfaces() {
        if (this.interfaces == null) {
            Set<ITypeReference> originalInterfaces = this.original.getInterfaces();
            if (originalInterfaces == null) {
                this.interfaces = Collections.emptySet();
            } else {
                this.interfaces = new HashSet<ITypeReference>();
                for (ITypeReference interfaze : originalInterfaces) {
                    this.interfaces.add(ViewpointAdapter.substitutedTypeReference(interfaze, this.substitutions));
                }
                this.interfaces = Collections.unmodifiableSet(this.interfaces);
            }
        }
        return this.interfaces;
    }

    @Override
    public Kind getKind() {
        return this.original.getKind();
    }

    @Override
    public Set<IMethod> getMethods() {
        if (this.methods == null) {
            Set<IMethod> originalMethods = this.original.getMethods();
            if (originalMethods == null) {
                this.methods = Collections.emptySet();
            } else {
                this.methods = new HashSet<IMethod>();
                for (IMethod m : this.original.getMethods()) {
                    this.methods.add(new MethodProjection(m, this.substitutions));
                }
                this.methods = Collections.unmodifiableSet(this.methods);
            }
        }
        return this.methods;
    }

    @Override
    public Set<Modifier> getModifiers() {
        return this.original.getModifiers();
    }

    @Override
    public String getName() {
        return this.original.getName();
    }

    @Override
    public List<String> getPackageFragments() {
        return this.original.getPackageFragments();
    }

    @Override
    public String getPackageName() {
        return this.original.getPackageName();
    }

    @Override
    public String getQualifiedName() {
        return this.original.getQualifiedName();
    }

    @Override
    public ITypeReference getSuperClass() {
        if (!this.superClassInit) {
            ITypeReference originalSuperClass = this.original.getSuperClass();
            if (originalSuperClass != null) {
                this.superClass = ViewpointAdapter.substitutedTypeReference(this.original.getSuperClass(), this.substitutions);
            }
            this.superClassInit = true;
        }
        return this.superClass;
    }

    @Override
    public List<ITypeVariableDefinition> getTypeParameters() {
        return this.original.getTypeParameters();
    }

    public int hashCode() {
        return SigClassDefinition.hashCode(this);
    }

    public boolean equals(Object obj) {
        return SigClassDefinition.equals(this, obj);
    }

    public String toString() {
        return "(" + SigClassDefinition.toString(this) + " : " + this.substitutions + " )";
    }
}

