/*
 * Decompiled with CFR 0.152.
 */
package signature.compare.model.impl;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import signature.compare.model.DeltaType;
import signature.compare.model.IDelta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SigDelta<T>
implements IDelta<T> {
    private T from;
    private T to;
    private static Set<String> ignore = new HashSet<String>();

    public SigDelta(T from, T to) {
        ignore.add("from");
        ignore.add("to");
        ignore.add("reason");
        ignore.add("ignore");
        this.from = from;
        this.to = to;
    }

    @Override
    public final T getFrom() {
        return this.from;
    }

    @Override
    public final T getTo() {
        return this.to;
    }

    @Override
    public final DeltaType getType() {
        if (this.from == null && this.to != null) {
            return DeltaType.ADDED;
        }
        if (this.from != null && this.to == null) {
            return DeltaType.REMOVED;
        }
        return DeltaType.CHANGED;
    }

    private static <T extends IDelta<?>> Set<T> getDeltas(Set<T> deltas, DeltaType type) {
        HashSet<IDelta> addedElements = new HashSet<IDelta>();
        for (IDelta delta : deltas) {
            if (!type.equals((Object)delta.getType())) continue;
            addedElements.add(delta);
        }
        return addedElements;
    }

    public static <T extends IDelta<?>> Set<T> getAdded(Set<T> deltas) {
        return SigDelta.getDeltas(deltas, DeltaType.ADDED);
    }

    public static <T extends IDelta<?>> Set<T> getRemoved(Set<T> deltas) {
        return SigDelta.getDeltas(deltas, DeltaType.REMOVED);
    }

    public static <T extends IDelta<?>> Set<T> getChanged(Set<T> deltas) {
        return SigDelta.getDeltas(deltas, DeltaType.CHANGED);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append(":\n");
        LinkedList<Field> allFields = new LinkedList<Field>();
        Class<?> actualClass = this.getClass();
        do {
            allFields.addAll(Arrays.asList(actualClass.getDeclaredFields()));
        } while ((actualClass = actualClass.getSuperclass()) != Object.class);
        builder.append("from: ");
        builder.append(this.from);
        builder.append("\nto:    ");
        builder.append(this.to);
        builder.append("\n");
        try {
            for (Field field : allFields) {
                if (ignore.contains(field.getName())) continue;
                field.setAccessible(true);
                Object delta = field.get(this);
                if (delta == null) continue;
                builder.append(field.getName());
                builder.append(":\n");
                builder.append(delta);
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        return builder.toString();
    }
}

