/*
 * Decompiled with CFR 0.152.
 */
package signature.compare;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import signature.UsageException;
import signature.compare.ApiComparator;
import signature.compare.model.IApiDelta;
import signature.compare.model.IPackageDelta;
import signature.compare.model.impl.SigDelta;
import signature.converter.Visibility;
import signature.converter.dex.DexFactory;
import signature.converter.doclet.DocletFactory;
import signature.io.IApiLoader;
import signature.io.html.HtmlDeltaExternalizer;
import signature.io.impl.BinaryApi;
import signature.model.IApi;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main {
    public static void main(String[] args) throws IOException {
        int at = 0;
        if (!"--from".equals(args[at])) {
            throw new UsageException();
        }
        String fromType = args[++at];
        boolean hasName = false;
        HashSet<String> fromFiles = new HashSet<String>();
        ++at;
        while (at < args.length) {
            if ("--name".equals(args[at])) {
                hasName = true;
                break;
            }
            if ("--to".equals(args[at])) break;
            fromFiles.add(args[at]);
            ++at;
        }
        String nameFrom = null;
        if (hasName) {
            nameFrom = "";
            if (!"--name".equals(args[at])) {
                throw new UsageException();
            }
            ++at;
            while (at < args.length && !"--to".equals(args[at])) {
                nameFrom = nameFrom + args[at];
                nameFrom = nameFrom + " ";
                ++at;
            }
            nameFrom = nameFrom.trim();
        }
        if (!"--to".equals(args[at])) {
            throw new UsageException();
        }
        String toType = args[++at];
        hasName = false;
        HashSet<String> toFiles = new HashSet<String>();
        ++at;
        while (at < args.length) {
            if ("--name".equals(args[at])) {
                hasName = true;
                break;
            }
            if ("--out".equals(args[at])) break;
            toFiles.add(args[at]);
            ++at;
        }
        String nameTo = null;
        if (hasName) {
            nameTo = "";
            if (!"--name".equals(args[at])) {
                throw new UsageException();
            }
            ++at;
            while (at < args.length && !"--out".equals(args[at])) {
                nameTo = nameTo + args[at];
                nameTo = nameTo + " ";
                ++at;
            }
            nameTo = nameTo.trim();
        }
        if (!"--out".equals(args[at])) {
            throw new UsageException();
        }
        String output = args[++at];
        if (!"--packages".equals(args[++at])) {
            throw new UsageException();
        }
        HashSet<String> packages = new HashSet<String>();
        ++at;
        while (at < args.length) {
            packages.add(args[at]);
            ++at;
        }
        ApiComparator comparator = new ApiComparator();
        IApi fromApi = Main.getApi(fromType, nameFrom, fromFiles, packages);
        IApi toApi = Main.getApi(toType, nameTo, toFiles, packages);
        HtmlDeltaExternalizer externalizer = new HtmlDeltaExternalizer();
        System.out.println("Writing delta report to " + output);
        IApiDelta delta = comparator.compare(fromApi, toApi);
        if (delta == null) {
            delta = new EmptyDelta(fromApi, toApi);
        }
        externalizer.externalize(output, delta);
    }

    private static IApi getApi(String specType, String name, Set<String> fileNames, Set<String> packageNames) throws IOException {
        System.out.println("Loading " + name + " of type " + specType + " from " + fileNames);
        IApiLoader factory = null;
        if ("doclet".equals(specType)) {
            Main.checkName(name);
            factory = new DocletFactory();
        } else if ("dex".equals(specType)) {
            Main.checkName(name);
            factory = new DexFactory();
        } else if ("sig".equals(specType)) {
            factory = new BinaryApi();
        } else {
            throw new UsageException();
        }
        return factory.loadApi(name, Visibility.PROTECTED, fileNames, packageNames);
    }

    private static void checkName(String name) {
        if (name == null) {
            throw new UsageException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EmptyDelta
    extends SigDelta<IApi>
    implements IApiDelta {
        public EmptyDelta(IApi from, IApi to) {
            super(from, to);
        }

        @Override
        public Set<IPackageDelta> getPackageDeltas() {
            return Collections.emptySet();
        }
    }
}

