/*
 * Decompiled with CFR 0.152.
 */
package signature.compare;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import signature.compare.IApiComparator;
import signature.compare.model.IAnnotationDelta;
import signature.compare.model.IAnnotationElementDelta;
import signature.compare.model.IAnnotationFieldDelta;
import signature.compare.model.IApiDelta;
import signature.compare.model.IClassDefinitionDelta;
import signature.compare.model.IConstructorDelta;
import signature.compare.model.IDelta;
import signature.compare.model.IEnumConstantDelta;
import signature.compare.model.IFieldDelta;
import signature.compare.model.IGenericDeclarationDelta;
import signature.compare.model.IMethodDelta;
import signature.compare.model.IModifierDelta;
import signature.compare.model.IPackageDelta;
import signature.compare.model.IParameterDelta;
import signature.compare.model.IParameterizedTypeDelta;
import signature.compare.model.IPrimitiveTypeDelta;
import signature.compare.model.ITypeReferenceDelta;
import signature.compare.model.ITypeVariableDefinitionDelta;
import signature.compare.model.IUpperBoundsDelta;
import signature.compare.model.IWildcardTypeDelta;
import signature.compare.model.impl.SigAnnotationDelta;
import signature.compare.model.impl.SigAnnotationElementDelta;
import signature.compare.model.impl.SigAnnotationFieldDelta;
import signature.compare.model.impl.SigApiDelta;
import signature.compare.model.impl.SigArrayTypeDelta;
import signature.compare.model.impl.SigClassDefinitionDelta;
import signature.compare.model.impl.SigClassReferenceDelta;
import signature.compare.model.impl.SigConstructorDelta;
import signature.compare.model.impl.SigEnumConstantDelta;
import signature.compare.model.impl.SigFieldDelta;
import signature.compare.model.impl.SigGenericDeclarationDelta;
import signature.compare.model.impl.SigMethodDelta;
import signature.compare.model.impl.SigModifierDelta;
import signature.compare.model.impl.SigPackageDelta;
import signature.compare.model.impl.SigParameterDelta;
import signature.compare.model.impl.SigParameterizedTypeDelta;
import signature.compare.model.impl.SigPrimitiveTypeDelta;
import signature.compare.model.impl.SigTypeDelta;
import signature.compare.model.impl.SigTypeVariableDefinitionDelta;
import signature.compare.model.impl.SigTypeVariableReferenceDelta;
import signature.compare.model.impl.SigUpperBoundsDelta;
import signature.compare.model.impl.SigValueDelta;
import signature.compare.model.impl.SigWildcardTypeDelta;
import signature.compare.model.subst.ClassProjection;
import signature.compare.model.subst.ViewpointAdapter;
import signature.model.IAnnotation;
import signature.model.IAnnotationElement;
import signature.model.IAnnotationField;
import signature.model.IApi;
import signature.model.IArrayType;
import signature.model.IClassDefinition;
import signature.model.IClassReference;
import signature.model.IConstructor;
import signature.model.IEnumConstant;
import signature.model.IExecutableMember;
import signature.model.IField;
import signature.model.IGenericDeclaration;
import signature.model.IMethod;
import signature.model.IPackage;
import signature.model.IParameter;
import signature.model.IParameterizedType;
import signature.model.IPrimitiveType;
import signature.model.ITypeReference;
import signature.model.ITypeVariableDefinition;
import signature.model.ITypeVariableReference;
import signature.model.IWildcardType;
import signature.model.Kind;
import signature.model.Modifier;
import signature.model.impl.SigAnnotationElement;
import signature.model.impl.SigArrayType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApiComparator
implements IApiComparator {
    private Set<ITypeReference> fromComparison = new HashSet<ITypeReference>();
    private Set<ITypeReference> toComparison = new HashSet<ITypeReference>();

    @Override
    public IApiDelta compare(IApi from, IApi to) {
        assert (from.getVisibility() == to.getVisibility());
        Set<IPackage> fromPackages = from.getPackages();
        Set<IPackage> toPackages = to.getPackages();
        Set<IPackageDelta> packageDeltas = this.compareSets(fromPackages, toPackages, new SigComparator<IPackage, IPackageDelta>(){

            @Override
            public IPackageDelta createChangedDelta(IPackage from, IPackage to) {
                return ApiComparator.this.comparePackage(from, to);
            }

            @Override
            public IPackageDelta createAddRemoveDelta(IPackage from, IPackage to) {
                return new SigPackageDelta(from, to);
            }

            @Override
            public boolean considerEqualElement(IPackage from, IPackage to) {
                return from.getName().equals(to.getName());
            }
        });
        SigApiDelta delta = null;
        if (packageDeltas != null) {
            delta = new SigApiDelta(from, to);
            delta.setPackageDeltas(packageDeltas);
        }
        return delta;
    }

    private IPackageDelta comparePackage(IPackage from, IPackage to) {
        Set<IAnnotationDelta> annotationDeltas;
        assert (from.getName().equals(to.getName()));
        Set<IClassDefinition> fromClasses = from.getClasses();
        Set<IClassDefinition> toClasses = to.getClasses();
        Set<IClassDefinitionDelta> classDeltas = this.compareSets(fromClasses, toClasses, new SigComparator<IClassDefinition, IClassDefinitionDelta>(){

            @Override
            public boolean considerEqualElement(IClassDefinition from, IClassDefinition to) {
                return ApiComparator.this.sameClassDefinition(from, to);
            }

            @Override
            public IClassDefinitionDelta createChangedDelta(IClassDefinition from, IClassDefinition to) {
                return ApiComparator.this.compareClass(from, to);
            }

            @Override
            public IClassDefinitionDelta createAddRemoveDelta(IClassDefinition from, IClassDefinition to) {
                return new SigClassDefinitionDelta(from, to);
            }
        });
        SigPackageDelta delta = null;
        if (classDeltas != null) {
            delta = new SigPackageDelta(from, to);
            delta.setClassDeltas(classDeltas);
        }
        if ((annotationDeltas = this.compareAnnotations(from.getAnnotations(), to.getAnnotations())) != null) {
            if (delta != null) {
                delta = new SigPackageDelta(from, to);
            }
            delta.setAnnotationDeltas(annotationDeltas);
        }
        return delta;
    }

    private IClassDefinitionDelta compareClass(IClassDefinition from, IClassDefinition to) {
        Set<IAnnotationFieldDelta> annotationFieldDeltas;
        Set<IFieldDelta> fieldDeltas;
        Set<IMethodDelta> methodDeltas;
        Set<IConstructorDelta> constructorDeltas;
        Set<ITypeVariableDefinitionDelta> typeVariableDeltas;
        Set<ITypeReferenceDelta<?>> interfaceDeltas;
        ITypeReferenceDelta<? extends ITypeReference> superTypeDelta;
        assert (from.getKind() == to.getKind());
        assert (from.getName().equals(to.getName()));
        assert (from.getPackageName().equals(to.getPackageName()));
        SigClassDefinitionDelta classDelta = null;
        Set<IModifierDelta> modifierDeltas = this.compareModifiers(from.getModifiers(), to.getModifiers());
        if (modifierDeltas != null) {
            if (classDelta == null) {
                classDelta = new SigClassDefinitionDelta(from, to);
            }
            classDelta.setModifierDeltas(modifierDeltas);
        }
        if ((superTypeDelta = this.compareType(from.getSuperClass(), to.getSuperClass(), false)) != null) {
            if (classDelta == null) {
                classDelta = new SigClassDefinitionDelta(from, to);
            }
            classDelta.setSuperClassDelta(superTypeDelta);
        }
        if ((interfaceDeltas = this.compareInterfaces(from, to)) != null) {
            if (classDelta == null) {
                classDelta = new SigClassDefinitionDelta(from, to);
            }
            classDelta.setInterfaceDeltas(interfaceDeltas);
        }
        if ((typeVariableDeltas = this.compareTypeVariableSequence(from.getTypeParameters(), to.getTypeParameters())) != null) {
            if (classDelta == null) {
                classDelta = new SigClassDefinitionDelta(from, to);
            }
            classDelta.setTypeVariableDeltas(typeVariableDeltas);
        }
        if ((constructorDeltas = this.compareConstructors(from.getConstructors(), to.getConstructors())) != null) {
            if (classDelta == null) {
                classDelta = new SigClassDefinitionDelta(from, to);
            }
            classDelta.setConstructorDeltas(constructorDeltas);
        }
        if ((methodDeltas = this.compareMethods(from, to)) != null) {
            if (classDelta == null) {
                classDelta = new SigClassDefinitionDelta(from, to);
            }
            classDelta.setMethodDeltas(methodDeltas);
        }
        if ((fieldDeltas = this.compareFields(from.getFields(), to.getFields())) != null) {
            if (classDelta == null) {
                classDelta = new SigClassDefinitionDelta(from, to);
            }
            classDelta.setFieldDeltas(fieldDeltas);
        }
        if (from.getKind() == Kind.ENUM) {
            Set<IEnumConstantDelta> enumDeltas = this.compareEnumConstants(from.getEnumConstants(), to.getEnumConstants());
            if (enumDeltas != null) {
                if (classDelta == null) {
                    classDelta = new SigClassDefinitionDelta(from, to);
                }
                classDelta.setEnumConstantDeltas(enumDeltas);
            }
        } else if (from.getKind() == Kind.ANNOTATION && (annotationFieldDeltas = this.compareAnnotationFields(from.getAnnotationFields(), to.getAnnotationFields())) != null) {
            if (classDelta == null) {
                classDelta = new SigClassDefinitionDelta(from, to);
            }
            classDelta.setAnnotationFieldDeltas(annotationFieldDeltas);
        }
        Set<IAnnotationDelta> annotationDeltas = this.compareAnnotations(from.getAnnotations(), to.getAnnotations());
        if (annotationDeltas != null) {
            if (classDelta == null) {
                classDelta = new SigClassDefinitionDelta(from, to);
            }
            classDelta.setAnnotationDeltas(annotationDeltas);
        }
        return classDelta;
    }

    private Set<ITypeReferenceDelta<?>> compareInterfaces(IClassDefinition from, IClassDefinition to) {
        Set<ITypeReference> fromClosure = this.getInterfaceClosure(from);
        Set<ITypeReference> toClosure = this.getInterfaceClosure(to);
        Set<ITypeReference> fromInterfaces = from.getInterfaces();
        Set<ITypeReference> toInterfaces = to.getInterfaces();
        HashSet deltas = new HashSet();
        for (ITypeReference type : fromInterfaces) {
            if (this.containsType(type, toInterfaces) || this.containsType(type, toClosure)) continue;
            deltas.add(new SigTypeDelta<Object>(type, null));
        }
        for (ITypeReference type : toInterfaces) {
            if (this.containsType(type, fromInterfaces) || this.containsType(type, fromClosure)) continue;
            deltas.add(new SigTypeDelta<ITypeReference>(null, type));
        }
        return deltas.isEmpty() ? null : deltas;
    }

    private boolean containsType(ITypeReference type, Set<ITypeReference> setOfTypes) {
        for (ITypeReference other : setOfTypes) {
            if (this.compareType(type, other, false) != null) continue;
            return true;
        }
        return false;
    }

    private Set<ITypeReference> getInterfaceClosure(IClassDefinition clazz) {
        HashSet<ITypeReference> closure = new HashSet<ITypeReference>();
        this.collectInterfaceClosure(ViewpointAdapter.getReferenceTo(clazz), closure);
        return closure;
    }

    private void collectInterfaceClosure(ITypeReference clazz, Set<ITypeReference> closure) {
        IClassDefinition classDefinition = this.getClassDefinition(clazz);
        Set<ITypeReference> interfaces = classDefinition.getInterfaces();
        if (interfaces == null) {
            return;
        }
        for (ITypeReference interfaze : interfaces) {
            closure.add(interfaze);
        }
        ITypeReference superclass = classDefinition.getSuperClass();
        if (superclass != null) {
            if (superclass instanceof IParameterizedType) {
                this.collectInterfaceClosure(((IParameterizedType)superclass).getRawType(), closure);
            } else {
                this.collectInterfaceClosure(superclass, closure);
            }
        }
        for (ITypeReference interfaze : interfaces) {
            if (interfaze instanceof IParameterizedType) {
                this.collectInterfaceClosure(((IParameterizedType)interfaze).getRawType(), closure);
                continue;
            }
            this.collectInterfaceClosure(interfaze, closure);
        }
    }

    private Set<IAnnotationDelta> compareAnnotations(Set<IAnnotation> from, Set<IAnnotation> to) {
        return this.compareSets(from, to, new SigComparator<IAnnotation, IAnnotationDelta>(){

            @Override
            public IAnnotationDelta createAddRemoveDelta(IAnnotation from, IAnnotation to) {
                return new SigAnnotationDelta(from, to);
            }

            @Override
            public boolean considerEqualElement(IAnnotation from, IAnnotation to) {
                return ApiComparator.this.sameClassDefinition(from.getType().getClassDefinition(), to.getType().getClassDefinition());
            }

            @Override
            public IAnnotationDelta createChangedDelta(IAnnotation from, IAnnotation to) {
                return ApiComparator.this.compareAnnotation(from, to);
            }
        });
    }

    private Set<IAnnotationFieldDelta> compareAnnotationFields(Set<IAnnotationField> from, Set<IAnnotationField> to) {
        return this.compareSets(from, to, new SigComparator<IAnnotationField, IAnnotationFieldDelta>(){

            @Override
            public boolean considerEqualElement(IAnnotationField from, IAnnotationField to) {
                return from.getName().equals(to.getName());
            }

            @Override
            public IAnnotationFieldDelta createAddRemoveDelta(IAnnotationField from, IAnnotationField to) {
                return new SigAnnotationFieldDelta(from, to);
            }

            @Override
            public IAnnotationFieldDelta createChangedDelta(IAnnotationField from, IAnnotationField to) {
                return ApiComparator.this.compareAnnotationField(from, to);
            }
        });
    }

    private Set<IEnumConstantDelta> compareEnumConstants(Set<IEnumConstant> from, Set<IEnumConstant> to) {
        return this.compareSets(from, to, new SigComparator<IEnumConstant, IEnumConstantDelta>(){

            @Override
            public boolean considerEqualElement(IEnumConstant from, IEnumConstant to) {
                return from.getName().equals(to.getName());
            }

            @Override
            public IEnumConstantDelta createAddRemoveDelta(IEnumConstant from, IEnumConstant to) {
                return new SigEnumConstantDelta(from, to);
            }

            @Override
            public IEnumConstantDelta createChangedDelta(IEnumConstant from, IEnumConstant to) {
                return ApiComparator.this.compareEnumConstant(from, to);
            }
        });
    }

    private Set<IFieldDelta> compareFields(Set<IField> from, Set<IField> to) {
        return this.compareSets(from, to, new SigComparator<IField, IFieldDelta>(){

            @Override
            public boolean considerEqualElement(IField from, IField to) {
                return from.getName().equals(to.getName());
            }

            @Override
            public IFieldDelta createAddRemoveDelta(IField from, IField to) {
                return new SigFieldDelta(from, to);
            }

            @Override
            public IFieldDelta createChangedDelta(IField from, IField to) {
                return ApiComparator.this.compareField(from, to);
            }
        });
    }

    private Set<IMethodDelta> compareMethods(IClassDefinition from, IClassDefinition to) {
        IMethod compatibleMethod;
        assert (from != null);
        assert (to != null);
        HashSet<IMethod> toMethods = new HashSet<IMethod>(to.getMethods());
        Set<IMethod> toClosure = this.getMethodClosure(to);
        HashSet<IMethod> fromMethods = new HashSet<IMethod>(from.getMethods());
        Set<IMethod> fromClosure = this.getMethodClosure(from);
        HashSet<IMethodDelta> deltas = new HashSet<IMethodDelta>();
        for (IMethod method : fromMethods) {
            IMethodDelta delta;
            compatibleMethod = this.findCompatibleMethod(method, toMethods);
            if (compatibleMethod == null && (compatibleMethod = this.findCompatibleMethod(method, toClosure)) == null) {
                deltas.add(new SigMethodDelta(method, null));
            }
            if (compatibleMethod == null || (delta = this.compareMethod(method, compatibleMethod)) == null) continue;
            deltas.add(delta);
        }
        for (IMethod method : toMethods) {
            compatibleMethod = this.findCompatibleMethod(method, fromMethods);
            if (compatibleMethod != null || (compatibleMethod = this.findCompatibleMethod(method, fromClosure)) != null) continue;
            deltas.add(new SigMethodDelta(null, method));
        }
        return deltas.isEmpty() ? null : deltas;
    }

    private IMethod findCompatibleMethod(IMethod method, Set<IMethod> set) {
        for (IMethod methodFromSet : set) {
            if (!this.equalsSignature(method, methodFromSet)) continue;
            return methodFromSet;
        }
        return null;
    }

    private Set<IMethod> getMethodClosure(IClassDefinition clazz) {
        HashSet<IMethod> closure = new HashSet<IMethod>();
        this.collectMethods(new ClassProjection(clazz, new HashMap<ITypeVariableDefinition, ITypeReference>()), closure);
        return closure;
    }

    private void collectMethods(IClassDefinition clazz, Set<IMethod> closure) {
        if (clazz == null) {
            return;
        }
        if (clazz.getMethods() != null) {
            closure.addAll(clazz.getMethods());
        }
        if (clazz.getSuperClass() != null) {
            this.collectMethods(this.getClassDefinition(clazz.getSuperClass()), closure);
        }
        if (clazz.getInterfaces() != null) {
            for (ITypeReference interfaze : clazz.getInterfaces()) {
                this.collectMethods(this.getClassDefinition(interfaze), closure);
            }
        }
    }

    private Set<IConstructorDelta> compareConstructors(Set<IConstructor> from, Set<IConstructor> to) {
        return this.compareSets(from, to, new SigComparator<IConstructor, IConstructorDelta>(){

            @Override
            public boolean considerEqualElement(IConstructor from, IConstructor to) {
                return ApiComparator.this.equalsSignature(from, to);
            }

            @Override
            public IConstructorDelta createAddRemoveDelta(IConstructor from, IConstructor to) {
                return new SigConstructorDelta(from, to);
            }

            @Override
            public IConstructorDelta createChangedDelta(IConstructor from, IConstructor to) {
                return ApiComparator.this.compareConstructor(from, to);
            }
        });
    }

    private boolean equalsSignature(IExecutableMember from, IExecutableMember to) {
        if (from.getName().equals(to.getName())) {
            return this.compareTypeSequence(this.getParameterList(from.getParameters()), this.getParameterList(to.getParameters()), true) == null;
        }
        return false;
    }

    private List<ITypeReference> getParameterList(List<IParameter> parameters) {
        LinkedList<ITypeReference> parameterTypes = new LinkedList<ITypeReference>();
        for (IParameter parameter : parameters) {
            parameterTypes.add(parameter.getType());
        }
        return parameterTypes;
    }

    private IAnnotationDelta compareAnnotation(IAnnotation from, IAnnotation to) {
        assert (this.sameClassDefinition(from.getType().getClassDefinition(), to.getType().getClassDefinition()));
        Set<IAnnotationElement> fromAnnotationElement = this.getNormalizedAnnotationElements(from);
        Set<IAnnotationElement> toAnnotationElement = this.getNormalizedAnnotationElements(to);
        Set<IAnnotationElementDelta> annotationElementDeltas = this.compareAnnotationElements(fromAnnotationElement, toAnnotationElement);
        SigAnnotationDelta delta = null;
        if (annotationElementDeltas != null) {
            delta = new SigAnnotationDelta(from, to);
            delta.setAnnotationElementDeltas(annotationElementDeltas);
        }
        return delta;
    }

    private Set<IAnnotationElement> getNormalizedAnnotationElements(IAnnotation annotation) {
        HashSet<IAnnotationElement> elements = new HashSet<IAnnotationElement>(annotation.getElements());
        HashSet<String> names = new HashSet<String>();
        for (IAnnotationElement annotationElement : elements) {
            names.add(annotationElement.getDeclaringField().getName());
        }
        for (IAnnotationField field : annotation.getType().getClassDefinition().getAnnotationFields()) {
            if (names.contains(field.getName())) continue;
            SigAnnotationElement sigAnnotationElement = new SigAnnotationElement();
            sigAnnotationElement.setDeclaringField(field);
            sigAnnotationElement.setValue(field.getDefaultValue());
            elements.add(sigAnnotationElement);
        }
        return elements;
    }

    private Set<IAnnotationElementDelta> compareAnnotationElements(Set<IAnnotationElement> from, Set<IAnnotationElement> to) {
        return this.compareSets(from, to, new SigComparator<IAnnotationElement, IAnnotationElementDelta>(){

            @Override
            public boolean considerEqualElement(IAnnotationElement from, IAnnotationElement to) {
                return from.getDeclaringField().getName().equals(to.getDeclaringField().getName());
            }

            @Override
            public IAnnotationElementDelta createAddRemoveDelta(IAnnotationElement from, IAnnotationElement to) {
                return new SigAnnotationElementDelta(from, to);
            }

            @Override
            public IAnnotationElementDelta createChangedDelta(IAnnotationElement from, IAnnotationElement to) {
                return ApiComparator.this.compareAnnotationElement(from, to);
            }
        });
    }

    private IAnnotationElementDelta compareAnnotationElement(IAnnotationElement from, IAnnotationElement to) {
        SigAnnotationElementDelta delta = null;
        SigValueDelta valueDelta = this.compareValue(from.getValue(), to.getValue());
        if (valueDelta != null) {
            delta = new SigAnnotationElementDelta(from, to);
            delta.setValueDelta(valueDelta);
        }
        return delta;
    }

    private Set<Modifier> prepareMethodModifiers(IMethod method) {
        HashSet<Modifier> modifierCopy = new HashSet<Modifier>(method.getModifiers());
        modifierCopy.remove((Object)Modifier.ABSTRACT);
        return modifierCopy;
    }

    private IMethodDelta compareMethod(IMethod from, IMethod to) {
        ITypeReferenceDelta<? extends ITypeReference> returnTypeDelta;
        Set<ITypeReferenceDelta<?>> exceptionDeltas;
        Set<ITypeVariableDefinitionDelta> typeParameterDeltas;
        Set<IAnnotationDelta> annotationDeltas;
        Set<IParameterDelta> parameterDeltas;
        assert (from != null && to != null);
        SigMethodDelta methodDelta = null;
        Set<IModifierDelta> modiferDeltas = this.compareModifiers(this.prepareMethodModifiers(from), this.prepareMethodModifiers(to));
        if (modiferDeltas != null) {
            methodDelta = new SigMethodDelta(from, to);
            methodDelta.setModifierDeltas(modiferDeltas);
        }
        if ((parameterDeltas = this.compareParameterSequence(from.getParameters(), to.getParameters())) != null) {
            if (methodDelta == null) {
                methodDelta = new SigMethodDelta(from, to);
            }
            methodDelta.setParameterDeltas(parameterDeltas);
        }
        if ((annotationDeltas = this.compareAnnotations(from.getAnnotations(), to.getAnnotations())) != null) {
            if (methodDelta == null) {
                methodDelta = new SigMethodDelta(from, to);
            }
            methodDelta.setAnnotationDeltas(annotationDeltas);
        }
        if ((typeParameterDeltas = this.compareTypeVariableSequence(from.getTypeParameters(), to.getTypeParameters())) != null) {
            if (methodDelta == null) {
                methodDelta = new SigMethodDelta(from, to);
            }
            methodDelta.setTypeVariableDeltas(typeParameterDeltas);
        }
        if ((exceptionDeltas = this.compareTypes(this.normalizeExceptions(from.getExceptions()), this.normalizeExceptions(to.getExceptions()))) != null) {
            if (methodDelta == null) {
                methodDelta = new SigMethodDelta(from, to);
            }
            methodDelta.setExceptionDeltas(exceptionDeltas);
        }
        if ((returnTypeDelta = this.compareType(from.getReturnType(), to.getReturnType(), false)) != null) {
            if (methodDelta == null) {
                methodDelta = new SigMethodDelta(from, to);
            }
            methodDelta.setReturnTypeDelta(returnTypeDelta);
        }
        return methodDelta;
    }

    private Set<ITypeReference> normalizeExceptions(Set<ITypeReference> exceptions) {
        Set<ITypeReference> exceptionCopy = new HashSet<ITypeReference>(exceptions);
        Iterator iterator = exceptionCopy.iterator();
        while (iterator.hasNext()) {
            ITypeReference exception = (ITypeReference)iterator.next();
            if (!this.isRuntimeExceptionOrErrorSubtype(exception)) continue;
            iterator.remove();
        }
        exceptionCopy = this.removeSpecializations(exceptionCopy);
        return exceptionCopy;
    }

    private Set<ITypeReference> removeSpecializations(Set<ITypeReference> exceptions) {
        HashSet<ITypeReference> exceptionCopy = new HashSet<ITypeReference>(exceptions);
        for (ITypeReference type : exceptions) {
            Iterator it = exceptionCopy.iterator();
            while (it.hasNext()) {
                ITypeReference subType = (ITypeReference)it.next();
                if (!this.isSuperClass(this.getClassDefinition(type), this.getClassDefinition(subType))) continue;
                it.remove();
            }
        }
        return exceptionCopy;
    }

    private boolean isSuperClass(IClassDefinition superC, IClassDefinition subC) {
        if (superC == null || subC == null) {
            return false;
        }
        if (subC.getSuperClass() == null) {
            return false;
        }
        if (this.getClassDefinition(subC.getSuperClass()).equals(superC)) {
            return true;
        }
        return this.isSuperClass(superC, this.getClassDefinition(subC.getSuperClass()));
    }

    private boolean isSuperInterface(IClassDefinition superClass, IClassDefinition subClass) {
        if (superClass == null || subClass == null) {
            return false;
        }
        if (subClass.getInterfaces() == null) {
            return false;
        }
        if (this.getClassDefinitions(subClass.getInterfaces()).contains(superClass)) {
            return true;
        }
        for (ITypeReference subType : subClass.getInterfaces()) {
            if (!this.isSuperInterface(superClass, this.getClassDefinition(subType))) continue;
            return true;
        }
        return false;
    }

    private Set<IClassDefinition> getClassDefinitions(Set<ITypeReference> references) {
        HashSet<IClassDefinition> definitions = new HashSet<IClassDefinition>();
        for (ITypeReference ref : references) {
            definitions.add(this.getClassDefinition(ref));
        }
        return definitions;
    }

    private IClassDefinition getClassDefinition(ITypeReference type) {
        assert (type != null);
        IClassDefinition returnValue = null;
        if (type instanceof IClassReference) {
            returnValue = ((IClassReference)type).getClassDefinition();
        } else if (type instanceof IParameterizedType) {
            returnValue = ((IParameterizedType)type).getRawType().getClassDefinition();
        }
        return returnValue;
    }

    private boolean isRuntimeExceptionOrErrorSubtype(ITypeReference exception) {
        IClassDefinition clazz = this.getClassDefinition(exception);
        if (clazz != null) {
            if (this.isRuntimeExceptionOrError(clazz)) {
                return true;
            }
            if (clazz.getSuperClass() != null) {
                return this.isRuntimeExceptionOrErrorSubtype(clazz.getSuperClass());
            }
            return false;
        }
        return false;
    }

    private boolean isRuntimeExceptionOrError(IClassDefinition exception) {
        if (exception == null) {
            return false;
        }
        String packageName = exception.getPackageName();
        String className = exception.getName();
        if (packageName != null && className != null && "java.lang".equals(packageName)) {
            return "RuntimeException".equals(className) || "Error".equals(className);
        }
        return false;
    }

    private IConstructorDelta compareConstructor(IConstructor from, IConstructor to) {
        Set<ITypeReferenceDelta<?>> exceptionDeltas;
        Set<ITypeVariableDefinitionDelta> typeParameterDeltas;
        Set<IAnnotationDelta> annotationDeltas;
        Set<IParameterDelta> parameterDeltas;
        SigConstructorDelta constructorDelta = null;
        Set<IModifierDelta> modiferDeltas = this.compareModifiers(from.getModifiers(), to.getModifiers());
        if (modiferDeltas != null) {
            constructorDelta = new SigConstructorDelta(from, to);
            constructorDelta.setModifierDeltas(modiferDeltas);
        }
        if ((parameterDeltas = this.compareParameterSequence(from.getParameters(), to.getParameters())) != null) {
            if (constructorDelta == null) {
                constructorDelta = new SigConstructorDelta(from, to);
            }
            constructorDelta.setParameterDeltas(parameterDeltas);
        }
        if ((annotationDeltas = this.compareAnnotations(from.getAnnotations(), to.getAnnotations())) != null) {
            if (constructorDelta == null) {
                constructorDelta = new SigConstructorDelta(from, to);
            }
            constructorDelta.setAnnotationDeltas(annotationDeltas);
        }
        if ((typeParameterDeltas = this.compareTypeVariableSequence(from.getTypeParameters(), to.getTypeParameters())) != null) {
            if (constructorDelta == null) {
                constructorDelta = new SigConstructorDelta(from, to);
            }
            constructorDelta.setTypeVariableDeltas(typeParameterDeltas);
        }
        if ((exceptionDeltas = this.compareTypes(this.normalizeExceptions(from.getExceptions()), this.normalizeExceptions(to.getExceptions()))) != null) {
            if (constructorDelta == null) {
                constructorDelta = new SigConstructorDelta(from, to);
            }
            constructorDelta.setExceptionDeltas(exceptionDeltas);
        }
        return constructorDelta;
    }

    private Set<IParameterDelta> compareParameterSequence(List<IParameter> from, List<IParameter> to) {
        assert (from.size() == to.size());
        HashSet<IParameterDelta> deltas = new HashSet<IParameterDelta>();
        Iterator<IParameter> fromIterator = from.iterator();
        Iterator<IParameter> toIterator = to.iterator();
        while (fromIterator.hasNext() && toIterator.hasNext()) {
            IParameterDelta delta = this.compareParameter(fromIterator.next(), toIterator.next());
            if (delta == null) continue;
            deltas.add(delta);
        }
        return deltas.isEmpty() ? null : deltas;
    }

    private IParameterDelta compareParameter(IParameter from, IParameter to) {
        Set<IAnnotationDelta> annotationDeltas;
        SigParameterDelta delta = null;
        ITypeReferenceDelta<? extends ITypeReference> typeDelta = this.compareType(from.getType(), to.getType(), false);
        if (typeDelta != null) {
            if (delta == null) {
                delta = new SigParameterDelta(from, to);
            }
            delta.setTypeDelta(typeDelta);
        }
        if ((annotationDeltas = this.compareAnnotations(from.getAnnotations(), to.getAnnotations())) != null) {
            if (delta == null) {
                delta = new SigParameterDelta(from, to);
            }
            delta.setAnnotationDeltas(annotationDeltas);
        }
        return delta;
    }

    private Set<ITypeVariableDefinitionDelta> compareTypeVariableSequence(List<ITypeVariableDefinition> from, List<ITypeVariableDefinition> to) {
        HashSet<ITypeVariableDefinitionDelta> deltas = new HashSet<ITypeVariableDefinitionDelta>();
        if (from.size() != to.size()) {
            for (ITypeVariableDefinition fromVariable : from) {
                deltas.add(new SigTypeVariableDefinitionDelta(fromVariable, null));
            }
            for (ITypeVariableDefinition toVariable : to) {
                deltas.add(new SigTypeVariableDefinitionDelta(null, toVariable));
            }
        }
        Iterator<ITypeVariableDefinition> fromIterator = from.iterator();
        Iterator<ITypeVariableDefinition> toIterator = to.iterator();
        while (fromIterator.hasNext() && toIterator.hasNext()) {
            ITypeVariableDefinitionDelta delta = this.compareTypeVariableDefinition(fromIterator.next(), toIterator.next());
            if (delta == null) continue;
            deltas.add(delta);
        }
        return deltas.isEmpty() ? null : deltas;
    }

    private ITypeVariableDefinitionDelta compareTypeVariableDefinition(ITypeVariableDefinition from, ITypeVariableDefinition to) {
        IGenericDeclarationDelta declarationDelta = this.compareGenericDeclaration(from, to);
        if (declarationDelta != null) {
            SigTypeVariableDefinitionDelta delta = new SigTypeVariableDefinitionDelta(from, to);
            delta.setGenericDeclarationDelta(declarationDelta);
            return delta;
        }
        IUpperBoundsDelta upperBoundDelta = this.compareUpperBounds(from.getUpperBounds(), to.getUpperBounds());
        if (upperBoundDelta != null) {
            SigTypeVariableDefinitionDelta delta = new SigTypeVariableDefinitionDelta(from, to);
            delta.setUpperBoundsDelta(upperBoundDelta);
            return delta;
        }
        return null;
    }

    private ITypeReferenceDelta<ITypeVariableReference> compareTypeVariableReference(ITypeVariableReference from, ITypeVariableReference to) {
        IGenericDeclarationDelta declarationDelta = this.compareGenericDeclaration(from.getTypeVariableDefinition(), to.getTypeVariableDefinition());
        if (declarationDelta != null) {
            SigTypeVariableReferenceDelta delta = new SigTypeVariableReferenceDelta(from, to);
            delta.setGenericDeclarationDelta(declarationDelta);
            return delta;
        }
        return null;
    }

    private Set<IModifierDelta> compareModifiers(Set<Modifier> from, Set<Modifier> to) {
        return this.compareSets(from, to, new SigComparator<Modifier, IModifierDelta>(){

            @Override
            public boolean considerEqualElement(Modifier from, Modifier to) {
                return from.equals((Object)to);
            }

            @Override
            public IModifierDelta createAddRemoveDelta(Modifier from, Modifier to) {
                return new SigModifierDelta(from, to);
            }

            @Override
            public IModifierDelta createChangedDelta(Modifier from, Modifier to) {
                return null;
            }
        });
    }

    private IFieldDelta compareField(IField from, IField to) {
        ITypeReferenceDelta<? extends ITypeReference> typeDelta;
        Set<IAnnotationDelta> annotationDeltas;
        SigFieldDelta fieldDelta = null;
        Set<IModifierDelta> modiferDeltas = this.compareModifiers(from.getModifiers(), to.getModifiers());
        if (modiferDeltas != null) {
            fieldDelta = new SigFieldDelta(from, to);
            fieldDelta.setModifierDeltas(modiferDeltas);
        }
        if ((annotationDeltas = this.compareAnnotations(from.getAnnotations(), to.getAnnotations())) != null) {
            if (fieldDelta == null) {
                fieldDelta = new SigFieldDelta(from, to);
            }
            fieldDelta.setAnnotationDeltas(annotationDeltas);
        }
        if ((typeDelta = this.compareType(from.getType(), to.getType(), false)) != null) {
            if (fieldDelta == null) {
                fieldDelta = new SigFieldDelta(from, to);
            }
            fieldDelta.setTypeDelta(typeDelta);
        }
        return fieldDelta;
    }

    private IEnumConstantDelta compareEnumConstant(IEnumConstant from, IEnumConstant to) {
        ITypeReferenceDelta<? extends ITypeReference> typeDelta;
        Set<IAnnotationDelta> annotationDeltas;
        SigEnumConstantDelta enumConstantDelta = null;
        Set<IModifierDelta> modiferDeltas = this.compareModifiers(from.getModifiers(), to.getModifiers());
        if (modiferDeltas != null) {
            enumConstantDelta = new SigEnumConstantDelta(from, to);
            enumConstantDelta.setModifierDeltas(modiferDeltas);
        }
        if ((annotationDeltas = this.compareAnnotations(from.getAnnotations(), to.getAnnotations())) != null) {
            if (enumConstantDelta == null) {
                enumConstantDelta = new SigEnumConstantDelta(from, to);
            }
            enumConstantDelta.setAnnotationDeltas(annotationDeltas);
        }
        if ((typeDelta = this.compareType(from.getType(), to.getType(), false)) != null) {
            if (enumConstantDelta == null) {
                enumConstantDelta = new SigEnumConstantDelta(from, to);
            }
            enumConstantDelta.setTypeDelta(typeDelta);
        }
        return enumConstantDelta;
    }

    private IAnnotationFieldDelta compareAnnotationField(IAnnotationField from, IAnnotationField to) {
        SigValueDelta defaultValueDelta;
        ITypeReferenceDelta<? extends ITypeReference> typeDelta;
        Set<IAnnotationDelta> annotationDeltas;
        SigAnnotationFieldDelta annotationFieldDelta = null;
        Set<IModifierDelta> modiferDeltas = this.compareModifiers(from.getModifiers(), to.getModifiers());
        if (modiferDeltas != null) {
            annotationFieldDelta = new SigAnnotationFieldDelta(from, to);
            annotationFieldDelta.setModifierDeltas(modiferDeltas);
        }
        if ((annotationDeltas = this.compareAnnotations(from.getAnnotations(), to.getAnnotations())) != null) {
            if (annotationFieldDelta == null) {
                annotationFieldDelta = new SigAnnotationFieldDelta(from, to);
            }
            annotationFieldDelta.setAnnotationDeltas(annotationDeltas);
        }
        if ((typeDelta = this.compareType(from.getType(), to.getType(), false)) != null) {
            if (annotationFieldDelta == null) {
                annotationFieldDelta = new SigAnnotationFieldDelta(from, to);
            }
            annotationFieldDelta.setTypeDelta(typeDelta);
        }
        if ((defaultValueDelta = this.compareValue(from.getDefaultValue(), to.getDefaultValue())) != null) {
            if (annotationFieldDelta == null) {
                annotationFieldDelta = new SigAnnotationFieldDelta(from, to);
            }
            annotationFieldDelta.setDefaultValueDelta(defaultValueDelta);
        }
        return annotationFieldDelta;
    }

    private SigValueDelta compareValue(Object from, Object to) {
        if (from == null && to == null) {
            return null;
        }
        if (from == null || to == null) {
            return new SigValueDelta(from, to);
        }
        SigValueDelta delta = null;
        if (from.getClass() == to.getClass()) {
            if (from.getClass().isArray()) {
                Object[] fromArray = (Object[])from;
                Object[] toArray = (Object[])from;
                if (!Arrays.equals(fromArray, toArray)) {
                    delta = new SigValueDelta(from, to);
                }
            } else if (from instanceof IEnumConstant) {
                IEnumConstantDelta enumConstantDelta = this.compareEnumConstant((IEnumConstant)from, (IEnumConstant)to);
                if (enumConstantDelta != null) {
                    delta = new SigValueDelta(from, to);
                }
            } else if (from instanceof IAnnotation) {
                IAnnotationDelta annotationDelta = this.compareAnnotation((IAnnotation)from, (IAnnotation)to);
                if (annotationDelta != null) {
                    delta = new SigValueDelta(from, to);
                }
            } else if (from instanceof IField) {
                IFieldDelta fieldDelta = this.compareField((IField)from, (IField)to);
                if (fieldDelta != null) {
                    delta = new SigValueDelta(from, to);
                }
            } else if (from instanceof ITypeReference) {
                ITypeReferenceDelta<? extends ITypeReference> typeDelta = this.compareType((ITypeReference)from, (ITypeReference)to, false);
                if (typeDelta != null) {
                    delta = new SigValueDelta(from, to);
                }
            } else if (!from.equals(to)) {
                delta = new SigValueDelta(from, to);
            }
        } else if (from != null || to != null) {
            delta = new SigValueDelta(from, to);
        }
        return delta;
    }

    private boolean considerEqualTypes(ITypeReference from, ITypeReference to) {
        assert (from != null && to != null);
        if (this.implementInterface(from, to, IPrimitiveType.class)) {
            return this.comparePrimitiveType((IPrimitiveType)from, (IPrimitiveType)to) == null;
        }
        if (this.implementInterface(from, to, IClassReference.class)) {
            return this.sameClassDefinition(((IClassReference)from).getClassDefinition(), ((IClassReference)to).getClassDefinition());
        }
        if (this.implementInterface(from, to, IArrayType.class)) {
            return this.considerEqualTypes(((IArrayType)from).getComponentType(), ((IArrayType)to).getComponentType());
        }
        if (this.implementInterface(from, to, IParameterizedType.class)) {
            return this.compareClassReference(((IParameterizedType)from).getRawType(), ((IParameterizedType)to).getRawType()) == null;
        }
        if (this.implementInterface(from, to, ITypeVariableReference.class)) {
            return this.compareTypeVariableReference((ITypeVariableReference)from, (ITypeVariableReference)to) == null;
        }
        return false;
    }

    private boolean areInComparison(ITypeReference from, ITypeReference to) {
        return this.fromComparison.contains(from) && this.toComparison.contains(to);
    }

    private void markInComparison(ITypeReference from, ITypeReference to) {
        this.fromComparison.add(from);
        this.toComparison.add(to);
    }

    private void markFinishedComparison(ITypeReference from, ITypeReference to) {
        this.fromComparison.remove(from);
        this.toComparison.remove(to);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ITypeReferenceDelta<? extends ITypeReference> compareType(ITypeReference from, ITypeReference to, boolean acceptErasedTypes) {
        if (from == null && to == null) {
            return null;
        }
        if (from == null && to != null || from != null && to == null) {
            return new SigTypeDelta<ITypeReference>(from, to);
        }
        if (this.areInComparison(from, to)) {
            return null;
        }
        try {
            this.markInComparison(from, to);
            if (this.implementInterface(from, to, IPrimitiveType.class)) {
                IPrimitiveTypeDelta iPrimitiveTypeDelta = this.comparePrimitiveType((IPrimitiveType)from, (IPrimitiveType)to);
                return iPrimitiveTypeDelta;
            }
            if (this.implementInterface(from, to, IClassReference.class)) {
                ITypeReferenceDelta<IClassReference> iTypeReferenceDelta = this.compareClassReference((IClassReference)from, (IClassReference)to);
                return iTypeReferenceDelta;
            }
            if (this.implementInterface(from, to, IArrayType.class)) {
                ITypeReferenceDelta<?> iTypeReferenceDelta = this.compareArrayType((IArrayType)from, (IArrayType)to);
                return iTypeReferenceDelta;
            }
            if (this.implementInterface(from, to, IParameterizedType.class)) {
                IParameterizedTypeDelta iParameterizedTypeDelta = this.compareParameterizedType((IParameterizedType)from, (IParameterizedType)to, acceptErasedTypes);
                return iParameterizedTypeDelta;
            }
            if (this.implementInterface(from, to, ITypeVariableReference.class)) {
                ITypeReferenceDelta<ITypeVariableReference> iTypeReferenceDelta = this.compareTypeVariableReference((ITypeVariableReference)from, (ITypeVariableReference)to);
                return iTypeReferenceDelta;
            }
            if (this.implementInterface(from, to, IWildcardType.class)) {
                IWildcardTypeDelta iWildcardTypeDelta = this.compareWildcardType((IWildcardType)from, (IWildcardType)to);
                return iWildcardTypeDelta;
            }
            if (acceptErasedTypes) {
                if (this.isGeneric(from) && !this.isGeneric(to)) {
                    ITypeReferenceDelta<? extends ITypeReference> iTypeReferenceDelta = this.compareType(this.getErasedType(from), to, false);
                    return iTypeReferenceDelta;
                }
                if (!this.isGeneric(from) && this.isGeneric(to)) {
                    ITypeReferenceDelta<? extends ITypeReference> iTypeReferenceDelta = this.compareType(from, this.getErasedType(to), false);
                    return iTypeReferenceDelta;
                }
            }
            SigTypeDelta<ITypeReference> sigTypeDelta = new SigTypeDelta<ITypeReference>(from, to);
            return sigTypeDelta;
        }
        finally {
            this.markFinishedComparison(from, to);
        }
    }

    private boolean isGeneric(ITypeReference reference) {
        if (reference instanceof IParameterizedType || reference instanceof ITypeVariableReference || reference instanceof IWildcardType) {
            return true;
        }
        if (reference instanceof IArrayType) {
            return this.isGeneric(((IArrayType)reference).getComponentType());
        }
        return false;
    }

    private ITypeReference getErasedType(ITypeReference reference) {
        if (reference instanceof IParameterizedType) {
            return ((IParameterizedType)reference).getRawType();
        }
        if (reference instanceof ITypeVariableReference) {
            ITypeVariableDefinition typeVariableDefinition = ((ITypeVariableReference)reference).getTypeVariableDefinition();
            return this.getErasedType(typeVariableDefinition.getUpperBounds().get(0));
        }
        if (reference instanceof IWildcardType) {
            return this.getErasedType(((IWildcardType)reference).getUpperBounds().get(0));
        }
        if (reference instanceof IArrayType) {
            return new SigArrayType(this.getErasedType(((IArrayType)reference).getComponentType()));
        }
        if (reference instanceof IPrimitiveType) {
            return reference;
        }
        if (reference instanceof IClassReference) {
            return reference;
        }
        throw new IllegalArgumentException("Unexpected type: " + reference);
    }

    private boolean implementInterface(ITypeReference from, ITypeReference to, Class<?> check) {
        return check.isAssignableFrom(from.getClass()) && check.isAssignableFrom(to.getClass());
    }

    private IWildcardTypeDelta compareWildcardType(IWildcardType from, IWildcardType to) {
        IUpperBoundsDelta upperBoundsDelta;
        ITypeReference toLowerBound;
        SigWildcardTypeDelta delta = null;
        ITypeReference fromLowerBound = from.getLowerBound();
        ITypeReferenceDelta<? extends ITypeReference> lowerBoundDelta = this.compareType(fromLowerBound, toLowerBound = to.getLowerBound(), false);
        if (lowerBoundDelta != null) {
            delta = new SigWildcardTypeDelta(from, to);
            delta.setLowerBoundDelta(lowerBoundDelta);
        }
        if ((upperBoundsDelta = this.compareUpperBounds(from.getUpperBounds(), to.getUpperBounds())) != null) {
            if (delta == null) {
                delta = new SigWildcardTypeDelta(from, to);
            }
            delta.setUpperBoundDelta(upperBoundsDelta);
        }
        return delta;
    }

    private IGenericDeclarationDelta compareGenericDeclaration(ITypeVariableDefinition fromVariable, ITypeVariableDefinition toVariable) {
        SigGenericDeclarationDelta delta = null;
        IGenericDeclaration from = fromVariable.getGenericDeclaration();
        IGenericDeclaration to = toVariable.getGenericDeclaration();
        if (from != null && to != null) {
            if (from.getClass() != to.getClass()) {
                delta = new SigGenericDeclarationDelta(from, to);
            } else if (from instanceof IClassDefinition) {
                IClassDefinition fromDeclaringClass = (IClassDefinition)from;
                IClassDefinition toDeclaringClass = (IClassDefinition)to;
                if (!this.sameClassDefinition(fromDeclaringClass, toDeclaringClass)) {
                    delta = new SigGenericDeclarationDelta(from, to);
                }
            } else if (from instanceof IConstructor) {
                IConstructor fromConstructor = (IConstructor)from;
                IConstructor toConstructor = (IConstructor)from;
                String fromConstructorName = fromConstructor.getName();
                String fromClassName = fromConstructor.getDeclaringClass().getQualifiedName();
                String toConstructorName = toConstructor.getName();
                String toClassName = toConstructor.getDeclaringClass().getQualifiedName();
                if (!fromConstructorName.equals(toConstructorName) || !fromClassName.equals(toClassName)) {
                    delta = new SigGenericDeclarationDelta(from, to);
                }
            } else if (from instanceof IMethod) {
                IMethod fromMethod = (IMethod)from;
                IMethod toMethod = (IMethod)from;
                String fromConstructorName = fromMethod.getName();
                String fromClassName = fromMethod.getDeclaringClass().getQualifiedName();
                String toConstructorName = toMethod.getName();
                String toClassName = toMethod.getDeclaringClass().getQualifiedName();
                if (!fromConstructorName.equals(toConstructorName) || !fromClassName.equals(toClassName)) {
                    delta = new SigGenericDeclarationDelta(from, to);
                }
            } else {
                throw new IllegalStateException("Invlaid eclaration site: " + from);
            }
            int fromPosition = this.getPositionOf(fromVariable, from);
            int toPosition = this.getPositionOf(toVariable, to);
            if (fromPosition != toPosition) {
                delta = new SigGenericDeclarationDelta(from, to);
            }
        } else {
            delta = new SigGenericDeclarationDelta(from, to);
        }
        return delta;
    }

    private int getPositionOf(ITypeVariableDefinition variable, IGenericDeclaration declaration) {
        return declaration.getTypeParameters().indexOf(variable);
    }

    private IUpperBoundsDelta compareUpperBounds(List<ITypeReference> from, List<ITypeReference> to) {
        ITypeReference toFirstUpperBound;
        if (from.isEmpty() && to.isEmpty()) {
            return null;
        }
        SigUpperBoundsDelta delta = null;
        ITypeReference fromFirstUpperBound = from.get(0);
        ITypeReferenceDelta<? extends ITypeReference> firstUpperBoundDelta = this.compareType(fromFirstUpperBound, toFirstUpperBound = to.get(0), false);
        if (firstUpperBoundDelta != null) {
            delta = new SigUpperBoundsDelta(from, to);
            delta.setFirstUpperBoundDelta(firstUpperBoundDelta);
        } else {
            Set<ITypeReference> normalizedto;
            Set<ITypeReference> normalizedfrom = this.removeGeneralizations(new HashSet<ITypeReference>(from));
            Set<ITypeReferenceDelta<?>> remainingUpperBoundsDelta = this.compareTypes(normalizedfrom, normalizedto = this.removeGeneralizations(new HashSet<ITypeReference>(to)));
            if (remainingUpperBoundsDelta != null) {
                delta = new SigUpperBoundsDelta(from, to);
                delta.setRemainingUpperBoundDeltas(remainingUpperBoundsDelta);
            }
        }
        return delta;
    }

    private Set<ITypeReference> removeGeneralizations(Set<ITypeReference> bounds) {
        HashSet<ITypeReference> boundsCopy = new HashSet<ITypeReference>(bounds);
        for (ITypeReference type : bounds) {
            Iterator it = boundsCopy.iterator();
            while (it.hasNext()) {
                ITypeReference superType = (ITypeReference)it.next();
                if (!this.isSuperClass(this.getClassDefinition(superType), this.getClassDefinition(type)) && !this.isSuperInterface(this.getClassDefinition(superType), this.getClassDefinition(type))) continue;
                it.remove();
            }
        }
        return boundsCopy;
    }

    private IParameterizedTypeDelta compareParameterizedType(IParameterizedType from, IParameterizedType to, boolean ignoreTypeArguments) {
        SigParameterizedTypeDelta delta = null;
        ITypeReferenceDelta<? extends ITypeReference> rawTypeDelta = this.compareType(from.getRawType(), to.getRawType(), false);
        if (rawTypeDelta != null) {
            delta = new SigParameterizedTypeDelta(from, to);
            delta.setRawTypeDelta(rawTypeDelta);
        } else {
            Set<ITypeReferenceDelta<?>> argumentTypeDeltas;
            ITypeReferenceDelta<? extends ITypeReference> ownerTypeDelta = this.compareType(from.getOwnerType(), to.getOwnerType(), false);
            if (ownerTypeDelta != null) {
                delta = new SigParameterizedTypeDelta(from, to);
                delta.setOwnerTypeDelta(ownerTypeDelta);
            } else if (!ignoreTypeArguments && (argumentTypeDeltas = this.compareTypeSequence(from.getTypeArguments(), to.getTypeArguments(), false)) != null) {
                delta = new SigParameterizedTypeDelta(from, to);
                delta.setArgumentTypeDeltas(argumentTypeDeltas);
            }
        }
        return delta;
    }

    private Set<ITypeReferenceDelta<? extends ITypeReference>> compareTypeSequence(List<ITypeReference> from, List<ITypeReference> to, boolean ignoreTypeArguments) {
        HashSet<ITypeReferenceDelta<? extends ITypeReference>> deltas = new HashSet<ITypeReferenceDelta<? extends ITypeReference>>();
        if (from.size() != to.size()) {
            for (ITypeReference type : from) {
                deltas.add(new SigTypeDelta<Object>(type, null));
            }
            for (ITypeReference type : to) {
                deltas.add(new SigTypeDelta<ITypeReference>(null, type));
            }
            return deltas;
        }
        Iterator<ITypeReference> fromIterator = from.iterator();
        Iterator<ITypeReference> toIterator = to.iterator();
        while (fromIterator.hasNext() && toIterator.hasNext()) {
            ITypeReferenceDelta<? extends ITypeReference> delta = this.compareType(fromIterator.next(), toIterator.next(), ignoreTypeArguments);
            if (delta == null) continue;
            deltas.add(delta);
        }
        return deltas.isEmpty() ? null : deltas;
    }

    private Set<ITypeReferenceDelta<? extends ITypeReference>> compareTypes(Set<ITypeReference> from, Set<ITypeReference> to) {
        return this.compareSets(from, to, new SigComparator<ITypeReference, ITypeReferenceDelta<? extends ITypeReference>>(){

            @Override
            public ITypeReferenceDelta<? extends ITypeReference> createAddRemoveDelta(ITypeReference from, ITypeReference to) {
                return new SigTypeDelta<ITypeReference>(from, to);
            }

            @Override
            public boolean considerEqualElement(ITypeReference from, ITypeReference to) {
                return ApiComparator.this.considerEqualTypes(from, to);
            }

            @Override
            public ITypeReferenceDelta<? extends ITypeReference> createChangedDelta(ITypeReference from, ITypeReference to) {
                return ApiComparator.this.compareType(from, to, false);
            }
        });
    }

    private <T, S extends IDelta<? extends T>> Set<S> compareSets(Set<T> from, Set<T> to, SigComparator<T, S> comparator) {
        HashSet<T> toCopy = new HashSet<T>(to);
        HashSet<S> deltas = new HashSet<S>();
        for (T fromType : from) {
            Iterator toIterator = toCopy.iterator();
            boolean equals = false;
            boolean hasNext = toIterator.hasNext();
            while (hasNext && !equals) {
                S compare;
                Object toElement = toIterator.next();
                equals = comparator.considerEqualElement(fromType, toElement);
                if (equals && (compare = comparator.createChangedDelta(fromType, toElement)) != null) {
                    deltas.add(compare);
                }
                hasNext = toIterator.hasNext();
            }
            if (equals) {
                toIterator.remove();
                continue;
            }
            S delta = comparator.createAddRemoveDelta(fromType, null);
            if (delta == null) continue;
            deltas.add(delta);
        }
        for (Object type : toCopy) {
            S delta = comparator.createAddRemoveDelta(null, type);
            if (delta == null) continue;
            deltas.add(delta);
        }
        return deltas.isEmpty() ? null : deltas;
    }

    private ITypeReferenceDelta<?> compareArrayType(IArrayType from, IArrayType to) {
        ITypeReferenceDelta<? extends ITypeReference> componentTypeDelta = this.compareType(from.getComponentType(), to.getComponentType(), false);
        if (componentTypeDelta != null) {
            SigArrayTypeDelta delta = new SigArrayTypeDelta(from, to);
            delta.setComponentTypeDelta(componentTypeDelta);
            return delta;
        }
        return null;
    }

    private ITypeReferenceDelta<IClassReference> compareClassReference(IClassReference fromRef, IClassReference toRef) {
        IClassDefinition to;
        IClassDefinition from = fromRef.getClassDefinition();
        if (!this.sameClassDefinition(from, to = toRef.getClassDefinition())) {
            return new SigClassReferenceDelta(fromRef, toRef);
        }
        return null;
    }

    private boolean sameClassDefinition(IClassDefinition from, IClassDefinition to) {
        boolean sameName = from.getName().equals(to.getName());
        boolean samePackage = from.getPackageName().equals(to.getPackageName());
        Kind fromKind = from.getKind();
        Kind toKind = to.getKind();
        boolean sameKind = fromKind == null || toKind == null || fromKind.equals((Object)toKind);
        return sameName && samePackage && sameKind;
    }

    private IPrimitiveTypeDelta comparePrimitiveType(IPrimitiveType from, IPrimitiveType to) {
        if (!from.equals(to)) {
            return new SigPrimitiveTypeDelta(from, to);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface SigComparator<T, S extends IDelta<? extends T>> {
        public boolean considerEqualElement(T var1, T var2);

        public S createChangedDelta(T var1, T var2);

        public S createAddRemoveDelta(T var1, T var2);
    }
}

