/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.widgets;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.internal.avd.AvdManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

final class AvdDetailsDialog
extends Dialog {
    private static Point sLastSize;
    private Shell mDialogShell;
    private final AvdManager.AvdInfo mAvdInfo;
    private Composite mRootComposite;

    public AvdDetailsDialog(Shell shell, AvdManager.AvdInfo avdInfo) {
        super(shell, 65536);
        this.mAvdInfo = avdInfo;
        this.setText("AVD details");
    }

    public void open() {
        this.createContents();
        this.positionShell();
        this.mDialogShell.open();
        this.mDialogShell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.mDialogShell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        if (!this.mDialogShell.isDisposed()) {
            sLastSize = this.mDialogShell.getSize();
            this.mDialogShell.close();
        }
    }

    private void createContents() {
        this.mDialogShell = new Shell(this.getParent(), 2160);
        this.mDialogShell.setLayout((Layout)new GridLayout(1, false));
        this.mDialogShell.setSize(450, 300);
        this.mDialogShell.setText(this.getText());
        this.mRootComposite = new Composite((Composite)this.mDialogShell, 0);
        this.mRootComposite.setLayout((Layout)new GridLayout(2, false));
        this.mRootComposite.setLayoutData((Object)new GridData(1808));
        Composite c = new Composite(this.mRootComposite, 0);
        GridLayout gl = new GridLayout(2, false);
        c.setLayout((Layout)gl);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        c.setLayoutData((Object)new GridData(768));
        if (this.mAvdInfo != null) {
            this.displayValue(c, "Name:", this.mAvdInfo.getName());
            this.displayValue(c, "Path:", this.mAvdInfo.getPath());
            if (this.mAvdInfo.getStatus() != AvdManager.AvdInfo.AvdStatus.OK) {
                this.displayValue(c, "Error:", this.mAvdInfo.getErrorMessage());
            } else {
                IAndroidTarget target = this.mAvdInfo.getTarget();
                AndroidVersion version = target.getVersion();
                this.displayValue(c, "Target:", String.format("%s (API level %s)", target.getName(), version.getApiString()));
                Map properties = this.mAvdInfo.getProperties();
                if (properties != null) {
                    String sdcard;
                    String skin = (String)properties.get("skin.name");
                    if (skin != null) {
                        this.displayValue(c, "Skin:", skin);
                    }
                    if ((sdcard = (String)properties.get("sdcard.size")) == null) {
                        sdcard = (String)properties.get("sdcard.path");
                    }
                    if (sdcard != null) {
                        this.displayValue(c, "SD Card:", sdcard);
                    }
                    HashMap copy = new HashMap(properties);
                    copy.remove("skin.name");
                    copy.remove("skin.path");
                    copy.remove("sdcard.size");
                    copy.remove("sdcard.path");
                    copy.remove("image.sysdir.1");
                    copy.remove("image.sysdir.2");
                    if (copy.size() > 0) {
                        Label l = new Label(this.mRootComposite, 258);
                        l.setLayoutData((Object)new GridData(4, 2, false, false, 2, 1));
                        c = new Composite(this.mRootComposite, 0);
                        gl = new GridLayout(2, false);
                        c.setLayout((Layout)gl);
                        gl.marginWidth = 0;
                        gl.marginHeight = 0;
                        c.setLayoutData((Object)new GridData(1808));
                        Set keys = copy.keySet();
                        for (String key : keys) {
                            this.displayValue(c, key + ":", (String)copy.get(key));
                        }
                    }
                }
            }
        }
    }

    private void displayValue(Composite parent, String label, String value) {
        Label l = new Label(parent, 0);
        l.setText(label);
        l.setLayoutData((Object)new GridData(3, 2, false, false));
        l = new Label(parent, 0);
        l.setText(value);
        l.setLayoutData((Object)new GridData(4, 2, true, false));
    }

    private void positionShell() {
        Shell child = this.mDialogShell;
        Shell parent = this.getParent();
        if (child != null && parent != null) {
            Rectangle parentArea = parent.getClientArea();
            Point parentLoc = parent.getLocation();
            int px = parentLoc.x;
            int py = parentLoc.y;
            int pw = parentArea.width;
            int ph = parentArea.height;
            Point childSize = sLastSize != null ? sLastSize : child.getSize();
            int cw = childSize.x;
            int ch = childSize.y;
            child.setLocation(px + (pw - cw) / 2, py + (ph - ch) / 2);
            child.setSize(cw, ch);
        }
    }
}

