/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.repository;

import com.android.prefs.AndroidLocation;
import com.android.sdklib.ISdkLog;
import com.android.sdklib.SdkConstants;
import com.android.sdklib.SdkManager;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.sdklib.internal.repository.AddonPackage;
import com.android.sdklib.internal.repository.Archive;
import com.android.sdklib.internal.repository.DocPackage;
import com.android.sdklib.internal.repository.ExtraPackage;
import com.android.sdklib.internal.repository.ITask;
import com.android.sdklib.internal.repository.ITaskFactory;
import com.android.sdklib.internal.repository.ITaskMonitor;
import com.android.sdklib.internal.repository.LocalSdkParser;
import com.android.sdklib.internal.repository.Package;
import com.android.sdklib.internal.repository.PlatformPackage;
import com.android.sdklib.internal.repository.RepoSource;
import com.android.sdklib.internal.repository.RepoSources;
import com.android.sdklib.internal.repository.SamplePackage;
import com.android.sdklib.internal.repository.ToolPackage;
import com.android.sdklib.repository.SdkRepository;
import com.android.sdkuilib.internal.repository.AdbWrapper;
import com.android.sdkuilib.internal.repository.ArchiveInfo;
import com.android.sdkuilib.internal.repository.LocalSdkAdapter;
import com.android.sdkuilib.internal.repository.RepoSourcesAdapter;
import com.android.sdkuilib.internal.repository.SettingsController;
import com.android.sdkuilib.internal.repository.UpdateChooserDialog;
import com.android.sdkuilib.internal.repository.UpdaterLogic;
import com.android.sdkuilib.internal.repository.icons.ImageFactory;
import com.android.sdkuilib.repository.UpdaterWindow;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UpdaterData {
    private String mOsSdkRoot;
    private final ISdkLog mSdkLog;
    private ITaskFactory mTaskFactory;
    private boolean mUserCanChangeSdkRoot;
    private SdkManager mSdkManager;
    private AvdManager mAvdManager;
    private final LocalSdkParser mLocalSdkParser = new LocalSdkParser();
    private final RepoSources mSources = new RepoSources();
    private final LocalSdkAdapter mLocalSdkAdapter = new LocalSdkAdapter(this);
    private final RepoSourcesAdapter mSourcesAdapter = new RepoSourcesAdapter(this);
    private ImageFactory mImageFactory;
    private final SettingsController mSettingsController;
    private final ArrayList<UpdaterWindow.ISdkListener> mListeners = new ArrayList();
    private Shell mWindowShell;
    private AndroidLocation.AndroidLocationException mAvdManagerInitError;

    public UpdaterData(String osSdkRoot, ISdkLog sdkLog) {
        this.mOsSdkRoot = osSdkRoot;
        this.mSdkLog = sdkLog;
        this.mSettingsController = new SettingsController(this);
        this.initSdk();
    }

    public String getOsSdkRoot() {
        return this.mOsSdkRoot;
    }

    public void setTaskFactory(ITaskFactory taskFactory) {
        this.mTaskFactory = taskFactory;
    }

    public ITaskFactory getTaskFactory() {
        return this.mTaskFactory;
    }

    public void setUserCanChangeSdkRoot(boolean userCanChangeSdkRoot) {
        this.mUserCanChangeSdkRoot = userCanChangeSdkRoot;
    }

    public boolean canUserChangeSdkRoot() {
        return this.mUserCanChangeSdkRoot;
    }

    public RepoSources getSources() {
        return this.mSources;
    }

    public RepoSourcesAdapter getSourcesAdapter() {
        return this.mSourcesAdapter;
    }

    public LocalSdkParser getLocalSdkParser() {
        return this.mLocalSdkParser;
    }

    public LocalSdkAdapter getLocalSdkAdapter() {
        return this.mLocalSdkAdapter;
    }

    public ISdkLog getSdkLog() {
        return this.mSdkLog;
    }

    public void setImageFactory(ImageFactory imageFactory) {
        this.mImageFactory = imageFactory;
    }

    public ImageFactory getImageFactory() {
        return this.mImageFactory;
    }

    public SdkManager getSdkManager() {
        return this.mSdkManager;
    }

    public AvdManager getAvdManager() {
        return this.mAvdManager;
    }

    public SettingsController getSettingsController() {
        return this.mSettingsController;
    }

    public void addListeners(UpdaterWindow.ISdkListener listener) {
        if (!this.mListeners.contains(listener)) {
            this.mListeners.add(listener);
        }
    }

    public void removeListener(UpdaterWindow.ISdkListener listener) {
        this.mListeners.remove(listener);
    }

    public void setWindowShell(Shell windowShell) {
        this.mWindowShell = windowShell;
    }

    public Shell getWindowShell() {
        return this.mWindowShell;
    }

    public boolean checkIfInitFailed() {
        if (this.mAvdManagerInitError != null) {
            String example = SdkConstants.currentPlatform() == 2 ? "%USERPROFILE%" : "~";
            String error = String.format("The AVD manager normally uses the user's profile directory to store AVD files. However it failed to find the default profile directory. \nTo fix this, please set the environment variable ANDROID_SDK_HOME to a valid path such as \"%s\".", example);
            if (this.mWindowShell != null) {
                MessageDialog.openError((Shell)this.mWindowShell, (String)"Android Virtual Devices Manager", (String)error);
            } else {
                this.mSdkLog.error(null, "%s", new Object[]{error});
            }
            return true;
        }
        return false;
    }

    private void initSdk() {
        this.mSdkManager = SdkManager.createManager((String)this.mOsSdkRoot, (ISdkLog)this.mSdkLog);
        try {
            this.mAvdManager = null;
            this.mAvdManager = new AvdManager(this.mSdkManager, this.mSdkLog);
        }
        catch (AndroidLocation.AndroidLocationException e) {
            this.mSdkLog.error((Throwable)e, "Unable to read AVDs: " + e.getMessage(), new Object[0]);
            this.mAvdManagerInitError = e;
        }
        this.notifyListeners(false);
    }

    public void reloadSdk() {
        this.mSdkManager.reloadSdk(this.mSdkLog);
        if (this.mAvdManager != null) {
            try {
                this.mAvdManager.reloadAvds(this.mSdkLog);
            }
            catch (AndroidLocation.AndroidLocationException androidLocationException) {
                // empty catch block
            }
        }
        this.mLocalSdkParser.clearPackages();
        this.notifyListeners(false);
    }

    public void reloadAvds() {
        if (this.mAvdManager != null) {
            try {
                this.mAvdManager.reloadAvds(this.mSdkLog);
            }
            catch (AndroidLocation.AndroidLocationException e) {
                this.mSdkLog.error((Throwable)e, null, new Object[0]);
            }
        }
    }

    public void setupDefaultSources() {
        RepoSource s;
        String[] urls;
        RepoSources sources = this.getSources();
        sources.add(new RepoSource("https://dl-ssl.google.com/android/repository/", false));
        String str = System.getenv("SDK_UPDATER_URLS");
        if (str != null) {
            for (String url : urls = str.split(";")) {
                if (url == null || url.length() <= 0 || sources.hasSource(s = new RepoSource(url, false))) continue;
                sources.add(s);
            }
        }
        sources.loadUserSources(this.getSdkLog());
        str = System.getenv("SDK_UPDATER_USER_URLS");
        if (str != null) {
            for (String url : urls = str.split(";")) {
                if (url == null || url.length() <= 0 || sources.hasSource(s = new RepoSource(url, true))) continue;
                sources.add(s);
            }
        }
    }

    public Package[] getInstalledPackage() {
        LocalSdkParser parser = this.getLocalSdkParser();
        Package[] packages = parser.getPackages();
        if (packages == null) {
            packages = parser.parseSdk(this.getOsSdkRoot(), this.getSdkManager(), this.getSdkLog());
        }
        return packages;
    }

    public void notifyListeners(final boolean init) {
        if (this.mWindowShell != null && this.mListeners.size() > 0) {
            this.mWindowShell.getDisplay().syncExec(new Runnable(){

                public void run() {
                    for (UpdaterWindow.ISdkListener listener : UpdaterData.this.mListeners) {
                        try {
                            listener.onSdkChange(init);
                        }
                        catch (Throwable t) {
                            UpdaterData.this.mSdkLog.error(t, null, new Object[0]);
                        }
                    }
                }
            });
        }
    }

    public void installArchives(final ArrayList<ArchiveInfo> result) {
        if (this.mTaskFactory == null) {
            throw new IllegalArgumentException("Task Factory is null");
        }
        final boolean forceHttp = this.getSettingsController().getForceHttp();
        this.mTaskFactory.start("Installing Archives", new ITask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(ITaskMonitor monitor) {
                int progressPerArchive = 200;
                monitor.setProgressMax(result.size() * 200);
                monitor.setDescription("Preparing to install archives", new Object[0]);
                boolean installedAddon = false;
                boolean installedTools = false;
                HashSet<Archive> installedArchives = new HashSet<Archive>();
                for (Package p : UpdaterData.this.getInstalledPackage()) {
                    for (Archive a : p.getArchives()) {
                        installedArchives.add(a);
                    }
                }
                int numInstalled = 0;
                block12: for (ArchiveInfo ai : result) {
                    Archive archive = ai.getNewArchive();
                    if (archive == null) continue;
                    int nextProgress = monitor.getProgress() + 200;
                    try {
                        if (monitor.isCancelRequested()) break;
                        ArchiveInfo[] adeps = ai.getDependsOn();
                        if (adeps != null) {
                            for (ArchiveInfo adep : adeps) {
                                Archive na = adep.getNewArchive();
                                if (na == null) {
                                    monitor.setResult("Skipping '%1$s'; it depends on a missing package.", new Object[]{archive.getParentPackage().getShortDescription()});
                                    continue block12;
                                }
                                if (installedArchives.contains(na)) continue;
                                monitor.setResult("Skipping '%1$s'; it depends on '%2$s' which was not installed.", new Object[]{archive.getParentPackage().getShortDescription(), adep.getShortDescription()});
                                continue block12;
                            }
                        }
                        if (!archive.install(UpdaterData.this.mOsSdkRoot, forceHttp, UpdaterData.this.mSdkManager, monitor)) continue;
                        installedArchives.add(archive);
                        ++numInstalled;
                        installedArchives.remove(ai.getReplaced());
                        if (archive.getParentPackage() instanceof AddonPackage) {
                            installedAddon = true;
                            continue;
                        }
                        if (!(archive.getParentPackage() instanceof ToolPackage)) continue;
                        installedTools = true;
                    }
                    catch (Throwable t) {
                        String msg = t.getMessage();
                        if (msg != null) {
                            msg = String.format("Unexpected Error installing '%1$s': %2$s: %3$s", archive.getParentPackage().getShortDescription(), t.getClass().getCanonicalName(), msg);
                        } else {
                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                            t.printStackTrace(new PrintStream(baos));
                            msg = String.format("Unexpected Error installing '%1$s'\n%2$s", archive.getParentPackage().getShortDescription(), baos.toString());
                        }
                        monitor.setResult(msg, new Object[0]);
                        UpdaterData.this.mSdkLog.error(t, msg, new Object[0]);
                    }
                    finally {
                        monitor.incProgress(nextProgress - monitor.getProgress());
                    }
                }
                if (installedAddon) {
                    try {
                        UpdaterData.this.mSdkManager.updateAdb();
                        monitor.setResult("Updated ADB to support the USB devices declared in the SDK add-ons.", new Object[0]);
                    }
                    catch (Exception e) {
                        UpdaterData.this.mSdkLog.error((Throwable)e, "Update ADB failed", new Object[0]);
                        monitor.setResult("failed to update adb to support the USB devices declared in the SDK add-ons.", new Object[0]);
                    }
                }
                if (installedAddon || installedTools) {
                    UpdaterData.this.askForAdbRestart(monitor);
                }
                if (installedTools) {
                    UpdaterData.this.notifyToolsNeedsToBeRestarted();
                }
                if (numInstalled == 0) {
                    monitor.setDescription("Done. Nothing was installed.", new Object[0]);
                } else {
                    monitor.setDescription("Done. %1$d %2$s installed.", new Object[]{numInstalled, numInstalled == 1 ? "package" : "packages"});
                    UpdaterData.this.reloadSdk();
                }
            }
        });
    }

    private void askForAdbRestart(ITaskMonitor monitor) {
        final boolean[] canRestart = new boolean[]{true};
        if (this.getWindowShell() != null && this.getSettingsController().getAskBeforeAdbRestart()) {
            Display display = this.getWindowShell().getDisplay();
            display.syncExec(new Runnable(){

                public void run() {
                    canRestart[0] = MessageDialog.openQuestion((Shell)UpdaterData.this.getWindowShell(), (String)"ADB Restart", (String)"A package that depends on ADB has been updated. It is recommended to restart ADB. Is it OK to do it now? If not, you can restart it manually later.");
                }
            });
        }
        if (canRestart[0]) {
            AdbWrapper adb = new AdbWrapper(this.getOsSdkRoot(), monitor);
            adb.stopAdb();
            adb.startAdb();
        }
    }

    private void notifyToolsNeedsToBeRestarted() {
        if (this.getWindowShell() == null) {
            return;
        }
        Display display = this.getWindowShell().getDisplay();
        display.syncExec(new Runnable(){

            public void run() {
                MessageDialog.openInformation((Shell)UpdaterData.this.getWindowShell(), (String)"Android Tools Updated", (String)"The Android SDK and AVD Manager that you are currently using has been updated. It is recommended that you now close the manager window and re-open it. If you started this window from Eclipse, please check if the Android plug-in needs to be updated.");
            }
        });
    }

    public void updateOrInstallAll_WithGUI(Collection<Archive> selectedArchives) {
        if (selectedArchives == null) {
            this.refreshSources(true);
        }
        UpdaterLogic ul = new UpdaterLogic();
        ArrayList<ArchiveInfo> archives = ul.computeUpdates(selectedArchives, this.getSources(), this.getLocalSdkParser().getPackages());
        if (selectedArchives == null) {
            ul.addNewPlatforms(archives, this.getSources(), this.getLocalSdkParser().getPackages());
        }
        UpdateChooserDialog dialog = new UpdateChooserDialog(this.getWindowShell(), this, archives);
        dialog.open();
        ArrayList<ArchiveInfo> result = dialog.getResult();
        if (result != null && result.size() > 0) {
            this.installArchives(result);
        }
    }

    public void updateOrInstallAll_NoGUI(Collection<String> pkgFilter, boolean includeObsoletes, boolean dryMode) {
        this.refreshSources(true);
        UpdaterLogic ul = new UpdaterLogic();
        ArrayList<ArchiveInfo> archives = ul.computeUpdates(null, this.getSources(), this.getLocalSdkParser().getPackages());
        ul.addNewPlatforms(archives, this.getSources(), this.getLocalSdkParser().getPackages());
        if (pkgFilter != null && pkgFilter.size() > 0 && archives != null && archives.size() > 0) {
            HashMap<String, Class> pkgMap = new HashMap<String, Class>();
            pkgMap.put("platform", PlatformPackage.class);
            pkgMap.put("add-on", AddonPackage.class);
            pkgMap.put("tool", ToolPackage.class);
            pkgMap.put("doc", DocPackage.class);
            pkgMap.put("sample", SamplePackage.class);
            pkgMap.put("extra", ExtraPackage.class);
            if (SdkRepository.NODES.length != pkgMap.size()) {
                this.mSdkLog.error(null, "Filter Mismatch!\nThe package filter list has changed. Please report this.", new Object[0]);
            }
            HashSet allowedPkgSet = new HashSet();
            for (String type : pkgFilter) {
                if (pkgMap.containsKey(type)) {
                    allowedPkgSet.add(pkgMap.get(type));
                    continue;
                }
                this.mSdkLog.error(null, "Ignoring unknown package filter '%1$s'", new Object[]{type});
            }
            pkgMap = null;
            Iterator<ArchiveInfo> it = archives.iterator();
            while (it.hasNext()) {
                Package p;
                boolean keep = false;
                ArchiveInfo ai = it.next();
                Archive a = ai.getNewArchive();
                if (a != null && (p = a.getParentPackage()) != null && allowedPkgSet.contains(p.getClass())) {
                    keep = true;
                }
                if (keep) continue;
                it.remove();
            }
            if (archives.size() == 0) {
                this.mSdkLog.warning("The package filter removed all packages. There is nothing to install.\nPlease consider trying updating again without a package filter.", new Object[0]);
                return;
            }
        }
        if (!includeObsoletes && archives != null && archives.size() > 0) {
            Iterator<ArchiveInfo> it = archives.iterator();
            while (it.hasNext()) {
                Package p;
                boolean keep = false;
                ArchiveInfo ai = it.next();
                Archive a = ai.getNewArchive();
                if (a != null && (p = a.getParentPackage()) != null && !p.isObsolete()) {
                    keep = true;
                }
                if (keep) continue;
                it.remove();
            }
            if (archives.size() == 0) {
                this.mSdkLog.warning("All candidate packages were obsolete. Nothing to install.", new Object[0]);
                return;
            }
        }
        if (archives != null && archives.size() > 0) {
            if (dryMode) {
                this.mSdkLog.printf("Packages selected for install:\n", new Object[0]);
                for (ArchiveInfo ai : archives) {
                    Package p;
                    Archive a = ai.getNewArchive();
                    if (a == null || (p = a.getParentPackage()) == null) continue;
                    this.mSdkLog.printf("- %1$s\n", new Object[]{p.getShortDescription()});
                }
                this.mSdkLog.printf("\nDry mode is on so nothing will actually be installed.\n", new Object[0]);
            } else {
                this.installArchives(archives);
            }
        } else {
            this.mSdkLog.printf("There is nothing to install or update.\n", new Object[0]);
        }
    }

    public void refreshSources(final boolean forceFetching) {
        assert (this.mTaskFactory != null);
        final boolean forceHttp = this.getSettingsController().getForceHttp();
        this.mTaskFactory.start("Refresh Sources", new ITask(){

            public void run(ITaskMonitor monitor) {
                RepoSource[] sources = UpdaterData.this.mSources.getSources();
                monitor.setProgressMax(sources.length);
                for (RepoSource source : sources) {
                    if (forceFetching || source.getPackages() != null || source.getFetchError() != null) {
                        source.load(monitor.createSubMonitor(1), forceHttp);
                    }
                    monitor.incProgress(1);
                }
            }
        });
    }
}

