/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.repository;

import com.android.sdklib.internal.repository.Archive;
import com.android.sdklib.internal.repository.IDescription;
import com.android.sdklib.internal.repository.Package;
import com.android.sdklib.internal.repository.RepoSource;
import com.android.sdkuilib.internal.repository.RepoSourcesAdapter;
import com.android.sdkuilib.internal.repository.SettingsController;
import com.android.sdkuilib.internal.repository.UpdaterData;
import com.android.sdkuilib.repository.UpdaterWindow;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class RemotePackagesPage
extends Composite
implements UpdaterWindow.ISdkListener {
    private final UpdaterData mUpdaterData;
    private CheckboxTreeViewer mTreeViewerSources;
    private Tree mTreeSources;
    private TreeColumn mColumnSource;
    private Button mUpdateOnlyCheckBox;
    private Group mDescriptionContainer;
    private Button mAddSiteButton;
    private Button mDeleteSiteButton;
    private Button mRefreshButton;
    private Button mInstallSelectedButton;
    private Label mDescriptionLabel;

    RemotePackagesPage(Composite parent, UpdaterData updaterData) {
        super(parent, 2048);
        this.mUpdaterData = updaterData;
        this.createContents(this);
        this.postCreate();
    }

    private void createContents(Composite parent) {
        parent.setLayout((Layout)new GridLayout(5, false));
        this.mTreeViewerSources = new CheckboxTreeViewer(parent, 2048);
        this.mTreeViewerSources.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                RemotePackagesPage.this.onTreeCheckStateChanged(event);
            }
        });
        this.mTreeSources = this.mTreeViewerSources.getTree();
        this.mTreeSources.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RemotePackagesPage.this.onTreeSelected();
            }
        });
        this.mTreeSources.setHeaderVisible(true);
        this.mTreeSources.setLayoutData((Object)new GridData(4, 4, true, true, 5, 1));
        this.mColumnSource = new TreeColumn(this.mTreeSources, 0);
        this.mColumnSource.setWidth(289);
        this.mColumnSource.setText("Sites, Packages and Archives");
        this.mDescriptionContainer = new Group(parent, 0);
        this.mDescriptionContainer.setLayout((Layout)new GridLayout(1, false));
        this.mDescriptionContainer.setText("Description");
        this.mDescriptionContainer.setLayoutData((Object)new GridData(4, 4, false, false, 5, 1));
        this.mDescriptionLabel = new Label((Composite)this.mDescriptionContainer, 0);
        this.mDescriptionLabel.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.mDescriptionLabel.setText("Line1\nLine2\nLine3");
        this.mAddSiteButton = new Button(parent, 0);
        this.mAddSiteButton.setText("Add Add-on Site...");
        this.mAddSiteButton.setToolTipText("Allows you to enter a new add-on site. Such site can only contribute add-ons and extra packages.");
        this.mAddSiteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RemotePackagesPage.this.onAddSiteSelected();
            }
        });
        this.mDeleteSiteButton = new Button(parent, 0);
        this.mDeleteSiteButton.setText("Delete Add-on Site...");
        this.mDeleteSiteButton.setToolTipText("Allows you to remove an add-on site. Built-in default sites cannot be removed.");
        this.mDeleteSiteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RemotePackagesPage.this.onRemoveSiteSelected();
            }
        });
        this.mUpdateOnlyCheckBox = new Button(parent, 32);
        this.mUpdateOnlyCheckBox.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false, 1, 1));
        this.mUpdateOnlyCheckBox.setText("Display updates only");
        this.mUpdateOnlyCheckBox.setToolTipText("When selected, only compatible update packages are shown in the list above.");
        this.mUpdateOnlyCheckBox.setSelection(this.mUpdaterData.getSettingsController().getShowUpdateOnly());
        this.mUpdateOnlyCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                RemotePackagesPage.this.onShowUpdateOnly();
            }
        });
        this.mRefreshButton = new Button(parent, 0);
        this.mRefreshButton.setText("Refresh");
        this.mRefreshButton.setToolTipText("Refreshes the list of packages from open sites.");
        this.mRefreshButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RemotePackagesPage.this.onRefreshSelected();
            }
        });
        this.mInstallSelectedButton = new Button(parent, 0);
        this.mInstallSelectedButton.setText("Install Selected");
        this.mInstallSelectedButton.setToolTipText("Allows you to review all selected packages and install them.");
        this.mInstallSelectedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RemotePackagesPage.this.onInstallSelectedArchives();
            }
        });
    }

    public void dispose() {
        this.mUpdaterData.removeListener(this);
        super.dispose();
    }

    protected void checkSubclass() {
    }

    private void postCreate() {
        this.mUpdaterData.addListeners(this);
        this.adjustColumnsWidth();
        this.updateButtonsState();
    }

    private void adjustColumnsWidth() {
        ControlAdapter resizer = new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = RemotePackagesPage.this.mTreeSources.getClientArea();
                RemotePackagesPage.this.mColumnSource.setWidth(r.width);
            }
        };
        this.mTreeSources.addControlListener((ControlListener)resizer);
        resizer.controlResized(null);
    }

    private void onTreeSelected() {
        Object elem;
        this.updateButtonsState();
        ISelection sel = this.mTreeViewerSources.getSelection();
        if (sel instanceof ITreeSelection && (elem = ((ITreeSelection)sel).getFirstElement()) instanceof IDescription) {
            this.mDescriptionLabel.setText(((IDescription)elem).getLongDescription());
            this.mDescriptionContainer.layout(true);
            return;
        }
        this.mDescriptionLabel.setText("");
    }

    private void onTreeCheckStateChanged(CheckStateChangedEvent event) {
        this.updateButtonsState();
        boolean b = event.getChecked();
        Object elem = event.getElement();
        assert (event.getSource() == this.mTreeViewerSources);
        if (!b) {
            this.mTreeViewerSources.setSubtreeChecked(elem, b);
            return;
        }
        ITreeContentProvider provider = (ITreeContentProvider)this.mTreeViewerSources.getContentProvider();
        if (elem instanceof RepoSource) {
            this.mTreeViewerSources.setExpandedState(elem, true);
            for (Object pkg : provider.getChildren(elem)) {
                this.mTreeViewerSources.setChecked(pkg, true);
                this.selectCompatibleArchives(pkg, provider);
            }
        } else if (elem instanceof Package) {
            this.selectCompatibleArchives(elem, provider);
        }
    }

    private void selectCompatibleArchives(Object pkg, ITreeContentProvider provider) {
        for (Object archive : provider.getChildren(pkg)) {
            if (!(archive instanceof Archive)) continue;
            this.mTreeViewerSources.setChecked(archive, ((Archive)archive).isCompatible());
        }
    }

    private void onShowUpdateOnly() {
        SettingsController controller = this.mUpdaterData.getSettingsController();
        controller.setShowUpdateOnly(this.mUpdateOnlyCheckBox.getSelection());
        controller.saveSettings();
        ArrayList<Archive> archives = new ArrayList<Archive>();
        for (Object element : this.mTreeViewerSources.getCheckedElements()) {
            if (element instanceof Archive) {
                archives.add((Archive)element);
            }
            this.mTreeViewerSources.setChecked(element, false);
        }
        this.mTreeViewerSources.refresh();
        for (Archive a : archives) {
            if (!a.isCompatible() || !this.mTreeViewerSources.setChecked((Object)a, true)) continue;
            this.mTreeViewerSources.setChecked((Object)a.getParentPackage(), true);
        }
        this.updateButtonsState();
    }

    private void onInstallSelectedArchives() {
        ArrayList<Archive> archives = new ArrayList<Archive>();
        for (Object element : this.mTreeViewerSources.getCheckedElements()) {
            if (!(element instanceof Archive)) continue;
            archives.add((Archive)element);
        }
        if (this.mUpdaterData != null) {
            this.mUpdaterData.updateOrInstallAll_WithGUI(archives);
        }
    }

    private void onAddSiteSelected() {
        final RepoSource[] knowSources = this.mUpdaterData.getSources().getSources();
        String title = "Add Add-on Site URL";
        String msg = "This dialog lets you add the URL of a new add-on site.\n\nAn add-on site can only provide new add-ons or \"user\" packages.\nAdd-on sites cannot provide standard Android platforms, docs or samples packages.\nInserting a URL here will not allow you to clone an official Android repository.\n\nPlease enter the URL of the repository.xml for the new add-on site:";
        InputDialog dlg = new InputDialog(this.getShell(), title, msg, null, new IInputValidator(){

            public String isValid(String newText) {
                if (newText == null || newText.length() == 0) {
                    return "Error: URL field is empty. Please enter a URL.";
                }
                if (!(newText.startsWith("file://") || newText.startsWith("ftp://") || newText.startsWith("http://") || newText.startsWith("https://"))) {
                    return "Error: The URL must start by one of file://, ftp://, http:// or https://";
                }
                for (RepoSource s : knowSources) {
                    if (!newText.equalsIgnoreCase(s.getUrl())) continue;
                    return "Error : This site is already listed.";
                }
                return null;
            }
        });
        if (dlg.open() == 0) {
            String url = dlg.getValue();
            this.mUpdaterData.getSources().add(new RepoSource(url, true));
            this.onRefreshSelected();
        }
    }

    private void onRemoveSiteSelected() {
        boolean changed = false;
        ISelection sel = this.mTreeViewerSources.getSelection();
        if (this.mUpdaterData != null && sel instanceof ITreeSelection) {
            for (Object c : ((ITreeSelection)sel).toList()) {
                if (!(c instanceof RepoSource) || !((RepoSource)c).isUserSource()) continue;
                RepoSource source = (RepoSource)c;
                String title = "Delete Add-on Site?";
                String msg = String.format("Are you sure you want to delete the add-on site '%1$s'?", source.getUrl());
                if (!MessageDialog.openQuestion((Shell)this.getShell(), (String)title, (String)msg)) continue;
                this.mUpdaterData.getSources().remove(source);
                changed = true;
            }
        }
        if (changed) {
            this.onRefreshSelected();
        }
    }

    private void onRefreshSelected() {
        if (this.mUpdaterData != null) {
            this.mUpdaterData.refreshSources(false);
        }
        this.mTreeViewerSources.refresh();
        this.updateButtonsState();
    }

    public void onSdkChange(boolean init) {
        RepoSourcesAdapter sources = this.mUpdaterData.getSourcesAdapter();
        this.mTreeViewerSources.setContentProvider(sources.getContentProvider());
        this.mTreeViewerSources.setLabelProvider((IBaseLabelProvider)sources.getLabelProvider());
        this.mTreeViewerSources.setInput((Object)sources);
        this.onTreeSelected();
    }

    private void updateButtonsState() {
        boolean hasCheckedArchive = false;
        Object[] checked = this.mTreeViewerSources.getCheckedElements();
        if (checked != null) {
            for (Object c : checked) {
                if (!(c instanceof Archive)) continue;
                hasCheckedArchive = true;
                break;
            }
        }
        boolean hasSelectedUserSource = false;
        ISelection sel = this.mTreeViewerSources.getSelection();
        if (sel instanceof ITreeSelection) {
            for (Object c : ((ITreeSelection)sel).toList()) {
                if (!(c instanceof RepoSource) || !((RepoSource)c).isUserSource()) continue;
                hasSelectedUserSource = true;
                break;
            }
        }
        this.mAddSiteButton.setEnabled(true);
        this.mDeleteSiteButton.setEnabled(hasSelectedUserSource);
        this.mRefreshButton.setEnabled(true);
        this.mInstallSelectedButton.setEnabled(hasCheckedArchive);
        this.mUpdateOnlyCheckBox.setSelection(this.mUpdaterData.getSettingsController().getShowUpdateOnly());
    }
}

