/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.repository;

import com.android.sdklib.internal.repository.Archive;
import com.android.sdklib.internal.repository.IDescription;
import com.android.sdklib.internal.repository.Package;
import com.android.sdkuilib.internal.repository.LocalSdkAdapter;
import com.android.sdkuilib.internal.repository.UpdaterData;
import com.android.sdkuilib.repository.UpdaterWindow;
import java.io.File;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class LocalPackagesPage
extends Composite
implements UpdaterWindow.ISdkListener {
    private final UpdaterData mUpdaterData;
    private Label mSdkLocLabel;
    private Text mSdkLocText;
    private Button mSdkLocBrowse;
    private TableViewer mTableViewerPackages;
    private Table mTablePackages;
    private TableColumn mColumnPackages;
    private Group mDescriptionContainer;
    private Composite mContainerButtons;
    private Button mUpdateButton;
    private Label mPlaceholder1;
    private Button mDeleteButton;
    private Label mPlaceholder2;
    private Button mRefreshButton;
    private Label mDescriptionLabel;

    public LocalPackagesPage(Composite parent, UpdaterData updaterData) {
        super(parent, 2048);
        this.mUpdaterData = updaterData;
        this.createContents(this);
        this.postCreate();
    }

    private void createContents(Composite parent) {
        parent.setLayout((Layout)new GridLayout(3, false));
        this.createSdkLocation(parent);
        this.mTableViewerPackages = new TableViewer(parent, 67584);
        this.mTablePackages = this.mTableViewerPackages.getTable();
        this.mTablePackages.setHeaderVisible(true);
        this.mTablePackages.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.mTablePackages.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LocalPackagesPage.this.onTreeSelected();
            }
        });
        this.mColumnPackages = new TableColumn(this.mTablePackages, 0);
        this.mColumnPackages.setWidth(377);
        this.mColumnPackages.setText("Installed Packages");
        this.mDescriptionContainer = new Group(parent, 0);
        this.mDescriptionContainer.setLayout((Layout)new GridLayout(1, false));
        this.mDescriptionContainer.setText("Description");
        this.mDescriptionContainer.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
        this.mDescriptionLabel = new Label((Composite)this.mDescriptionContainer, 0);
        this.mDescriptionLabel.setLayoutData((Object)new GridData(4, 128, true, true, 1, 1));
        this.mDescriptionLabel.setText("Line1\nLine2\nLine3");
        this.mContainerButtons = new Composite(parent, 0);
        this.mContainerButtons.setLayout((Layout)new GridLayout(5, false));
        this.mContainerButtons.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.mUpdateButton = new Button(this.mContainerButtons, 0);
        this.mUpdateButton.setText("Update All...");
        this.mUpdateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LocalPackagesPage.this.onUpdateSelected();
            }
        });
        this.mPlaceholder1 = new Label(this.mContainerButtons, 0);
        this.mPlaceholder1.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.mDeleteButton = new Button(this.mContainerButtons, 0);
        this.mDeleteButton.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
        this.mDeleteButton.setText("Delete...");
        this.mDeleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LocalPackagesPage.this.onDeleteSelected();
            }
        });
        this.mPlaceholder2 = new Label(this.mContainerButtons, 0);
        this.mPlaceholder2.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.mRefreshButton = new Button(this.mContainerButtons, 0);
        this.mRefreshButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.mRefreshButton.setText("Refresh");
        this.mRefreshButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LocalPackagesPage.this.onRefreshSelected();
            }
        });
    }

    private void createSdkLocation(Composite parent) {
        this.mSdkLocLabel = new Label(parent, 0);
        this.mSdkLocLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.mSdkLocLabel.setText("SDK Location:");
        this.mSdkLocText = new Text(parent, 2048);
        this.mSdkLocText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        if (this.mUpdaterData.canUserChangeSdkRoot()) {
            this.mSdkLocBrowse = new Button(parent, 0);
            this.mSdkLocBrowse.setText("Browse...");
        } else {
            this.mSdkLocText.setEditable(false);
            ++((GridData)this.mSdkLocText.getLayoutData()).horizontalSpan;
        }
        if (this.mUpdaterData.getOsSdkRoot() != null) {
            this.mSdkLocText.setText(this.mUpdaterData.getOsSdkRoot());
        }
    }

    public void dispose() {
        this.mUpdaterData.removeListener(this);
        super.dispose();
    }

    protected void checkSubclass() {
    }

    private void postCreate() {
        this.mUpdaterData.addListeners(this);
        this.adjustColumnsWidth();
        this.updateButtonsState();
    }

    private void adjustColumnsWidth() {
        ControlAdapter resizer = new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = LocalPackagesPage.this.mTablePackages.getClientArea();
                LocalPackagesPage.this.mColumnPackages.setWidth(r.width);
            }
        };
        this.mTablePackages.addControlListener((ControlListener)resizer);
        resizer.controlResized(null);
    }

    private void updateButtonsState() {
        ISelection sel = this.mTableViewerPackages.getSelection();
        boolean hasSelection = sel != null && !sel.isEmpty();
        this.mUpdateButton.setEnabled(this.mTablePackages.getItemCount() > 0);
        this.mDeleteButton.setEnabled(hasSelection);
        this.mRefreshButton.setEnabled(true);
    }

    private void onTreeSelected() {
        Object elem;
        this.updateButtonsState();
        ISelection sel = this.mTableViewerPackages.getSelection();
        if (sel instanceof IStructuredSelection && (elem = ((IStructuredSelection)sel).getFirstElement()) instanceof IDescription) {
            this.mDescriptionLabel.setText(((IDescription)elem).getLongDescription());
            this.mDescriptionContainer.layout(true);
            return;
        }
        this.mDescriptionLabel.setText("");
    }

    private void onUpdateSelected() {
        this.mUpdaterData.updateOrInstallAll_WithGUI(null);
    }

    private void onDeleteSelected() {
        Object elem;
        ISelection sel = this.mTableViewerPackages.getSelection();
        if (sel instanceof IStructuredSelection && (elem = ((IStructuredSelection)sel).getFirstElement()) instanceof Package) {
            String title = "Delete SDK Package";
            String error = null;
            Package p = (Package)elem;
            Archive[] archives = p.getArchives();
            if (archives.length == 1 && archives[0] != null && archives[0].isLocal()) {
                Archive archive = archives[0];
                String osPath = archive.getLocalOsPath();
                File dir = new File(osPath);
                if (dir.isDirectory()) {
                    String msg = String.format("Are you sure you want to delete '%1$s' at '%2$s'? This cannot be undone.", p.getShortDescription(), osPath);
                    if (MessageDialog.openQuestion((Shell)this.getShell(), (String)title, (String)msg)) {
                        archive.deleteLocal();
                        this.onRefreshSelected();
                    }
                } else {
                    error = "Directory not found for this package";
                }
            } else {
                error = "No local archive found for this package";
            }
            if (error != null) {
                MessageDialog.openError((Shell)this.getShell(), (String)title, (String)error);
            }
            return;
        }
    }

    private void onRefreshSelected() {
        this.mUpdaterData.reloadSdk();
        this.updateButtonsState();
    }

    public void onSdkChange(boolean init) {
        LocalSdkAdapter localSdkAdapter = this.mUpdaterData.getLocalSdkAdapter();
        this.mTableViewerPackages.setLabelProvider((IBaseLabelProvider)localSdkAdapter.getLabelProvider());
        this.mTableViewerPackages.setContentProvider(localSdkAdapter.getContentProvider());
        this.mTableViewerPackages.setInput((Object)localSdkAdapter);
        this.onTreeSelected();
    }
}

