/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkmanager;

import com.android.sdklib.ISdkLog;
import com.android.sdklib.repository.SdkRepository;
import com.android.sdkmanager.CommandLineProcessor;
import java.util.Arrays;

class SdkCommandLine
extends CommandLineProcessor {
    public static final String VERB_LIST = "list";
    public static final String VERB_CREATE = "create";
    public static final String VERB_MOVE = "move";
    public static final String VERB_DELETE = "delete";
    public static final String VERB_UPDATE = "update";
    public static final String OBJECT_SDK = "sdk";
    public static final String OBJECT_AVD = "avd";
    public static final String OBJECT_AVDS = "avds";
    public static final String OBJECT_TARGET = "target";
    public static final String OBJECT_TARGETS = "targets";
    public static final String OBJECT_PROJECT = "project";
    public static final String OBJECT_TEST_PROJECT = "test-project";
    public static final String OBJECT_LIB_PROJECT = "lib-project";
    public static final String OBJECT_EXPORT_PROJECT = "export-project";
    public static final String OBJECT_ADB = "adb";
    public static final String ARG_ALIAS = "alias";
    public static final String ARG_ACTIVITY = "activity";
    public static final String KEY_ACTIVITY = "activity";
    public static final String KEY_PACKAGE = "package";
    public static final String KEY_MODE = "mode";
    public static final String KEY_TARGET_ID = "target";
    public static final String KEY_NAME = "name";
    public static final String KEY_LIBRARY = "library";
    public static final String KEY_PATH = "path";
    public static final String KEY_FILTER = "filter";
    public static final String KEY_SKIN = "skin";
    public static final String KEY_SDCARD = "sdcard";
    public static final String KEY_FORCE = "force";
    public static final String KEY_RENAME = "rename";
    public static final String KEY_SUBPROJECTS = "subprojects";
    public static final String KEY_MAIN_PROJECT = "main";
    public static final String KEY_NO_UI = "no-ui";
    public static final String KEY_NO_HTTPS = "no-https";
    public static final String KEY_DRY_MODE = "dry-mode";
    public static final String KEY_OBSOLETE = "obsolete";
    private static final String[][] ACTIONS = new String[][]{{"list", "", "Lists existing targets or virtual devices."}, {"list", "avd", "Lists existing Android Virtual Devices.", "avds"}, {"list", "target", "Lists existing targets.", "targets"}, {"create", "avd", "Creates a new Android Virtual Device."}, {"move", "avd", "Moves or renames an Android Virtual Device."}, {"delete", "avd", "Deletes an Android Virtual Device."}, {"update", "avd", "Updates an Android Virtual Device to match the folders of a new SDK."}, {"create", "project", "Creates a new Android Project."}, {"update", "project", "Updates an Android Project (must have an AndroidManifest.xml)."}, {"create", "test-project", "Creates a new Android Test Project."}, {"update", "test-project", "Updates an Android Test Project (must have an AndroidManifest.xml)."}, {"create", "lib-project", "Creates a new Android Library Project."}, {"update", "lib-project", "Updates an Android Library Project (must have an AndroidManifest.xml)."}, {"update", "adb", "Updates adb to support the USB devices declared in the SDK add-ons."}, {"update", "sdk", "Updates the SDK by suggesting new platforms to install if available."}};

    public SdkCommandLine(ISdkLog logger) {
        super(logger, ACTIONS);
        this.define(CommandLineProcessor.Mode.STRING, false, VERB_CREATE, OBJECT_AVD, "p", KEY_PATH, "Location path of the directory where the new AVD will be created", null);
        this.define(CommandLineProcessor.Mode.STRING, true, VERB_CREATE, OBJECT_AVD, "n", KEY_NAME, "Name of the new AVD", null);
        this.define(CommandLineProcessor.Mode.STRING, true, VERB_CREATE, OBJECT_AVD, "t", "target", "Target id of the new AVD", null);
        this.define(CommandLineProcessor.Mode.STRING, false, VERB_CREATE, OBJECT_AVD, "s", KEY_SKIN, "Skin of the new AVD", null);
        this.define(CommandLineProcessor.Mode.STRING, false, VERB_CREATE, OBJECT_AVD, "c", KEY_SDCARD, "Path to a shared SD card image, or size of a new sdcard for the new AVD", null);
        this.define(CommandLineProcessor.Mode.BOOLEAN, false, VERB_CREATE, OBJECT_AVD, "f", KEY_FORCE, "Force creation (override an existing AVD)", false);
        this.define(CommandLineProcessor.Mode.STRING, true, VERB_DELETE, OBJECT_AVD, "n", KEY_NAME, "Name of the AVD to delete", null);
        this.define(CommandLineProcessor.Mode.STRING, true, VERB_MOVE, OBJECT_AVD, "n", KEY_NAME, "Name of the AVD to move or rename", null);
        this.define(CommandLineProcessor.Mode.STRING, false, VERB_MOVE, OBJECT_AVD, "r", KEY_RENAME, "New name of the AVD to rename", null);
        this.define(CommandLineProcessor.Mode.STRING, false, VERB_MOVE, OBJECT_AVD, "p", KEY_PATH, "New location path of the directory where to move the AVD", null);
        this.define(CommandLineProcessor.Mode.STRING, true, VERB_UPDATE, OBJECT_AVD, "n", KEY_NAME, "Name of the AVD to update", null);
        this.define(CommandLineProcessor.Mode.BOOLEAN, false, VERB_UPDATE, OBJECT_SDK, "u", KEY_NO_UI, "Update from command-line, without any UI", false);
        this.define(CommandLineProcessor.Mode.BOOLEAN, false, VERB_UPDATE, OBJECT_SDK, "s", KEY_NO_HTTPS, "Use HTTP instead of the default HTTPS for downloads", false);
        this.define(CommandLineProcessor.Mode.BOOLEAN, false, VERB_UPDATE, OBJECT_SDK, "f", KEY_FORCE, "Force replacing things that have been modified (samples, adb)", false);
        this.define(CommandLineProcessor.Mode.STRING, false, VERB_UPDATE, OBJECT_SDK, "t", KEY_FILTER, "A coma-separated list of " + Arrays.toString(SdkRepository.NODES) + " to limit update to specified types of packages", null);
        this.define(CommandLineProcessor.Mode.BOOLEAN, false, VERB_UPDATE, OBJECT_SDK, "o", KEY_OBSOLETE, "Install obsolete packages", false);
        this.define(CommandLineProcessor.Mode.BOOLEAN, false, VERB_UPDATE, OBJECT_SDK, "n", KEY_DRY_MODE, "Only simulates what would be updated but does not download/install anything", false);
        this.define(CommandLineProcessor.Mode.STRING, true, VERB_CREATE, OBJECT_PROJECT, "p", KEY_PATH, "Location path of new project", null);
        this.define(CommandLineProcessor.Mode.STRING, true, VERB_CREATE, OBJECT_PROJECT, "t", "target", "Target id of the new project", null);
        this.define(CommandLineProcessor.Mode.STRING, true, VERB_CREATE, OBJECT_PROJECT, "k", KEY_PACKAGE, "Package name", null);
        this.define(CommandLineProcessor.Mode.STRING, true, VERB_CREATE, OBJECT_PROJECT, "a", "activity", "Activity name", null);
        this.define(CommandLineProcessor.Mode.STRING, false, VERB_CREATE, OBJECT_PROJECT, "n", KEY_NAME, "Project name", null);
        this.define(CommandLineProcessor.Mode.STRING, true, VERB_CREATE, OBJECT_TEST_PROJECT, "p", KEY_PATH, "Location path of new project", null);
        this.define(CommandLineProcessor.Mode.STRING, false, VERB_CREATE, OBJECT_TEST_PROJECT, "n", KEY_NAME, "Project name", null);
        this.define(CommandLineProcessor.Mode.STRING, true, VERB_CREATE, OBJECT_TEST_PROJECT, "m", KEY_MAIN_PROJECT, "Location path of the project to test, relative to the new project", null);
        this.define(CommandLineProcessor.Mode.STRING, true, VERB_CREATE, OBJECT_LIB_PROJECT, "p", KEY_PATH, "Location path of new project", null);
        this.define(CommandLineProcessor.Mode.STRING, true, VERB_CREATE, OBJECT_LIB_PROJECT, "t", "target", "Target id of the new project", null);
        this.define(CommandLineProcessor.Mode.STRING, false, VERB_CREATE, OBJECT_LIB_PROJECT, "n", KEY_NAME, "Project name", null);
        this.define(CommandLineProcessor.Mode.STRING, true, VERB_CREATE, OBJECT_LIB_PROJECT, "k", KEY_PACKAGE, "Package name", null);
        this.define(CommandLineProcessor.Mode.STRING, true, VERB_UPDATE, OBJECT_PROJECT, "p", KEY_PATH, "Location path of the project", null);
        this.define(CommandLineProcessor.Mode.STRING, false, VERB_UPDATE, OBJECT_PROJECT, "t", "target", "Target id to set for the project", null);
        this.define(CommandLineProcessor.Mode.STRING, false, VERB_UPDATE, OBJECT_PROJECT, "n", KEY_NAME, "Project name", null);
        this.define(CommandLineProcessor.Mode.BOOLEAN, false, VERB_UPDATE, OBJECT_PROJECT, "s", KEY_SUBPROJECTS, "Also update any projects in sub-folders, such as test projects.", false);
        this.define(CommandLineProcessor.Mode.STRING, false, VERB_UPDATE, OBJECT_PROJECT, "l", KEY_LIBRARY, "Location path of an Android Library to add, relative to the main project", null);
        this.define(CommandLineProcessor.Mode.STRING, true, VERB_UPDATE, OBJECT_TEST_PROJECT, "p", KEY_PATH, "Location path of the project", null);
        this.define(CommandLineProcessor.Mode.STRING, true, VERB_UPDATE, OBJECT_TEST_PROJECT, "m", KEY_MAIN_PROJECT, "Location path of the project to test, relative to the new project", null);
        this.define(CommandLineProcessor.Mode.STRING, true, VERB_UPDATE, OBJECT_LIB_PROJECT, "p", KEY_PATH, "Location path of the project", null);
        this.define(CommandLineProcessor.Mode.STRING, false, VERB_UPDATE, OBJECT_LIB_PROJECT, "t", "target", "Target id to set for the project", null);
    }

    public boolean acceptLackOfVerb() {
        return true;
    }

    public String getParamLocationPath() {
        return (String)this.getValue(null, null, KEY_PATH);
    }

    public String getParamTargetId() {
        return (String)this.getValue(null, null, "target");
    }

    public String getParamName() {
        return (String)this.getValue(null, null, KEY_NAME);
    }

    public String getParamSkin() {
        return (String)this.getValue(null, null, KEY_SKIN);
    }

    public String getParamSdCard() {
        return (String)this.getValue(null, null, KEY_SDCARD);
    }

    public boolean getFlagForce() {
        return (Boolean)this.getValue(null, null, KEY_FORCE);
    }

    public String getParamMoveNewName() {
        return (String)this.getValue(VERB_MOVE, null, KEY_RENAME);
    }

    public String getParamProjectPackage(String directObject) {
        return (String)this.getValue(null, directObject, KEY_PACKAGE);
    }

    public String getParamProjectActivity() {
        return (String)this.getValue(null, OBJECT_PROJECT, "activity");
    }

    public String getParamProjectLibrary(String directObject) {
        return (String)this.getValue(null, directObject, KEY_LIBRARY);
    }

    public boolean getParamSubProject() {
        return (Boolean)this.getValue(null, OBJECT_PROJECT, KEY_SUBPROJECTS);
    }

    public String getParamTestProjectMain() {
        return (String)this.getValue(null, null, KEY_MAIN_PROJECT);
    }

    public boolean getFlagNoUI() {
        return (Boolean)this.getValue(null, null, KEY_NO_UI);
    }

    public boolean getFlagNoHttps() {
        return (Boolean)this.getValue(null, null, KEY_NO_HTTPS);
    }

    public boolean getFlagDryMode() {
        return (Boolean)this.getValue(null, null, KEY_DRY_MODE);
    }

    public boolean getFlagObsolete() {
        return (Boolean)this.getValue(null, null, KEY_OBSOLETE);
    }

    public String getParamFilter() {
        return (String)this.getValue(null, null, KEY_FILTER);
    }
}

