/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository;

import com.android.sdklib.SdkConstants;
import com.android.sdklib.SdkManager;
import com.android.sdklib.internal.repository.Archive;
import com.android.sdklib.internal.repository.ITaskMonitor;
import com.android.sdklib.internal.repository.Package;
import com.android.sdklib.internal.repository.RepoSource;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolPackage
extends Package {
    ToolPackage(RepoSource source, Node packageNode, Map<String, String> licenses) {
        super(source, packageNode, licenses);
    }

    ToolPackage(RepoSource source, Properties props, int revision, String license, String description, String descUrl, Archive.Os archiveOs, Archive.Arch archiveArch, String archiveOsPath) {
        super(source, props, revision, license, description, descUrl, archiveOs, archiveArch, archiveOsPath);
    }

    @Override
    public String getShortDescription() {
        return String.format("Android SDK Tools, revision %1$d%2$s", this.getRevision(), this.isObsolete() ? " (Obsolete)" : "");
    }

    @Override
    public String getLongDescription() {
        String s = this.getDescription();
        if (s == null || s.length() == 0) {
            s = this.getShortDescription();
        }
        if (s.indexOf("revision") == -1) {
            s = s + String.format("\nRevision %1$d%2$s", this.getRevision(), this.isObsolete() ? " (Obsolete)" : "");
        }
        return s;
    }

    @Override
    public File getInstallFolder(String osSdkRoot, String suggestedDir, SdkManager sdkManager) {
        return new File(osSdkRoot, "tools");
    }

    @Override
    public boolean sameItemAs(Package pkg) {
        return pkg instanceof ToolPackage;
    }

    @Override
    public void postInstallHook(Archive archive, ITaskMonitor monitor, File installFolder) {
        super.postInstallHook(archive, monitor, installFolder);
        if (installFolder == null) {
            return;
        }
        File libDir = new File(installFolder, "lib");
        if (!libDir.isDirectory()) {
            return;
        }
        String scriptName = "post_tools_install";
        String shell = "";
        if (SdkConstants.currentPlatform() == 2) {
            shell = "cmd.exe /c ";
            scriptName = scriptName + ".bat";
        } else {
            scriptName = scriptName + ".sh";
        }
        File scriptFile = new File(libDir, scriptName);
        if (!scriptFile.isFile()) {
            return;
        }
        int status = -1;
        try {
            Process proc = Runtime.getRuntime().exec(shell + scriptName, null, libDir);
            status = this.grabProcessOutput(proc, monitor, scriptName);
        }
        catch (Exception e) {
            monitor.setResult("Exception: %s", e.toString());
        }
        if (status != 0) {
            monitor.setResult("Failed to execute %s", scriptName);
            return;
        }
    }

    private int grabProcessOutput(final Process process, final ITaskMonitor monitor, final String scriptName) throws InterruptedException {
        Thread t1 = new Thread(""){

            public void run() {
                InputStreamReader is = new InputStreamReader(process.getErrorStream());
                BufferedReader errReader = new BufferedReader(is);
                try {
                    String line;
                    while ((line = errReader.readLine()) != null) {
                        monitor.setResult("[%1$s] Error: %2$s", scriptName, line);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        Thread t2 = new Thread(""){

            public void run() {
                InputStreamReader is = new InputStreamReader(process.getInputStream());
                BufferedReader outReader = new BufferedReader(is);
                try {
                    String line;
                    while ((line = outReader.readLine()) != null) {
                        monitor.setResult("[%1$s] %2$s", scriptName, line);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        t1.start();
        t2.start();
        return process.waitFor();
    }
}

