/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.project;

import com.android.sdklib.internal.project.ProjectProperties;
import com.android.sdklib.internal.project.ProjectPropertiesWorkingCopy;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApkSettings {
    private static final char CHAR_EQUAL = ':';
    private static final char CHAR_SEP = '|';
    private static final String STR_SEP = Pattern.quote(new String(new char[]{'|'}));
    private boolean mSplitByDensity = false;
    private boolean mSplitByAbi = false;
    private final Map<String, String> mSplitByLocale;

    public ApkSettings(ProjectProperties properties) {
        this.mSplitByDensity = Boolean.parseBoolean(properties.getProperty("split.density"));
        this.mSplitByAbi = Boolean.parseBoolean(properties.getProperty("split.abi"));
        String locale = properties.getProperty("split.locale");
        this.mSplitByLocale = locale != null && locale.length() > 0 ? ApkSettings.readLocaleFilters(locale) : Collections.unmodifiableMap(new HashMap());
    }

    public boolean isSplitByDensity() {
        return this.mSplitByDensity;
    }

    public void setSplitByDensity(boolean split) {
        this.mSplitByDensity = split;
    }

    public boolean isSplitByAbi() {
        return this.mSplitByAbi;
    }

    public void setSplitByAbi(boolean split) {
        this.mSplitByAbi = split;
    }

    public void write(ProjectPropertiesWorkingCopy properties) {
        properties.setProperty("split.density", Boolean.toString(this.mSplitByDensity));
        properties.setProperty("split.abi", Boolean.toString(this.mSplitByAbi));
    }

    public boolean equals(Object obj) {
        if (obj instanceof ApkSettings) {
            ApkSettings objSettings = (ApkSettings)obj;
            return this.mSplitByDensity == objSettings.mSplitByDensity && this.mSplitByAbi == objSettings.mSplitByAbi;
        }
        return false;
    }

    public int hashCode() {
        return Integer.valueOf((this.mSplitByDensity ? 1 : 0) + (this.mSplitByAbi ? 2 : 0)).hashCode();
    }

    public static Map<String, String> readLocaleFilters(String locale) {
        String[] filters;
        HashMap<String, String> map = new HashMap<String, String>();
        for (String filter : filters = locale.split(STR_SEP)) {
            int charPos = filter.indexOf(58);
            if (charPos <= 0) continue;
            map.put(filter.substring(0, charPos), filter.substring(charPos + 1));
        }
        return Collections.unmodifiableMap(map);
    }

    public static String writeLocaleFilters(Map<String, String> filterMap) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> entry : filterMap.entrySet()) {
            if (!first) {
                sb.append('|');
            }
            first = false;
            sb.append(entry.getKey());
            sb.append(':');
            sb.append(entry.getValue());
        }
        return sb.toString();
    }

    public Map<String, String> getLocaleFilters() {
        return this.mSplitByLocale;
    }
}

