/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.avd;

import com.android.prefs.AndroidLocation;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.ISdkLog;
import com.android.sdklib.SdkConstants;
import com.android.sdklib.SdkManager;
import com.android.sdklib.internal.project.ProjectProperties;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AvdManager {
    public static final String AVD_FOLDER_EXTENSION = ".avd";
    public static final String AVD_INFO_PATH = "path";
    public static final String AVD_INFO_TARGET = "target";
    public static final String AVD_INI_SKIN_PATH = "skin.path";
    public static final String AVD_INI_SKIN_NAME = "skin.name";
    public static final String AVD_INI_SDCARD_PATH = "sdcard.path";
    public static final String AVD_INI_SDCARD_SIZE = "sdcard.size";
    public static final String AVD_INI_IMAGES_1 = "image.sysdir.1";
    public static final String AVD_INI_IMAGES_2 = "image.sysdir.2";
    public static final Pattern NUMERIC_SKIN_SIZE = Pattern.compile("([0-9]{2,})x([0-9]{2,})");
    private static final String USERDATA_IMG = "userdata.img";
    private static final String CONFIG_INI = "config.ini";
    private static final String SDCARD_IMG = "sdcard.img";
    private static final String INI_EXTENSION = ".ini";
    private static final Pattern INI_NAME_PATTERN = Pattern.compile("(.+)\\.ini$", 2);
    private static final Pattern IMAGE_NAME_PATTERN = Pattern.compile("(.+)\\.img$", 2);
    public static final Pattern SDCARD_SIZE_PATTERN = Pattern.compile("(\\d+)([MK])");
    public static final Pattern RE_AVD_NAME = Pattern.compile("[a-zA-Z0-9._-]+");
    public static final String CHARS_AVD_NAME = "a-z A-Z 0-9 . _ -";
    public static final String HARDWARE_INI = "hardware.ini";
    private final ArrayList<AvdInfo> mAllAvdList = new ArrayList();
    private AvdInfo[] mValidAvdList;
    private AvdInfo[] mBrokenAvdList;
    private final SdkManager mSdkManager;

    public static String getBaseAvdFolder() throws AndroidLocation.AndroidLocationException {
        return AndroidLocation.getFolder() + "avd";
    }

    public AvdManager(SdkManager sdkManager, ISdkLog log) throws AndroidLocation.AndroidLocationException {
        this.mSdkManager = sdkManager;
        this.buildAvdList(this.mAllAvdList, log);
    }

    public SdkManager getSdkManager() {
        return this.mSdkManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AvdInfo[] getAllAvds() {
        ArrayList<AvdInfo> arrayList = this.mAllAvdList;
        synchronized (arrayList) {
            return this.mAllAvdList.toArray(new AvdInfo[this.mAllAvdList.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AvdInfo[] getValidAvds() {
        ArrayList<AvdInfo> arrayList = this.mAllAvdList;
        synchronized (arrayList) {
            if (this.mValidAvdList == null) {
                ArrayList<AvdInfo> list = new ArrayList<AvdInfo>();
                for (AvdInfo avd : this.mAllAvdList) {
                    if (avd.getStatus() != AvdInfo.AvdStatus.OK) continue;
                    list.add(avd);
                }
                this.mValidAvdList = list.toArray(new AvdInfo[list.size()]);
            }
            return this.mValidAvdList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AvdInfo[] getBrokenAvds() {
        ArrayList<AvdInfo> arrayList = this.mAllAvdList;
        synchronized (arrayList) {
            if (this.mBrokenAvdList == null) {
                ArrayList<AvdInfo> list = new ArrayList<AvdInfo>();
                for (AvdInfo avd : this.mAllAvdList) {
                    if (avd.getStatus() == AvdInfo.AvdStatus.OK) continue;
                    list.add(avd);
                }
                this.mBrokenAvdList = list.toArray(new AvdInfo[list.size()]);
            }
            return this.mBrokenAvdList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AvdInfo getAvd(String name, boolean validAvdOnly) {
        boolean ignoreCase;
        boolean bl = ignoreCase = SdkConstants.currentPlatform() == 2;
        if (validAvdOnly) {
            for (AvdInfo info : this.getValidAvds()) {
                String name2 = info.getName();
                if (!name2.equals(name) && (!ignoreCase || !name2.equalsIgnoreCase(name))) continue;
                return info;
            }
        } else {
            ArrayList<AvdInfo> arrayList = this.mAllAvdList;
            synchronized (arrayList) {
                for (AvdInfo info : this.mAllAvdList) {
                    String name2 = info.getName();
                    if (!name2.equals(name) && (!ignoreCase || !name2.equalsIgnoreCase(name))) continue;
                    return info;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadAvds(ISdkLog log) throws AndroidLocation.AndroidLocationException {
        ArrayList<AvdInfo> allList = new ArrayList<AvdInfo>();
        this.buildAvdList(allList, log);
        ArrayList<AvdInfo> arrayList = this.mAllAvdList;
        synchronized (arrayList) {
            this.mAllAvdList.clear();
            this.mAllAvdList.addAll(allList);
            this.mBrokenAvdList = null;
            this.mValidAvdList = null;
        }
    }

    /*
     * Exception decompiling
     */
    public AvdInfo createAvd(File avdFolder, String name, IAndroidTarget target, String skinName, String sdcard, Map<String, String> hardwareConfig, boolean removePrevious, ISdkLog log) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[TRYBLOCK]], but top level block is 41[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getImageRelativePath(IAndroidTarget target) throws InvalidTargetPathException {
        String[] list;
        String sdkLocation;
        String imageFullPath = target.getPath(3);
        if (!imageFullPath.startsWith(sdkLocation = this.mSdkManager.getLocation())) {
            assert (false);
            throw new InvalidTargetPathException("Target location is not inside the SDK.");
        }
        File folder = new File(imageFullPath);
        if (folder.isDirectory() && (list = folder.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return IMAGE_NAME_PATTERN.matcher(name).matches();
            }
        })).length > 0) {
            if ((imageFullPath = imageFullPath.substring(sdkLocation.length())).charAt(0) == File.separatorChar) {
                imageFullPath = imageFullPath.substring(1);
            }
            return imageFullPath;
        }
        return null;
    }

    public String getSkinRelativePath(String skinName, IAndroidTarget target, ISdkLog log) {
        String sdkLocation;
        if (log == null) {
            throw new IllegalArgumentException("log cannot be null");
        }
        File skin = this.getSkinPath(skinName, target);
        if (!skin.exists()) {
            log.error(null, "Skin '%1$s' does not exist.", skinName);
            return null;
        }
        String path = skin.getAbsolutePath();
        if (!path.startsWith(sdkLocation = this.mSdkManager.getLocation())) {
            log.error(null, "Target location is not inside the SDK.", new Object[0]);
            assert (false);
            return null;
        }
        if ((path = path.substring(sdkLocation.length())).charAt(0) == File.separatorChar) {
            path = path.substring(1);
        }
        return path;
    }

    public File getSkinPath(String skinName, IAndroidTarget target) {
        String path = target.getPath(5);
        File skin = new File(path, skinName);
        if (!skin.exists() && !target.isPlatform()) {
            target = target.getParent();
            path = target.getPath(5);
            skin = new File(path, skinName);
        }
        return skin;
    }

    private File createAvdIniFile(String name, File avdFolder, IAndroidTarget target) throws AndroidLocation.AndroidLocationException, IOException {
        HashMap<String, String> values = new HashMap<String, String>();
        File iniFile = AvdInfo.getIniFile(name);
        values.put(AVD_INFO_PATH, avdFolder.getAbsolutePath());
        values.put(AVD_INFO_TARGET, target.hashString());
        AvdManager.writeIniFile(iniFile, values);
        return iniFile;
    }

    private File createAvdIniFile(AvdInfo info) throws AndroidLocation.AndroidLocationException, IOException {
        return this.createAvdIniFile(info.getName(), new File(info.getPath()), info.getTarget());
    }

    public boolean deleteAvd(AvdInfo avdInfo, ISdkLog log) {
        try {
            String path;
            boolean error = false;
            File f = avdInfo.getIniFile();
            if (f != null && f.exists()) {
                log.printf("Deleting file %1$s\n", f.getCanonicalPath());
                if (!f.delete()) {
                    log.error(null, "Failed to delete %1$s\n", f.getCanonicalPath());
                    error = true;
                }
            }
            if ((path = avdInfo.getPath()) != null && (f = new File(path)).exists()) {
                log.printf("Deleting folder %1$s\n", f.getCanonicalPath());
                if (!this.deleteContentOf(f) || !f.delete()) {
                    log.error(null, "Failed to delete %1$s\n", f.getCanonicalPath());
                    error = true;
                }
            }
            this.removeAvd(avdInfo);
            if (!error) {
                log.printf("\nAVD '%1$s' deleted.\n", avdInfo.getName());
                return true;
            }
            log.printf("\nAVD '%1$s' deleted with errors. See errors above.\n", avdInfo.getName());
        }
        catch (AndroidLocation.AndroidLocationException e) {
            log.error(e, null, new Object[0]);
        }
        catch (IOException e) {
            log.error(e, null, new Object[0]);
        }
        catch (SecurityException e) {
            log.error(e, null, new Object[0]);
        }
        return false;
    }

    public boolean moveAvd(AvdInfo avdInfo, String newName, String paramFolderPath, ISdkLog log) {
        try {
            if (paramFolderPath != null) {
                File f = new File(avdInfo.getPath());
                log.warning("Moving '%1$s' to '%2$s'.", avdInfo.getPath(), paramFolderPath);
                if (!f.renameTo(new File(paramFolderPath))) {
                    log.error(null, "Failed to move '%1$s' to '%2$s'.", avdInfo.getPath(), paramFolderPath);
                    return false;
                }
                AvdInfo info = new AvdInfo(avdInfo.getName(), paramFolderPath, avdInfo.getTargetHash(), avdInfo.getTarget(), avdInfo.getProperties());
                this.replaceAvd(avdInfo, info);
                this.createAvdIniFile(info);
            }
            if (newName != null) {
                File oldIniFile = avdInfo.getIniFile();
                File newIniFile = AvdInfo.getIniFile(newName);
                log.warning("Moving '%1$s' to '%2$s'.", oldIniFile.getPath(), newIniFile.getPath());
                if (!oldIniFile.renameTo(newIniFile)) {
                    log.error(null, "Failed to move '%1$s' to '%2$s'.", oldIniFile.getPath(), newIniFile.getPath());
                    return false;
                }
                AvdInfo info = new AvdInfo(newName, avdInfo.getPath(), avdInfo.getTargetHash(), avdInfo.getTarget(), avdInfo.getProperties());
                this.replaceAvd(avdInfo, info);
            }
            log.printf("AVD '%1$s' moved.\n", avdInfo.getName());
        }
        catch (AndroidLocation.AndroidLocationException e) {
            log.error(e, null, new Object[0]);
        }
        catch (IOException e) {
            log.error(e, null, new Object[0]);
        }
        return true;
    }

    private boolean deleteContentOf(File folder) throws SecurityException {
        for (File f : folder.listFiles()) {
            if (f.isDirectory() && !this.deleteContentOf(f)) {
                return false;
            }
            if (f.delete()) continue;
            return false;
        }
        return true;
    }

    private File[] buildAvdFilesList() throws AndroidLocation.AndroidLocationException {
        String avdRoot = AvdManager.getBaseAvdFolder();
        File folder = new File(avdRoot);
        if (folder.isFile()) {
            throw new AndroidLocation.AndroidLocationException(String.format("%1$s is not a valid folder.", avdRoot));
        }
        if (!folder.exists()) {
            folder.mkdirs();
            return null;
        }
        File[] avds = folder.listFiles(new FilenameFilter(){

            public boolean accept(File parent, String name) {
                if (INI_NAME_PATTERN.matcher(name).matches()) {
                    boolean isFile = new File(parent, name).isFile();
                    return isFile;
                }
                return false;
            }
        });
        return avds;
    }

    private void buildAvdList(ArrayList<AvdInfo> allList, ISdkLog log) throws AndroidLocation.AndroidLocationException {
        File[] avds = this.buildAvdFilesList();
        if (avds != null) {
            for (File avd : avds) {
                AvdInfo info = this.parseAvdInfo(avd, log);
                if (info == null) continue;
                allList.add(info);
            }
        }
    }

    private AvdInfo parseAvdInfo(File path, ISdkLog log) {
        String imageSysDir;
        Map<String, String> map = ProjectProperties.parsePropertyFile(path, log);
        String avdPath = map.get(AVD_INFO_PATH);
        String targetHash = map.get(AVD_INFO_TARGET);
        IAndroidTarget target = null;
        File configIniFile = null;
        Map<String, String> properties = null;
        if (targetHash != null) {
            target = this.mSdkManager.getTargetFromHashString(targetHash);
        }
        if (avdPath != null) {
            configIniFile = new File(avdPath, CONFIG_INI);
        }
        if (configIniFile != null) {
            if (!configIniFile.isFile()) {
                log.warning("Missing file '%1$s'.", configIniFile.getPath());
            } else {
                properties = ProjectProperties.parsePropertyFile(configIniFile, log);
            }
        }
        String name = path.getName();
        Matcher matcher = INI_NAME_PATTERN.matcher(path.getName());
        if (matcher.matches()) {
            name = matcher.group(1);
        }
        boolean validImageSysdir = true;
        if (properties != null && (imageSysDir = properties.get(AVD_INI_IMAGES_1)) != null) {
            File f = new File(this.mSdkManager.getLocation() + File.separator + imageSysDir);
            if (!f.isDirectory()) {
                validImageSysdir = false;
            } else {
                imageSysDir = properties.get(AVD_INI_IMAGES_2);
                if (imageSysDir != null && !(f = new File(this.mSdkManager.getLocation() + File.separator + imageSysDir)).isDirectory()) {
                    validImageSysdir = false;
                }
            }
        }
        AvdInfo.AvdStatus status = avdPath == null ? AvdInfo.AvdStatus.ERROR_PATH : (configIniFile == null ? AvdInfo.AvdStatus.ERROR_CONFIG : (targetHash == null ? AvdInfo.AvdStatus.ERROR_TARGET_HASH : (target == null ? AvdInfo.AvdStatus.ERROR_TARGET : (properties == null ? AvdInfo.AvdStatus.ERROR_PROPERTIES : (!validImageSysdir ? AvdInfo.AvdStatus.ERROR_IMAGE_DIR : AvdInfo.AvdStatus.OK)))));
        AvdInfo info = new AvdInfo(name, avdPath, targetHash, target, properties, status);
        return info;
    }

    private static void writeIniFile(File iniFile, Map<String, String> values) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(iniFile), "UTF-8");
        for (Map.Entry<String, String> entry : values.entrySet()) {
            writer.write(String.format("%1$s=%2$s\n", entry.getKey(), entry.getValue()));
        }
        writer.close();
    }

    private boolean createSdCard(String toolLocation, String size, String location, ISdkLog log) {
        try {
            String[] command = new String[]{toolLocation, size, location};
            Process process = Runtime.getRuntime().exec(command);
            ArrayList<String> errorOutput = new ArrayList<String>();
            ArrayList<String> stdOutput = new ArrayList<String>();
            int status = this.grabProcessOutput(process, errorOutput, stdOutput, true);
            if (status == 0) {
                return true;
            }
            for (String error : errorOutput) {
                log.error(null, error, new Object[0]);
            }
        }
        catch (InterruptedException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        log.error(null, "Failed to create the SD card.", new Object[0]);
        return false;
    }

    private int grabProcessOutput(final Process process, final ArrayList<String> errorOutput, final ArrayList<String> stdOutput, boolean waitforReaders) throws InterruptedException {
        assert (errorOutput != null);
        assert (stdOutput != null);
        Thread t1 = new Thread(""){

            public void run() {
                InputStreamReader is = new InputStreamReader(process.getErrorStream());
                BufferedReader errReader = new BufferedReader(is);
                try {
                    String line;
                    while ((line = errReader.readLine()) != null) {
                        errorOutput.add(line);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        Thread t2 = new Thread(""){

            public void run() {
                InputStreamReader is = new InputStreamReader(process.getInputStream());
                BufferedReader outReader = new BufferedReader(is);
                try {
                    String line;
                    while ((line = outReader.readLine()) != null) {
                        stdOutput.add(line);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        t1.start();
        t2.start();
        if (waitforReaders) {
            try {
                t1.join();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            try {
                t2.join();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        return process.waitFor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAvd(AvdInfo avdInfo) {
        ArrayList<AvdInfo> arrayList = this.mAllAvdList;
        synchronized (arrayList) {
            if (this.mAllAvdList.remove(avdInfo)) {
                this.mBrokenAvdList = null;
                this.mValidAvdList = null;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAvd(String name, ISdkLog log) throws IOException {
        AvdInfo avd = null;
        ArrayList<AvdInfo> arrayList = this.mAllAvdList;
        synchronized (arrayList) {
            for (AvdInfo info : this.mAllAvdList) {
                if (!info.getName().equals(name)) continue;
                avd = info;
                break;
            }
        }
        if (avd == null) {
            log.error(null, "There is no Android Virtual Device named '%s'.", name);
            return;
        }
        this.updateAvd(avd, log);
    }

    public void updateAvd(AvdInfo avd, ISdkLog log) throws IOException {
        AvdInfo.AvdStatus status;
        Map<String, String> oldProperties = avd.getProperties();
        HashMap<String, String> properties = new HashMap<String, String>();
        if (oldProperties != null) {
            properties.putAll(oldProperties);
        }
        if (this.setImagePathProperties(avd.getTarget(), properties, log)) {
            if (properties.containsKey(AVD_INI_IMAGES_1)) {
                log.printf("Updated '%1$s' with value '%2$s'\n", AVD_INI_IMAGES_1, properties.get(AVD_INI_IMAGES_1));
            }
            if (properties.containsKey(AVD_INI_IMAGES_2)) {
                log.printf("Updated '%1$s' with value '%2$s'\n", AVD_INI_IMAGES_2, properties.get(AVD_INI_IMAGES_2));
            }
            status = AvdInfo.AvdStatus.OK;
        } else {
            log.error(null, "Unable to find non empty system images folders for %1$s", avd.getName());
            status = AvdInfo.AvdStatus.ERROR_IMAGE_DIR;
        }
        File configIniFile = new File(avd.getPath(), CONFIG_INI);
        AvdManager.writeIniFile(configIniFile, properties);
        AvdInfo newAvd = new AvdInfo(avd.getName(), avd.getPath(), avd.getTargetHash(), avd.getTarget(), properties, status);
        this.replaceAvd(avd, newAvd);
    }

    private boolean setImagePathProperties(IAndroidTarget target, Map<String, String> properties, ISdkLog log) {
        properties.remove(AVD_INI_IMAGES_1);
        properties.remove(AVD_INI_IMAGES_2);
        try {
            IAndroidTarget parent;
            String property = AVD_INI_IMAGES_1;
            String imagePath = this.getImageRelativePath(target);
            if (imagePath != null) {
                properties.put(property, imagePath);
                property = AVD_INI_IMAGES_2;
            }
            if ((parent = target.getParent()) != null && (imagePath = this.getImageRelativePath(parent)) != null) {
                properties.put(property, imagePath);
            }
            return properties.containsKey(AVD_INI_IMAGES_1);
        }
        catch (InvalidTargetPathException e) {
            log.error(e, e.getMessage(), new Object[0]);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceAvd(AvdInfo oldAvd, AvdInfo newAvd) {
        ArrayList<AvdInfo> arrayList = this.mAllAvdList;
        synchronized (arrayList) {
            this.mAllAvdList.remove(oldAvd);
            this.mAllAvdList.add(newAvd);
            this.mBrokenAvdList = null;
            this.mValidAvdList = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class AvdInfo
    implements Comparable<AvdInfo> {
        private final String mName;
        private final String mPath;
        private final String mTargetHash;
        private final IAndroidTarget mTarget;
        private final Map<String, String> mProperties;
        private final AvdStatus mStatus;

        public AvdInfo(String name, String path, String targetHash, IAndroidTarget target, Map<String, String> properties) {
            this(name, path, targetHash, target, properties, AvdStatus.OK);
        }

        public AvdInfo(String name, String path, String targetHash, IAndroidTarget target, Map<String, String> properties, AvdStatus status) {
            this.mName = name;
            this.mPath = path;
            this.mTargetHash = targetHash;
            this.mTarget = target;
            this.mProperties = properties == null ? null : Collections.unmodifiableMap(properties);
            this.mStatus = status;
        }

        public String getName() {
            return this.mName;
        }

        public String getPath() {
            return this.mPath;
        }

        public String getTargetHash() {
            return this.mTargetHash;
        }

        public IAndroidTarget getTarget() {
            return this.mTarget;
        }

        public AvdStatus getStatus() {
            return this.mStatus;
        }

        public static File getIniFile(String name) throws AndroidLocation.AndroidLocationException {
            String avdRoot = AvdManager.getBaseAvdFolder();
            return new File(avdRoot, name + AvdManager.INI_EXTENSION);
        }

        public File getIniFile() throws AndroidLocation.AndroidLocationException {
            return AvdInfo.getIniFile(this.mName);
        }

        public static File getConfigFile(String path) {
            return new File(path, AvdManager.CONFIG_INI);
        }

        public File getConfigFile() {
            return AvdInfo.getConfigFile(this.mPath);
        }

        public Map<String, String> getProperties() {
            return this.mProperties;
        }

        public String getErrorMessage() {
            try {
                switch (this.mStatus) {
                    case ERROR_PATH: {
                        return String.format("Missing AVD 'path' property in %1$s", this.getIniFile());
                    }
                    case ERROR_CONFIG: {
                        return String.format("Missing config.ini file in %1$s", this.mPath);
                    }
                    case ERROR_TARGET_HASH: {
                        return String.format("Missing 'target' property in %1$s", this.getIniFile());
                    }
                    case ERROR_TARGET: {
                        return String.format("Unknown target '%1$s' in %2$s", this.mTargetHash, this.getIniFile());
                    }
                    case ERROR_PROPERTIES: {
                        return String.format("Failed to parse properties from %1$s", this.getConfigFile());
                    }
                    case ERROR_IMAGE_DIR: {
                        return String.format("Invalid value in image.sysdir. Run 'android update avd -n %1$s'", this.mName);
                    }
                    case OK: {
                        assert (false);
                        return null;
                    }
                }
            }
            catch (AndroidLocation.AndroidLocationException e) {
                return "Unable to get HOME folder.";
            }
            return null;
        }

        public boolean isRunning() {
            File f = new File(this.mPath, "userdata-qemu.img.lock");
            return f.isFile();
        }

        @Override
        public int compareTo(AvdInfo o) {
            if (this.mTarget == null) {
                return 1;
            }
            if (o.mTarget == null) {
                return -1;
            }
            int targetDiff = this.mTarget.compareTo(o.mTarget);
            if (targetDiff == 0) {
                return this.mName.compareTo(o.mName);
            }
            return targetDiff;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum AvdStatus {
            OK,
            ERROR_PATH,
            ERROR_CONFIG,
            ERROR_TARGET_HASH,
            ERROR_TARGET,
            ERROR_PROPERTIES,
            ERROR_IMAGE_DIR;

        }
    }

    private static final class InvalidTargetPathException
    extends Exception {
        private static final long serialVersionUID = 1L;

        InvalidTargetPathException(String message) {
            super(message);
        }
    }
}

