/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WritePreloadedClassFile {
    static final int MIN_LOAD_TIME_MICROS = 1250;
    static final int MIN_PROCESSES = 10;

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        if (args.length != 1) {
            System.err.println("Usage: WritePreloadedClassFile [compiled log]");
            System.exit(-1);
        }
        String rootFile = args[0];
        Root root = Root.fromFile(rootFile);
        for (LoadedClass loadedClass : root.loadedClasses.values()) {
            loadedClass.preloaded = false;
        }
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream("frameworks/base/preloaded-classes"), Charset.forName("US-ASCII")));
        out.write("# Classes which are preloaded by com.android.internal.os.ZygoteInit.\n");
        out.write("# Automatically generated by frameworks/base/tools/preload/" + WritePreloadedClassFile.class.getSimpleName() + ".java.\n");
        out.write("# MIN_LOAD_TIME_MICROS=1250\n");
        out.write("# MIN_PROCESSES=10\n");
        TreeSet<LoadedClass> toPreload = new TreeSet<LoadedClass>();
        for (LoadedClass loadedClass : root.loadedClasses.values()) {
            Set<String> names = loadedClass.processNames();
            if (!Policy.isPreloadable(loadedClass) || names.size() < 10 && (loadedClass.medianTimeMicros() <= 1250 || names.size() <= 1)) continue;
            toPreload.add(loadedClass);
        }
        int initialSize = toPreload.size();
        System.out.println(initialSize + " classses were loaded by more than one app.");
        for (Proc proc : root.processes.values()) {
            if (!proc.fromZygote() || Policy.isService(proc.name)) continue;
            for (Operation operation : proc.operations) {
                LoadedClass loadedClass = operation.loadedClass;
                if (!WritePreloadedClassFile.shouldPreload(loadedClass)) continue;
                toPreload.add(loadedClass);
            }
        }
        System.out.println("Added " + (toPreload.size() - initialSize) + " more to speed up applications.");
        System.out.println(toPreload.size() + " total classes will be preloaded.");
        WritePreloadedClassFile.addAllClassesFrom("zygote", root, toPreload);
        for (LoadedClass loadedClass : toPreload) {
            out.write(loadedClass.name + "\n");
        }
        ((Writer)out).close();
        for (LoadedClass loadedClass : toPreload) {
            loadedClass.preloaded = true;
        }
        root.toFile(rootFile);
    }

    private static void addAllClassesFrom(String processName, Root root, Set<LoadedClass> toPreload) {
        for (Proc proc : root.processes.values()) {
            if (!proc.name.equals(processName)) continue;
            for (Operation operation : proc.operations) {
                boolean preloadable = Policy.isPreloadable(operation.loadedClass);
                if (!preloadable) continue;
                toPreload.add(operation.loadedClass);
            }
        }
    }

    private static boolean shouldPreload(LoadedClass clazz) {
        return Policy.isPreloadable(clazz) && clazz.medianTimeMicros() > 1250;
    }
}

