/*
 * Decompiled with CFR 0.152.
 */
class Record {
    private static final String[] REPLACE_CLASSES = new String[]{"com.google.android.apps.maps:FriendService", "com.google.android.apps.maps\\u003AFriendService", "com.google.android.apps.maps:driveabout", "com.google.android.apps.maps\\u003Adriveabout", "com.google.android.apps.maps:LocationFriendService", "com.google.android.apps.maps\\u003ALocationFriendService"};
    final int ppid;
    final int pid;
    final int tid;
    final String processName;
    final int classLoader;
    final Type type;
    final String className;
    final long time;
    int sourceLineNumber;

    Record(String line, int lineNum) {
        char typeChar = line.charAt(0);
        switch (typeChar) {
            case '>': {
                this.type = Type.START_LOAD;
                break;
            }
            case '<': {
                this.type = Type.END_LOAD;
                break;
            }
            case '+': {
                this.type = Type.START_INIT;
                break;
            }
            case '-': {
                this.type = Type.END_INIT;
                break;
            }
            default: {
                throw new AssertionError((Object)("Bad line: " + line));
            }
        }
        this.sourceLineNumber = lineNum;
        for (int i = 0; i < REPLACE_CLASSES.length; i += 2) {
            line = line.replace(REPLACE_CLASSES[i], REPLACE_CLASSES[i + 1]);
        }
        line = line.substring(1);
        String[] parts = line.split(":");
        this.ppid = Integer.parseInt(parts[0]);
        this.pid = Integer.parseInt(parts[1]);
        this.tid = Integer.parseInt(parts[2]);
        this.processName = this.decode(parts[3]).intern();
        this.classLoader = Integer.parseInt(parts[4]);
        this.className = this.vmTypeToLanguage(this.decode(parts[5])).intern();
        this.time = Long.parseLong(parts[6]);
    }

    String decode(String rawField) {
        String result = rawField;
        int offset = result.indexOf("\\u");
        while (offset >= 0) {
            String before = result.substring(0, offset);
            String escaped = result.substring(offset + 2, offset + 6);
            String after = result.substring(offset + 6);
            result = String.format("%s%c%s", before, Integer.parseInt(escaped, 16), after);
            offset = result.indexOf("\\u", offset + 1);
        }
        return result;
    }

    String vmTypeToLanguage(String typeName) {
        if ("(null)".equals(typeName)) {
            return typeName;
        }
        if (!typeName.startsWith("L") || !typeName.endsWith(";")) {
            throw new AssertionError((Object)("Bad name: " + typeName + " in line " + this.sourceLineNumber));
        }
        typeName = typeName.substring(1, typeName.length() - 1);
        return typeName.replace("/", ".");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Type {
        START_LOAD,
        END_LOAD,
        START_INIT,
        END_INIT;

    }
}

