/*
 * Decompiled with CFR 0.152.
 */
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

class Operation
implements Serializable {
    private static final long serialVersionUID = 0L;
    final Proc process;
    final long startTimeNanos;
    final int index;
    final Type type;
    long endTimeNanos = -1L;
    final LoadedClass loadedClass;
    final List<Operation> subops = new ArrayList<Operation>();

    Operation(Proc process, LoadedClass loadedClass, long startTimeNanos, int index, Type type) {
        this.process = process;
        this.loadedClass = loadedClass;
        this.startTimeNanos = startTimeNanos;
        this.index = index;
        this.type = type;
    }

    private long inclusiveTimeNanos() {
        if (this.endTimeNanos == -1L) {
            throw new IllegalStateException("End time hasn't been set yet: " + this.loadedClass.name);
        }
        return this.endTimeNanos - this.startTimeNanos;
    }

    int exclusiveTimeMicros() {
        long exclusive = this.inclusiveTimeNanos();
        for (Operation child : this.subops) {
            exclusive -= child.inclusiveTimeNanos();
        }
        if (exclusive < 0L) {
            throw new AssertionError((Object)this.loadedClass.name);
        }
        return Operation.nanosToMicros(exclusive);
    }

    int medianExclusiveTimeMicros() {
        switch (this.type) {
            case LOAD: {
                return this.loadedClass.medianLoadTimeMicros();
            }
            case INIT: {
                return this.loadedClass.medianInitTimeMicros();
            }
        }
        throw new AssertionError();
    }

    private static int nanosToMicros(long nanos) {
        long micros = nanos / 1000L;
        int microsInt = (int)micros;
        if ((long)microsInt != micros) {
            throw new RuntimeException("Integer overflow: " + nanos);
        }
        return microsInt;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.type.toString());
        sb.append(' ');
        sb.append(this.loadedClass.toString());
        if (this.subops.size() > 0) {
            sb.append(" (");
            sb.append(this.subops.size());
            sb.append(" sub ops)");
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Type {
        LOAD,
        INIT;

    }
}

