/*
 * Decompiled with CFR 0.152.
 */
package com.android.monkeyrunner;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jheer.XMLWriter;

public class MonkeyRecorder {
    private static String mXmlFilename;
    private static FileWriter mXmlFile;
    private static XMLWriter mXmlWriter;
    private static String mDirname;
    private static List<String> mScreenShotNames;
    private static final String ROOT_DIR = "out";
    private static final SimpleDateFormat SIMPLE_DATE_TIME_FORMAT;

    public MonkeyRecorder(String scriptName, String version) throws IOException {
        File scriptFile = new File(scriptName);
        scriptName = scriptFile.getName();
        mDirname = "out/" + MonkeyRecorder.stripType(scriptName) + "-" + MonkeyRecorder.now();
        new File(mDirname).mkdirs();
        mXmlFilename = MonkeyRecorder.stampFilename(MonkeyRecorder.stripType(scriptName) + ".xml");
        MonkeyRecorder.initXmlFile(scriptName, version);
    }

    private static String now() {
        return SIMPLE_DATE_TIME_FORMAT.format(Calendar.getInstance().getTime());
    }

    private static void initXmlFile(String scriptName, String version) throws IOException {
        String[] names = new String[]{"script_name", "monkeyRunnerVersion"};
        String[] values = new String[]{scriptName, version};
        mXmlFile = new FileWriter(mDirname + "/" + mXmlFilename);
        mXmlWriter = new XMLWriter(mXmlFile);
        mXmlWriter.begin();
        mXmlWriter.comment("Monkey Script Results");
        mXmlWriter.start("script_run", names, values, names.length);
    }

    public static void addComment(String comment) throws IOException {
        mXmlWriter.comment(comment);
    }

    public static void startCommand() throws IOException {
        mXmlWriter.start("command", "dateTime", MonkeyRecorder.now());
    }

    public static void addInput(String cmd) throws IOException {
        String name = "cmd";
        String value = cmd;
        mXmlWriter.tag("input", name, value);
    }

    public static void addResult(String result, String filename) throws IOException {
        int num_args = 2;
        String[] names = new String[3];
        String[] values = new String[3];
        names[0] = "result";
        values[0] = result;
        names[1] = "dateTime";
        values[1] = MonkeyRecorder.now();
        if (filename.length() != 0) {
            names[2] = "screenshot";
            values[2] = MonkeyRecorder.stampFilename(filename);
            MonkeyRecorder.addScreenShot(filename);
            num_args = 3;
        }
        mXmlWriter.tag("response", names, values, num_args);
    }

    public static void addAttribute(String name, String value) throws IOException {
        mXmlWriter.addAttribute(name, value);
    }

    public static void addDeviceVar(String name, String value) throws IOException {
        String[] names = new String[]{"name", "value"};
        String[] values = new String[]{name, value};
        mXmlWriter.tag("device_var", names, values, names.length);
    }

    private static void addScreenShot(String filename) {
        File file = new File(filename);
        String screenShotName = MonkeyRecorder.stampFilename(filename);
        file.renameTo(new File(mDirname, screenShotName));
        mScreenShotNames.add(screenShotName);
    }

    public static void endCommand() throws IOException {
        mXmlWriter.end();
    }

    private static String stampFilename(String filename) {
        int typeIndex = filename.lastIndexOf(46);
        if (typeIndex == -1) {
            return filename + "-" + MonkeyRecorder.now();
        }
        return filename.substring(0, typeIndex) + "-" + MonkeyRecorder.now() + filename.substring(typeIndex);
    }

    private static String stripType(String filename) {
        int typeIndex = filename.lastIndexOf(46);
        if (typeIndex == -1) {
            return filename;
        }
        return filename.substring(0, typeIndex);
    }

    public static void close() throws IOException {
        byte[] buf = new byte[1024];
        String zipFileName = mXmlFilename + ".zip";
        MonkeyRecorder.endCommand();
        mXmlFile.close();
        FileOutputStream zipFile = new FileOutputStream("out/" + zipFileName);
        ZipOutputStream out = new ZipOutputStream(zipFile);
        MonkeyRecorder.addFileToZip(out, mDirname + "/" + mXmlFilename, buf);
        for (String filename : mScreenShotNames) {
            MonkeyRecorder.addFileToZip(out, mDirname + "/" + filename, buf);
        }
        out.close();
    }

    private static void addFileToZip(ZipOutputStream zip, String filepath, byte[] buf) throws IOException {
        int len;
        FileInputStream in = new FileInputStream(filepath);
        zip.putNextEntry(new ZipEntry(filepath));
        while ((len = in.read(buf)) > 0) {
            zip.write(buf, 0, len);
        }
        zip.closeEntry();
        in.close();
    }

    static {
        mScreenShotNames = new ArrayList<String>();
        SIMPLE_DATE_TIME_FORMAT = new SimpleDateFormat("yyyyMMdd-HH:mm:ss");
    }
}

