/*
 * Decompiled with CFR 0.152.
 */
package com.android.mkstubs.sourcer;

import java.util.ArrayList;
import org.objectweb.asm.Type;
import org.objectweb.asm.signature.SignatureVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SignatureSourcer
implements SignatureVisitor {
    private final StringBuilder mBuf = new StringBuilder();
    private final StringBuilder mFormalsBuf = new StringBuilder();
    private boolean mWritingFormals;
    private int mArgumentStack;
    private SignatureSourcer mReturnType;
    private SignatureSourcer mSuperClass;
    private ArrayList<SignatureSourcer> mParameters = new ArrayList();

    private StringBuilder getBuf() {
        if (this.mWritingFormals) {
            return this.mFormalsBuf;
        }
        return this.mBuf;
    }

    public String toString() {
        return this.mBuf.toString();
    }

    public SignatureSourcer getReturnType() {
        return this.mReturnType;
    }

    public ArrayList<SignatureSourcer> getParameters() {
        return this.mParameters;
    }

    public boolean hasFormalsContent() {
        return this.mFormalsBuf.length() > 0;
    }

    public String formalsToString() {
        return this.mFormalsBuf.toString();
    }

    public SignatureSourcer getSuperClass() {
        return this.mSuperClass;
    }

    @Override
    public void visitFormalTypeParameter(String name) {
        if (!this.mWritingFormals) {
            this.mWritingFormals = true;
            this.getBuf().append('<');
        } else {
            this.getBuf().append(", ");
        }
        this.getBuf().append(name);
        this.getBuf().append(" extends ");
    }

    @Override
    public SignatureVisitor visitClassBound() {
        return this;
    }

    @Override
    public SignatureVisitor visitInterfaceBound() {
        return this;
    }

    @Override
    public SignatureVisitor visitSuperclass() {
        this.endFormals();
        SignatureSourcer sourcer = new SignatureSourcer();
        assert (this.mSuperClass == null);
        this.mSuperClass = sourcer;
        return sourcer;
    }

    @Override
    public SignatureVisitor visitInterface() {
        return this;
    }

    @Override
    public SignatureVisitor visitParameterType() {
        this.endFormals();
        SignatureSourcer sourcer = new SignatureSourcer();
        this.mParameters.add(sourcer);
        return sourcer;
    }

    @Override
    public SignatureVisitor visitReturnType() {
        this.endFormals();
        SignatureSourcer sourcer = new SignatureSourcer();
        assert (this.mReturnType == null);
        this.mReturnType = sourcer;
        return sourcer;
    }

    @Override
    public SignatureVisitor visitExceptionType() {
        this.getBuf().append('^');
        return this;
    }

    @Override
    public void visitBaseType(char descriptor) {
        this.getBuf().append(Type.getType(Character.toString(descriptor)).getClassName());
    }

    @Override
    public void visitTypeVariable(String name) {
        this.getBuf().append(name.replace('/', '.'));
    }

    @Override
    public SignatureVisitor visitArrayType() {
        this.getBuf().append('[');
        return this;
    }

    @Override
    public void visitClassType(String name) {
        this.getBuf().append(name.replace('/', '.'));
        this.mArgumentStack *= 2;
    }

    @Override
    public void visitInnerClassType(String name) {
        this.endArguments();
        this.getBuf().append('.');
        this.getBuf().append(name.replace('/', '.'));
        this.mArgumentStack *= 2;
    }

    @Override
    public void visitTypeArgument() {
        if (this.mArgumentStack % 2 == 0) {
            ++this.mArgumentStack;
            this.getBuf().append('<');
        } else {
            this.getBuf().append(", ");
        }
        this.getBuf().append('*');
    }

    @Override
    public SignatureVisitor visitTypeArgument(char wildcard) {
        if (this.mArgumentStack % 2 == 0) {
            ++this.mArgumentStack;
            this.getBuf().append('<');
        } else {
            this.getBuf().append(", ");
        }
        if (wildcard != '=') {
            if (wildcard == '+') {
                this.getBuf().append("? extends ");
            } else if (wildcard == '-') {
                this.getBuf().append("? super ");
            } else {
                this.getBuf().append(wildcard);
            }
        }
        return this;
    }

    @Override
    public void visitEnd() {
        this.endArguments();
    }

    private void endFormals() {
        if (this.mWritingFormals) {
            this.getBuf().append('>');
            this.mWritingFormals = false;
        }
    }

    private void endArguments() {
        if (this.mArgumentStack % 2 != 0) {
            this.getBuf().append('>');
        }
        this.mArgumentStack /= 2;
    }
}

