/*
 * Decompiled with CFR 0.152.
 */
package com.android.mkstubs.sourcer;

import com.android.mkstubs.sourcer.AccessSourcer;
import com.android.mkstubs.sourcer.AnnotationSourcer;
import com.android.mkstubs.sourcer.Output;
import com.android.mkstubs.sourcer.SignatureSourcer;
import java.util.ArrayList;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.signature.SignatureReader;

class MethodSourcer
implements MethodVisitor {
    private final Output mOutput;
    private final int mAccess;
    private final String mClassName;
    private final String mName;
    private final String mDesc;
    private final String mSignature;
    private final String[] mExceptions;
    private boolean mNeedDeclaration;
    private boolean mIsConstructor;

    public MethodSourcer(Output output, String className, int access, String name, String desc, String signature, String[] exceptions) {
        this.mOutput = output;
        this.mClassName = className;
        this.mAccess = access;
        this.mName = name;
        this.mDesc = desc;
        this.mSignature = signature;
        this.mExceptions = exceptions;
        this.mNeedDeclaration = true;
        this.mIsConstructor = "<init>".equals(name);
    }

    private void writeHeader() {
        int i;
        if (!this.mNeedDeclaration) {
            return;
        }
        AccessSourcer as = new AccessSourcer(this.mOutput);
        as.write(this.mAccess, AccessSourcer.IS_METHOD);
        SignatureSourcer sigSourcer = null;
        if (this.mSignature != null) {
            SignatureReader sigReader = new SignatureReader(this.mSignature);
            sigSourcer = new SignatureSourcer();
            sigReader.accept(sigSourcer);
            if (sigSourcer.hasFormalsContent()) {
                this.mOutput.write(" %s", sigSourcer.formalsToString());
            }
        }
        if (!this.mIsConstructor) {
            if (sigSourcer == null || sigSourcer.getReturnType() == null) {
                this.mOutput.write(" %s", Type.getReturnType(this.mDesc).getClassName());
            } else {
                this.mOutput.write(" %s", sigSourcer.getReturnType().toString());
            }
        }
        this.mOutput.write(" %s(", this.mIsConstructor ? this.mClassName : this.mName);
        if (this.mSignature == null) {
            Type[] types = Type.getArgumentTypes(this.mDesc);
            for (i = 0; i < types.length; ++i) {
                if (i > 0) {
                    this.mOutput.write(", ", new Object[0]);
                }
                this.mOutput.write("%s arg%d", types[i].getClassName(), i);
            }
        } else {
            ArrayList<SignatureSourcer> params = sigSourcer.getParameters();
            for (i = 0; i < params.size(); ++i) {
                if (i > 0) {
                    this.mOutput.write(", ", new Object[0]);
                }
                this.mOutput.write("%s arg%d", params.get(i).toString(), i);
            }
        }
        this.mOutput.write(")", new Object[0]);
        if (this.mExceptions != null && this.mExceptions.length > 0) {
            this.mOutput.write(" throws ", new Object[0]);
            for (int i2 = 0; i2 < this.mExceptions.length; ++i2) {
                if (i2 > 0) {
                    this.mOutput.write(", ", new Object[0]);
                }
                this.mOutput.write(this.mExceptions[i2].replace('/', '.'), new Object[0]);
            }
        }
        this.mOutput.write(" {\n", new Object[0]);
        this.mNeedDeclaration = false;
    }

    public void visitCode() {
        this.writeHeader();
        this.mOutput.write("throw new RuntimeException(\"Stub\");", new Object[0]);
    }

    public void visitEnd() {
        this.writeHeader();
        this.mOutput.write("\n}\n", new Object[0]);
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.mOutput.write("@%s", desc);
        return new AnnotationSourcer(this.mOutput);
    }

    public AnnotationVisitor visitAnnotationDefault() {
        return null;
    }

    public void visitAttribute(Attribute attr) {
        this.mOutput.write("%s /* non-standard method attribute */ ", attr.type);
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
    }

    public void visitFrame(int type, int local, Object[] local2, int stack, Object[] stack2) {
    }

    public void visitIincInsn(int var, int increment) {
    }

    public void visitInsn(int opcode) {
    }

    public void visitIntInsn(int opcode, int operand) {
    }

    public void visitJumpInsn(int opcode, Label label) {
    }

    public void visitLabel(Label label) {
    }

    public void visitLdcInsn(Object cst) {
    }

    public void visitLineNumber(int line, Label start) {
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
    }

    public void visitMaxs(int maxStack, int maxLocals) {
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
    }

    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        return null;
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
    }

    public void visitTypeInsn(int opcode, String type) {
    }

    public void visitVarInsn(int opcode, int var) {
    }
}

