/*
 * Decompiled with CFR 0.152.
 */
package com.android.mkstubs.sourcer;

import com.android.mkstubs.sourcer.AccessSourcer;
import com.android.mkstubs.sourcer.AnnotationSourcer;
import com.android.mkstubs.sourcer.FieldSourcer;
import com.android.mkstubs.sourcer.MethodSourcer;
import com.android.mkstubs.sourcer.Output;
import com.android.mkstubs.sourcer.SignatureSourcer;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.signature.SignatureReader;

public class ClassSourcer
implements ClassVisitor {
    private final Output mOutput;
    private final AccessSourcer mAccessSourcer;
    private String mClassName;

    public ClassSourcer(Output output) {
        this.mOutput = output;
        this.mAccessSourcer = new AccessSourcer(this.mOutput);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        String pkg = name.substring(0, name.lastIndexOf(47)).replace('/', '.');
        this.mClassName = name.substring(name.lastIndexOf(47) + 1);
        this.mOutput.write("package %s;\n", pkg);
        this.mAccessSourcer.write(access & 0xFFFFFFDF, AccessSourcer.IS_CLASS);
        this.mOutput.write(" class %s", this.mClassName);
        if (signature != null) {
            SignatureReader sigReader = new SignatureReader(signature);
            SignatureSourcer sigSourcer = new SignatureSourcer();
            sigReader.accept(sigSourcer);
            if (sigSourcer.hasFormalsContent()) {
                this.mOutput.write(sigSourcer.formalsToString(), new Object[0]);
            }
            this.mOutput.write(" extends %s", sigSourcer.getSuperClass().toString());
        } else {
            this.mOutput.write(" extends %s", superName.replace('/', '.'));
        }
        if (interfaces != null && interfaces.length > 0) {
            this.mOutput.write(" implements ", new Object[0]);
            boolean need_sep = false;
            for (String i : interfaces) {
                if (need_sep) {
                    this.mOutput.write(", ", new Object[0]);
                }
                this.mOutput.write(i.replace('/', '.'), new Object[0]);
                need_sep = true;
            }
        }
        this.mOutput.write(" {\n", new Object[0]);
    }

    public void visitEnd() {
        this.mOutput.write("}\n", new Object[0]);
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.mOutput.write("@%s", desc);
        return new AnnotationSourcer(this.mOutput);
    }

    public void visitAttribute(Attribute attr) {
        this.mOutput.write("%s /* non-standard class attribute */ ", attr.type);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if ((access & 0x1000) != 0) {
            return null;
        }
        return new FieldSourcer(this.mOutput, access, name, desc, signature);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        return new MethodSourcer(this.mOutput, this.mClassName, access, name, desc, signature, exceptions);
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
    }

    public void visitOuterClass(String owner, String name, String desc) {
    }

    public void visitSource(String source, String debug) {
    }
}

