/*
 * Decompiled with CFR 0.152.
 */
package com.android.mkstubs.sourcer;

import com.android.mkstubs.sourcer.Output;

class AccessSourcer {
    private final Output mOutput;
    public static int IS_CLASS = 1;
    public static int IS_FIELD = 2;
    public static int IS_METHOD = 4;

    public AccessSourcer(Output output) {
        this.mOutput = output;
    }

    public void write(int access, int filter) {
        boolean need_sep = false;
        for (Flag f : Flag.values()) {
            if ((f.getFilter() & filter) == 0 || (access & f.getValue()) == 0) continue;
            if (need_sep) {
                this.mOutput.write(" ", new Object[0]);
            }
            this.mOutput.write(f.toString(), new Object[0]);
            need_sep = true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Flag {
        ACC_PUBLIC(1, IS_CLASS | IS_FIELD | IS_METHOD),
        ACC_PRIVATE(2, IS_CLASS | IS_FIELD | IS_METHOD),
        ACC_PROTECTED(4, IS_CLASS | IS_FIELD | IS_METHOD),
        ACC_STATIC(8, IS_FIELD | IS_METHOD),
        ACC_FINAL(16, IS_CLASS | IS_FIELD | IS_METHOD),
        ACC_SUPER(32, IS_CLASS),
        ACC_SYNCHRONIZED(32, IS_METHOD),
        ACC_VOLATILE(64, IS_FIELD),
        ACC_BRIDGE(64, IS_METHOD),
        ACC_VARARGS(128, IS_METHOD),
        ACC_TRANSIENT(128, IS_FIELD),
        ACC_NATIVE(256, IS_METHOD),
        ACC_INTERFACE(512, IS_CLASS),
        ACC_ABSTRACT(1024, IS_CLASS | IS_METHOD),
        ACC_STRICT(2048, IS_METHOD),
        ACC_SYNTHETIC(4096, IS_CLASS | IS_FIELD | IS_METHOD),
        ACC_ANNOTATION(8192, IS_CLASS),
        ACC_ENUM(16384, IS_CLASS),
        ACC_DEPRECATED(131072, IS_CLASS | IS_FIELD | IS_METHOD);

        private final int mValue;
        private final int mFilter;

        private Flag(int value, int filter) {
            this.mValue = value;
            this.mFilter = filter;
        }

        public int getValue() {
            return this.mValue;
        }

        public int getFilter() {
            return this.mFilter;
        }

        public String toString() {
            return super.toString().substring(4).toLowerCase();
        }
    }
}

